<!-- PAGE HEADER -->
<div class="page-header-breadcrumb d-md-flex d-block align-items-center justify-content-between ">
  <h4 class="fw-medium mb-0"><?= Helpers::getPageName(); ?></h4>
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="javascript:void(0);" class="-50">Fiscal Affairs</a>
    </li>
    <li class="breadcrumb-item active" aria-current="page"><?= Helpers::getPageName(); ?></li>
  </ol>
</div>
<!-- END PEAGE HEADER -->

<!-- APP CONTENT -->
<div class="main-content app-content">
    <div class="container-fluid">
      
        <div class="row">
            <div class="col-xl-12">
                <?php if ($this->session->flashdata()) {
                    echo Helpers::showFlash($this->session->flashdata("response1"));
                } ?>
            </div>
        </div>


        <div class="row">
            <div class="col-12">
               <div class="card  custom-card m-b-20">
        <div class="card-header">
          <div class="card-title">
          Mini Statements
          </div>
        </div>
                    <div class="card-body table-card-body">
                        <div class="table-responsive">
                          <table id="datatable-basic" class="table table-bordered text-nowrap" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>
                                        <th>Description</th>
                                        <th>Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($data['mini_statement']) {
                                        $key = 1;
                                        foreach ($data['mini_statement'] as $user) {
                                            $direct = Helpers::getUserObj($user["user_id"]);
                                            $pack = MemberHelper::packagename($user["package_id"]);
                                            $sponsor = Helpers::getUserObj($user["sponsor_id"]);
                                            $date = $user["date"];
                                    ?>
                                            <tr>
                                                <td><?= $key; ?></td>
                                                <td><?= "FC" . $user["id"] ?></td>
                                                <td><?= $user["before_earning_amount"]; ?></td>
                                                <td><?= $user["after_earning_amount"]; ?></td>
                                                <td><?= MemberHelper::currencyConverter($this->currency, $user["amount"]); ?> <?= $this->currency; ?></td>
                                                <td><?= $direct["username"] ?> bought the <?= $pack; ?> pack.</td>

                                                <td><?= $user["type"] ?></td>

                                                <td><?= date("d-F-Y H:i", strtotime($date)); ?></td>
                                            </tr>
                                    <?php $key = $key + 1;
                                        }
                                    } ?>

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>
                                        <th>Description</th>
                                        <th>Time</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>


        <div class="row">
            <div class="col-12">
                <div class="card  custom-card m-b-20">
        <div class="card-header">
          <div class="card-title">
         Agent Mini Statements
          </div>
        </div>
                    <div class="card-body table-card-body">
                        <div class="table-responsive">
                          <table id="datatable-basic2" class="table table-bordered text-nowrap" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>
                                        <th>Description</th>
                                        <th>Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($data['agent_mini_statement']) {
                                        $key = 1;
                                        foreach ($data['agent_mini_statement'] as $user) {
                                            $direct = Helpers::getUserObj($user["user_id"]);
                                            // $pack = MemberHelper::packagename($user["package_id"]);
                                            $sponsor = Helpers::getUserObj($user["sponsor_id"]);
                                            $date = $user["date"];
                                    ?>
                                            <tr>
                                                <td><?= $key; ?></td>
                                                <td><?= "FC" . $user["id"] ?></td>
                                                <td><?= $user["before_earning_amount"]; ?></td>
                                                <td><?= $user["after_earning_amount"]; ?></td>
                                                <td><?= MemberHelper::currencyConverter($this->currency, $user["amount"]); ?> <?= $this->currency; ?></td>
                                                <td><?= $direct["username"] ?> bought the Agent pack.</td>

                                                <td><?= $user["type"] ?></td>

                                                <td><?= date("d-F-Y H:i", strtotime($date)); ?></td>
                                            </tr>
                                    <?php $key = $key + 1;
                                        }
                                    } ?>


                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>
                                        <th>Description</th>
                                        <th>Time</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>


        <div class="row">
            <div class="col-12">
                <div class="card  custom-card m-b-20">
        <div class="card-header">
          <div class="card-title">
         Unlock Mini Statements
          </div>
        </div>
                    <div class="card-body table-card-body">
                        <div class="table-responsive">
                          <table id="datatable-basic3" class="table table-bordered text-nowrap" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>

                                        <th>Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($data['unlock_mini_statement']) {
                                        $key = 1;
                                        foreach ($data['unlock_mini_statement'] as $user) {
                                            $direct = Helpers::getUserObj($user["user_id"]);
                                            // $pack = MemberHelper::packagename($user["package_id"]);
                                            $sponsor = Helpers::getUserObj($user["sponsor_id"]);
                                            $date = $user["date"];
                                    ?>
                                            <tr>
                                                <td><?= $key; ?></td>
                                                <td><?= "FC" . $user["id"] ?></td>
                                                <td><?= $user["before_earning_amount"]; ?></td>
                                                <td><?= $user["after_earning_amount"]; ?></td>
                                                <td><?= MemberHelper::currencyConverter($this->currency, $user["amount"]); ?> <?= $this->currency; ?></td>
                                                <td><?= $direct["username"] ?> unlocked the <?= $user["type"] ?>
                                                    <?php if ($user['type'] == "Cashback Bonus") {
                                                        if ($user['package_id'] == 1) { ?>
                                                            <span class="badge bg-danger">5000</span>
                                                        <?php }
                                                        if ($user['package_id'] == 2) { ?>
                                                            <span class="badge bg-danger">10000</span>
                                                    <?php }
                                                    } ?>
                                                </td>



                                                <td><?= date("d-F-Y H:i", strtotime($date)); ?></td>
                                            </tr>
                                    <?php $key = $key + 1;
                                        }
                                    } ?>


                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>

                                        <th>Time</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>


        <div class="row">
            <div class="col-12">
                <div class="card  custom-card m-b-20">
        <div class="card-header">
          <div class="card-title">
         Verification Mini Statements
          </div>
        </div>
                    <div class="card-body table-card-body">
                        <div class="table-responsive">
                          <table id="datatable-basic4" class="table table-bordered text-nowrap" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>

                                        <th>Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($data['verification_mini_statement']) {
                                        $key = 1;
                                        foreach ($data['verification_mini_statement'] as $user) {
                                            $direct = Helpers::getUserObj($user["user_id"]);
                                            // $pack = MemberHelper::packagename($user["package_id"]);
                                            $sponsor = Helpers::getUserObj($user["sponsor_id"]);
                                            $date = $user["date"];
                                    ?>
                                            <tr>
                                                <td><?= $key; ?></td>
                                                <td><?= "FC" . $user["id"] ?></td>
                                                <td><?= $user["before_earning_amount"]; ?></td>
                                                <td><?= $user["after_earning_amount"]; ?></td>
                                                <td><?= MemberHelper::currencyConverter($this->currency, $user["amount"]); ?> <?= $this->currency; ?></td>
                                                <td><?= $direct["username"] ?> Bought the Verification Package

                                                </td>



                                                <td><?= date("d-F-Y H:i", strtotime($date)); ?></td>
                                            </tr>
                                    <?php $key = $key + 1;
                                        }
                                    } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>

                                        <th>Time</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>



        <div class="row">
            <div class="col-12">
               <div class="card  custom-card m-b-20">
        <div class="card-header">
          <div class="card-title">
         Access Code Mini Statements
          </div>
        </div>
                    <div class="card-body table-card-body">
                        <div class="table-responsive">
                          <table id="datatable-basic5" class="table table-bordered text-nowrap" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>

                                        <th>Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($data['access_code_mini_statement']) {
                                        $key = 1;
                                        foreach ($data['access_code_mini_statement'] as $user) {
                                            $direct = Helpers::getUserObj($user["user_id"]);
                                            // $pack = MemberHelper::packagename($user["package_id"]);
                                            $sponsor = Helpers::getUserObj($user["sponsor_id"]);
                                            $date = $user["date"];
                                    ?>
                                            <tr>
                                                <td><?= $key; ?></td>
                                                <td><?= "FC" . $user["id"] ?></td>
                                                <td><?= $user["before_earning_amount"]; ?></td>
                                                <td><?= $user["after_earning_amount"]; ?></td>
                                                <td><?= MemberHelper::currencyConverter($this->currency, $user["amount"]); ?> <?= $this->currency; ?></td>
                                                <td><?= $direct["username"] ?> Bought the Access Code Package

                                                </td>



                                                <td><?= date("d-F-Y H:i", strtotime($date)); ?></td>
                                            </tr>
                                    <?php $key = $key + 1;
                                        }
                                    } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>

                                        <th>Time</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>



        <div class="row">
            <div class="col-12">
               <div class="card  custom-card m-b-20">
        <div class="card-header">
          <div class="card-title">
         Forex Classes Mini Statements
          </div>
        </div>
                    <div class="card-body table-card-body">
                        <div class="table-responsive">
                          <table id="datatable-basic6" class="table table-bordered text-nowrap" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>

                                        <th>Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($data['forex_classes_mini']) {
                                        $key = 1;
                                        foreach ($data['forex_classes_mini'] as $user) {
                                            $direct = Helpers::getUserObj($user["user_id"]);
                                            // $pack = MemberHelper::packagename($user["package_id"]);
                                            $sponsor = Helpers::getUserObj($user["sponsor_id"]);
                                            $date = $user["date"];
                                    ?>
                                            <tr>
                                                <td><?= $key; ?></td>
                                                <td><?= "FC" . $user["id"] ?></td>
                                                <td><?= $user["before_earning_amount"]; ?></td>
                                                <td><?= $user["after_earning_amount"]; ?></td>
                                                <td><?= MemberHelper::currencyConverter($this->currency, $user["amount"]); ?> <?= $this->currency; ?></td>
                                                <td><?= $direct["username"] ?> Bought the Forex Classes Package

                                                </td>



                                                <td><?= date("d-F-Y H:i", strtotime($date)); ?></td>
                                            </tr>
                                    <?php $key = $key + 1;
                                        }
                                    } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>

                                        <th>Time</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>




        <div class="row">
            <div class="col-12">
               <div class="card  custom-card m-b-20">
        <div class="card-header">
          <div class="card-title">
         Google Ads Mini Statements
          </div>
        </div>
                    <div class="card-body table-card-body">
                        <div class="table-responsive">
                          <table id="datatable-basic7" class="table table-bordered text-nowrap" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>

                                        <th>Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($data['google_ads_mini']) {
                                        $key = 1;
                                        foreach ($data['google_ads_mini'] as $user) {
                                            $direct = Helpers::getUserObj($user["user_id"]);
                                            // $pack = MemberHelper::packagename($user["package_id"]);
                                            $sponsor = Helpers::getUserObj($user["sponsor_id"]);
                                            $date = $user["date"];
                                    ?>
                                            <tr>
                                                <td><?= $key; ?></td>
                                                <td><?= "FC" . $user["id"] ?></td>
                                                <td><?= $user["before_earning_amount"]; ?></td>
                                                <td><?= $user["after_earning_amount"]; ?></td>
                                                <td><?= MemberHelper::currencyConverter($this->currency, $user["amount"]); ?> <?= $this->currency; ?></td>
                                                <td><?= $direct["username"] ?> Bought the Google Ads Package

                                                </td>



                                                <td><?= date("d-F-Y H:i", strtotime($date)); ?></td>
                                            </tr>
                                    <?php $key = $key + 1;
                                        }
                                    } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>

                                        <th>Time</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>





        <div class="row">
            <div class="col-12">
               <div class="card  custom-card m-b-20">
        <div class="card-header">
          <div class="card-title">
         Online Writing Mini Statements
          </div>
        </div>
                    <div class="card-body table-card-body">
                        <div class="table-responsive">
                          <table id="datatable-basic8" class="table table-bordered text-nowrap" style="width:100%">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>

                                        <th>Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php if ($data['online_writing_mini']) {
                                        $key = 1;
                                        foreach ($data['online_writing_mini'] as $user) {
                                            $direct = Helpers::getUserObj($user["user_id"]);
                                            // $pack = MemberHelper::packagename($user["package_id"]);
                                            $sponsor = Helpers::getUserObj($user["sponsor_id"]);
                                            $date = $user["date"];
                                    ?>
                                            <tr>
                                                <td><?= $key; ?></td>
                                                <td><?= "FC" . $user["id"] ?></td>
                                                <td><?= $user["before_earning_amount"]; ?></td>
                                                <td><?= $user["after_earning_amount"]; ?></td>
                                                <td><?= MemberHelper::currencyConverter($this->currency, $user["amount"]); ?> <?= $this->currency; ?></td>
                                                <td><?= $direct["username"] ?> Bought the Online Writing Package

                                                </td>



                                                <td><?= date("d-F-Y H:i", strtotime($date)); ?></td>
                                            </tr>
                                    <?php $key = $key + 1;
                                        }
                                    } ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>#</th>
                                        <th>TransID</th>
                                        <th>Before Earning Balance</th>
                                        <th>After Earning Balance</th>
                                        <th>Amount</th>
                                        <th>Action</th>

                                        <th>Time</th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>

        </div>


    </div>
</div>