<div class="page-header-breadcrumb d-md-flex d-block align-items-center justify-content-between ">
    <h4 class="fw-medium mb-0">Paypal Verification</h4>
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);" class="-50">Paypal Verification</a>
        </li>
        <li class="breadcrumb-item active" aria-current="page"><?= Helpers::getPageName(); ?></li>
    </ol>
</div>


<div class="main-content app-content">
    <div class="container-fluid mb-4">


        <div class="row">
            <div class="col-xl-10 m-auto">
                <?php if ($this->session->flashdata()) { ?>
                    <div class="mt-5 mb-2"><?php echo Helpers::showFlash($this->session->flashdata("response")); ?></div>
                <?php   } ?>
                <div class="card custom-card">
                    <div class="card-header">
                        <div class="card-title">
                            Paypal Verification
                        </div>
                    </div>
                    <div class="card-body">
                        <form method="post" enctype="multipart/form-data">
                            <div class="mb-3">
                                <label for="exampleInputEmail1" class="form-label">Paypal Email</label>
                                <input type="text" name="paypal_email" class="form-control" required>

                            </div>
                            <div class="mb-3">
                                <label for="exampleInputPassword1" class="form-label">Amount Id</label>
                                <input type="text" class="form-control" name="amount" id="exampleInputPassword1" required>
                            </div>
                            <button type="submit" class="btn btn-primary">Submit</button>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-xl-12">
                <div class="card custom-card">
                    <div class="card-header">
                        <!-- <div class="card-title">
                            Used Epins
                        </div> -->
                    </div>
                    <div class="card-body table-card-body">
                        <div class="table-responsive">
                            <table id="datatable-basic2" class="table table-bordered text-nowrap" style="width:100%">
                                <thead>
                                    <tr>
                                        <th scope="col">Id</th>
                                        <th scope="col">Paypal Email</th>
                                        <th scope="col">Amount </th>
                                        <th scope="col">Status</th>

                                        <th scope="col">Date</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $key = 1;
                                    if ($data) {
                                        foreach ($data as $user) {
                                            $date = $user["date"];
                                    ?>
                                            <tr>
                                                <td><?= $key ?></td>
                                                <td><?= $user["paypal_email"] ?></td>
                                                <td><?= MemberHelper::currencyConverter($this->currency, $user["amount"]); ?> <?= $this->currency; ?></td>
                                                <?php if ($user['status'] == 0) { ?>
                                                    <td><span class="badge bg-warning">Pending</span></td>
                                                <?php } elseif ($user['status'] == 1) { ?>
                                                    <td><span class="badge bg-success">Accepted</span></td>
                                                <?php } elseif ($user['status'] == 2) { ?>
                                                    <td><span class="badge bg-danger">Rejected</span></td>
                                                <?php } ?>
                                                <td><?= date("d-F-Y", strtotime($date)); ?></td>
                                            </tr>
                                    <?php $key = $key + 1;
                                        }
                                    } ?>
                                </tbody>
                            </table>

                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</div>