<?php
/**
 * libSSE-php
 *
 * Copyright (C) Tony Yip 2016.
 *
 * Permission is hereby granted, free of charge,
 * to any person obtaining a copy of this software
 * and associated documentation files (the "Software"),
 * to deal in the Software without restriction,
 * including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons
 * to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice
 * shall be included in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS",
 * WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * @category libSSE-php
 * @author   Licson Lee <licson0729@gmail.com>
 * @license  http://opensource.org/licenses/MIT MIT License
 */

/**
 * It has same result in data, but using the Symfony HttpFoundation Component
 *
 * Able to be used for Symfony or Laravel
 */

require_once __DIR__ . '/../../vendor/autoload.php';

use \Symfony\Component\HttpFoundation\StreamedResponse;
use Sse\Event;
use Sse\SSE;

class TimeEvent implements Event {
    public function check(){
        return true;
    }

    public function update(){
        return date('l, F jS, Y, h:i:s A');
    }
}

$sse = new SSE;
$sse->exec_limit = 10;
$sse->addEventListener('time', new TimeEvent());
$response = $sse->createResponse();

$response->send();