<?php
$adminData = Helpers::getAdmin(true);
?>
<!-- PAGE HEADER -->
<div class="page-header-breadcrumb d-md-flex d-block align-items-center justify-content-between ">
    <h4 class="fw-medium mb-0">Order Confirm</h4>
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);" class="-50">Order Confirm</a>
        </li>
        <li class="breadcrumb-item active" aria-current="page"><?= Helpers::getPageName(); ?></li>
    </ol>
</div>
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="container">
            <!-- Start::row-1 -->

            <div class="row">
                <div class="col-lg-12 mx-auto col-md-12 text-center ">

                    <?php if ($this->session->flashdata()) { ?>
                        <div class="mt-5 mb-2"><?php echo Helpers::showFlash($this->session->flashdata("response")); ?> </div>
                    <?php    } ?>
                </div>
                <div class="col-xl-9">
                    <div class="card custom-card">
                        <div class="card-body p-0 product-checkout">
                            <ul class="nav nav-tabs tab-style-6 nav-justified d-sm-flex d-block border-bottom border-block-end-dashed" id="myTab1" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="order-tab" data-bs-toggle="tab"
                                        data-bs-target="#order-tab-pane" type="button" role="tab"
                                        aria-controls="order-tab" aria-selected="true">Delivery Address</button>
                                </li>
                            </ul>
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active border-0 p-0" id="order-tab-pane" role="tabpanel"
                                    aria-labelledby="order-tab-pane" tabindex="0">
                                    <div class="p-4">
                                        <div class="card-body p-0">
                                            <div class="p-3 border-bottom border-block-end-dashed">
                                                <div class="d-flex align-items-center justify-content-between mb-3">
                                                    <div class="text-black op-7">Full Name</div>
                                                    <div class="fw-semibold fs-14"><?= $data['full_name']; ?></div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between mb-3">
                                                    <div class="text-black op-7">Street Address</div>
                                                    <div class="fw-semibold fs-14"><?= $data['street']; ?></div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between mb-3">
                                                    <div class="text-black op-7">Phone Number</div>
                                                    <div class="fw-semibold fs-14"><?= $data['phone']; ?></div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between mb-3">
                                                    <div class="text-black op-7">State</div>
                                                    <div class="fw-semibold fs-14"><?= $data['state']; ?></div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between mb-3">
                                                    <div class="text-black op-7">City</div>
                                                    <div class="fw-semibold fs-14"><?= $data['city']; ?></div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between mb-3">
                                                    <div class="text-black op-7">Country</div>
                                                    <div class="fw-semibold fs-14"><?= $data['country']; ?></div>
                                                </div>
                                                <div class="d-flex align-items-center justify-content-between mb-3">
                                                    <div class="text-black op-7">Zip Code</div>
                                                    <div class="fw-semibold fs-14"><?= $data['zip_code']; ?></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3">
                    <div class="card custom-card">
                        <div class="card-header">
                            <div class="card-title me-1">Payment</div>
                        </div>
                        <div class="card-body p-0">
                            <div class="p-3 border-bottom border-block-end-dashed">
                                <div class="d-flex align-items-center justify-content-between mb-3">
                                    <div class="text-muted op-7">Sub Total</div>
                                    <?php $sub = $this->cart->total(); ?>
                                    <div class="fw-semibold fs-14"><?= $sub; ?> KES</div>
                                </div>
                                <?php if ($this->cart->contents()) { ?>
                                    <form method="POST" action="<?= base_url() . 'payment' ?>" enctype="multipart/form-data">
                                        <input type="hidden" name="amount" value="<?= $sub ?>">
                                        <input type="submit" name="proceed" class="btn btn-primary mt-3" value="Proceed to Payment">

                                    </form>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
                <!--End::row-1 -->
            </div>
        </div>
    </div>
</div>