 <div class="page-header-breadcrumb d-md-flex d-block align-items-center justify-content-between ">
     <h4 class="fw-medium mb-0">Notification</h4>
     <ol class="breadcrumb">
         <li class="breadcrumb-item"><a href="javascript:void(0);" class="-50">Notification</a>
         </li>
         <li class="breadcrumb-item active" aria-current="page"><?= Helpers::getPageName(); ?></li>
     </ol>
 </div>


 <div class="main-content app-content">
     <div class="container-fluid mb-4">

         <!-- Section: Notifications Only For You -->
         <div class="row mb-5">
             <div class="col-12">
                 <div class="card  h-100" data-type="only-for-you">
                     <div class="card-header text-center bg-light">
                         <h4 class=" text-dark mb-0">
                             Notifications Only For You
                         </h4>
                     </div>

                     <div class="card-body">
                         <?php if (!empty($data)): ?>
                             <div class="row">
                                 <?php foreach ($data as $row): ?>
                                     <?php
                                        if (!empty($row['from_id'])) {
                                            $fromUser = Helpers::getUserObj($row['from_id']);
                                            $avatar = !empty($fromUser['image']) ? base_url($fromUser['image']) : base_url('assets/images/faces/1.jpg');
                                            $username = $fromUser['username'];
                                        } else {
                                            $avatar = base_url('assets/images/faces/1.jpg');
                                            $username = 'Admin';
                                        }
                                        ?>
                                     <div class="col-xl-3 col-md-6 mb-4 ">
                                         <div class="card custom-shadow h-100">
                                             <div class="card-header d-flex align-items-center">
                                                 <div class="me-2">
                                                     <div class="avatar avatar-sm">
                                                         <img alt="avatar" class="rounded-circle" src="<?= htmlspecialchars($avatar); ?>">
                                                     </div>
                                                 </div>
                                                 <div>
                                                     <div class="fs-15 fw-semibold"><?= htmlspecialchars($username); ?></div>
                                                 </div>
                                             </div>
                                             <div class="card-body">
                                                 <div class="fw-semibold mb-2">Subject: <?= htmlspecialchars($row['subject']); ?></div>
                                                 <div class="text-muted"><?= htmlspecialchars($row['msg']); ?></div>
                                             </div>
                                             <div class="card-footer d-flex justify-content-between">
                                                 <div class="fs-semibold fs-14">Date</div>
                                                 <div class="fw-semibold text-primary"><?= date("d M, Y", strtotime($row['created_at'] ?? date("Y-m-d"))); ?></div>
                                             </div>
                                         </div>
                                     </div>
                                 <?php endforeach; ?>
                             </div>
                         <?php else: ?>
                             <div class="text-center py-2">
                                 <p class="text-muted fs-16 mb-0">No Notifications Found...</p>
                             </div>
                         <?php endif; ?>
                     </div>
                 </div>
             </div>
         </div>

         <!-- Section: Notifications For All Users -->
         <div class="row mb-5">
             <div class="col-12">
                 <div class="card  h-100" data-type="for-all">
                     <div class="card-header text-center bg-light">
                         <h4 class=" text-dark mb-0" >
                             Notifications For All Users
                         </h4>
                     </div>
                     <div class="card-body">
                         <?php if (!empty($data1)): ?>
                             <div class="row">
                                 <?php foreach ($data1 as $row1): ?>
                                     <?php
                                        $avatar = base_url('assets/images/faces/1.jpg'); // default admin image
                                        $username = 'Admin';
                                        ?>
                                     <div class="col-xl-3  col-md-6 mb-4">
                                         <div class="card custom-shadow h-100">
                                             <div class="card-header d-flex align-items-center">
                                                 <div class="me-2">
                                                     <div class="avatar avatar-sm">
                                                         <img alt="avatar" class="rounded-circle" src="<?= htmlspecialchars($avatar); ?>">
                                                     </div>
                                                 </div>
                                                 <div>
                                                     <div class="fs-15 fw-semibold"><?= htmlspecialchars($username); ?></div>
                                                 </div>
                                             </div>
                                             <div class="card-body">
                                                 <div class="fw-semibold mb-2">Subject: <?= htmlspecialchars($row1['subject']); ?></div>
                                                 <div class="text-muted"><?= htmlspecialchars($row1['msg']); ?></div>
                                             </div>
                                             <div class="card-footer d-flex justify-content-between">
                                                 <div class="fs-semibold fs-14">Date</div>
                                                 <div class="fw-semibold text-success"><?= date("d M, Y", strtotime($row1['created_at'] ?? date("Y-m-d"))); ?></div>
                                             </div>
                                         </div>
                                     </div>
                                 <?php endforeach; ?>
                             </div>
                         <?php else: ?>
                             <div class="text-center py-2">
                                 <p class="text-muted fs-16 mb-0">No Notifications Found...</p>
                             </div>
                         <?php endif; ?>
                     </div>
                 </div>
             </div>
         </div>

     </div>
 </div>
 <style>
     /* Card overall style */
     .custom-shadow {
         border-radius: 15px;
         overflow: hidden;
         background-color: #ffffff;
         transition: all 0.4s ease;
         box-shadow: 0 4px 15px rgba(0, 0, 0, 0.08), 0 2px 5px rgba(0, 0, 0, 0.05);
     }

   
 </style>