 <div class="page-header-breadcrumb d-md-flex d-block align-items-center justify-content-between ">
     <h4 class="fw-medium mb-0">loan</h4>
     <ol class="breadcrumb">
         <li class="breadcrumb-item"><a href="javascript:void(0);" class="-50">loan</a>
         </li>
         <li class="breadcrumb-item active" aria-current="page"><?= Helpers::getPageName(); ?></li>
     </ol>
 </div>


 <div class="main-content app-content">
     <div class="container-fluid mb-4">
         <?php if ($this->session->flashdata()) { ?>
             <div class="mt-5 mt-2"> <?php echo Helpers::showFlash($this->session->flashdata("response")); ?></div>
         <?php    } ?>
         <div class="card custom-card shadow-sm border-0">
             <div class="card-body">
                 <div class="row g-3 align-items-start">

                     <!-- Left Side: Loan Info -->
                     <div class="col-md-6 border-end pe-4">
                         <div class="d-flex align-items-center mb-3">

                             <h5 class="fw-semibold mb-0">Loan Application</h5>
                         </div>

                         <div class="mb-2 fs-12 badge bg-primary">
                             Balance:

                             <?php
                                $amount = MemberHelper::ewallet();
                                echo MemberHelper::currencyConverter($this->currency, $amount);
                                ?> <?= $this->currency; ?>
                         </div>
                         <p class="mb-1 fs-12  fw-semibold"> 6.8% Interest fees will be charged</p>
                         <p class="mb-2 fs-12  fw-semibold">Loan processing fee is <?= MemberHelper::currencyConverter($this->currency, 100); ?> <?= $this->currency; ?></p>
                         <p class="mb-2 fs-12  fw-semibold">You can borrow up to <?= MemberHelper::currencyConverter($this->currency, 100000); ?> <?= $this->currency; ?></p>
                     </div>

                     <!-- Right Side: Loan Form -->
                     <div class="col-md-6 ps-4">
                         <?php if (validation_errors()) { ?>
                             <div class="alert alert-danger py-1 px-2 fs-12"><?= validation_errors(); ?></div>
                         <?php } ?>
                         <form method="post" enctype="multipart/form-data">
                             <div class="mb-3">
                                 <label for="exampleInputEmail1" class="form-label">Amount in KES</label>
                                 <input type="text" name="amount" placeholder="Amount (<?= $this->currency; ?>)" class="form-control" required>

                             </div>
                             <div class="mb-3">
                                 <label for="exampleInputPassword1" class="form-label">Duration in months</label>
                                 <input type="text" class="form-control" name="time" id="exampleInputPassword1" required>
                             </div>
                             <input type="hidden" name="otp_request" value="1">
                             <button type="submit" class="btn btn-primary">Get A Loan</button>
                         </form>

                     </div>

                 </div>
             </div>
         </div>



         <div class="col-xl-12">
             <div class="card custom-card">
                 <div class="card-header">
                     <div class="card-title">
                         Recent Payments Queue
                     </div>
                 </div>
                 <div class="card-body table-card-body">
                     <div class="table-responsive">
                         <table id="datatable-basic" class="table table-bordered text-nowrap" style="width:100%">
                             <thead>
                                 <tr>
                                     <th>#</th>
                                     <th>Username</th>
                                     <th>Amount</th>
                                     <th>Duration</th>
                                     <th>date</th>
                                     <th></th>
                                     <th></th>
                                 </tr>
                             </thead>
                             <tbody>
                                 <?php if ($data) {
                                        $key = 0;
                                        foreach ($data as $key => $user) {
                                            $value = Helpers::getUserObj($user["user_id"]);
                                            $date = $user['date'];
                                    ?>
                                         <tr>
                                             <td><?= ($key + 1); ?></td>
                                             <td><?= $value["username"]; ?></td>
                                             <td><?= MemberHelper::currencyConverter($this->currency, $user['amount']); ?> <?= $this->currency; ?>
                                             </td>
                                             <td><?= $user['duration']; ?></td>
                                             <td><?= date("d-F-Y", strtotime($date)); ?></td>
                                         </tr>

                                 <?php
                                            $key = $key + 1;
                                        }
                                    }

                                    ?>
                             </tbody>

                         </table>

                     </div>
                 </div>

             </div>
         </div>



     </div>
 </div>