<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, minimum-scale=1.0">

    <title>Znabdeal</title>


    <!-- Favicon -->
    <link rel="icon" type="image/png" href="<?= base_url(); ?>website/images/icons/favicon.png">

    <!-- WebFont.js -->
    <script>
        WebFontConfig = {
            google: {
                families: ['Poppins:400,500,600,700,800']
            }
        };
        (function(d) {
            var wf = d.createElement('script'),
                s = d.scripts[0];
            wf.src = '<?= base_url(); ?>website/js/webfont.js';
            wf.async = true;
            s.parentNode.insertBefore(wf, s);
        })(document);
    </script>

    <link rel="preload" href="<?= base_url(); ?>website/vendor/fontawesome-free/webfonts/fa-regular-400.woff2" as="font" type="font/woff2" crossorigin="anonymous">
    <link rel="preload" href="<?= base_url(); ?>website/vendor/fontawesome-free/webfonts/fa-solid-900.woff2" as="font" type="font/woff2" crossorigin="anonymous">
    <link rel="preload" href="<?= base_url(); ?>website/vendor/fontawesome-free/webfonts/fa-brands-400.woff2" as="font" type="font/woff2" crossorigin="anonymous">
    <link rel="preload" href="<?= base_url(); ?>website/fonts/wolmart.woff?png09e" as="font" type="font/woff" crossorigin="anonymous">

    <!-- Vendor CSS -->
    <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>website/vendor/fontawesome-free/css/all.min.css">

    <!-- Plugins CSS -->
    <link rel="stylesheet" href="<?= base_url(); ?>website/vendor/swiper/swiper-bundle.min.css">
    <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>website/vendor/animate/animate.min.css">
    <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>website/vendor/magnific-popup/magnific-popup.min.css">

    <!-- Default CSS -->
    <link rel="stylesheet" type="text/css" href="<?= base_url(); ?>website/css/demo5.min.css">
</head>

<body class="home">
    <div class="page-wrapper">

        <!-- Start of Header -->
        <header class="header">
            <div class="header-top">
                <div class="container">
                    <div class="header-left">
                        <p class="welcome-msg">Welcome to Znabdeal!</p>
                    </div>
                    <div class="header-right">
                        <div class="dropdown">
                            <a href="#currency">USD</a>
                            <div class="dropdown-box">
                                <a href="#USD">USD</a>
                                <a href="#EUR">EUR</a>
                            </div>
                        </div>
                        <!-- End of DropDown Menu -->

                        <div class="dropdown">
                            <a href="#language"><img src="<?= base_url(); ?>website/images/flags/eng.png" alt="ENG Flag" width="14" height="8" class="dropdown-image" /> ENG</a>
                            <div class="dropdown-box">
                                <a href="#ENG">
                                    <img src="<?= base_url(); ?>website/images/flags/eng.png" alt="ENG Flag" width="14" height="8" class="dropdown-image" />
                                    ENG
                                </a>
                                <a href="#FRA">
                                    <img src="<?= base_url(); ?>website/images/flags/fra.png" alt="FRA Flag" width="14" height="8" class="dropdown-image" />
                                    FRA
                                </a>
                            </div>
                        </div>
                        <!-- End of Dropdown Menu -->
                        <span class="divider d-lg-show"></span>
                        <a href="#" class="d-lg-show">Blog</a>
                        <a href="#" class="d-lg-show">Contact Us</a>
                        <a href="#" class="d-lg-show">My Account</a>
                        <a href="<?= base_url(); ?>login" class=""><i class="w-icon-account"></i>Sign In</a>
                        <span class="delimiter d-lg-show">/</span>
                        <a href="<?= base_url(); ?>register" class="ml-0 ">Register</a>
                    </div>
                </div>
            </div>
            <!-- End of Header Top -->

            <div class="header-middle">
                <div class="container">
                    <div class="header-left mr-md-4">
                        <a href="#" class="mobile-menu-toggle  w-icon-hamburger" aria-label="menu-toggle">
                        </a>
                        <a href="#" class="logo ml-lg-0">
                            <img src="<?= base_url(); ?>website/images/demos/demo5/logo-1.png" alt="logo" width="145" height="45" />
                        </a>
                        <form method="get" action="#" class="header-search hs-expanded hs-round d-none d-md-flex input-wrapper">
                            <div class="select-box">
                                <select id="category" name="category">
                                    <option value="">All Categories</option>
                                    <option value="4">Fashion</option>
                                    <option value="5">Furniture</option>
                                    <option value="6">Shoes</option>
                                    <option value="7">Sports</option>
                                    <option value="8">Games</option>
                                    <option value="9">Computers</option>
                                    <option value="10">Electronics</option>
                                    <option value="11">Kitchen</option>
                                    <option value="12">Clothing</option>
                                </select>
                            </div>
                            <input type="text" class="form-control" name="search" id="search" placeholder="Search in..." required />
                            <button class="btn btn-search" type="submit"><i class="w-icon-search"></i>
                            </button>
                        </form>
                    </div>
                    <div class="header-right ml-4">
                        <div class="header-call d-xs-show d-lg-flex align-items-center">
                            <a href="#" class="w-icon-call"></a>
                            <div class="call-info d-lg-show">
                                <h4 class="chat font-weight-normal font-size-md text-normal ls-normal text-light mb-0">
                                    <a href="#" class="text-capitalize">Call Us Now</a> :
                                </h4>
                                <a href="#" class="phone-number font-weight-bolder ls-50">0(800)123-456</a>
                            </div>
                        </div>
                        <a class="wishlist label-down link d-xs-show" href="#">
                            <i class="w-icon-heart"></i>
                            <span class="wishlist-label d-lg-show">Wishlist</span>
                        </a>
                        <a class="compare label-down link d-xs-show" href="#">
                            <i class="w-icon-compare"></i>
                            <span class="compare-label d-lg-show">Compare</span>
                        </a>
                        <div class="dropdown cart-dropdown cart-offcanvas mr-0 mr-lg-2">
                            <div class="cart-overlay"></div>
                            <a href="#" class="cart-toggle label-down link">
                                <i class="w-icon-cart">
                                    <span class="cart-count">2</span>
                                </i>
                                <span class="cart-label">Cart</span>
                            </a>
                            <div class="dropdown-box">
                                <div class="cart-header">
                                    <span>Shopping Cart</span>
                                    <a href="#" class="btn-close">Close<i class="w-icon-long-arrow-right"></i></a>
                                </div>

                                <div class="products">
                                    <div class="product product-cart">
                                        <div class="product-detail">
                                            <a href="#" class="product-name">Beige knitted
                                                elas<br>tic
                                                runner shoes</a>
                                            <div class="price-box">
                                                <span class="product-quantity">1</span>
                                                <span class="product-price">$25.68</span>
                                            </div>
                                        </div>
                                        <figure class="product-media">
                                            <a href="#">
                                                <img src="<?= base_url(); ?>website/images/cart/product-1.jpg" alt="product" height="84" width="94" />
                                            </a>
                                        </figure>
                                        <button class="btn btn-link btn-close" aria-label="button">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>

                                    <div class="product product-cart">
                                        <div class="product-detail">
                                            <a href="#" class="product-name">Blue utility
                                                pina<br>fore
                                                denim dress</a>
                                            <div class="price-box">
                                                <span class="product-quantity">1</span>
                                                <span class="product-price">$32.99</span>
                                            </div>
                                        </div>
                                        <figure class="product-media">
                                            <a href="#">
                                                <img src="<?= base_url(); ?>website/images/cart/product-2.jpg" alt="product" width="84" height="94" />
                                            </a>
                                        </figure>
                                        <button class="btn btn-link btn-close" aria-label="button">
                                            <i class="fas fa-times"></i>
                                        </button>
                                    </div>
                                </div>

                                <div class="cart-total">
                                    <label>Subtotal:</label>
                                    <span class="price">$58.67</span>
                                </div>

                                <div class="cart-action">
                                    <a href="#" class="btn btn-dark btn-outline btn-rounded">View Cart</a>
                                    <a href="#" class="btn btn-primary  btn-rounded">Checkout</a>
                                </div>
                            </div>
                            <!-- End of Dropdown Box -->
                        </div>
                    </div>
                </div>
            </div>
            <!-- End of Header Middle -->

            <div class="header-bottom sticky-content fix-top sticky-header has-dropdown">
                <div class="container">
                    <div class="inner-wrap">
                        <div class="header-left">
                            <div class="dropdown category-dropdown show-dropdown" data-visible="true">
                                <a href="#" class="text-white category-toggle" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true" data-display="static" title="Browse Categories">
                                    <i class="w-icon-category"></i>
                                    <span>Browse Categories</span>
                                </a>

                                <div class="dropdown-box">
                                    <ul class="menu vertical-menu category-menu">
                                        <?php if ($cat) {
                                            foreach ($cat as $row) { ?>

                                                <li class="">
                                                    <a class="" href="<?= base_url(); ?>product_list?name=<?= $row['name']; ?>"> <?= $row['name']; ?></a>
                                                </li>
                                        <?php }
                                        } ?>





                                    </ul>
                                </div>
                            </div>
                            <nav class="main-nav">
                                <ul class="menu active-underline">
                                    <li class="active">
                                        <a href="#">Home</a>
                                    </li>
                                    <li class="">
                                        <a href="#">About Us</a>
                                    </li>
                                    <li class="">
                                        <a href="#">Shop</a>
                                    </li>
                                    <li class="">
                                        <a href="#">Blog</a>
                                    </li>
                                    <li class="">
                                        <a href="#">Contact Us</a>
                                    </li>




                                </ul>
                            </nav>
                        </div>
                        <div class="header-right">
                            <a href="#" class="d-xl-show"><i class="w-icon-map-marker mr-1"></i>Track Order</a>
                            <a href="#"><i class="w-icon-sale"></i>Daily Deals</a>
                        </div>
                    </div>
                </div>
            </div>
        </header>
        <!-- End of Header -->

        <!-- Start of Main-->
        <main class="main">
            <div class="container">
                <div class="intro-wrapper">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="swiper-container swiper-theme animation-slider pg-inner" data-swiper-options="{
                                'slidesPerView': 1,
                                'autoplay': {
                                    'delay': 8000,
                                    'disableOnInteraction': false
                                }
                            }">
                                <div class="swiper-wrapper row gutter-no cols-1">
                                    <div class="swiper-slide intro-slide intro-slide1 banner banner-fixed br-sm" style="background-image: url(<?= base_url(); ?>website/images/demos/demo5/slides/slide-1.jpg); background-color: #5D5E62;">
                                        <div class="banner-content x-50 w-100 text-center">
                                            <h3 class="banner-title text-white text-uppercase slide-animate" data-animation-options="{'name': 'zoomIn', 'duration': '1s'}">Comfort
                                            </h3>
                                            <figure class="slide-animate floating-item" data-animation-options="{
                                                'name': 'fadeInDownShorter', 'duration': '1s', 'delay': '1s'
                                            }" data-options="{'relativeInput':true,'clipRelativeInput':true,'invertX':true,'invertY':true}" data-child-depth="0.2">
                                                <img src="<?= base_url(); ?>website/images/demos/demo5/slides/bicycle.png" alt="Bicycle" width="495" height="307" />
                                            </figure>
                                            <p class="ls-25 slide-animate" data-animation-options="{
                                                'name': 'fadeInUpShorter', 'duration': '1s', 'delay': '1s'
                                            }">Get Free Shipping on all orders over <strong class="text-secondary">$99.00</strong></p>
                                            <a href="#" class="btn btn-white btn-link btn-underline btn-icon-right slide-animate" data-animation-options="{
                                                    'name': 'fadeInUpShorter', 'duration': '1s', 'delay': '1s'
                                                }">
                                                Discover Now<i class="w-icon-long-arrow-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                    <div class="swiper-slide intro-slide intro-slide2 banner banner-fixed br-sm" style="background-image: url(<?= base_url(); ?>website/images/demos/demo5/slides/slide-2.jpg); background-color: #EBEDEC;">
                                        <div class="banner-content y-50">
                                            <div class="slide-animate" data-animation-options="{
                                                'name': 'fadeInRightShorter', 'duration': '1s'
                                            }">
                                                <h5 class="banner-subtitle text-uppercase text-primary ls-25">New
                                                    Arrivals
                                                </h5>
                                                <h3 class="banner-title text-capitalize ls-25 mb-0">Men's Fashion</h3>
                                                <div class="banner-price-info text-default font-weight-bold mb-6 ls-50">
                                                    Start at <span class="text-secondary">$12.00</span>
                                                </div>
                                                <a href="#" class="btn btn-dark btn-rounded">Shop
                                                    Now</a>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="swiper-slide intro-slide intro-slide3 banner banner-fixed br-sm" style="background-image: url(<?= base_url(); ?>website/images/demos/demo5/slides/slide-3.jpg); background-color: #E0E0DE;">
                                        <div class="banner-content text-right y-50">
                                            <div class="slide-animate" data-animation-options="{
                                                'name': 'fadeInUpShorter', 'duration': '1s'
                                            }">
                                                <h5 class="banner-subtitle text-primary text-uppercase">Best Sellers
                                                </h5>
                                                <h3 class="banner-title text-capitalize lh-1 ls-25">New
                                                    Sneaker<br>Collection</h3>
                                                <div class="banner-price-info text-uppercase text-default">
                                                    <strong class="text-dark">Up To 10%</strong> Discount
                                                </div>
                                                <a href="#" class="btn btn-dark btn-rounded">Shop
                                                    Now</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="swiper-pagination"></div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="row">
                                <div class="col-md-12 col-xs-6 mb-4">
                                    <div class="category-banner banner banner-fixed br-sm">
                                        <figure>
                                            <img src="<?= base_url(); ?>website/images/demos/demo5/categories/1-1.jpg" alt="Category" width="330" height="239" style="background-color: #605959;" />
                                        </figure>
                                        <div class="banner-content">
                                            <h3 class="banner-title text-white text-capitalize ls-25">New
                                                Lifestyle<br>Collection</h3>
                                            <h5 class="banner-subtitle text-white text-capitalize ls-25">Discount</h5>
                                            <div class="banner-price-info text-white text-uppercase ls-25">25% Off</div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 col-xs-6 mb-4">
                                    <div class="category-banner banner banner-fixed br-sm">
                                        <figure>
                                            <img src="<?= base_url(); ?>website/images/demos/demo5/categories/1-2.jpg" alt="Category" width="330" height="239" style="background-color: #eff5f5;" />
                                        </figure>
                                        <div class="banner-content">
                                            <h3 class="banner-title text-white text-capitalize ls-25 mb-3">Online
                                                Classic<br>Yoga Sale</h3>
                                            <del class="old-price text-white ls-25">$499.99</del>
                                            <div class="new-price text-secondary ls-25">$299.99</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End of Intro-wrapper -->

                <div class="swiper-container swiper-theme icon-box-wrapper appear-animate br-sm bg-white" data-swiper-options="{
                    'loop': true,
                    'spaceBetween': 30,
                    'slidesPerView': 1,
                    'autoplay': {
                        'delay': 4000,
                        'disableOnInteraction': false
                    },
                    'breakpoints': {
                        '576': {
                            'slidesPerView': 2
                        },
                        '768': {
                            'slidesPerView': 2
                        },
                        '992': {
                            'slidesPerView': 3
                        },
                        '1200': {
                            'slidesPerView': 4
                        }
                    }}">
                    <div class="swiper-wrapper row cols-md-4 cols-sm-3 cols-1">
                        <div class="swiper-slide icon-box icon-box-side text-dark">
                            <span class="icon-box-icon icon-shipping">
                                <i class="w-icon-truck"></i>
                            </span>
                            <div class="icon-box-content">
                                <h4 class="icon-box-title font-weight-bolder ls-normal">Free Shipping & Returns</h4>
                                <p class="text-default">For all orders over $99</p>
                            </div>
                        </div>
                        <div class="swiper-slide icon-box icon-box-side text-dark">
                            <span class="icon-box-icon icon-payment">
                                <i class="w-icon-bag"></i>
                            </span>
                            <div class="icon-box-content">
                                <h4 class="icon-box-title font-weight-bolder ls-normal">Secure Payment</h4>
                                <p class="text-default">We ensure secure payment</p>
                            </div>
                        </div>
                        <div class="swiper-slide icon-box icon-box-side text-dark icon-box-money">
                            <span class="icon-box-icon icon-money">
                                <i class="w-icon-money"></i>
                            </span>
                            <div class="icon-box-content">
                                <h4 class="icon-box-title font-weight-bolder ls-normal">Money Back Guarantee</h4>
                                <p class="text-default">Any back within 30 days</p>
                            </div>
                        </div>
                        <div class="swiper-slide icon-box icon-box-side text-dark icon-box-chat">
                            <span class="icon-box-icon icon-chat">
                                <i class="w-icon-chat"></i>
                            </span>
                            <div class="icon-box-content">
                                <h4 class="icon-box-title font-weight-bolder ls-normal">Customer Support</h4>
                                <p class="text-default">Call or email us 24/7</p>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End of Iocn Box Wrapper -->

                <div class="title-link-wrapper title-deals appear-animate mb-4">
                    <h2 class="title title-link">All Products</h2>
                    <div class="product-countdown-container font-size-sm text-white  align-items-center mr-auto">
                        <!-- <label>Offer Ends in: </label>
                        <div class="product-countdown countdown-compact ml-1 font-weight-bold" data-until="+10d" data-relative="true" data-compact="true">10days,00:00:00</div> -->
                    </div>
                    <a href="<?= base_url();?>login" class="ml-0">More Products<i class="w-icon-long-arrow-right"></i></a>
                </div>
                <div class="swiper-container swiper-theme appear-animate mb-6" data-swiper-options="{
                    'spaceBetween': 20,
                    'slidesPerView': 2,
                    'breakpoints': {
                        '576': {
                            'slidesPerView': 3
                        },
                        '768': {
                            'slidesPerView': 4
                        },
                        '992': {
                            'slidesPerView': 5
                        }
                    }
                }">
                    <div class="swiper-wrapper row cols-lg-5 cols-md-4 cols-sm-3 cols-2">
                    <?php if ($data) {
                                    foreach ($data as $row) {
                                      
                                ?>  
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center">
                                <figure class="product-media">
                                    <a href="<?= base_url(); ?>product_details?id=<?= $row['id']; ?>">
                                        <img src="<?= base_url(); ?>uploads/files/products/1/<?= $row['image1']; ?>" alt="Product" width="300" height="338">
                                        <img src="<?= base_url(); ?>uploads/files/products/1/<?= $row['image2']; ?>" alt="Product" width="300" height="338">
                                    </a>
                                    <div class="product-action-vertical">
                                        <a href="<?= base_url(); ?>cart?id=<?= $row['id']; ?>" class="btn-product-icon w-icon-cart" title="Add to cart"></a>
                                      
                                    </div>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name"><a href="<?= base_url(); ?>product_details?id=<?= $row['id']; ?>"><?= $row['name']; ?></a>
                                    </h4>
                                    <!-- <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 80%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                        <a href="#" class="rating-reviews">(1 Reviews)</a>
                                    </div> -->
                                    <div class="product-price">
                                        <ins class="new-price"><?= $row['selling_price']; ?> KES</ins><del class="old-price"><?= $row['selling_price']+100; ?> KES</del>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php } }?>
                        <!-- End of Product Wrap -->
                    
                        <!-- End of Product Wrap -->
                        
                        <!-- End of Product Wrap -->
                    
                        <!-- End of Product Wrap -->
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
                <!-- End of Prodcut Deals Wrapper -->

                <div class="swiper-container swiper-theme shadow-swiper icon-category-wrapper appear-animate mb-10 pb-2" data-swiper-options="{
                    'spaceBetween': 20,
                    'slidesPerView': 2,
                    'breakpoints': {
                        '480': {
                            'slidesPerView': 3
                        },
                        '768': {
                            'slidesPerView': 5
                        },
                        '992': {
                            'slidesPerView': 6
                        },
                        '1200': {
                            'slidesPerView': 8
                        }
                    }
                }">
                    <div class="swiper-wrapper row cols-xl-8 cols-lg-7 cols-md-6 cols-sm-4 cols-xs-3 cols-2 justify-content-center">

                        <?php if ($cat) {
                            foreach ($cat as $row) { ?>
                                <div class="swiper-slide category category-icon">
                                    <a href="<?= base_url(); ?>product_list?name=<?= $row['name']; ?>">
                                        <figure class="category-media">
                                            <i class="fa fa-shopping-cart"></i>
                                        </figure>
                                    </a>
                                    <div class="category-content">
                                        <h4 class="category-name"><a href="<?= base_url(); ?>product_list?name=<?= $row['name']; ?>"><?= $row['name']; ?></a></h4>
                                    </div>
                                </div>

                        <?php }
                        } ?>



                    </div>
                    <div class="swiper-pagination"></div>
                </div>
                <!-- End of Icon Category Wrapper -->

                

                <div class="category-banner-wrapper appear-animate row mb-5">
                    <div class="col-md-6 mb-4">
                        <div class="banner banner-fixed br-sm">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/categories/2-1.jpg" alt="Category Banner" width="680" height="180" style="background-color: #EAEAEA;" />
                            </figure>
                            <div class="banner-content y-50">
                                <h5 class="banner-subtitle text-capitalize font-weight-normal ls-25">From Online Store
                                </h5>
                                <h3 class="banner-title text-capitalize ls-10">Cosmetic Sale</h3>
                                <a href="#" class="btn btn-dark btn-link btn-underline btn-icon-right">
                                    Discover Now<i class="w-icon-long-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6 mb-4">
                        <div class="banner banner-fixed br-sm">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/categories/2-2.jpg" alt="Category Banner" width="680" height="180" style="background-color: #565960;" />
                            </figure>
                            <div class="banner-content y-50">
                                <h5 class="banner-subtitle text-white text-capitalize font-weight-normal ls-25">Season
                                    Collection</h5>
                                <h3 class="banner-title text-white text-capitalize">New Fashion Style</h3>
                                <a href="#" class="btn btn-white btn-link btn-underline btn-icon-right">
                                    Discover Now<i class="w-icon-long-arrow-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End of Category Banner Wrapper -->

                <div class="title-link-wrapper mb-4 appear-animate">
                    <h2 class="title title-link title-vendor pt-2 pb-2">Top Weekly Vendors</h2>
                </div>
                <div class="swiper">
                    <div class="swiper-container shadow-swiper swiper-theme vendor-wrapper appear-animate mb-10 pb-1" data-swiper-options="{
                        'spaceBetween': 20,
                        'slidesPerView': 1,
                        'breakpoints': {
                            '576': {
                                'slidesPerView': 2
                            },
                            '768': {
                                'slidesPerView': 3
                            },
                            '992': {
                                'slidesPerView': 4
                            }
                        }
                    }">
                        <div class="swiper-wrapper row cols-xl-4 cols-md-3 cols-sm-2 cols-1">
                            <div class="swiper-slide vendor-widget">
                                <div class="vendor-widget-banner">
                                    <figure class="vendor-banner">
                                        <a href="#">
                                            <img src="<?= base_url(); ?>website/images/demos/demo3/vendors/1.jpg" alt="Vendor Banner" width="1200" height="390" style="background-color: #ECE7DF;" />
                                        </a>
                                    </figure>
                                    <div class="vendor-details">
                                        <figure class="vendor-logo">
                                            <a href="#">
                                                <img src="<?= base_url(); ?>website/images/demos/demo3/vendors/brand-1.jpg" alt="Vendor Logo" width="90" height="90" />
                                            </a>
                                        </figure>
                                        <div class="vendor-personal">
                                            <h4 class="vendor-name">
                                                <a href="#">OAIO Store</a>
                                            </h4>
                                            <span class="vendor-product-count">27 Products</span>
                                        </div>
                                    </div>
                                </div>
                                <!-- End of Vendor Widget Banner -->
                            </div>
                            <div class="swiper-slide vendor-widget">
                                <div class="vendor-widget-banner">
                                    <figure class="vendor-banner">
                                        <a href="#">
                                            <img src="<?= base_url(); ?>website/images/demos/demo3/vendors/2.jpg" alt="Vendor Banner" width="1200" height="390" style="background-color: #293936;" />
                                        </a>
                                    </figure>
                                    <div class="vendor-details">
                                        <figure class="vendor-logo">
                                            <a href="#">
                                                <img src="<?= base_url(); ?>website/images/demos/demo3/vendors/brand-2.jpg" alt="Vendor Logo" width="90" height="90" />
                                            </a>
                                        </figure>
                                        <div class="vendor-personal">
                                            <h4 class="vendor-name">
                                                <a href="#">Trident Store</a>
                                            </h4>
                                            <span class="vendor-product-count">11 Products</span>
                                        </div>
                                    </div>
                                </div>
                                <!-- End of Vendor Widget Banner -->
                            </div>
                            <div class="swiper-slide vendor-widget">
                                <div class="vendor-widget-banner">
                                    <figure class="vendor-banner">
                                        <a href="#">
                                            <img src="<?= base_url(); ?>website/images/demos/demo3/vendors/3.jpg" alt="Vendor Banner" width="1200" height="390" style="background-color: #B8CDCE;" />
                                        </a>
                                    </figure>
                                    <div class="vendor-details">
                                        <figure class="vendor-logo">
                                            <a href="#">
                                                <img src="<?= base_url(); ?>website/images/demos/demo3/vendors/brand-3.jpg" alt="Vendor Logo" width="90" height="90" />
                                            </a>
                                        </figure>
                                        <div class="vendor-personal">
                                            <h4 class="vendor-name">
                                                <a href="#">Pam Store</a>
                                            </h4>
                                            <span class="vendor-product-count">16 Products</span>
                                        </div>
                                    </div>
                                </div>
                                <!-- End of Vendor Widget Banner -->
                            </div>
                            <div class="swiper-slide vendor-widget">
                                <div class="vendor-widget-banner">
                                    <figure class="vendor-banner">
                                        <a href="#">
                                            <img src="<?= base_url(); ?>website/images/demos/demo3/vendors/4.jpg" alt="Vendor Banner" width="1200" height="390" style="background-color: #F5F5F5;" />
                                        </a>
                                    </figure>
                                    <div class="vendor-details">
                                        <figure class="vendor-logo">
                                            <a href="#">
                                                <img src="<?= base_url(); ?>website/images/demos/demo3/vendors/brand-4.jpg" alt="Vendor Logo" width="90" height="90" />
                                            </a>
                                        </figure>
                                        <div class="vendor-personal">
                                            <h4 class="vendor-name">
                                                <a href="#">K Group Store</a>
                                            </h4>
                                            <span class="vendor-product-count">25 Products</span>
                                        </div>
                                    </div>
                                </div>
                                <!-- End of Vendor Widget Banner -->
                            </div>
                        </div>
                        <div class="swiper-pagination"></div>
                    </div>
                </div>
                <!-- End of Swiper Container -->
            </div>
            <!-- End of Container -->

            <section class="grey-section appear-animate pt-10 pb-10">
                <div class="container mb-2">
                    <div class="title-link-wrapper mb-4">
                        <h2 class="title title-link">Featured Products</h2>
                        <a href="#">More Products<i class="w-icon-long-arrow-right"></i></a>
                    </div>
                    <div class="row grid grid-type">
                        <div class="grid-item grid-item-single">
                            <div class="product product-single">
                                <div class="row align-items-center">
                                    <div class="col-md-6">
                                        <div class="product-gallery mb-0">
                                            <figure class="product-image">
                                                <img src="<?= base_url(); ?>website/images/demos/demo5/products/2-1.jpg" data-zoom-image="<?= base_url(); ?>website/images/demos/demo5/products/2-1.jpg" alt="Product Image" width="800" height="900">
                                            </figure>
                                        </div>
                                    </div>
                                    <div class="col-md-6 pr-md-4 mt-4 mt-md-0">
                                        <div class="product-details scrollable pl-0">
                                            <h2 class="product-title mb-1"><a href="#">Men's Season
                                                    Blue Clothes</a></h2>

                                            <hr class="product-divider">

                                            <div class="product-price mb-2"><ins class="new-price ls-50">$150.00 -
                                                    $180.00</ins></div>

                                            <div class="ratings-container mb-4">
                                                <div class="ratings-full">
                                                    <span class="ratings" style="width: 80%;"></span>
                                                    <span class="tooltiptext tooltip-top"></span>
                                                </div>
                                                <a href="#" class="rating-reviews">(3 Reviews)</a>
                                            </div>

                                            <div class="product-form product-variation-form product-size-swatch mb-3">
                                                <label class="mb-1">Size:</label>
                                                <div class="flex-wrap d-flex align-items-center product-variations">
                                                    <a href="#" class="size">Small</a>
                                                    <a href="#" class="size">Medium</a>
                                                    <a href="#" class="size">Large</a>
                                                    <a href="#" class="size">Extra Large</a>
                                                </div>
                                                <a href="#" class="product-variation-clean">Clean All</a>
                                            </div>

                                            <div class="product-variation-price">
                                                <span></span>
                                            </div>

                                            <div class="product-form pt-4">
                                                <div class="product-qty-form mb-2 mr-2">
                                                    <div class="input-group">
                                                        <input class="quantity form-control" type="number" min="1" max="10000000">
                                                        <button class="quantity-plus w-icon-plus"></button>
                                                        <button class="quantity-minus w-icon-minus"></button>
                                                    </div>
                                                </div>
                                                <button class="btn btn-primary btn-cart">
                                                    <i class="w-icon-cart"></i>
                                                    <span>Add to Cart</span>
                                                </button>
                                            </div>

                                            <div class="social-links-wrapper mt-1">
                                                <div class="social-links">
                                                    <div class="social-icons social-no-color border-thin">
                                                        <a href="#" class="social-icon social-facebook w-icon-facebook"></a>
                                                        <a href="#" class="social-icon social-twitter w-icon-twitter"></a>
                                                        <a href="#" class="social-icon social-pinterest fab fa-pinterest-p"></a>
                                                        <a href="#" class="social-icon social-whatsapp fab fa-whatsapp"></a>
                                                    </div>
                                                </div>
                                                <span class="divider d-xs-show"></span>
                                                <div class="product-link-wrapper d-flex">
                                                    <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"><span></span></a>
                                                    <a href="#" class="btn-product-icon btn-compare btn-icon-left w-icon-compare"><span></span></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Grid Item -->
                        <div class="grid-item grid-item-widget">
                            <div class="product product-widget">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/2-2.jpg" alt="Product" width="300" height="338">
                                    </a>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name">
                                        <a href="#">Top Rating Helmet</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 80%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$34.99</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Grid Item -->
                        <div class="grid-item grid-item-widget">
                            <div class="product product-widget">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/2-3.jpg" alt="Product" width="300" height="338">
                                    </a>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name">
                                        <a href="#">Smartphone Electronic Charger</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 80%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$35.00</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Grid Item -->
                        <div class="grid-item grid-item-widget">
                            <div class="product product-widget">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/2-4.jpg" alt="Product" width="300" height="338">
                                    </a>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name">
                                        <a href="#">Skate Pan</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 80%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$50.99</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Grid Item -->
                        <div class="grid-item grid-item-widget">
                            <div class="product product-widget">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/2-5.jpg" alt="Product" width="300" height="338">
                                    </a>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name">
                                        <a href="#">Blue Ski Boots</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 100%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$88.00</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Grid Item -->
                        <div class="grid-item grid-item-widget">
                            <div class="product product-widget">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/2-6.jpg" alt="Product" width="300" height="338">
                                    </a>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name">
                                        <a href="#">Dumbells</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 100%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$59.00</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Grid Item -->
                        <div class="grid-item grid-item-widget">
                            <div class="product product-widget">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/2-7.jpg" alt="Product" width="300" height="338">
                                    </a>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name">
                                        <a href="#">Professional Perfect Camera</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 100%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$123.00</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Grid Item -->
                        <div class="grid-item grid-item-widget">
                            <div class="product product-widget">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/2-8.jpg" alt="Product" width="300" height="338">
                                    </a>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name">
                                        <a href="#">Soft Sound Marker</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 100%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$39.99</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Grid Item -->
                        <div class="grid-item grid-item-widget">
                            <div class="product product-widget">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/2-9.jpg" alt="Product" width="300" height="338">
                                    </a>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name">
                                        <a href="#">Roller Skates</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 100%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$66.99</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Grid Item -->
                    </div>
                </div>
                <!-- End of Container -->
            </section>
            <!-- End of Grey Section -->

            <div class="container mt-10 pt-2">
                <div class="banner banner-simple appear-animate br-sm mb-10" style="background-image: url(<?= base_url(); ?>website/images/demos/demo5/banners/1.jpg);
                    background-color: #414548;">
                    <div class="banner-content align-items-center">
                        <div class="banner-price-info">
                            <div class="discount text-secondary font-weight-bolder ls-25 lh-1">
                                40<sup class="font-weight-bold p-relative">%</sup>
                                <sub class="font-weight-bold text-uppercase p-relative ls-normal">Off</sub>
                            </div>
                            <p class="text-white font-weight-bolder text-capitalize mb-0 ls-10">2021 Collection</p>
                        </div>
                        <hr class="divider bg-white">
                        <div class="banner-info mb-0">
                            <h3 class="banner-title text-white font-weight-normal ls-25">
                                We are the Leading<br>
                                <strong>Ski Tool Saler in US</strong>
                            </h3>
                            <a href="#" class="btn btn-primary btn-link btn-underline btn-icon-right">
                                Discover Now<i class="w-icon-long-arrow-right"></i></a>
                        </div>
                    </div>
                    <figure class="skrollable">
                        <img src="<?= base_url(); ?>website/images/demos/demo5/banners/ski.png" alt="Banner" data-bottom-top="transform: translateY(5vh);" data-top-bottom="transform: translateY(-5vh);">
                    </figure>
                </div>
                <!-- End of Banner Simple -->

                <div class="title-link-wrapper appear-animate mb-4">
                    <h2 class="title title-link pt-1">Apparels &amp; Clothings</h2>
                    <a href="#">More Products<i class="w-icon-long-arrow-right"></i></a>
                </div>
                <div class="swiper-container swiper-theme products-apparel appear-animate mb-7" data-swiper-options="{
                    'spaceBetween': 20,
                    'slidesPerView': 2,
                    'breakpoints': {
                        '576': {
                            'slidesPerView': 3
                        },
                        '768': {
                            'slidesPerView': 4
                        },
                        '992': {
                            'slidesPerView': 5
                        }
                    }
                }">
                    <div class="swiper-wrapper row cols-lg-5 cols-md-4 cols-sm-3 cols-2">

                        <div class="swiper-slide product-wrap">
                            <div class="product text-center">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/3-1-1.jpg" alt="Product" width="300" height="338">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/3-1-2.jpg" alt="Product" width="300" height="338">
                                    </a>
                                    <div class="product-action-vertical">
                                        <a href="#" class="btn-product-icon btn-cart w-icon-cart" title="Add to cart"></a>
                                        <!-- <a href="#" class="btn-product-icon btn-wishlist w-icon-heart" title="Add to wishlist"></a>
                                        <a href="#" class="btn-product-icon btn-quickview w-icon-search" title="Quickview"></a>
                                        <a href="#" class="btn-product-icon btn-compare w-icon-compare" title="Add to Compare"></a> -->
                                    </div>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name"><a href="#">Multi Function Watch</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 80%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                        <a href="#" class="rating-reviews">(1 Reviews)</a>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$170.00</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/3-2.jpg" alt="Product" width="300" height="338">
                                    </a>
                                    <div class="product-action-vertical">
                                        <a href="#" class="btn-product-icon btn-cart w-icon-cart" title="Add to cart"></a>
                                        <!-- <a href="#" class="btn-product-icon btn-wishlist w-icon-heart" title="Add to wishlist"></a>
                                        <a href="#" class="btn-product-icon btn-quickview w-icon-search" title="Quickview"></a>
                                        <a href="#" class="btn-product-icon btn-compare w-icon-compare" title="Add to Compare"></a> -->
                                    </div>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name"><a href="#">Men's Suede Belt</a></h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 60%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                        <a href="#" class="rating-reviews">(1 Reviews)</a>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$39.00</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/3-3.jpg" alt="Product" width="300" height="338">
                                    </a>
                                    <div class="product-action-vertical">
                                        <a href="#" class="btn-product-icon btn-cart w-icon-cart" title="Add to cart"></a>
                                        <!-- <a href="#" class="btn-product-icon btn-wishlist w-icon-heart" title="Add to wishlist"></a>
                                        <a href="#" class="btn-product-icon btn-quickview w-icon-search" title="Quickview"></a>
                                        <a href="#" class="btn-product-icon btn-compare w-icon-compare" title="Add to Compare"></a> -->
                                    </div>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name"><a href="#">Gold Watch</a></h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 100%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                        <a href="#" class="rating-reviews">(5 Reviews)</a>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$210.00</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/3-4-1.jpg" alt="Product" width="300" height="338">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/3-4-2.jpg" alt="Product" width="300" height="338">
                                    </a>
                                    <div class="product-action-vertical">
                                        <a href="#" class="btn-product-icon btn-cart w-icon-cart" title="Add to cart"></a>
                                        <!-- <a href="#" class="btn-product-icon btn-wishlist w-icon-heart" title="Add to wishlist"></a>
                                        <a href="#" class="btn-product-icon btn-quickview w-icon-search" title="Quickview"></a>
                                        <a href="#" class="btn-product-icon btn-compare w-icon-compare" title="Add to Compare"></a> -->
                                    </div>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name"><a href="#">Portable Charger</a></h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 100%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                        <a href="#" class="rating-reviews">(8 Reviews)</a>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$25.00</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/3-5.jpg" alt="Product" width="300" height="338">
                                    </a>
                                    <div class="product-action-vertical">
                                        <a href="#" class="btn-product-icon btn-cart w-icon-cart" title="Add to cart"></a>
                                        <!-- <a href="#" class="btn-product-icon btn-wishlist w-icon-heart" title="Add to wishlist"></a>
                                        <a href="#" class="btn-product-icon btn-quickview w-icon-search" title="Quickview"></a>
                                        <a href="#" class="btn-product-icon btn-compare w-icon-compare" title="Add to Compare"></a> -->
                                    </div>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name"><a href="#">Headkerchief</a></h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 80%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                        <a href="#" class="rating-reviews">(4 Reviews)</a>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$28.99</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
                <!-- End of Prodcut Wrapper -->

                <div class="row grid grid-float appear-animate">
                    <div class="col-lg-6 grid-item height-x2 grid-item-lg">
                        <div class="banner banner-fixed br-sm">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/banners/2-1.jpg" alt="Banner" width="680" height="420" style="background-color: #242529;" />
                            </figure>
                            <div class="banner-content text-center x-50 w-100 pl-4 pr-4">
                                <h5 class="banner-subtitle text-uppercase text-secondary font-weight-bold ls-25 mb-1">
                                    From Samsung</h5>
                                <h3 class="banner-title text-capitalize text-white mb-0">Introducing Galaxy Note 10</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6 grid-item height-x1 grid-item-md">
                        <div class="banner banner-fixed br-sm">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/banners/2-2.jpg" alt="Banner" width="680" height="200" style="background-color: #EEEEF0;" />
                            </figure>
                            <div class="banner-content y-50">
                                <h5 class="banner-subtitle font-weight-normal text-uppercase mb-0">New Arrivals</h5>
                                <h3 class="banner-title text-capitalize ls-25">Gymnastic Apparatus</h3>
                                <div class="banner-price-info text-default font-weight-normal">
                                    Up to <strong class="text-primary text-uppercase">25% Off</strong>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6 grid-item height-x1 grid-item-sm">
                        <div class="banner banner-fixed br-sm">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/banners/2-3.jpg" alt="Banner" width="330" height="200" style="background-color: #519DD9;" />
                            </figure>
                            <div class="banner-content text-center x-50 y-50 w-100">
                                <h3 class="banner-title text-white text-uppercase mb-1 font-weight-bolder">Hey!</h3>
                                <p class="text-white mb-0">Spend $60 and get Free US main-land delivery</p>
                                <p class="text-white mb-0">(Order under $60 only /$4.75)</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6 grid-item height-x1 grid-item-sm">
                        <div class="banner banner-fixed br-sm">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/banners/2-4.jpg" alt="Banner" width="330" height="200" style="background-color: #5F5657;" />
                            </figure>
                            <div class="banner-content y-50">
                                <h3 class="banner-title text-white text-capitalize ls-25">Men's<br>Accessories</h3>
                                <del class="old-price text-white">$499.99</del>
                                <div class="new-price text-secondary ls-25">$299.99</div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- End of Grid -->

                <div class="title-link-wrapper appear-animate mt-10 mb-4">
                    <h2 class="title title-link pt-1">Consumer Electronics</h2>
                    <a href="#" class="ls-normal">More Products<i class="w-icon-long-arrow-right"></i></a>
                </div>
                <div class="swiper-container swiper-theme appear-animate mb-9" data-swiper-options="{
                    'spaceBetween': 20,
                    'slidesPerView': 2,
                    'breakpoints': {
                        '576': {
                            'slidesPerView': 3
                        },
                        '768': {
                            'slidesPerView': 4
                        },
                        '992': {
                            'slidesPerView': 5
                        }
                    }
                }">
                    <div class="swiper-wrapper row cols-lg-5 cols-md-4 cols-sm-3 cols-2">

                        <div class="swiper-slide product-wrap">
                            <div class="product text-center">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/4-1-1.jpg" alt="Product" width="300" height="338">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/4-1-2.jpg" alt="Product" width="300" height="338">
                                    </a>
                                    <div class="product-action-vertical">
                                        <a href="#" class="btn-product-icon btn-cart w-icon-cart" title="Add to cart"></a>
                                        <!-- <a href="#" class="btn-product-icon btn-wishlist w-icon-heart" title="Add to wishlist"></a>
                                        <a href="#" class="btn-product-icon btn-quickview w-icon-search" title="Quickview"></a>
                                        <a href="#" class="btn-product-icon btn-compare w-icon-compare" title="Add to Compare"></a> -->
                                    </div>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name"><a href="#">Red Cap Sound Marker</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 80%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                        <a href="#" class="rating-reviews">(1 Reviews)</a>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$65.89 - $69.99</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/4-2.jpg" alt="Product" width="300" height="338">
                                    </a>
                                    <div class="product-action-vertical">
                                        <a href="#" class="btn-product-icon btn-cart w-icon-cart" title="Add to cart"></a>
                                        <!-- <a href="#" class="btn-product-icon btn-wishlist w-icon-heart" title="Add to wishlist"></a>
                                        <a href="#" class="btn-product-icon btn-quickview w-icon-search" title="Quickview"></a>
                                        <a href="#" class="btn-product-icon btn-compare w-icon-compare" title="Add to Compare"></a> -->
                                    </div>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name"><a href="#">Men's Black Watch</a></h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 60%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                        <a href="#" class="rating-reviews">(1 Reviews)</a>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$75.00</ins><del class="old-price">$79.00</del>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/4-3.jpg" alt="Product" width="300" height="338">
                                    </a>
                                    <div class="product-action-vertical">
                                        <a href="#" class="btn-product-icon btn-cart w-icon-cart" title="Add to cart"></a>
                                        <!-- <a href="#" class="btn-product-icon btn-wishlist w-icon-heart" title="Add to wishlist"></a>
                                        <a href="#" class="btn-product-icon btn-quickview w-icon-search" title="Quickview"></a>
                                        <a href="#" class="btn-product-icon btn-compare w-icon-compare" title="Add to Compare"></a> -->
                                    </div>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name"><a href="#">Fabulous Sound Speaker</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 100%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                        <a href="#" class="rating-reviews">(5 Reviews)</a>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$62.00</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/4-4-1.jpg" alt="Product" width="300" height="338">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/4-4-2.jpg" alt="Product" width="300" height="338">
                                    </a>
                                    <div class="product-action-vertical">
                                        <a href="#" class="btn-product-icon btn-cart w-icon-cart" title="Add to cart"></a>
                                        <!-- <a href="#" class="btn-product-icon btn-wishlist w-icon-heart" title="Add to wishlist"></a>
                                        <a href="#" class="btn-product-icon btn-quickview w-icon-search" title="Quickview"></a>
                                        <a href="#" class="btn-product-icon btn-compare w-icon-compare" title="Add to Compare"></a> -->
                                    </div>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name"><a href="#">Mini Wireless Earphone</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 100%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                        <a href="#" class="rating-reviews">(8 Reviews)</a>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$49.99</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center">
                                <figure class="product-media">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/4-5.jpg" alt="Product" width="300" height="338">
                                    </a>
                                    <div class="product-action-vertical">
                                        <a href="#" class="btn-product-icon btn-cart w-icon-cart" title="Add to cart"></a>
                                        <!-- <a href="#" class="btn-product-icon btn-wishlist w-icon-heart" title="Add to wishlist"></a>
                                        <a href="#" class="btn-product-icon btn-quickview w-icon-search" title="Quickview"></a>
                                        <a href="#" class="btn-product-icon btn-compare w-icon-compare" title="Add to Compare"></a> -->
                                    </div>
                                </figure>
                                <div class="product-details">
                                    <h4 class="product-name"><a href="#">Good-Performance
                                            Humidifier</a>
                                    </h4>
                                    <div class="ratings-container">
                                        <div class="ratings-full">
                                            <span class="ratings" style="width: 80%;"></span>
                                            <span class="tooltiptext tooltip-top"></span>
                                        </div>
                                        <a href="#" class="rating-reviews">(4 Reviews)</a>
                                    </div>
                                    <div class="product-price">
                                        <ins class="new-price">$79.00</ins>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
                <!-- End of Products -->

                <h2 class="title text-left title-client  mb-5 appear-animate">Our Clients</h2>
                <div class="swiper-container swiper-theme  brands-wrapper br-sm mb-10 appear-animate" data-swiper-options="{
                    'autoplay': false,
                    'autoplayTimeout': 4000,
                    'loop': true,
                    'spaceBetween': 20,
                    'slidesPerView': 2,
                    'breakpoints': {
                        '576': {
                            'slidesPerView': 3
                        },
                        '768': {
                            'slidesPerView': 4
                        },
                        '992': {
                            'slidesPerView': 6
                        },
                        '1200': {
                            'slidesPerView': 8
                        }
                    }
                }">
                    <div class="swiper-wrapper row cols-xl-8 cols-lg-6 cols-md-4 cols-sm-3 cols-2">

                        <div class="swiper-slide">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/brands/1.png" alt="Brand" width="310" height="180" />
                            </figure>
                        </div>
                        <div class="swiper-slide">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/brands/2.png" alt="Brand" width="310" height="180" />
                            </figure>
                        </div>
                        <div class="swiper-slide">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/brands/3.png" alt="Brand" width="310" height="180" />
                            </figure>
                        </div>
                        <div class="swiper-slide">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/brands/4.png" alt="Brand" width="310" height="180" />
                            </figure>
                        </div>
                        <div class="swiper-slide">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/brands/5.png" alt="Brand" width="310" height="180" />
                            </figure>
                        </div>
                        <div class="swiper-slide">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/brands/6.png" alt="Brand" width="310" height="180" />
                            </figure>
                        </div>
                        <div class="swiper-slide">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/brands/7.png" alt="Brand" width="310" height="180" />
                            </figure>
                        </div>
                        <div class="swiper-slide">
                            <figure>
                                <img src="<?= base_url(); ?>website/images/demos/demo5/brands/8.png" alt="Brand" width="310" height="180" />
                            </figure>
                        </div>
                    </div>
                </div>
                <!-- End of Brands Wrapper -->

                <div class="title-link-wrapper appear-animate mb-4">
                    <h2 class="title title-link title-blog">From Our Blog</h2>
                    <a href="#" class="font-weight-bold font-size-normal ls-normal">View All
                        Articles</a>
                </div>
                <div class="swiper-container swiper-theme post-wrapper appear-animate mb-3" data-swiper-options="{
                    'slidesPerView': 4,
                    'spaceBetween': 20,
                    'slidesPerView': 1,
                    'breakpoints': {
                        '576': {
                            'slidesPerView': 2
                        },
                        '768': {
                            'slidesPerView': 3
                        },
                        '992': {
                            'slidesPerView': 4
                        }
                    }
                }">
                    <div class="swiper-wrapper row cols-lg-4 cols-md-3 cols-sm-2 cols-1">
                        <div class="swiper-slide post text-center overlay-zoom">
                            <figure class="post-media br-sm">
                                <a href="#">
                                    <img src="<?= base_url(); ?>website/images/demos/demo5/blogs/1.jpg" alt="Post" width="280" height="180" style="background-color: #828896;" />
                                </a>
                            </figure>
                            <div class="post-details">
                                <div class="post-meta">
                                    by <a href="#" class="post-author">John Doe</a>
                                    - <a href="#" class="post-date mr-0">03.05.2021</a>
                                </div>
                                <h4 class="post-title"><a href="#">Aliquam tincidunt mauris eurisus</a>
                                </h4>
                                <a href="#" class="btn btn-link btn-dark btn-underline">Read More<i class="w-icon-long-arrow-right"></i></a>
                            </div>
                        </div>
                        <div class="swiper-slide post text-center overlay-zoom">
                            <figure class="post-media br-sm">
                                <a href="#">
                                    <img src="<?= base_url(); ?>website/images/demos/demo5/blogs/2.jpg" alt="Post" width="280" height="180" style="background-color: #C7C7C5;" />
                                </a>
                            </figure>
                            <div class="post-details">
                                <div class="post-meta">
                                    by <a href="#" class="post-author">John Doe</a>
                                    - <a href="#" class="post-date mr-0">03.05.2021</a>
                                </div>
                                <h4 class="post-title"><a href="#">Cras ornare tristique elit</a></h4>
                                <a href="#" class="btn btn-link btn-dark btn-underline">Read More<i class="w-icon-long-arrow-right"></i></a>
                            </div>
                        </div>
                        <div class="swiper-slide post text-center overlay-zoom">
                            <figure class="post-media br-sm">
                                <a href="#">
                                    <img src="<?= base_url(); ?>website/images/demos/demo5/blogs/3.jpg" alt="Post" width="280" height="180" style="background-color: #BDBDB5;" />
                                </a>
                            </figure>
                            <div class="post-details">
                                <div class="post-meta">
                                    by <a href="#" class="post-author">John Doe</a>
                                    - <a href="#" class="post-date mr-0">03.05.2021</a>
                                </div>
                                <h4 class="post-title"><a href="#">Vivamus vestibulum ntulla nec ante</a>
                                </h4>
                                <a href="#" class="btn btn-link btn-dark btn-underline">Read More<i class="w-icon-long-arrow-right"></i></a>
                            </div>
                        </div>
                        <div class="swiper-slide post text-center overlay-zoom">
                            <figure class="post-media br-sm">
                                <a href="#">
                                    <img src="<?= base_url(); ?>website/images/demos/demo5/blogs/4.jpg" alt="Post" width="280" height="180" style="background-color: #546B73;" />
                                </a>
                            </figure>
                            <div class="post-details">
                                <div class="post-meta">
                                    by <a href="#" class="post-author">John Doe</a>
                                    - <a href="#" class="post-date mr-0">03.05.2021</a>
                                </div>
                                <h4 class="post-title"><a href="#">Fusce lacinia arcuet nulla</a></h4>
                                <a href="#" class="btn btn-link btn-dark btn-underline">Read More<i class="w-icon-long-arrow-right"></i></a>
                            </div>
                        </div>
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
                <!-- Post Wrapper -->

                <div class="title-link-wrapper appear-animate mb-4">
                    <h2 class="title title-link title-viewed">Recently Viewed</h2>
                    <a href="#" class="font-weight-bold font-size-normal ls-normal">
                        More Products<i class="w-icon-long-arrow-right"></i></a>
                </div>
                <div class="swiper-container swiper-theme shadow-swiper appear-animate pb-4 mb-8" data-swiper-options="{
                    'nav': false,
                    'dots': true,
                    'spaceBetween': 20,
                    'slidesPerView': 2,
                    'breakpoints': {
                        '576': {
                            'slidesPerView': 3
                        },
                        '768': {
                            'slidesPerView': 5
                        },
                        '992': {
                            'slidesPerView': 6
                        },
                        '1200': {
                            'slidesPerView': 8
                        }
                    }
                }">
                    <div class="swiper-wrapper row cols-xl-8 cols-lg-6 cols-md-4 cols-2">
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center product-absolute">
                                <figure class="product-media">
                                    <a href="product-defa#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/3-5.jpg" alt="Category image" width="130" height="146" style="background-color: #fff" />
                                    </a>
                                </figure>
                                <h4 class="product-name">
                                    <a href="#">Headkerchief</a>
                                </h4>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center product-absolute">
                                <figure class="product-media">
                                    <a href="product-defa#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/1-1-1.jpg" alt="Category image" width="130" height="146" style="background-color: #fff" />
                                    </a>
                                </figure>
                                <h4 class="product-name">
                                    <a href="#">Leather Stripe Watch</a>
                                </h4>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center product-absolute">
                                <figure class="product-media">
                                    <a href="product-defa#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/4-1-1.jpg" alt="Category image" width="130" height="146" style="background-color: #fff" />
                                    </a>
                                </figure>
                                <h4 class="product-name">
                                    <a href="#">Red Cap Sound Marker</a>
                                </h4>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center product-absolute">
                                <figure class="product-media">
                                    <a href="product-defa#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/2-3.jpg" alt="Category image" width="130" height="146" style="background-color: #fff" />
                                    </a>
                                </figure>
                                <h4 class="product-name">
                                    <a href="#">Smartphone Electronic Charger</a>
                                </h4>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center product-absolute">
                                <figure class="product-media">
                                    <a href="product-defa#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/2-5.jpg" alt="Category image" width="130" height="146" style="background-color: #fff" />
                                    </a>
                                </figure>
                                <h4 class="product-name">
                                    <a href="#">Blue Ski Boots</a>
                                </h4>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center product-absolute">
                                <figure class="product-media">
                                    <a href="product-defa#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/2-8.jpg" alt="Category image" width="130" height="146" style="background-color: #fff" />
                                    </a>
                                </figure>
                                <h4 class="product-name">
                                    <a href="#">Soft Sound Marker</a>
                                </h4>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center product-absolute">
                                <figure class="product-media">
                                    <a href="product-defa#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/3-1-1.jpg" alt="Category image" width="130" height="146" style="background-color: #fff" />
                                    </a>
                                </figure>
                                <h4 class="product-name">
                                    <a href="#">Multi function Watch</a>
                                </h4>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                        <div class="swiper-slide product-wrap">
                            <div class="product text-center product-absolute">
                                <figure class="product-media">
                                    <a href="product-defa#">
                                        <img src="<?= base_url(); ?>website/images/demos/demo5/products/1-2.jpg" alt="Category image" width="130" height="146" style="background-color: #fff" />
                                    </a>
                                </figure>
                                <h4 class="product-name">
                                    <a href="#">Running Machine</a>
                                </h4>
                            </div>
                        </div>
                        <!-- End of Product Wrap -->
                    </div>
                    <div class="swiper-pagination"></div>
                </div>
                <!-- End of Reviewed Producs -->
            </div>
        </main>
        <!-- End of Main -->

        <!-- Start of Footer -->
        <footer class="footer appear-animate" data-animation-options="{
            'name': 'fadeIn'
        }">
            <div class="container">
                <div class="footer-newsletter">
                    <div class="row justify-content-center align-items-center">
                        <div class="col-xl-3 col-lg-2">
                            <a href="#" class="logo-footer">
                                <img src="<?= base_url(); ?>website/images/demos/demo5/logo-1.png" alt="logo-footer" width="145" height="45" />
                            </a>
                        </div>
                        <div class="col-xl-4 col-lg-5">
                            <div class="swiper-slide icon-box icon-box-side text-dark">
                                <div class="icon-box-icon d-inline-flex">
                                    <i class="w-icon-envelop3"></i>
                                </div>
                                <div class="icon-box-content">
                                    <h4 class="icon-box-title text-uppercase font-weight-bold">Subscribe To Our
                                        Newsletter</h4>
                                    <p>Get all the latest information on Events, Sales and Offers.</p>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-5 col-lg-5 col-md-9 mt-4 mt-lg-0 ">
                            <form action="#" method="get" class="input-wrapper input-wrapper-inline input-wrapper-rounded">
                                <input type="email" class="form-control mr-2 bg-white text-default" name="email" id="email" placeholder="Your E-mail Address" />
                                <button class="btn btn-primary btn-rounded" type="submit">Subscribe<i class="w-icon-long-arrow-right"></i></button>
                            </form>
                        </div>
                    </div>
                </div>
                <div class="footer-top">
                    <div class="row">
                        <div class="col-lg-5 col-sm-6">
                            <div class="widget widget-about">
                                <div class="widget-body">
                                    <p class="widget-about-title">Got Question? Call us 24/7</p>
                                    <a href="tel:18005707777" class="widget-about-call">1-800-570-7777</a>
                                    <p class="widget-about-desc">Facilisi nullam vehicula ipsum a arcu cursus vitae
                                        congue. Pretium quam,
                                        elit ut aliquam purus sit. Porttitor rhoncus dolor purus non enim.
                                    </p>
                                    <label class="label-social d-block text-dark">Social Media</label>
                                    <div class="social-icons social-icons-colored">
                                        <a href="#" class="social-icon social-facebook w-icon-facebook"></a>
                                        <a href="#" class="social-icon social-twitter w-icon-twitter"></a>
                                        <a href="#" class="social-icon social-instagram w-icon-instagram"></a>
                                        <a href="#" class="social-icon social-youtube w-icon-youtube"></a>
                                        <a href="#" class="social-icon social-pinterest w-icon-pinterest"></a>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-2 col-sm-6">
                            <div class="widget">
                                <h3 class="widget-title">Company</h3>
                                <ul class="widget-body">
                                    <li><a href="#">About Us</a></li>
                                    <li><a href="#">Team Member</a></li>
                                    <li><a href="#">Career</a></li>
                                    <li><a href="#">Contact Us</a></li>
                                    <li><a href="#">Affilate</a></li>
                                    <li><a href="#">Order History</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-2 col-sm-6">
                            <div class="widget">
                                <h4 class="widget-title">My Account</h4>
                                <ul class="widget-body">
                                    <li><a href="#">Track My Order</a></li>
                                    <li><a href="#">View Cart</a></li>
                                    <li><a href="#">Sign In</a></li>
                                    <li><a href="#">Help</a></li>
                                    <li><a href="#">My Wishlist</a></li>
                                    <li><a href="#">Privacy Policy</a></li>
                                </ul>
                            </div>
                        </div>
                        <div class="col-lg-2 col-sm-6">
                            <div class="widget">
                                <h4 class="widget-title">Customer Service</h4>
                                <ul class="widget-body">
                                    <li><a href="#">Payment Methods</a></li>
                                    <li><a href="#">Money-back guarantee!</a></li>
                                    <li><a href="#">Product Returns</a></li>
                                    <li><a href="#">Support Center</a></li>
                                    <li><a href="#">Shipping</a></li>
                                    <li><a href="#">Term and Conditions</a></li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="footer-bottom">
                <div class="container">
                    <div class="footer-left">
                        <p class="copyright">Copyright © 2023 Znabdeal. All Rights Reserved.</p>
                    </div>
                    <div class="footer-right">
                        <span class="payment-label mr-lg-8">We're using safe payment for</span>
                        <figure class="payment">
                            <img src="<?= base_url(); ?>website/images/payment.png" alt="payment" width="159" height="25" />
                        </figure>
                    </div>
                </div>
            </div>
        </footer>
        <!-- End of Footer -->
    </div>
    <!-- End of Page Wrapper -->

    <!-- Start of Sticky Footer -->
    <div class="sticky-footer sticky-content fix-bottom">
        <a href="#" class="sticky-link active">
            <i class="w-icon-home"></i>
            <p>Home</p>
        </a>
        <a href="#" class="sticky-link">
            <i class="w-icon-category"></i>
            <p>Shop</p>
        </a>
        <a href="#" class="sticky-link">
            <i class="w-icon-account"></i>
            <p>Account</p>
        </a>
        <div class="cart-dropdown dir-up">
            <a href="#" class="sticky-link">
                <i class="w-icon-cart"></i>
                <p>Cart</p>
            </a>
            <div class="dropdown-box">
                <div class="products">
                    <div class="product product-cart">
                        <div class="product-detail">
                            <h3 class="product-name">
                                <a href="#">Beige knitted elas<br>tic
                                    runner shoes</a>
                            </h3>
                            <div class="price-box">
                                <span class="product-quantity">1</span>
                                <span class="product-price">$25.68</span>
                            </div>
                        </div>
                        <figure class="product-media">
                            <a href="#">
                                <img src="<?= base_url(); ?>website/images/cart/product-1.jpg" alt="product" height="84" width="94" />
                            </a>
                        </figure>
                        <button class="btn btn-link btn-close" aria-label="button">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>

                    <div class="product product-cart">
                        <div class="product-detail">
                            <h3 class="product-name">
                                <a href="#">Blue utility pina<br>fore
                                    denim dress</a>
                            </h3>
                            <div class="price-box">
                                <span class="product-quantity">1</span>
                                <span class="product-price">$32.99</span>
                            </div>
                        </div>
                        <figure class="product-media">
                            <a href="#">
                                <img src="<?= base_url(); ?>website/images/cart/product-2.jpg" alt="product" width="84" height="94" />
                            </a>
                        </figure>
                        <button class="btn btn-link btn-close" aria-label="button">
                            <i class="fas fa-times"></i>
                        </button>
                    </div>
                </div>

                <div class="cart-total">
                    <label>Subtotal:</label>
                    <span class="price">$58.67</span>
                </div>

                <div class="cart-action">
                    <a href="#" class="btn btn-dark btn-outline btn-rounded">View Cart</a>
                    <a href="#" class="btn btn-primary  btn-rounded">Checkout</a>
                </div>
            </div>
            <!-- End of Dropdown Box -->
        </div>

        <div class="header-search hs-toggle dir-up">
            <a href="#" class="search-toggle sticky-link">
                <i class="w-icon-search"></i>
                <p>Search</p>
            </a>
            <form action="#" class="input-wrapper">
                <input type="text" class="form-control" name="search" autocomplete="off" placeholder="Search" required />
                <button class="btn btn-search" type="submit">
                    <i class="w-icon-search"></i>
                </button>
            </form>
        </div>
    </div>
    <!-- End of Sticky Footer -->

    <!-- Start of Scroll Top -->
    <a id="scroll-top" class="scroll-top" href="#top" title="Top" role="button"> <i class="w-icon-angle-up"></i> <svg version="1.1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 70 70">
            <circle id="progress-indicator" fill="transparent" stroke="#000000" stroke-miterlimit="10" cx="35" cy="35" r="34" style="stroke-dasharray: 16.4198, 400;"></circle>
        </svg> </a>
    <!-- End of Scroll Top -->

    <!-- Start of Mobile Menu -->
    <div class="mobile-menu-wrapper">
        <div class="mobile-menu-overlay"></div>
        <!-- End of .mobile-menu-overlay -->

        <a href="#" class="mobile-menu-close"><i class="close-icon"></i></a>
        <!-- End of .mobile-menu-close -->

        <div class="mobile-menu-container scrollable">
            <form action="#" method="get" class="input-wrapper">
                <input type="text" class="form-control" name="search" autocomplete="off" placeholder="Search" required />
                <button class="btn btn-search" type="submit">
                    <i class="w-icon-search"></i>
                </button>
            </form>
            <!-- End of Search Form -->
            <div class="tab">
                <ul class="nav nav-tabs" role="tablist">
                    <li class="nav-item">
                        <a href="#main-menu" class="nav-link active">Main Menu</a>
                    </li>
                    <li class="nav-item">
                        <a href="#categories" class="nav-link">Categories</a>
                    </li>
                </ul>
            </div>
            <div class="tab-content">
                <div class="tab-pane active" id="main-menu">
                    <ul class="mobile-menu">
                        <li><a href="#">Home</a></li>
                        <li class="">
                            <a href="#">About Us</a>
                        </li>
                        <li class="">
                            <a href="#">Shop</a>
                        </li>
                        <li class="">
                            <a href="#">Blog</a>
                        </li>
                        <li class="">
                            <a href="#">Contact Us</a>
                        </li>




                    </ul>
                </div>
                <div class="tab-pane" id="categories">
                    <ul class="mobile-menu">
                        <li>
                            <a href="#">
                                <i class="w-icon-tshirt2"></i>Fashion
                            </a>
                            <ul>
                                <li>
                                    <a href="#">Women</a>
                                    <ul>
                                        <li><a href="#">New Arrivals</a>
                                        </li>
                                        <li><a href="#">Best Sellers</a>
                                        </li>
                                        <li><a href="#">Trending</a></li>
                                        <li><a href="#">Clothing</a></li>
                                        <li><a href="#">Shoes</a></li>
                                        <li><a href="#">Bags</a></li>
                                        <li><a href="#">Accessories</a>
                                        </li>
                                        <li><a href="#">Jewlery &
                                                Watches</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="#">Men</a>
                                    <ul>
                                        <li><a href="#">New Arrivals</a>
                                        </li>
                                        <li><a href="#">Best Sellers</a>
                                        </li>
                                        <li><a href="#">Trending</a></li>
                                        <li><a href="#">Clothing</a></li>
                                        <li><a href="#">Shoes</a></li>
                                        <li><a href="#">Bags</a></li>
                                        <li><a href="#">Accessories</a>
                                        </li>
                                        <li><a href="#">Jewlery &
                                                Watches</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <a href="#">
                                <i class="w-icon-home"></i>Home & Garden
                            </a>
                            <ul>
                                <li>
                                    <a href="#">Bedroom</a>
                                    <ul>
                                        <li><a href="#">Beds, Frames &
                                                Bases</a></li>
                                        <li><a href="#">Dressers</a></li>
                                        <li><a href="#">Nightstands</a>
                                        </li>
                                        <li><a href="#">Kid's Beds &
                                                Headboards</a></li>
                                        <li><a href="#">Armoires</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="#">Living Room</a>
                                    <ul>
                                        <li><a href="#">Coffee Tables</a>
                                        </li>
                                        <li><a href="#">Chairs</a></li>
                                        <li><a href="#">Tables</a></li>
                                        <li><a href="#">Futons & Sofa
                                                Beds</a></li>
                                        <li><a href="#">Cabinets &
                                                Chests</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="#">Office</a>
                                    <ul>
                                        <li><a href="#">Office Chairs</a>
                                        </li>
                                        <li><a href="#">Desks</a></li>
                                        <li><a href="#">Bookcases</a></li>
                                        <li><a href="#">File Cabinets</a>
                                        </li>
                                        <li><a href="#">Breakroom
                                                Tables</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="#">Kitchen & Dining</a>
                                    <ul>
                                        <li><a href="#">Dining Sets</a>
                                        </li>
                                        <li><a href="#">Kitchen Storage
                                                Cabinets</a></li>
                                        <li><a href="#">Bashers Racks</a>
                                        </li>
                                        <li><a href="#">Dining Chairs</a>
                                        </li>
                                        <li><a href="#">Dining Room
                                                Tables</a></li>
                                        <li><a href="#">Bar Stools</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <a href="#">
                                <i class="w-icon-electronics"></i>Electronics
                            </a>
                            <ul>
                                <li>
                                    <a href="#">Laptops &amp; Computers</a>
                                    <ul>
                                        <li><a href="#">Desktop
                                                Computers</a></li>
                                        <li><a href="#">Monitors</a></li>
                                        <li><a href="#">Laptops</a></li>
                                        <li><a href="#">Hard Drives &amp;
                                                Storage</a></li>
                                        <li><a href="#">Computer
                                                Accessories</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="#">TV &amp; Video</a>
                                    <ul>
                                        <li><a href="#">TVs</a></li>
                                        <li><a href="#">Home Audio
                                                Speakers</a></li>
                                        <li><a href="#">Projectors</a></li>
                                        <li><a href="#">Media Streaming
                                                Devices</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="#">Digital Cameras</a>
                                    <ul>
                                        <li><a href="#">Digital SLR
                                                Cameras</a></li>
                                        <li><a href="#">Sports & Action
                                                Cameras</a></li>
                                        <li><a href="#">Camera Lenses</a>
                                        </li>
                                        <li><a href="#">Photo Printer</a>
                                        </li>
                                        <li><a href="#">Digital Memory
                                                Cards</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="#">Cell Phones</a>
                                    <ul>
                                        <li><a href="#">Carrier Phones</a>
                                        </li>
                                        <li><a href="#">Unlocked Phones</a>
                                        </li>
                                        <li><a href="#">Phone & Cellphone
                                                Cases</a></li>
                                        <li><a href="#">Cellphone
                                                Chargers</a></li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <a href="#">
                                <i class="w-icon-furniture"></i>Furniture
                            </a>
                            <ul>
                                <li>
                                    <a href="#">Furniture</a>
                                    <ul>
                                        <li><a href="#">Sofas & Couches</a>
                                        </li>
                                        <li><a href="#">Armchairs</a></li>
                                        <li><a href="#">Bed Frames</a></li>
                                        <li><a href="#">Beside Tables</a>
                                        </li>
                                        <li><a href="#">Dressing Tables</a>
                                        </li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="#">Lighting</a>
                                    <ul>
                                        <li><a href="#">Light Bulbs</a>
                                        </li>
                                        <li><a href="#">Lamps</a></li>
                                        <li><a href="#">Celling Lights</a>
                                        </li>
                                        <li><a href="#">Wall Lights</a>
                                        </li>
                                        <li><a href="#">Bathroom
                                                Lighting</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="#">Home Accessories</a>
                                    <ul>
                                        <li><a href="#">Decorative
                                                Accessories</a></li>
                                        <li><a href="#">Candals &
                                                Holders</a></li>
                                        <li><a href="#">Home Fragrance</a>
                                        </li>
                                        <li><a href="#">Mirrors</a></li>
                                        <li><a href="#">Clocks</a></li>
                                    </ul>
                                </li>
                                <li>
                                    <a href="#">Garden & Outdoors</a>
                                    <ul>
                                        <li><a href="#">Garden
                                                Furniture</a></li>
                                        <li><a href="#">Lawn Mowers</a>
                                        </li>
                                        <li><a href="#">Pressure
                                                Washers</a></li>
                                        <li><a href="#">All Garden
                                                Tools</a></li>
                                        <li><a href="#">Outdoor Dining</a>
                                        </li>
                                    </ul>
                                </li>
                            </ul>
                        </li>
                        <li>
                            <a href="#">
                                <i class="w-icon-heartbeat"></i>Healthy & Beauty
                            </a>
                        </li>
                        <li>
                            <a href="#">
                                <i class="w-icon-gift"></i>Gift Ideas
                            </a>
                        </li>
                        <li>
                            <a href="#">
                                <i class="w-icon-gamepad"></i>Toy & Games
                            </a>
                        </li>
                        <li>
                            <a href="#">
                                <i class="w-icon-ice-cream"></i>Cooking
                            </a>
                        </li>
                        <li>
                            <a href="#">
                                <i class="w-icon-ios"></i>Smart Phones
                            </a>
                        </li>
                        <li>
                            <a href="#">
                                <i class="w-icon-camera"></i>Cameras & Photo
                            </a>
                        </li>
                        <li>
                            <a href="#">
                                <i class="w-icon-ruby"></i>Accessories
                            </a>
                        </li>
                        <li>
                            <a href="#" class="font-weight-bold text-primary text-uppercase ls-25">
                                View All Categories<i class="w-icon-angle-right"></i>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
    <!-- End of Mobile Menu -->

    <!-- Start of Newsletter popup -->
    <div class="newsletter-popup mfp-hide">
        <div class="newsletter-content">
            <h4 class="text-uppercase font-weight-normal ls-25">Get Up to<span class="text-primary">25% Off</span></h4>
            <h2 class="ls-25">Sign up to Wolmart</h2>
            <p class="text-light ls-10">Subscribe to the Wolmart market newsletter to
                receive updates on special offers.</p>
            <form action="#" method="get" class="input-wrapper input-wrapper-inline input-wrapper-round">
                <input type="email" class="form-control email font-size-md" name="email" id="email2" placeholder="Your email address" required="">
                <button class="btn btn-dark" type="submit">SUBMIT</button>
            </form>
            <div class="form-checkbox d-flex align-items-center">
                <input type="checkbox" class="custom-checkbox" id="hide-newsletter-popup" name="hide-newsletter-popup" required="">
                <label for="hide-newsletter-popup" class="font-size-sm text-light">Don't show this popup again.</label>
            </div>
        </div>
    </div>
    <!-- End of Newsletter popup -->

    <!-- Start of Quick View -->
    <div class="product product-single product-popup">
        <div class="row gutter-lg">
            <div class="col-md-6 mb-4 mb-md-0">
                <div class="product-gallery product-gallery-sticky">
                    <div class="swiper-container product-single-swiper swiper-theme nav-inner">
                        <div class="swiper-wrapper row cols-1 gutter-no">
                            <div class="swiper-slide">
                                <figure class="product-image">
                                    <img src="<?= base_url(); ?>website/images/products/popup/1-440x494.jpg" data-zoom-image="<?= base_url(); ?>website/images/products/popup/1-800x900.jpg" alt="Water Boil Black Utensil" width="800" height="900">
                                </figure>
                            </div>
                            <div class="swiper-slide">
                                <figure class="product-image">
                                    <img src="<?= base_url(); ?>website/images/products/popup/2-440x494.jpg" data-zoom-image="<?= base_url(); ?>website/images/products/popup/2-800x900.jpg" alt="Water Boil Black Utensil" width="800" height="900">
                                </figure>
                            </div>
                            <div class="swiper-slide">
                                <figure class="product-image">
                                    <img src="<?= base_url(); ?>website/images/products/popup/3-440x494.jpg" data-zoom-image="<?= base_url(); ?>website/images/products/popup/3-800x900.jpg" alt="Water Boil Black Utensil" width="800" height="900">
                                </figure>
                            </div>
                            <div class="swiper-slide">
                                <figure class="product-image">
                                    <img src="<?= base_url(); ?>website/images/products/popup/4-440x494.jpg" data-zoom-image="<?= base_url(); ?>website/images/products/popup/4-800x900.jpg" alt="Water Boil Black Utensil" width="800" height="900">
                                </figure>
                            </div>
                        </div>
                        <button class="swiper-button-next"></button>
                        <button class="swiper-button-prev"></button>
                    </div>
                    <div class="product-thumbs-wrap swiper-container" data-swiper-options="{
                        'navigation': {
                            'nextEl': '.swiper-button-next',
                            'prevEl': '.swiper-button-prev'
                        }
                    }">
                        <div class="product-thumbs swiper-wrapper row cols-4 gutter-sm">
                            <div class="product-thumb swiper-slide">
                                <img src="<?= base_url(); ?>website/images/products/popup/1-103x116.jpg" alt="Product Thumb" width="103" height="116">
                            </div>
                            <div class="product-thumb swiper-slide">
                                <img src="<?= base_url(); ?>website/images/products/popup/2-103x116.jpg" alt="Product Thumb" width="103" height="116">
                            </div>
                            <div class="product-thumb swiper-slide">
                                <img src="<?= base_url(); ?>website/images/products/popup/3-103x116.jpg" alt="Product Thumb" width="103" height="116">
                            </div>
                            <div class="product-thumb swiper-slide">
                                <img src="<?= base_url(); ?>website/images/products/popup/4-103x116.jpg" alt="Product Thumb" width="103" height="116">
                            </div>
                        </div>
                        <button class="swiper-button-next"></button>
                        <button class="swiper-button-prev"></button>
                    </div>
                </div>
            </div>
            <div class="col-md-6 overflow-hidden p-relative">
                <div class="product-details scrollable pl-0">
                    <h2 class="product-title">Electronics Black Wrist Watch</h2>
                    <div class="product-bm-wrapper">
                        <figure class="brand">
                            <img src="<?= base_url(); ?>website/images/products/brand/brand-1.jpg" alt="Brand" width="102" height="48" />
                        </figure>
                        <div class="product-meta">
                            <div class="product-categories">
                                Category:
                                <span class="product-category"><a href="#">Electronics</a></span>
                            </div>
                            <div class="product-sku">
                                SKU: <span>MS46891340</span>
                            </div>
                        </div>
                    </div>

                    <hr class="product-divider">

                    <div class="product-price">$40.00</div>

                    <div class="ratings-container">
                        <div class="ratings-full">
                            <span class="ratings" style="width: 80%;"></span>
                            <span class="tooltiptext tooltip-top"></span>
                        </div>
                        <a href="#" class="rating-reviews">(3 Reviews)</a>
                    </div>

                    <div class="product-short-desc">
                        <ul class="list-type-check list-style-none">
                            <li>Ultrices eros in cursus turpis massa cursus mattis.</li>
                            <li>Volutpat ac tincidunt vitae semper quis lectus.</li>
                            <li>Aliquam id diam maecenas ultricies mi eget mauris.</li>
                        </ul>
                    </div>

                    <hr class="product-divider">

                    <div class="product-form product-variation-form product-color-swatch">
                        <label>Color:</label>
                        <div class="d-flex align-items-center product-variations">
                            <a href="#" class="color" style="background-color: #ffcc01"></a>
                            <a href="#" class="color" style="background-color: #ca6d00;"></a>
                            <a href="#" class="color" style="background-color: #1c93cb;"></a>
                            <a href="#" class="color" style="background-color: #ccc;"></a>
                            <a href="#" class="color" style="background-color: #333;"></a>
                        </div>
                    </div>
                    <div class="product-form product-variation-form product-size-swatch">
                        <label class="mb-1">Size:</label>
                        <div class="flex-wrap d-flex align-items-center product-variations">
                            <a href="#" class="size">Small</a>
                            <a href="#" class="size">Medium</a>
                            <a href="#" class="size">Large</a>
                            <a href="#" class="size">Extra Large</a>
                        </div>
                        <a href="#" class="product-variation-clean">Clean All</a>
                    </div>

                    <div class="product-variation-price">
                        <span></span>
                    </div>

                    <div class="product-form">
                        <div class="product-qty-form">
                            <div class="input-group">
                                <input class="quantity form-control" type="number" min="1" max="10000000">
                                <button class="quantity-plus w-icon-plus"></button>
                                <button class="quantity-minus w-icon-minus"></button>
                            </div>
                        </div>
                        <button class="btn btn-primary btn-cart">
                            <i class="w-icon-cart"></i>
                            <span>Add to Cart</span>
                        </button>
                    </div>

                    <div class="social-links-wrapper">
                        <div class="social-links">
                            <div class="social-icons social-no-color border-thin">
                                <a href="#" class="social-icon social-facebook w-icon-facebook"></a>
                                <a href="#" class="social-icon social-twitter w-icon-twitter"></a>
                                <a href="#" class="social-icon social-pinterest fab fa-pinterest-p"></a>
                                <a href="#" class="social-icon social-whatsapp fab fa-whatsapp"></a>
                                <a href="#" class="social-icon social-youtube fab fa-linkedin-in"></a>
                            </div>
                        </div>
                        <span class="divider d-xs-show"></span>
                        <div class="product-link-wrapper d-flex">
                            <a href="#" class="btn-product-icon btn-wishlist w-icon-heart"><span></span></a>
                            <a href="#" class="btn-product-icon btn-compare btn-icon-left w-icon-compare"><span></span></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- End of Quick view -->

    <!-- Plugin JS File -->
    <script src="<?= base_url(); ?>website/vendor/jquery/jquery.min.js"></script>
    <script src="<?= base_url(); ?>website/vendor/jquery.plugin/jquery.plugin.min.js"></script>
    <script src="<?= base_url(); ?>website/vendor/parallax/parallax.min.js"></script>
    <script src="<?= base_url(); ?>website/vendor/swiper/swiper-bundle.min.js"></script>
    <script src="<?= base_url(); ?>website/vendor/imagesloaded/imagesloaded.pkgd.min.js"></script>
    <script src="<?= base_url(); ?>website/vendor/jquery.countdown/jquery.countdown.min.js"></script>
    <script src="<?= base_url(); ?>website/vendor/magnific-popup/jquery.magnific-popup.min.js"></script>
    <script src="<?= base_url(); ?>website/vendor/floating-parallax/parallax.min.js"></script>
    <script src="<?= base_url(); ?>website/vendor/zoom/jquery.zoom.js"></script>
    <script src="<?= base_url(); ?>website/vendor/skrollr/skrollr.min.js"></script>

    <script src="<?= base_url(); ?>website/js/main.min.js"></script>
</body>