<div class="content-wrapper">
  <div class="card">
    <div class="card-body">
      <h4 class="card-title">Deposits</h4>
      <div class="row">
        <div class="col-12">
          <?php if ($this->session->flashdata()) {
            echo Helpers::showFlash($this->session->flashdata("response"));
          } ?>
          <div class="table-responsive">
            <table id="order-listing" class="table">
              <thead>
                <tr>
                  <th>User Id</th>
                  <th>Username</th>
                  <th>Mpesa Transaction Id</th>
                  <th>Phone</th>
                  <th>Amount</th>
                  <th>Date</th>
                  <th>Status</th>
                  <th></th>
                </tr>
              </thead>
              <tbody>
                <?php foreach ($data as $value) { ?>
                  <tr>
                    <td><?= $value["user_id"]; ?></td>
                    <td><?= $value["username"]; ?></td>
                    <td><?= $value['mpesa_trans_id']; ?></td>
                    <td><?= $value["phone"]; ?></td>
                    <td><?= $value["amount"]; ?></td>
                    <td><?= $value["created_at"]; ?></td>
                    <td><?= $value["status"] ? 'Approved' : 'Not Approved'; ?></td>
                  
                      <td>
                      <?php if (!$value["marked"]) { ?>
                        <div class="row text-center">
                          <div class="col-md-12" style="margin-bottom: 10px">
                            <a class="btn btn-info" href='<?= base_url() . "admin/deposit_approve_funds?id={$value["id"]}"; ?>'>Yes</a>
                          </div>
                          <div class="col-md-12">
                            <a class="btn btn-info" href='<?= base_url() . "admin/deposit_disapprove_funds?id={$value["id"]}"; ?>'>No</a>
                          </div>
                          <?php } ?>
                      </td>
               
                  </tr>
                <?php } ?>
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>