<?php



class Members extends ci_model

{

	function add_user_log($userId, $parentId)
	{

		$data = array();

		$data["user_id"] = $userId;

		$data["referral_id"] = $parentId;

		$data["created_at"] = date('Y-m-d');;

		$response = $this->db->insert('user_logs', $data);

		return $response ? $response : false;
	}

	function getUserByRefCode($data)

	{

		$this->db->where("username", $data);

		$user = $this->db->get("users")->row_array();

		return ($user);
	}

	function get_notification($user_id)

	{

		$this->db->order_by('id', 'desc');

		$this->db->where("user_id", $user_id);

		$user = $this->db->get("adm_msg")->result_array();

		return ($user);
	}

	function update_adm_msg($userid, $data)

	{

		$this->db->where("user_id", $userid);

		$this->db->update("adm_msg", $data);

		if ($this->db->affected_rows()) {

			return true;
		} else {

			return false;
		}
	}

	function add_wallet_amount($userId, $data)
	{

		$user = $this->get_user_wallet($userId);

		if ($user) {

			$response = $this->db->query("UPDATE topupwallet SET wallet_amount = wallet_amount + {$data["wallet_amount"]} WHERE id = {$user['id']}");
		} else {

			$response = $this->db->insert('topupwallet', $data);
		}

		return $response;
	}

	function get_user_wallet($id)
	{

		return $this->db->get_where('topupwallet', array('user_id' => $id))->row_array();
	}

	function substract_wallet_amount($userId, $amount)
	{

		$user = $this->get_user_wallet($userId);

		$response = false;

		if ($user) {

			$response = $this->db->query("UPDATE topupwallet SET wallet_amount = wallet_amount - {$amount} WHERE user_id = {$userId}");
		}

		return $response;
	}

	function get_user_support_message($id)
	{

		$data = $this->db->where("user_id", $id)->get('support')->result_array();

		return $data ? $data : false;
	}

	function add_support_ticket($data)
	{

		$response = $this->db->insert('support', $data);

		return $response ? $response : false;
	}

	function getreferralsarray($id)

	{

		$this->db->where("referral_id", $id);

		$result = $this->db->get("user_logs")->result_array();

		return $result;
	}



	function get_user_earning($id)
	{

		$data = $this->db->get_where('ewallet', array('user_id' => $id, "amount  >=" => 0))->row_array();

		return $data ? $data : false;
	}

	function get_app_earning($id)
	{

		$data = $this->db->get_where('app_earning', array('user_id' => $id, "amount  >=" => 0))->row_array();

		return $data ? $data : false;
	}

	function substract_app_amount($userId, $amount)
	{

		$user = $this->get_app_earning($userId);

		$response = false;

		if ($user) {

			$response = $this->db->query("UPDATE app_earning SET amount = amount - {$amount} WHERE user_id = {$userId}");

			//$response = $query->result_array();

		}

		return $response;
	}





	function get_game_earning($id)
	{

		$data = $this->db->get_where('game_wallet', array('user_id' => $id, "amount  >=" => 0))->row_array();

		return $data ? $data : false;
	}

	function add_game_wallet($userId, $data)
	{

		$user = $this->get_game_earning($userId);

		if ($user) {

			$response = $this->db->query("UPDATE game_wallet SET amount = amount + {$data["amount"]} WHERE id = {$user['id']}");
		} else {

			$response = $this->db->insert('game_wallet', $data);
		}

		return $response;
	}

	function substract_game_wallet_amount($userId, $amount)
	{

		$user = $this->get_game_earning($userId);

		$response = false;

		if ($user) {

			$response = $this->db->query("UPDATE game_wallet SET amount = amount - {$amount} WHERE user_id = {$userId}");
		}

		return $response;
	}

	function add_earning_amount($userId, $data)
	{

		$user = $this->get_user_earning($userId);

		if ($user) {

			$response = $this->db->query("UPDATE ewallet SET amount = amount + {$data["amount"]} WHERE user_id = {$userId}");

			//$response = $query->result_array();

		} else {

			$response = $this->db->insert('ewallet', $data);
		}

		return $response;
	}

	function substract_ewallet_amount($userId, $amount)
	{

		$user = $this->get_user_earning($userId);

		$response = false;

		if ($user) {

			$response = $this->db->query("UPDATE ewallet SET amount = amount - {$amount} WHERE user_id = {$userId}");

			//$response = $query->result_array();

		}

		return $response;
	}

	function store_fund($data)

	{

		$this->db->insert('mpesa', $data);

		return $this->db->insert_id();
	}

	function store_mpesa_request($data)

	{

		$this->db->insert('mpesa_requests', $data);

		return $this->db->insert_id();
	}

	function store_loan($data)

	{

		$this->db->insert('loan', $data);

		return $this->db->insert_id();
	}

	function get_loan($userid)

	{

		$this->db->where("user_id", $userid);

		$data = $this->db->get("loan")->result_array();
		return $data;
	}


	function getuserbyuname($username)

	{

		$this->db->where("username", $username);

		$data = $this->db->get("users")->row_array();

		return $data ? $data : 0;
	}

	function add_fund_transfer($data)
	{

		$response = $this->db->insert('wallet_funds_transfer', $data);

		return $response ? $response : false;
	}

	function get_all_packages()

	{

		return $this->db->get('packages')->result_array();
	}

	function getParentByUserId($id)
	{

		$getUserFromLog = $this->db->get_where('user_logs', array('user_id' => $id))->row_array();

		if ($getUserFromLog) {

			$getUserFromUsrTable = $this->db->get_where('users', array('id' => $getUserFromLog['referral_id']))->row_array();

			if ($getUserFromUsrTable) {

				return $getUserFromUsrTable;
			}
		}

		return false;
	}

	function checkIfUserBoughtSubscription($userId, $packageId = false)
	{


		$this->db->order_by('id', 'desc');
		$this->db->where('user_id', $userId);

		if ($packageId) {

			$this->db->where('package_id', $packageId);
		}

		$query = $this->db->get('sales');

		$data =  $query->row_array();

		return $data ? $data : false;
	}

	function getlastpackid($userId)

	{
		$this->db->select_max('package_id');
		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('sales');

		$data =  $query->row_array();

		return $data ? $data : false;
	}

	function getlastpackidbyId($userId)

	{
		// $this->db->select_max('package_id');
		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('sales');

		$data =  $query->row_array();

		return $data ? $data : false;
	}

	function add_membership_to_user_account($userId, $packageId, $amount = false, $sponsor = false)
	{





		$data = array();

		$data["user_id"] = $userId;

		$data["package_id"] = $packageId;

		$data["sponsor_id"] = $sponsor;

		$data["purchase_date"] = date('Y-m-d H:i:s');

		$response = $this->db->insert('sales', $data);

		return $response ? $response : false;
	}

	function getPackageFromId($getPackageId)

	{

		return $this->db->get_where('packages', array('id' => $getPackageId))->row_array();
	}

	function countmembersales($userId, $data)

	{

		$user = $this->get_membersales($userId);

		if ($user) {

			$response = $this->db->query("UPDATE count_sales SET sales = sales + {$data["sales"]} WHERE id = {$user['id']}");
		} else {

			$response = $this->db->insert('count_sales', $data);
		}

		return $response;
	}

	function get_membersales($id)
	{
		return $this->db->get_where('count_sales', array('user_id' => $id))->row_array();
	}

	function updateprofile($id, $data)

	{

		$this->db->where('id', $id);

		$this->db->update('users', $data);

		if ($this->db->affected_rows()) {

			return true;
		} else {

			return false;
		}
	}

	function add_transaction($data)

	{

		$response = $this->db->insert('transaction', $data);

		return $response;
	}

	function checkhighestpack($userid)

	{

		$this->db->where("user_id", $userid);

		$this->db->select_max('package_id');

		$query = $this->db->get("sales")->row_array();

		return $query;
	}

	function getreferrals($id)

	{

		$this->db->where("referral_id", $id);

		$result = $this->db->get("user_logs")->num_rows();

		return $result;
	}

	function unique_multidim_array($array, $key)
	{
		$temp_array = array();
		$i = 0;
		$key_array = array();

		foreach ($array as $val) {
			if (!in_array($val[$key], $key_array)) {
				$key_array[$i] = $val[$key];
				$temp_array[$i] = $val;
			}
			$i++;
		}
		return $temp_array;
	}

	function getactiveusers($id)

	{

		$this->db->where("sponsor_id", $id);

		$result = $this->db->get("sales")->result_array();
		if ($result) {
			$uniqueArray =   count($this->unique_multidim_array($result, 'user_id'));
		} else {
			$uniqueArray = 0;
		}


		return $uniqueArray;
	}

	function gettotalusers()

	{

		$this->db->where("id !=", 1);

		$data = $this->db->get("users")->result_array();

		return $data ? count($data) : 0;
	}

	function gettotalpaidusers()

	{

		$this->db->distinct();

		$this->db->select('user_id');

		$this->db->where("user_id !=", 1);

		$data = $this->db->get("sales")->result_array();

		return $data ? count($data) : 0;
	}

	function gettotalpackagesold()

	{

		$data = $this->db->get("sales")->result_array();

		return $data ? count($data) : 0;
	}

	function gettotalamountearned()

	{

		$this->db->select_sum('package_amount');

		$data = $this->db->get("sales")->row_array();

		return $data ? $data["package_amount"] : 0;
	}

	function getuserdetails($id)

	{

		$this->db->where("id", $id);

		$data = $this->db->get("users")->row_array();

		return $data ? $data : false;
	}

	function gethighestpackage($id)

	{

		$this->db->select_max("package_id");

		$this->db->where("user_id", $id);

		$data = $this->db->get("sales")->row_array();

		return $data;
	}



	function get_packagename($id)

	{

		$this->db->where("id", $id);

		$data = $this->db->get("packages")->row_array();

		return $data ? $data : false;
	}

	function direct_list($id)

	{

		$query = $this->db->query("SELECT users.*, user_logs.* FROM user_logs LEFT JOIN users ON user_logs.user_id = users.id WHERE user_logs.referral_id =  $id")->result_array();

		return $query;
	}

	function add_withraw_request($data)
	{

		$response = $this->db->insert('withdraw_request', $data);

		return $response ? $response : false;
	}

	function get_withdraw_request($id)

	{
		$this->db->order_by('id', 'desc');

		$this->db->where("user_id", $id);

		$resp = $this->db->get("withdraw_request")->result_array();

		return $resp;
	}



	function add_withraw_game_request($data)
	{

		$response = $this->db->insert('withdraw_game_request', $data);

		return $response ? $response : false;
	}

	function add_withraw_app_request($data)
	{

		$response = $this->db->insert('withdraw_app_request', $data);

		return $response ? $response : false;
	}
	function get_app_withdraw_request($id)

	{

		$this->db->where("user_id", $id);

		$resp = $this->db->get("withdraw_app_request")->result_array();

		return $resp;
	}

	function add_withraw_spining_request($data)
	{

		$response = $this->db->insert('withdraw_spining_request', $data);

		return $response ? $response : false;
	}
	function get_spining_withdraw_request($id)

	{

		$this->db->where("user_id", $id);

		$resp = $this->db->get("withdraw_spining_request")->result_array();

		return $resp;
	}

	function add_withraw_whatsapp_request($data)
	{

		$response = $this->db->insert('withdraw_whatsapp_request', $data);

		return $response ? $response : false;
	}
	function get_whatsapp_withdraw_request($id)

	{

		$this->db->where("user_id", $id);

		$resp = $this->db->get("withdraw_whatsapp_request")->result_array();

		return $resp;
	}


	function get_game_withdraw_request($id)

	{

		$this->db->where("user_id", $id);

		$resp = $this->db->get("withdraw_game_request")->result_array();

		return $resp;
	}

	function allpackages($id)

	{
		$this->db->order_by('id', 'desc');
		$this->db->where('user_id', $id);

		$query = $this->db->get('sales');

		$data = $query->result_array();

		return $data ? $data : false;
	}

	function getsponsor($id)

	{

		$this->db->where("user_id", $id);

		$query = $this->db->get("user_logs")->row_array();

		$this->db->where("id", $query["referral_id"]);

		$sponsor = $this->db->get("users")->row_array();

		return $sponsor;
	}

	function getbasicpackusers($id)

	{

		$this->db->where("sponsor_id", $id);

		$this->db->where("package_id", 1);

		$query = $this->db->get("sales")->result_array();

		return $query;
	}
	function getsilverpackusers($id)

	{

		$this->db->where("sponsor_id", $id);

		$this->db->where("package_id", 2);

		$query = $this->db->get("sales")->result_array();

		return $query;
	}

	function getstarpackusers($id)

	{

		$this->db->where("sponsor_id", $id);

		$this->db->where("package_id", 3);

		$query = $this->db->get("sales")->result_array();

		return $query;
	}

	function getpremiumpackusers($id)

	{

		$this->db->where("sponsor_id", $id);

		$this->db->where("package_id", 4);

		$query = $this->db->get("sales")->result_array();

		return $query;
	}

	function getvippackusers($id)

	{

		$this->db->where("sponsor_id", $id);

		$this->db->where("package_id", 5);

		$query = $this->db->get("sales")->result_array();

		return $query;
	}

	function getamountwithdrawn($id)

	{

		$this->db->where("user_id", $id);

		$this->db->select_sum('amount');
		$this->db->where("status", 1);
		$query = $this->db->get("withdraw_request")->row_array();

		return $query["amount"];
	}
	function getwhatsappamountwithdrawn($id)

	{

		$this->db->where("user_id", $id);

		$this->db->select_sum('amount');
		$this->db->where("status", 1);
		$query = $this->db->get("withdraw_whatsapp_request")->row_array();

		return $query["amount"];
	}

	function getmpesaerequests($id)

	{

		$this->db->where("user_id", $id);

		$query = $this->db->get("mpesa")->result_array();

		return $query;
	}

	function getmpesaerequestsbytransid($id)

	{
		$this->db->order_by('id', 'DESC');

		$this->db->where("username", $id);

		$query = $this->db->get("mpesa_deposit")->row_array();

		return $query;
	}

	function getwallettransferhistory($id)

	{

		$this->db->where("user_id", $id);

		$query = $this->db->get("wallet_funds_transfer")->result_array();

		return $query;
	}

	function getwalletreceivehistory($id)

	{

		$this->db->where("to_id", $id);

		$query = $this->db->get("wallet_funds_transfer")->result_array();

		return $query;
	}

	function gettransactions($id)

	{

		$this->db->order_by('id', 'DESC');

		$this->db->where("to_id", $id);

		$query = $this->db->get("transaction")->result_array();

		return $query;
	}

	function insertpost($data)

	{

		$this->db->insert('posts', $data);

		return $this->db->insert_id();
	}

	function getarticles($user_id)

	{

		$this->db->where("user_id", $user_id);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get("posts")->result_array();

		return $query;
	}

	function add_mpesa_response($data)

	{

		$query = $this->db->insert("mpesa_response", $data);

		return $query;
	}

	function getdetailsbyref($id)

	{



		$this->db->where("id", $id);

		$query = $this->db->get("mpesa_requests")->row_array();

		return $query;
	}

	function getdetailsbyphone($id)

	{



		$this->db->where("phone", $id);

		$query = $this->db->get("users")->row_array();

		return $query;
	}

	function getdetailsbyusername($id)

	{



		$this->db->where("username", $id);

		$query = $this->db->get("users")->row_array();

		return $query;
	}

	function checkpackagebought($id)

	{

		$this->db->where("user_id", $id);

		$query = $this->db->get("sales")->row_array();

		return $query;
	}

	function checkpackboughtpremium($id)

	{

		$this->db->where("user_id", $id);
		$this->db->where("package_id", 4);

		$query = $this->db->get("sales")->row_array();

		return $query;
	}

	public function get_ads()
	{



		$query = $this->db->get('ads');

		return $query->result_array();
	}
	public function get_banner()
	{



		$query = $this->db->get('banner');

		return $query->row_array();
	}

	public function getwhatsappscreenshot($id)
	{

		$this->db->where('user_id', $id);

		$query = $this->db->get('whatsapp_request');

		return $query->result_array();
	}

	public function getSumEarnings($id)
	{

		$this->db->where('user_id', $id);

		$data = $this->db->select_sum('earning')->from('whatsapp_request')->get();

		return $data->result_array();
		$query = $this->db->get('whatsapp_request');

		return $query->result_array();
	}
	public function whatsapp_request($data)
	{

		if ($this->db->insert('whatsapp_request', $data)) {

			$id = $this->db->insert_id();

			$user = $this->db->get_where('whatsapp_request', array('id' => $id))->row_array();

			return $user;
		}

		return false;
	}

	public function checktrans($id)

	{

		$this->db->where("trans_id", $id);

		$query = $this->db->get("mpesa_response")->row_array();

		return $query;
	}

	public function get_single_mpesa_response($phone)
	{

		$this->db->where("phone", $phone);
		$this->db->where('date_now >=', '2021-08-20');

		$query = $this->db->get("mpesa_response")->result_array();

		return $query;
	}

	public function add_spining_wheel($data)
	{
		if ($this->db->insert('spining_wheel', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('spining_wheel', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}

	public function add_spining_wheel_rewards($data)
	{


		if ($this->db->insert('spining_wheel_rewards', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('spining_wheel_rewards', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}

	public function checkuser_spining_wheel($userid)
	{

		$this->db->where('user_id', $userid);
		$query = $this->db->get('spining_wheel');
		return $query->row_array();
	}

	public function get_spining_wheel_rows()
	{
		$query = $this->db->get('spining_wheel');
		return $query->num_rows();
	}

	public function request_app_ss($data)
	{

		if ($this->db->insert('app_ss', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('app_ss', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}

	public function add_game_transaction($data)
	{

		if ($this->db->insert('game_transaction', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('game_transaction', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}

	public function add_game_rewards($data)
	{

		if ($this->db->insert('game_transaction_rewards', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('game_transaction_rewards', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}

	function get_whatsapp_earning($id)
	{

		$data = $this->db->get_where('whatsapp_earning', array('user_id' => $id, "amount  >=" => 0))->row_array();

		return $data ? $data : false;
	}

	function add_whatsapp_earning($userId, $data)
	{

		$user = $this->get_whatsapp_earning($userId);

		if ($user) {

			$response = $this->db->query("UPDATE whatsapp_earning SET amount = amount + {$data["amount"]} WHERE id = {$user['id']}");
		} else {

			$response = $this->db->insert('whatsapp_earning', $data);
		}

		return $response;
	}

	function substract_whatsapp_amount($userId, $amount)
	{

		$user = $this->get_whatsapp_earning($userId);

		$response = false;

		if ($user) {

			$response = $this->db->query("UPDATE whatsapp_earning SET amount = amount - {$amount} WHERE user_id = {$userId}");

			//$response = $query->result_array();

		}

		return $response;
	}

	function get_spining_earning($id)
	{

		$data = $this->db->get_where('spining_earning', array('user_id' => $id, "amount  >=" => 0))->row_array();

		return $data ? $data : false;
	}

	function add_spining_earning($userId, $data)
	{

		$user = $this->get_spining_earning($userId);

		if ($user) {

			$response = $this->db->query("UPDATE spining_earning SET amount = amount + {$data["amount"]} WHERE id = {$user['id']}");
		} else {

			$response = $this->db->insert('spining_earning', $data);
		}

		return $response;
	}

	function substract_spining_amount($userId, $amount)
	{

		$user = $this->get_spining_earning($userId);

		$response = false;

		if ($user) {

			$response = $this->db->query("UPDATE spining_earning SET amount = amount - {$amount} WHERE user_id = {$userId}");

			//$response = $query->result_array();

		}

		return $response;
	}

	function add_transfer_otp($data)
	{
		$response = $this->db->insert('otp_transfer', $data);
		return $response ? $response : false;
	}

	function get_otp_transfer_row($id)
	{
		return $this->db->order_by("id", "desc")->get_where('otp_transfer', array('user_id' => $id))->row_array();
	}

	function update_otp_transfer_row($id, $data)
	{

		$this->db->where('id', $id);
		$this->db->update('otp_transfer', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	function get_ewallet_sum()
	{

		$this->db->where('amount >=', 0);
		$this->db->select_sum('amount');

		$this->db->from('ewallet');
		return $this->db->get()->row_array();
	}



	function getTransactionByRef($ref)
	{
		$this->db->where("transactionref", $ref);
		$query = $this->db->get("withdraw_request")->row_array();
		return $query;
	}
	function updateTransaction($ref, $data)
	{
		$this->db->where('transactionref', $ref);
		$this->db->update('withdraw_request', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}

	public function gettimelast($id)
	{
		$yesterday = date('Y-m-d h:i:s', strtotime("-12 hours"));

		$this->db->where('user_id', $id);

		$this->db->where('date >=', $yesterday);


		$this->db->order_by('id', 'desc');

		$query = $this->db->get('whatsapp_request');


		return $query->result_array();
	}

	public function save_Mail_database($data)
	{

		$response = $this->db->insert('emails_sent', $data);
		return $response ? $response : false;
	}



	public function getMailsFromDatabase()
	{

		$lastdate = date('Y-m-d h:i:s', strtotime("-1 hours"));


		$this->db->where('date >=', $lastdate);

		$query = $this->db->get('emails_sent');


		return $query->result_array();
	}

	public function getBankLogs()
	{

		$result = $this->db->get("bank_logs")->result_array();
		return $result;
	}
	public function getBankLogsById($id)
	{
		$this->db->where("id", $id);
		$result = $this->db->get("bank_logs")->row_array();
		return $result;
	}


	public function getUSAPaypal()
	{

		$result = $this->db->get("usa_paypal")->result_array();
		return $result;
	}
	public function getMasterCard()
	{

		$result = $this->db->get("master_card")->result_array();
		return $result;
	}
	public function getVisa()
	{

		$result = $this->db->get("visa_card")->result_array();
		return $result;
	}

	function add_points_wallet($userId, $data)
	{

		$user = $this->get_points_wallet($userId);

		if ($user) {

			$response = $this->db->query("UPDATE points_wallet SET amount = amount + {$data["amount"]} WHERE id = {$user['id']}");
		} else {

			$response = $this->db->insert('points_wallet', $data);
		}

		return $response;
	}

	function get_points_wallet($id)
	{

		return $this->db->get_where('points_wallet', array('user_id' => $id))->row_array();
	}

	function substract_points_wallet($userId, $amount)
	{

		$user = $this->get_points_wallet($userId);

		$response = false;

		if ($user) {

			$response = $this->db->query("UPDATE points_wallet SET amount = amount - {$amount} WHERE user_id = {$userId}");
		}

		return $response;
	}

	function add_convert_points_history($data)
	{


		$response = $this->db->insert('points_convert_history', $data);

		return $response;
	}

	function getHistoryConvertPoints($user_id)
	{

		return $this->db->get_where('points_convert_history', array('user_id' => $user_id))->result_array();
	}

	function add_points_transaction($data)

	{

		$response = $this->db->insert('points_transaction', $data);

		return $response;
	}

	public function getforexPackage()
	{


		$query = $this->db->get("forex_package")->row_array();
		return $query;
	}

	public function checkForexPack($user_id)
	{

		$this->db->where("user_id", $user_id);
		$query = $this->db->get("forex_membership")->row_array();
		return $query;
	}

	public function add_forex_membership($data)
	{

		$res = $this->db->insert('forex_membership', $data);
		return $res;
	}

	public function getCurrencyAmount($to_currency)
	{

		$query = $this->db->get_where('currencies', array('name' => $to_currency))->row_array();
		return $query ? $query : false;
	}

	public function getAgentPackage()
	{


		$query = $this->db->get("agent_packages")->row_array();
		return $query;
	}

	function getAgentPackageFromId($getPackageId)

	{

		return $this->db->get_where('agent_packages', array('id' => $getPackageId))->row_array();
	}

	function checkIfUserBoughtAgentSubscription($userId, $packageId = false)
	{



		$this->db->where('user_id', $userId);

		if ($packageId) {

			$this->db->where('package_id', $packageId);
		}

		$query = $this->db->get('agent_sales');

		$data =  $query->row_array();

		return $data ? $data : false;
	}

	function add_membership_to_user_account_agent_pack($userId, $packageId, $amount = false, $sponsor = false)
	{





		$data = array();

		$data["user_id"] = $userId;

		$data["package_id"] = $packageId;

		$data["sponsor_id"] = $sponsor;

		$data["purchase_date"] = date('Y-m-d');

		$response = $this->db->insert('agent_sales', $data);

		return $response ? $response : false;
	}


	function countmembersales_agentpack($userId, $data)

	{

		$user = $this->get_membersales_agent_pack($userId);

		if ($user) {

			$response = $this->db->query("UPDATE agent_count_sales SET sales = sales + {$data["sales"]} WHERE id = {$user['id']}");
		} else {

			$response = $this->db->insert('agent_count_sales', $data);
		}

		return $response;
	}

	function get_membersales_agent_pack($id)
	{

		return $this->db->get_where('agent_count_sales', array('user_id' => $id))->row_array();
	}
	function getlastpackid_agentPack($userId)

	{

		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('agent_sales');

		$data =  $query->row_array();

		return $data ? $data : false;
	}
	function add_transaction_agent_pack($data)

	{

		$response = $this->db->insert('agent_transaction', $data);

		return $response;
	}

	function get_notification_all()

	{


		$this->db->order_by('id', 'desc');
		$user = $this->db->get("adm_msg_all_users")->result_array();

		return ($user);
	}


	function add_transfer_otp_admin($data)
	{
		$response = $this->db->insert('adm_otp', $data);
		return $response ? $response : false;
	}

	function get_otp_transfer_row_admin($id)
	{
		return $this->db->order_by("id", "desc")->get_where('adm_otp', array('user_id' => $id))->row_array();
	}

	function update_otp_transfer_row_admin($id, $data)
	{

		$this->db->where('id', $id);
		$this->db->update('adm_otp', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}

	function get_last_notification($user_id)

	{

		$this->db->order_by('id', 'desc');

		$this->db->where("user_id", $user_id);

		$user = $this->db->get("adm_msg")->row_array();

		return ($user);
	}
	function get_last_notification_all()

	{


		$this->db->order_by('id', 'desc');
		$user = $this->db->get("adm_msg_all_users")->row_array();

		return ($user);
	}
	public function agent_verification_add($data)
	{

		$q = $this->db->insert('agent_verification', $data);
		return $q;
	}
	function get_agent_verification_request($id)

	{

		$this->db->order_by('id', 'desc');
		$this->db->where("user_id", $id);

		$resp = $this->db->get("agent_verification")->row_array();

		return $resp;
	}
	function get_agent_verification_request_rejected($id)

	{

		$this->db->where("user_id", $id);
		$this->db->where("status", 2);

		$resp = $this->db->get("agent_verification")->result_array();

		return $resp;
	}

	function get_agent_verification_request_pending($id)

	{
		$this->db->order_by('id', 'desc');
		$this->db->where("user_id", $id);
		$this->db->where("status", 0);

		$resp = $this->db->get("agent_verification")->row_array();

		return $resp;
	}

	public function paypal_verification_add($data)
	{

		$q = $this->db->insert('paypal_verification', $data);
		return $q;
	}

	function get_paypal_verification_request($id)

	{

		$this->db->order_by('id', 'desc');
		$this->db->where("user_id", $id);

		$resp = $this->db->get("paypal_verification")->result_array();

		return $resp;
	}

	function add_paypal_wallet($userId, $data)
	{

		$user = $this->get_paypal_wallet($userId);

		if ($user) {

			$response = $this->db->query("UPDATE paypal_wallet SET amount = amount + {$data["amount"]} WHERE id = {$user['id']}");
		} else {

			$response = $this->db->insert('paypal_wallet', $data);
		}

		return $response;
	}

	function get_paypal_wallet($id)
	{

		return $this->db->get_where('paypal_wallet', array('user_id' => $id))->row_array();
	}

	function substract_paypal_wallet($userId, $amount)
	{

		$user = $this->get_paypal_wallet($userId);

		$response = false;

		if ($user) {

			$response = $this->db->query("UPDATE paypal_wallet SET amount = amount - {$amount} WHERE user_id = {$userId}");
		}

		return $response;
	}

	function add_withraw_paypal_request($data)
	{

		$response = $this->db->insert('withdraw_paypal_request', $data);

		return $response ? $response : false;
	}


	function get_paypal_withdraw_request($id)

	{
		$this->db->order_by('id', 'desc');
		$this->db->where("user_id", $id);

		$resp = $this->db->get("withdraw_paypal_request")->result_array();

		return $resp;
	}

	function alreadyUnlockPack($id)

	{

		$this->db->where("user_id", $id);

		$resp = $this->db->get("unlock_sales")->row_array();

		return $resp;
	}
	function add_unlock_package($data)
	{

		$response = $this->db->insert('unlock_sales', $data);

		return $response ? $response : false;
	}

	function spining_history($uid)
	{

		$this->db->where("user_id", $uid);

		$resp = $this->db->get("spining_wheel_rewards")->result_array();

		return $resp;
	}


	function agent_history($userId)

	{

		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('agent_sales');

		$data =  $query->result_array();

		return $data ? $data : false;
	}
	function unlock_sales_history($userId)

	{

		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('unlock_sales');

		$data =  $query->result_array();

		return $data ? $data : false;
	}

	/* verifictaion sales  */


	function alreadyVerficationPack($id)

	{

		$this->db->where("user_id", $id);

		$resp = $this->db->get("verification_sales")->row_array();

		return $resp;
	}
	function add_verfication_package($data)
	{

		$response = $this->db->insert('verification_sales', $data);

		return $response ? $response : false;
	}

	function verfication_sales_history($userId)

	{

		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('verification_sales');

		$data =  $query->result_array();

		return $data ? $data : false;
	}



	function alreadyPaypalLoginPack($id)

	{

		$this->db->where("user_id", $id);

		$resp = $this->db->get("paypal_login_sales")->row_array();

		return $resp;
	}
	function add_Paypal_login($data)
	{

		$response = $this->db->insert('paypal_login_sales', $data);

		return $response ? $response : false;
	}

	function paypal_login_history($userId)
	{

		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('paypal_login_sales');

		$data =  $query->result_array();

		return $data ? $data : false;
	}

	function get_compounding_amount($userId)

	{

		$this->db->order_by('id', 'DESC');
		$this->db->where('user_id', $userId);
		$this->db->where('amount >', 0);
		$query = $this->db->get('compounding_wallet');
		$data =  $query->row_array();
		return $data ? $data : false;
	}
	function get_compounding_wallet($userId)

	{

		$this->db->order_by('id', 'DESC');
		$this->db->where('user_id', $userId);
		$query = $this->db->get('compounding_wallet');
		$data =  $query->row_array();
		return $data ? $data : false;
	}

	function add_compounding_amount($data)
	{
		$response = $this->db->insert('compounding_wallet', $data);

		return $response ? $this->db->insert_id() : false;
	}

	function update_amount_in_compounding_wallet($id, $data)

	{

		$this->db->where('id', $id);

		$this->db->update('compounding_wallet', $data);

		if ($this->db->affected_rows()) {

			return true;
		} else {

			return false;
		}
	}

	function add_roi_compound($data)
	{
		$response = $this->db->insert('compounding_roi', $data);
		return $response ? $response : false;
	}

	function get_all_compound_wallet()
	{

		$this->db->where('amount >', 0);
		$query = $this->db->get('compounding_wallet');
		$data =  $query->result_array();
		return $data ? $data : false;
	}
	function get_last_roi_compound($userId, $id)
	{

		$this->db->order_by('id', 'DESC');
		$this->db->where('user_id', $userId);
		$this->db->where('invest_id', $id);
		$query = $this->db->get('compounding_roi');
		$data =  $query->row_array();
		return $data ? $data : false;
	}
	function get_all_roi_compound($userId)
	{

		$this->db->order_by('id', 'DESC');
		$this->db->where('user_id', $userId);
		$query = $this->db->get('compounding_roi');
		$data =  $query->result_array();
		return $data ? $data : false;
	}

	function substract_compound_amount($userId, $amount, $id)
	{

		$user = $this->get_compounding_wallet($userId);

		$response = false;

		if ($user) {

			$response = $this->db->query("UPDATE compounding_wallet SET amount = amount - {$amount} WHERE user_id = {$userId} AND id = {$id}");
		}

		return $response;
	}


	function get_compounding_earning($id)
	{

		$data = $this->db->get_where('compounding_earnings', array('user_id' => $id))->row_array();

		return $data ? $data : false;
	}

	function add_compounding_earning($userId, $data)
	{

		$user = $this->get_compounding_earning($userId);

		if ($user) {

			$response = $this->db->query("UPDATE compounding_earnings SET amount = amount + {$data["amount"]} WHERE id = {$user['id']}");
		} else {

			$response = $this->db->insert('compounding_earnings', $data);
		}

		return $response;
	}

	function substract_compounding_earning($userId, $amount)
	{

		$user = $this->get_compounding_earning($userId);

		$response = false;

		if ($user) {

			$response = $this->db->query("UPDATE compounding_earnings SET amount = amount - {$amount} WHERE user_id = {$userId}");
		}

		return $response;
	}


	function add_compound_withdraw($data)
	{

		$response = $this->db->insert('compounding_withdraw', $data);

		return $response ? $response : false;
	}
	function add_direct_bonus_compounding($data)
	{

		$response = $this->db->insert('compounding_direct_bonus', $data);

		return $response ? $response : false;
	}

	function get_compound_withdraw_requests($id)

	{

		$this->db->where("user_id", $id);

		$resp = $this->db->get("compounding_withdraw")->result_array();

		return $resp;
	}

	function get_all_commission_roi($userId)
	{

		$this->db->order_by('id', 'DESC');
		$this->db->where('to_id', $userId);
		$query = $this->db->get('compounding_direct_bonus');
		$data =  $query->result_array();
		return $data ? $data : false;
	}

	function alreadyaccess_codePack($id)

	{

		$this->db->where("user_id", $id);

		$resp = $this->db->get("access_code_sales")->row_array();

		return $resp;
	}
	function add_access_code($data)
	{

		$response = $this->db->insert('access_code_sales', $data);

		return $response ? $response : false;
	}

	function access_code_history($userId)

	{

		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('access_code_sales');

		$data =  $query->result_array();

		return $data ? $data : false;
	}

	function add_unlock_welcome_bonus_sale($data)
	{

		$response = $this->db->insert('unlock_welcome_bonus_sales', $data);

		return $response ? $response : false;
	}
	function add_unlock_cashback_bonus_sale($data)
	{

		$response = $this->db->insert('unlock_cashback_bonus_sales', $data);

		return $response ? $response : false;
	}

	function get_agent_transactions($id)

	{

		$this->db->order_by('id', 'DESC');

		$this->db->where("to_id", $id);

		$query = $this->db->get("agent_transaction")->result_array();

		return $query;
	}
	function get_unlock_transactions($id)

	{
		$this->db->order_by('id', 'DESC');
		$this->db->where("to_id", $id);

		$query = $this->db->get("unlock_transaction")->result_array();

		return $query;
	}
	function add_unlock_transaction($data)

	{

		$response = $this->db->insert('unlock_transaction', $data);

		return $response;
	}
	function get_verification_transactions($id)

	{
		$this->db->order_by('id', 'DESC');
		$this->db->where("to_id", $id);

		$query = $this->db->get("verification_transaction")->result_array();

		return $query;
	}
	function add_verification_transaction($data)

	{

		$response = $this->db->insert('verification_transaction', $data);

		return $response;
	}
	function get_access_code_transactions($id)

	{
		$this->db->order_by('id', 'DESC');
		$this->db->where("to_id", $id);

		$query = $this->db->get("access_code_transaction")->result_array();

		return $query;
	}
	function add_access_code_transaction($data)

	{

		$response = $this->db->insert('access_code_transaction', $data);

		return $response;
	}

	function get_cashback_bonus($id)
	{

		$data = $this->db->get_where('cashback_bonus', array('user_id' => $id))->row_array();

		return $data ? $data : false;
	}

	function add_cashback_bonus($userId, $data)
	{

		$user = $this->get_cashback_bonus($userId);

		if ($user) {

			$response = $this->db->query("UPDATE cashback_bonus SET amount = amount + {$data["amount"]} WHERE user_id = {$userId}");

			//$response = $query->result_array();

		} else {

			$response = $this->db->insert('cashback_bonus', $data);
		}

		return $response;
	}

	function substract_cashback_bonus($userId, $amount)
	{

		$user = $this->get_cashback_bonus($userId);

		$response = false;

		if ($user) {

			$response = $this->db->query("UPDATE cashback_bonus SET amount = amount - {$amount} WHERE user_id = {$userId}");

			//$response = $query->result_array();

		}

		return $response;
	}

	function updatePackages($id, $data)

	{

		$this->db->where('id', $id);

		$this->db->update('packages', $data);

		if ($this->db->affected_rows()) {

			return true;
		} else {

			return false;
		}
	}
	function updateMails($id, $data)

	{

		$this->db->where('id', $id);

		$this->db->update('email_msg', $data);

		if ($this->db->affected_rows()) {

			return true;
		} else {

			return false;
		}
	}


	function  delete_mail($id)
	{
		$this->db->where('id', $id);
		return  $this->db->delete("email_msg");
	}



	function  get_50_mail()
	{
		$this->db->order_by('id', 'asc');
		$query = $this->db->get("email_msg", 50)->result_array();

		return $query ? $query : false;
	}

	function add_order($data)
	{
		$response = $this->db->insert('orders', $data);

		return $response ? $response : false;
	}

	function get_all_orders($uid)
	{
		$this->db->where('user_id', $uid);
		$q =  $this->db->get("orders")->result_array();
		return $q ? $q : false;
	}
	function get_all_orders_active($uid)
	{
		$this->db->where('user_id', $uid);
		$this->db->where('status !=', 2);
		$q =  $this->db->get("orders")->result_array();
		return $q ? $q : false;
	}
	public function get_single_category_all_product($id)
	{

		$this->db->order_by("id", "desc");
		$this->db->where('status', 1);
		$this->db->where('cat_id', $id);
		$query = $this->db->get('products');
		return $query->result_array();
	}
	public function get_category_by_name($name)
	{

		$this->db->order_by("id", "desc");
		$this->db->where('status', 1);
		$this->db->where('name', $name);
		$query = $this->db->get('category');
		return $query->row_array();
	}
	function getmpesaerequests_deposit($id)

	{

		$this->db->where("user_id", $id);

		$query = $this->db->get("mpesa_deposit")->result_array();

		return $query;
	}
	function store_fund_deposit($data)

	{

		$this->db->insert('mpesa_deposit', $data);

		return $this->db->insert_id();
	}
	function getuserbyphone($phone)

	{

		$this->db->where("phone", $phone);

		$data = $this->db->get("users")->row_array();

		return $data ? $data : 0;
	}
	function add_orders_commission($data)

	{

		$this->db->insert('orders_commission', $data);

		return $this->db->insert_id();
	}
	function get_orders_commissions($to_id)

	{

		$this->db->where("to_id", $to_id);

		$data = $this->db->get("orders_commission")->result_array();

		return $data ? $data : false;
	}

	public function get_mpesa_response($uname)

	{

		$this->db->where("description", $uname);

		$query = $this->db->get("mpesa_response")->result_array();

		return $query;
	}

	function get_all_order_commission()
	{


		$query = $this->db->get('orders_commission');
		$data =  $query->result_array();
		return $data ? $data : false;
	}

	function add_payment_mpesa($data)

	{

		$this->db->insert('payment_requests', $data);

		return $this->db->insert_id();
	}

	function get_payment_request($id)
	{
		$this->db->order_by('id', 'desc');
		$this->db->where('checkout_id', $id);
		$query = $this->db->get('payment_requests');
		$data =  $query->result_array();
		return $data ? $data : false;
	}

	function update_payment_request($id, $data)

	{

		$this->db->where("id", $id);

		$this->db->update("payment_requests", $data);

		if ($this->db->affected_rows()) {

			return true;
		} else {

			return false;
		}
	}
	function add_payment_response($data)

	{

		$this->db->insert('pay_response', $data);

		return $this->db->insert_id();
	}

	function get_mpesa_deposit_by_transfer_id($id)

	{

		$this->db->where("mpesa_trans_id", $id);

		$query = $this->db->get("mpesa_deposit")->row_array();

		return $query;
	}
	function update_mpesa_deposit($id, $data)

	{

		$this->db->where("id", $id);

		$this->db->update("mpesa_deposit", $data);

		if ($this->db->affected_rows()) {

			return true;
		} else {

			return false;
		}
	}

	function add_forex_classes_sales($userId, $packageId, $amount = false, $sponsor = false, $package_name, $package_amount)
	{
		$data = array();
		$data["user_id"] = $userId;
		$data["package_id"] = $packageId;
		$data["sponsor_id"] = $sponsor;
		$data["package_name"] = $package_name;
		$data["package_amount"] = $package_amount;

		$data["purchase_date"] = date('Y-m-d H:i:s');

		$response = $this->db->insert('forex_classes_sales', $data);

		return $response ? $response : false;
	}

	function add_forex_classes_transaction($data)

	{

		$response = $this->db->insert('forex_classes_transaction', $data);

		return $response;
	}
	function forex_classes_sales_history($userId)

	{

		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('forex_classes_sales');

		$data =  $query->result_array();

		return $data ? $data : false;
	}

	public function get_forex_classes_sales_by_id($id, $uid)
	{
		$this->db->where("id", $id);
		$this->db->where("user_id", $uid);
		$resp = $this->db->get("forex_classes_sales")->row_array();

		return $resp;
	}

	function get_forex_classes_transactions($id)

	{
		$this->db->order_by('id', 'DESC');
		$this->db->where("to_id", $id);
		$query = $this->db->get("forex_classes_transaction")->result_array();
		return $query;
	}

	public function get_payment_request_all($uname)
	{
		$this->db->order_by('id', 'DESC');
		$this->db->where("user_id", $uname);
		$this->db->where("status", 1);
		$this->db->where("marked", 1);
		$query = $this->db->get("mpesa_deposit")->result_array();
		return $query;
	}

	public function get_payment_request_by_mpesaid($uname)

	{

		$this->db->where("mpesa_transfer_id", $uname);
		$this->db->where("status", 1);
		$query = $this->db->get("payment_requests")->row_array();

		return $query;
	}

	function getGooglePackageFromId($getPackageId)

	{

		return $this->db->get_where('google_ads', array('id' => $getPackageId))->row_array();
	}
	function checkIfUserBoughtGoogleSubscription($userId, $packageId = false)
	{



		$this->db->where('user_id', $userId);

		if ($packageId) {

			$this->db->where('package_id', $packageId);
		}

		$query = $this->db->get('google_sales');

		$data =  $query->row_array();

		return $data ? $data : false;
	}
	function getOnlineWritingPackageFromId($getPackageId)

	{

		return $this->db->get_where('online_writing', array('id' => $getPackageId))->row_array();
	}
	function checkIfUserBought_OW_Subscription($userId, $packageId = false)
	{



		$this->db->where('user_id', $userId);

		if ($packageId) {

			$this->db->where('package_id', $packageId);
		}

		$query = $this->db->get('online_writing_sales');

		$data =  $query->row_array();

		return $data ? $data : false;
	}

	function add_membership_to_user_account_google_pack($userId, $packageId, $amount = false, $sponsor = false)
	{





		$data = array();

		$data["user_id"] = $userId;

		$data["package_id"] = $packageId;

		$data["sponsor_id"] = $sponsor;

		$data["purchase_date"] = date('Y-m-d');

		$response = $this->db->insert('google_sales', $data);

		return $response ? $response : false;
	}

	function add_membership_to_user_account_OW_pack($userId, $packageId, $amount = false, $sponsor = false)
	{





		$data = array();

		$data["user_id"] = $userId;

		$data["package_id"] = $packageId;

		$data["sponsor_id"] = $sponsor;

		$data["purchase_date"] = date('Y-m-d');

		$response = $this->db->insert('online_writing_sales', $data);

		return $response ? $response : false;
	}

	function countmembersales_googlepack($userId, $data)

	{

		$user = $this->get_membersales_google_pack($userId);

		if ($user) {

			$response = $this->db->query("UPDATE google_count_sales SET sales = sales + {$data["sales"]} WHERE id = {$user['id']}");
		} else {

			$response = $this->db->insert('google_count_sales', $data);
		}

		return $response;
	}

	function get_membersales_google_pack($id)
	{

		return $this->db->get_where('google_count_sales', array('user_id' => $id))->row_array();
	}

	function countmembersales_OWpack($userId, $data)

	{

		$user = $this->get_membersales_OW_pack($userId);

		if ($user) {

			$response = $this->db->query("UPDATE online_writing_count_sales SET sales = sales + {$data["sales"]} WHERE id = {$user['id']}");
		} else {

			$response = $this->db->insert('online_writing_count_sales', $data);
		}

		return $response;
	}

	function get_membersales_OW_pack($id)
	{

		return $this->db->get_where('online_writing_count_sales', array('user_id' => $id))->row_array();
	}

	function getlastpackid_googlePack($userId)

	{

		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('google_sales');

		$data =  $query->row_array();

		return $data ? $data : false;
	}
	function getlastpackid_OWPack($userId)

	{

		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('online_writing_sales');

		$data =  $query->row_array();

		return $data ? $data : false;
	}

	function add_transaction_google_pack($data)

	{

		$response = $this->db->insert('google_transaction', $data);

		return $response;
	}
	function add_transaction_ow_pack($data)

	{

		$response = $this->db->insert('online_writing_transaction', $data);

		return $response;
	}
	function get_google_pack()
	{
		return $this->db->get('google_ads')->row_array();
	}
	function get_online_writing_pack()
	{
		return $this->db->get('online_writing')->row_array();
	}

	function get_google_ads_transactions($id)
	{
		$this->db->order_by('id', 'DESC');
		$this->db->where("to_id", $id);
		$query = $this->db->get("google_transaction")->result_array();
		return $query;
	}
	function get_online_writing_transactions($id)
	{
		$this->db->order_by('id', 'DESC');
		$this->db->where("to_id", $id);
		$query = $this->db->get("online_writing_transaction")->result_array();
		return $query;
	}


	function add_deleted_row($data)

	{
		return $this->db->insert("admin_sales_deleted", $data);
	}
	function get_sales_data()

	{
		$data = $this->db->get("sales")->result_array();
		return $data ? $data : 0;
	}
	function update_sales($id)
	{
		$this->db->where("id", $id);
		$this->db->delete("sales");
		return true;
	}
	public function get_remotask_pack($id)
	{
		$this->db->where("id", $id);
		$query = $this->db->get("remotak_packages")->row_array();
		return $query;
	}
	public function get_remo_all_packs()
	{

		$query = $this->db->get("remotak_packages")->result_array();
		return $query;
	}

	public function add_remotask_membership($data)
	{

		$res = $this->db->insert('remotask_membership', $data);
		return $res;
	}

	function remotask_history($userId)

	{

		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('remotask_membership');

		$data =  $query->result_array();

		return $data ? $data : false;
	}

	function get_all_share_packages()

	{

		return $this->db->get('shares')->result_array();
	}

	public function get_share_pack($id)
	{
		$this->db->where("id", $id);
		$query = $this->db->get("shares")->row_array();
		return $query;
	}
	public function get_share_pack_result_array($id)
	{
		$this->db->where("user_id", $id);
		$query = $this->db->get("shares_membership")->result_array();
		return $query;
	}

	public function add_share_membership($data)
	{

		$res = $this->db->insert('shares_membership', $data);
		return $res;
	}
	function get_locked_package($id)

	{

		$this->db->where("user_id", $id);

		$resp = $this->db->get("unlock_sales")->result_array();

		return $resp;
	}
	function de_sub_admin($id)
	{
		$this->db->where("id", $id);
		$this->db->delete("admin_details");
		return true;
	}

	public function add_whatsapp_package_membership($data)
	{

		$res = $this->db->insert('whatsapp_package', $data);
		return $res;
	}
	function whatsapp_package_history($userId)

	{

		$this->db->where('user_id', $userId);

		$this->db->order_by('id', 'DESC');

		$query = $this->db->get('whatsapp_package');

		$data =  $query->result_array();

		return $data ? $data : false;
	}

	public function add_bet($data)
	{

		$res = $this->db->insert('bet', $data);
		return $res;
	}
	function get_all_bets($userId, $currency)

	{

		$this->db->where('user_id', $userId);
		$this->db->where('currency', $currency);
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('bet');
		$data =  $query->result_array();
		return $data ? $data : false;
	}
	function get_all_bets_all()

	{
		$this->db->where('status', 0);
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('bet');
		$data =  $query->result_array();
		return $data ? $data : false;
	}

	function update_bet_data($id, $data)

	{

		$this->db->where("id", $id);

		$this->db->update("bet", $data);

		if ($this->db->affected_rows()) {

			return true;
		} else {

			return false;
		}
	}

	function add_forex_amount($userId, $data)
	{

		$user = $this->get_forex_wallet($userId);

		if ($user) {

			$response = $this->db->query("UPDATE forex_wallet SET amount = amount + {$data["amount"]} WHERE id = {$user['id']}");
		} else {

			$response = $this->db->insert('forex_wallet', $data);
		}

		return $response;
	}

	function get_forex_wallet($id)
	{

		return $this->db->get_where('forex_wallet', array('user_id' => $id))->row_array();
	}

	function substract_forex_amount($userId, $amount)
	{

		$user = $this->get_forex_wallet($userId);

		$response = false;

		if ($user) {

			$response = $this->db->query("UPDATE forex_wallet SET amount = amount - {$amount} WHERE user_id = {$userId}");
		}

		return $response;
	}

	function add_convert_history($data)
	{

		$res = $this->db->insert('forex_wallet_convert_history', $data);
		return $res;
	}

	function get_all_convert_data(){
		$res = $this->db->get('forex_wallet_convert_history')->result_array();
		return $res;
	}
	
	function get_active_bet_by_userid($userId, $c)

	{

		$this->db->where('status', 0);
		$this->db->where('user_id', $userId);
		$this->db->where('currency', $c);
		$query = $this->db->get('bet');
		$data =  $query->result_array();
		return $data ? $data : false;
	}
	
		function get_all_bets_approved()

	{
		$this->db->where('status', 1);
		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('bet');
		$data =  $query->result_array();
		return $data ? $data : false;
	}
	
	function get_kyc_already_exists($userId)
	{

		$this->db->order_by('id', 'DESC');
		$this->db->where('user_id', $userId);
		$query = $this->db->get('kyc');
		$data =  $query->row_array();
		return $data ? $data : false;
	}

	public function request_kyc($data)
	{
		if ($this->db->insert('kyc', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('kyc', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}
	
	public function withdraw_request_forex_insert($data)
	{
		if ($this->db->insert('withdraw_request_forex', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('withdraw_request_forex', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}

	function get_withdrawal_forex($userId)
	{
		$this->db->order_by('id', 'DESC');
		$this->db->where('user_id', $userId);
		$query = $this->db->get('withdraw_request_forex');
		$data =  $query->result_array();
		return $data ? $data : false;
	}
	
	function get_withdrawal_approved_forex($userId)
	{
		$this->db->where('user_id', $userId);
		$this->db->where('status', 1);
		$query = $this->db->get('withdraw_request_forex');
		$data =  $query->row_array();
		return $data ? $data : false;
	}
	function get_all_active_bet()
	{
		$this->db->where('status', 0);
		$query = $this->db->get('bet');
		$data =  $query->result_array();
		return $data ? $data : false;
	}
	
	function get_all_convert_data_by_user_id($userId)
	{	
		$this->db->where('user_id', $userId);
		$res = $this->db->get('forex_wallet_convert_history')->result_array();
		return $res;
	}
}
