<?php

/***
 * Created by Bennito254
 *
 * Github: https://github.com/bennito254
 * E-Mail: bennito254@gmail.com
 */

/**
 * This is a simple PHP class for the MPesa API.
 *
 * @package Mpesa API Client
 * @license http://mit.com.licence MIT LICENCE
 * @author  Ben Muriithi <benmuriithi929@gmail.com>
 */

class Mpesa
{
    /**
     * The common part of the MPesa API endpoints
     * @var string $base_url
     */
    private $base_url;
    /**
     * The consumer key
     * @var string $consumer_key
     */
    private $consumer_key;
    /**
     * The consumer key secret
     * @var string $consumer_secret
     */
    private $consumer_secret;
    /**
     * The MPesa Paybill number
     * @var int $paybill
     */
    public $paybill;
    /**
     * The Lipa Na MPesa paybill number
     * @var int $lipa_na_mpesa
     */
    public $lipa_na_mpesa;
    /**
     * The Lipa Na MPesa paybill number SAG Key
     * @var string $lipa_na_mpesa_key
     */
    private $lipa_na_mpesa_key;
    /**
     * The Mpesa portal Username
     * @var string $initiator_username
     */
    private $initiator_username;
    /**
     * The Mpesa portal Password
     * @var string $initiator_password
     */
    private $initiator_password;
    /**
     * The Callback common part of the URL eg "https://domain.com/callbacks/"
     * @var string $initiator_password
     */
    private $callback_baseurl;
    /**
     * The test phone number provided by safaricom. For developers
     * @var string $test_msisdn
     */
    private $test_msisdn;
    /**
     * The signed API credentials
     * @var string $cred
     */
    private $cred;
    public $callback_url;

    /**
     * Construct method
     *
     * Initializes the class with an array of API values.
     *
     * @param array $config
     * @return void
     * @throws exception if the values array is not valid
     */

    public function __construct()
    {

        // $this->base_url = 'https://api.safaricom.co.ke/mpesa/'; //Base URL for the API endpoints. This is basically the 'common' part of the API endpoints
        //   $this->consumer_key = 'zx57tklzE7kDYRZz3zznsAbAl2vpoumD';    //App Key. Get it at https://developer.safaricom.co.ke
        //  $this->consumer_secret = 'fDc69Wiwp3NaBwGJ';                    //App Secret Key. Get it at https://developer.safaricom.co.ke
        //  $this->paybill = '4117531';                                    //The paybill/till/lipa na mpesa number
        //  $this->lipa_na_mpesa = '4117531';                                //Lipa Na Mpesa online checkout
        //  $this->lipa_na_mpesa_key = '1d26b4f3e4b6e58aa65bb397c34e34e2e9ab4cb470d7e218aefc7611d4122e0b';    //Lipa Na Mpesa online checkout password
        //  $this->transactionType = 'CustomerPayBillOnline';

        $settings = Helpers::settings();

        $this->base_url = "https://api.safaricom.co.ke/mpesa/"; //Base URL for the API endpoints. This is basically the 'common' part of the API endpoints
        $this->consumer_key = $settings['consumer_key'];    //App Key. Get it at https://developer.safaricom.co.ke
        $this->consumer_secret = $settings['consumer_secret'];                    //App Secret Key. Get it at https://developer.safaricom.co.ke
        $this->paybill = $settings['proxy_short_code'];                                      //The paybill/till/lipa na mpesa number
        $this->lipa_na_mpesa = $settings['short_code'];                                //Lipa Na Mpesa online checkout
        $this->lipa_na_mpesa_key = $settings['lipa_na_mpesa_key'];    //Lipa Na Mpesa online checkout password
        $this->transactionType = 'CustomerPayBillOnline';
    }

    /**
     * Submit Request
     *
     * Handles submission of all API endpoints queries
     *
     * @param string $url The API endpoint URL
     * @param string|bool $data  The data to POST to the endpoint $url
     * @return object|boolean Curl response or FALSE on failure
     * @throws exception if the Access Token is not valid
     */

    private function submit_request($url, $data)
    { // Returns cURL response

        $credentials = base64_encode($this->consumer_key . ':' . $this->consumer_secret);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, 'https://api.safaricom.co.ke/oauth/v1/generate?grant_type=client_credentials');
        //curl_setopt($ch, CURLOPT_URL, 'https://sandbox.safaricom.co.ke/oauth/v1/generate?grant_type=client_credentials');

        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('Authorization: Basic ' . $credentials, 'Content-Type: application/json'));
        $response = curl_exec($ch);
        curl_close($ch);
        $response = json_decode($response);

        $access_token = $response ? $response->access_token : '';

        // The above $access_token expires after an hour, find a way to cache it to minimize requests to the server
        if (!$access_token) {
            throw new Exception("Invalid access token generated");
        }

        if ($access_token != '' || $access_token !== FALSE) {
            $curl = curl_init();
            curl_setopt($curl, CURLOPT_URL, $url);
            curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json', 'Authorization: Bearer ' . $access_token));

            curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($curl, CURLOPT_POST, TRUE);
            curl_setopt($curl, CURLOPT_POSTFIELDS, $data);

            $response = curl_exec($curl);
            curl_close($curl);
            return $response;
        } else {
            return FALSE;
        }
    }

    /*********************************************************************
     *
     *    LNMO APIs
     *
     * ******************************************************************
     * @throws \Exception
     */

    public function lnmo_request($amount, $phone, $ref = "Payment")
    {
        if (!is_numeric($amount) || $amount < 1 || !is_numeric($phone)) {
            throw new Exception("Invalid amount and/or phone number. Amount should be 1 or more, phone number should be in the format 254xxxxxxxx");

            return FALSE;
        }


        $timestamp = date('YmdHis');
        $passwd = base64_encode($this->paybill . '' . $this->lipa_na_mpesa_key . '' . $timestamp);
        $data = array(
            'BusinessShortCode' => $this->paybill,
            'Password' => $passwd,
            'Timestamp' => $timestamp,
            'TransactionType' => $this->transactionType,
            'Amount' => $amount,
            'PartyA' => $phone,
            'PartyB' => $this->lipa_na_mpesa,
            'PhoneNumber' => $phone,
            'CallBackURL' => $this->callback_url,
            'AccountReference' => $ref,
            'TransactionDesc' => 'Deposit payment',
        );
        $data = json_encode($data);
        $url = $this->base_url . 'stkpush/v1/processrequest';
        $response = $this->submit_request($url, $data);
        //$result = json_decode($response);

        return $response;
    }
}
