<?php

class Helpers
{
    static function flash($cssClass, $message, $extraClass = '')
    {
        $res = array();
        if ($cssClass && $message) {
            $res = array("class" => $cssClass, "message" => $message, "extraClass" => $extraClass);
        }
        return $res;
    }
    static function showFlash($flash)
    {
        return "<div class='alert alert-" . $flash['class'] . " " . $flash['extraClass'] . "'>" . $flash['message'] . "</div>";
    }

    static function getAdminDetails($uid)
    {
        $ci = &get_instance();
        $ci->load->model('Adm');
        $id = $ci->Adm->getAdmin($uid);
        return $id;
    }
    static function get_tokens_packages_by_id($uid)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $id = $ci->Members->get_tokens_packages_by_id($uid);
        return $id;
    }
    static function admin_id()
    {
        $ci = &get_instance();
        if (isset($ci->session->userdata["adminlogin"])) {
            $admin = $ci->session->userdata["adminlogin"];
            return $admin;
        }
    }
    static function getPagelink()
{
    $ci = &get_instance();
    $segment = $ci->uri->segment(1); // lazada ke baad wala
    return $segment; 
}


    static function admin_details($id)
    {
        $ci = &get_instance();
        $ci->load->model("Adm");
        $user = $ci->Adm->getadmindetails($id);
        return $user;
    }
    static function user_id()
    {
        $ci = &get_instance();
        if (isset($ci->session->userdata["user"])) {
            $user = $ci->session->userdata["user"];
            return $user;
        }
    }
    
    static function game_user_id()
    {
        $ci = &get_instance();
        if (isset($ci->session->userdata["game_user"])) {
            $user = $ci->session->userdata["game_user"];
            return $user;
        }
    }

    static function getParentObj($uid)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $notification = $ci->Members->getParentByUserId($uid);
        return $notification;
    }
    static function get_notification($user_id)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $notification = $ci->Members->get_notification($user_id);
        return $notification;
    }

    static function get_payment_request_mpesa_id($user_id)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $notification = $ci->Members->get_payment_request_by_mpesaid($user_id);
        return $notification;
    }
    static function get_payment_request_mpesa_id_game($user_id)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $notification = $ci->Members->get_payment_request_by_mpesaid_game($user_id);
        return $notification;
    }

    static function get_notification_all()
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $notification = $ci->Members->get_notification_all();
        return $notification;
    }

    static function getreferrallink()
    {
        $cid = self::user_id();
        $link = base_url() . 'auth/register?ref=' . $cid["username"];
        return $link;
    }
    static function generateLink($url = false)
    {
        $link = '#';
        if ($url) {
            $link = base_url() . 'member/' . $url;
        }
        return $link;
    }
    static function generateUniqueRefId($length = false)
    {
        $length = $length ? $length : 6;
        $ci = &get_instance();
        $ci->load->helper('string');
        $code = random_string('alnum', $length);
        $uniqueCode = $code;
        return $uniqueCode;
    }
    static function date($date = false)
    {

        $res = false;

        if ($date)
            $res =  date('F d, Y ', strtotime($date));
        else
            $res = date('Y-m-d H:i:s');
        return $res;
    }
    static function getuserbyusername($username)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $username = $ci->Members->getuserbyuname($username);
        return $username;
    }
    static function getuserbyphone($phone)
    {
        $ci = &get_instance();
        $ci->load->model('Adm');
        $username = $ci->Adm->getuserbyphone($phone);
        return $username;
    }
    static function get_activationdate($id)
    {
        $ci = &get_instance();
        $ci->load->model('Adm');
        $data = $ci->Adm->getActivationDate($id);
        $activation = $data ? $data["purchase_date"] : "Not Activated";
        return $activation;
    }
    static function getAdmin($model = false)
    {
        $ci = &get_instance();
        $ci->load->model('Users');
        $adminUser = $ci->Users->getAdminAccount();
        return $model ? $adminUser : $adminUser["id"];
    }
    static function getGameUser($uid=false)
    {

        $ci = &get_instance();
        $ci->load->model('Members');
         $cid = self::game_user_id();
         $uid = $uid ? $uid : $cid["id"];
        $user = $ci->Members->get_game_userbyid($uid);
        return $user;
    }
    static function getUserObj($uid = false)
    {
        $cid = self::user_id();
        $uid = $uid ? $uid : $cid["id"];
        $ci = &get_instance();
        $ci->load->model('Users');
        $user = $ci->Users->getUserById($uid);
        return $user;
    }
    static function totalusers()
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $totalusers = $ci->Members->gettotalusers();
        return $totalusers ? $totalusers : 0;
    }
    static function totalpaidusers()
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $totalpaidusers = $ci->Members->gettotalpaidusers();
        return $totalpaidusers ? $totalpaidusers : 0;
    }
    static function getPageName()
    {

        $ci = &get_instance();

        $segment = $ci->uri->segment(1);

        return ucwords(str_replace("_", " ", $segment));
    }
    static function totalpackagesold()
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $totalpackagesold = $ci->Members->gettotalpackagesold();
        return $totalpackagesold ? $totalpackagesold : 0;
    }
    static function totalamountearned()
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $totalamountearned = $ci->Members->gettotalamountearned();
        return $totalamountearned ? $totalamountearned : 0;
    }
    static function userdetails($id)
    {
        $ci = &get_instance();
        $ci->load->model("Members");
        $user = $ci->Members->getuserdetails($id);
        return $user;
    }
    static function saveMail($uid, $type)
    {
        $ci = &get_instance();
        $data['user_id'] = $uid ? $uid : 0;
        $data['email_type'] = $type ? $type : 0;
        $data['date'] = date("Y-m-d H:i:s");
        $ci->load->model("Members");
        $user = $ci->Members->save_Mail_database($data);
        return $user;
    }
    static function sendEmail($emailTitle, $userEmail, $viewMessage)
    {

        $ci = &get_instance();

        $ci->load->library('email');
        $config['protocol'] = 'sendmail';
        $config['mailpath'] = '/usr/sbin/sendmail';
        $config['charset'] = 'iso-8859-1';
        $config['wordwrap'] = TRUE;
        $ci->email->initialize($config);
        $ci->email->set_mailtype("html");
        $ci->email->set_newline("\r\n");
        $ci->email->to($userEmail);
        $ci->email->from('noreply@highvlex.cc', 'Highvlex');
        $ci->email->subject($emailTitle);
        $ci->email->message($viewMessage);
        $ci->email->send();
    }


    static function send_sms($phoneNumber, $message)
    {
        $endpoint   = 'https://account.softwareske.com/smsAPI?sendsms&';
        $_apiEndpointStatus = 'https://account.softwareske.com/smsAPI?groupstatus&';
        $_apiCreateContact  = 'https://account.softwareske.com/smsAPI?create_contact&';
        $_route             = 0;
        $apiKey     = 'd0Oz1taBbqzKggGrOm9IcKDWftDTIXd0';
        $apiToken   = '6cpe1632480621';
        $senderID   = 'BETTERDINE';
        // $phoneNumber = "+254746899412";
        // $message ="Welcome Jesse";

        $params = http_build_query([

            'apikey'       => $apiKey,
            'apitoken'     => $apiToken,
            'type'         => 'sms',
            'from'         => $senderID,
            'to'           => $phoneNumber,
            'text'         => $message,
            'scheduledate' => date('Y-m-d H:i:s'),
            'route'        => $_route

        ]);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $endpoint . $params);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('application/x-www-form-urlencoded'));
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($ch, CURLOPT_CAINFO, getcwd() . "/cacert.cer");
        curl_setopt($ch, CURLOPT_VERBOSE, true);
        $response = curl_exec($ch);

        /*
        // enable the below to debug any boolean(false) response
        $res=(object)array(

        'response'  =>  curl_exec( $ch ),
        'info'      =>  curl_getinfo( $ch ),
        'errors'    =>  curl_error( $ch )
        );
        curl_close($ch);
        */

        $response = json_decode($response, true);
        if ($response['status'] == "queued") {
            return true;
        } elseif ($response['status'] == "error") {
            return  $response['message'];
        } else {
            return false;
        }
    }

    static function settings()
    {
        $ci = &get_instance();
        $ci->load->model("adm");
        $settings = $ci->adm->get_settings();
        return $settings;
    }

    static function sumRows($uid)
    {
        $ci = &get_instance();
        $ci->load->model("adm");
        $total = $ci->adm->sumSameRows($uid);
        return $total;
    }
    static function get_subscriptions_by_id($uid)
    {
        $ci = &get_instance();
        $ci->load->model("Members");
        $total = $ci->Members->get_subscriptions_by_id($uid);
        return $total;
    }
}
class MemberHelper
{
    static function getAllSummitPackages()
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $packages = $ci->Members->get_all_summit_packages();
        return $packages;
    }
 
  static function packagenamesummit($id)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        $packagename = $ci->Members->get_packagenamesummit($id);
        return $packagename ? $packagename["name"] : "";
    }
 
  static function getAllOwnershipPackages()
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $packages = $ci->Members->get_all_ownership_packages();
        return $packages;
    }
 
static function packagenameownership($id)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        $packagename = $ci->Members->get_packagenameownership($id);
        return $packagename ? $packagename["name"] : "";
    }
    static function pointsWallet($id = false)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');

        if ($id) {
            $ewallet = $ci->Members->get_points_wallet($id);
        } else {
            $ewallet = $ci->Members->get_points_wallet($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }
    static function paypalWallet($id = false)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');

        if ($id) {
            $ewallet = $ci->Members->get_paypal_wallet($id);
        } else {
            $ewallet = $ci->Members->get_paypal_wallet($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }

    static function getforexPackage()
    {

        $ci = &get_instance();
        $ci->load->model('Members');
        $res = $ci->Members->getforexPackage();
        return $res;
    }


    static function checkForexPackBought($uid)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $pack = $ci->Members->checkForexPack($uid);
        return $pack;
    }
    static function getUserFromRefCode($data)
    {
        $ci = &get_instance();
        $ci->load->model("Members");
        $user = $ci->Members->getUserByRefCode($data);
        return $user ? $user : 0;
    }
    static function user_wallet($id = false, $type = 'dollar')
    {
        $ci = &get_instance();
        $uid = helpers::user_id();
        $ci->load->model('Members');
        if ($id) {
            $amount = $ci->Members->get_user_wallet($id);
        } else {
            $amount = $ci->Members->get_user_wallet($uid["id"]);
        }

        $walletAmount = $amount ? $amount['wallet_amount'] : 0;

        return $walletAmount ? round($walletAmount, 2) : 0;
    }
    static function karibu_wallet($id = false, $type = 'dollar')
    {
        $ci = &get_instance();
        $uid = helpers::user_id();
        $ci->load->model('Members');
        if ($id) {
            $amount = $ci->Members->get_karibu_user_wallet($id);
        } else {
            $amount = $ci->Members->get_karibu_user_wallet($uid["id"]);
        }

        $walletAmount = $amount ? $amount['wallet_amount'] : 0;

        return $walletAmount ? round($walletAmount, 2) : 0;
    }
    static function aviator_game_wallet($id)
    {
        $ci = &get_instance();
        $uid = helpers::user_id();
        $ci->load->model('Members');

        $amount = $ci->Members->get_aviator_user_wallet($id);


        $walletAmount = $amount ? $amount['amount'] : 0;

        return $walletAmount ? round($walletAmount, 2) : 0;
    }

    static function demo_wallet($id = false, $type = 'dollar')
    {
        $ci = &get_instance();
        $uid = helpers::user_id();
        $ci->load->model('Members');
        if ($id) {
            $amount = $ci->Members->get_demo_wallet($id);
        } else {
            $amount = $ci->Members->get_demo_wallet($uid["id"]);
        }

        $walletAmount = $amount ? $amount['amount'] : 0;

        return $walletAmount ? round($walletAmount, 2) : 0;
    }
    static function forex_wallet($id = false, $type = 'dollar')
    {
        $ci = &get_instance();
        $uid = helpers::user_id();
        $ci->load->model('Members');
        if ($id) {
            $amount = $ci->Members->get_forex_wallet($id);
        } else {
            $amount = $ci->Members->get_forex_wallet($uid["id"]);
        }

        $walletAmount = $amount ? $amount['amount'] : 0;

        return $walletAmount ? round($walletAmount, 2) : 0;
    }
    static function ewallet($id = false)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        if ($id) {
            $ewallet = $ci->Members->get_user_earning($id);
        } else {
            $ewallet = $ci->Members->get_user_earning($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }
    static function cashback_bonus($id = false)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        if ($id) {
            $ewallet = $ci->Members->get_cashback_bonus($id);
        } else {
            $ewallet = $ci->Members->get_cashback_bonus($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }
    static function compound_amount($id = false)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        if ($id) {
            $ewallet = $ci->Members->get_compounding_amount($id);
        } else {
            $ewallet = $ci->Members->get_compounding_amount($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }
    static function compound_earning($id = false)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        if ($id) {
            $ewallet = $ci->Members->get_compounding_earning($id);
        } else {
            $ewallet = $ci->Members->get_compounding_earning($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }
    static function gamewallet($id = false)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        if ($id) {
            $ewallet = $ci->Members->get_game_earning($id);
        } else {
            $ewallet = $ci->Members->get_game_earning($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }

    static function app_earnings($id = false)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        if ($id) {
            $ewallet = $ci->Members->get_app_earning($id);
        } else {
            $ewallet = $ci->Members->get_app_earning($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }

    static function whatsapp_earnings($id = false)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        if ($id) {
            $ewallet = $ci->Members->get_whatsapp_earning($id);
        } else {
            $ewallet = $ci->Members->get_whatsapp_earning($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }

    static function spining_earnings($id = false)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        if ($id) {
            $ewallet = $ci->Members->get_spining_earning($id);
        } else {
            $ewallet = $ci->Members->get_spining_earning($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }

    static function getAllPackages()
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $packages = $ci->Members->get_all_packages();
        return $packages;
    }
    static function getuserreferrals()
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        $query = $ci->Members->getreferrals($uid["id"]);
        return $query;
    }
    static function getuseractivemembers()
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        $query = $ci->Members->getactiveusers($uid["id"]);
        return $query;
    }
    static function gethighestpack($id = false)
    {
        $cid = Helpers::user_id();
        $uid = $id ? $id : $cid["id"];
        $ci = &get_instance();
        $ci->load->model('Members');
        $package = $ci->Members->gethighestpackage($uid);
        $packagename = $ci->Members->get_packagename($package["package_id"]);
        return $packagename;
    }

    static function packagename($id)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        $packagename = $ci->Members->get_packagename($id);
        return $packagename ? $packagename["name"] : "";
    }
    static function getRemoTaskPackages()
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        $packagename = $ci->Members->get_remo_all_packs();
        return $packagename ? $packagename : "";
    }
    static function getRemoTaskPackagesById($id)
    {
        $uid = Helpers::user_id();
        $ci = &get_instance();
        $ci->load->model('Members');
        $packagename = $ci->Members->get_remotask_pack($id);
        return $packagename ? $packagename : "";
    }
    static function getref($id)
    {

        $ci = &get_instance();
        $ci->load->model('Members');
        $query = $ci->Members->getreferralsarray($id);
        return $query;
    }
    static function getsponsordetails($id = false)
    {
        $cid = Helpers::user_id();
        $uid = $id ? $id : $cid["id"];
        $ci = &get_instance();
        $ci->load->model('Members');
        $sponsor = $ci->Members->getsponsor($uid);
        return $sponsor;
    }
    static function amountwithdrawn($id = false)
    {
        $cid = Helpers::user_id();
        $uid = $id ? $id : $cid["id"];
        $ci = &get_instance();
        $ci->load->model('Members');
        $sponsor = $ci->Members->getamountwithdrawn($uid);
        return $sponsor;
    }
    static function whatsappamountwithdrawn($id = false)
    {
        $cid = Helpers::user_id();
        $uid = $id ? $id : $cid["id"];
        $ci = &get_instance();
        $ci->load->model('Members');
        $sponsor = $ci->Members->getwhatsappamountwithdrawn($uid);
        return $sponsor;
    }
    static function checkpackbought($id = false)
    {
        $cid = Helpers::user_id();
        $uid = $id ? $id : $cid["id"];
        $ci = &get_instance();
        $ci->load->model('Members');
        $pack = $ci->Members->checkpackagebought($uid);
        return $pack;
    }

    static function checkpackboughtpremium($id = false)
    {
        $cid = Helpers::user_id();
        $uid = $id ? $id : $cid["id"];
        $ci = &get_instance();
        $ci->load->model('Members');
        $pack = $ci->Members->getstarpackusers($uid);
        return $pack;
    }
    static function getearned()
    {

        $ci = &get_instance();
        $ci->load->model('Members');
        $sum = $ci->Members->get_ewallet_sum();
        return $sum['amount'];
    }

    static function get_country_currency($code)
    {

        $currency =  array(
            'AF' => 'AFN',
            'AL' => 'ALL',
            'DZ' => 'DZD',
            'AS' => 'USD',
            'AD' => 'EUR',
            'AO' => 'AOA',
            'AI' => 'XCD',
            'AQ' => 'XCD',
            'AG' => 'XCD',
            'AR' => 'ARS',
            'AM' => 'AMD',
            'AW' => 'AWG',
            'AU' => 'AUD',
            'AT' => 'EUR',
            'AZ' => 'AZN',
            'BS' => 'BSD',
            'BH' => 'BHD',
            'BD' => 'BDT',
            'BB' => 'BBD',
            'BY' => 'BYR',
            'BE' => 'EUR',
            'BZ' => 'BZD',
            'BJ' => 'XOF',
            'BM' => 'BMD',
            'BT' => 'BTN',
            'BO' => 'BOB',
            'BA' => 'BAM',
            'BW' => 'BWP',
            'BV' => 'NOK',
            'BR' => 'BRL',
            'IO' => 'USD',
            'BN' => 'BND',
            'BG' => 'BGN',
            'BF' => 'XOF',
            'BI' => 'BIF',
            'KH' => 'KHR',
            'CM' => 'XAF',
            'CA' => 'CAD',
            'CV' => 'CVE',
            'KY' => 'KYD',
            'CF' => 'XAF',
            'TD' => 'XAF',
            'CL' => 'CLP',
            'CN' => 'CNY',
            'HK' => 'HKD',
            'CX' => 'AUD',
            'CC' => 'AUD',
            'CO' => 'COP',
            'KM' => 'KMF',
            'CG' => 'XAF',
            'CD' => 'CDF',
            'CK' => 'NZD',
            'CR' => 'CRC',
            'HR' => 'HRK',
            'CU' => 'CUP',
            'CY' => 'EUR',
            'CZ' => 'CZK',
            'DK' => 'DKK',
            'DJ' => 'DJF',
            'DM' => 'XCD',
            'DO' => 'DOP',
            'EC' => 'ECS',
            'EG' => 'EGP',
            'SV' => 'SVC',
            'GQ' => 'XAF',
            'ER' => 'ERN',
            'EE' => 'EUR',
            'ET' => 'ETB',
            'FK' => 'FKP',
            'FO' => 'DKK',
            'FJ' => 'FJD',
            'FI' => 'EUR',
            'FR' => 'EUR',
            'GF' => 'EUR',
            'TF' => 'EUR',
            'GA' => 'XAF',
            'GM' => 'GMD',
            'GE' => 'GEL',
            'DE' => 'EUR',
            'GH' => 'GHS',
            'GI' => 'GIP',
            'GR' => 'EUR',
            'GL' => 'DKK',
            'GD' => 'XCD',
            'GP' => 'EUR',
            'GU' => 'USD',
            'GT' => 'QTQ',
            'GG' => 'GGP',
            'GN' => 'GNF',
            'GW' => 'GWP',
            'GY' => 'GYD',
            'HT' => 'HTG',
            'HM' => 'AUD',
            'HN' => 'HNL',
            'HU' => 'HUF',
            'IS' => 'ISK',
            'IN' => 'INR',
            'ID' => 'IDR',
            'IR' => 'IRR',
            'IQ' => 'IQD',
            'IE' => 'EUR',
            'IM' => 'GBP',
            'IL' => 'ILS',
            'IT' => 'EUR',
            'JM' => 'JMD',
            'JP' => 'JPY',
            'JE' => 'GBP',
            'JO' => 'JOD',
            'KZ' => 'KZT',
            'KE' => 'KES',
            'KI' => 'AUD',
            'KP' => 'KPW',
            'KR' => 'KRW',
            'KW' => 'KWD',
            'KG' => 'KGS',
            'LA' => 'LAK',
            'LV' => 'EUR',
            'LB' => 'LBP',
            'LS' => 'LSL',
            'LR' => 'LRD',
            'LY' => 'LYD',
            'LI' => 'CHF',
            'LT' => 'EUR',
            'LU' => 'EUR',
            'MK' => 'MKD',
            'MG' => 'MGF',
            'MW' => 'MWK',
            'MY' => 'MYR',
            'MV' => 'MVR',
            'ML' => 'XOF',
            'MT' => 'EUR',
            'MH' => 'USD',
            'MQ' => 'EUR',
            'MR' => 'MRO',
            'MU' => 'MUR',
            'YT' => 'EUR',
            'MX' => 'MXN',
            'FM' => 'USD',
            'MD' => 'MDL',
            'MC' => 'EUR',
            'MN' => 'MNT',
            'ME' => 'EUR',
            'MS' => 'XCD',
            'MA' => 'MAD',
            'MZ' => 'MZN',
            'MM' => 'MMK',
            'NA' => 'NAD',
            'NR' => 'AUD',
            'NP' => 'NPR',
            'NL' => 'EUR',
            'AN' => 'ANG',
            'NC' => 'XPF',
            'NZ' => 'NZD',
            'NI' => 'NIO',
            'NE' => 'XOF',
            'NG' => 'NGN',
            'NU' => 'NZD',
            'NF' => 'AUD',
            'MP' => 'USD',
            'NO' => 'NOK',
            'OM' => 'OMR',
            'PK' => 'PKR',
            'PW' => 'USD',
            'PA' => 'PAB',
            'PG' => 'PGK',
            'PY' => 'PYG',
            'PE' => 'PEN',
            'PH' => 'PHP',
            'PN' => 'NZD',
            'PL' => 'PLN',
            'PT' => 'EUR',
            'PR' => 'USD',
            'QA' => 'QAR',
            'RE' => 'EUR',
            'RO' => 'RON',
            'RU' => 'RUB',
            'RW' => 'RWF',
            'SH' => 'SHP',
            'KN' => 'XCD',
            'LC' => 'XCD',
            'PM' => 'EUR',
            'VC' => 'XCD',
            'WS' => 'WST',
            'SM' => 'EUR',
            'ST' => 'STD',
            'SA' => 'SAR',
            'SN' => 'XOF',
            'RS' => 'RSD',
            'SC' => 'SCR',
            'SL' => 'SLL',
            'SG' => 'SGD',
            'SK' => 'EUR',
            'SI' => 'EUR',
            'SB' => 'SBD',
            'SO' => 'SOS',
            'ZA' => 'ZAR',
            'GS' => 'GBP',
            'SS' => 'SSP',
            'ES' => 'EUR',
            'LK' => 'LKR',
            'SD' => 'SDG',
            'SR' => 'SRD',
            'SJ' => 'NOK',
            'SZ' => 'SZL',
            'SE' => 'SEK',
            'CH' => 'CHF',
            'SY' => 'SYP',
            'TW' => 'TWD',
            'TJ' => 'TJS',
            'TZ' => 'TZS',
            'TH' => 'THB',
            'TG' => 'XOF',
            'TK' => 'NZD',
            'TO' => 'TOP',
            'TT' => 'TTD',
            'TN' => 'TND',
            'TR' => 'TRY',
            'TM' => 'TMT',
            'TC' => 'USD',
            'TV' => 'AUD',
            'UG' => 'UGX',
            'UA' => 'UAH',
            'AE' => 'AED',
            'GB' => 'GBP',
            'US' => 'USD',
            'UM' => 'USD',
            'UY' => 'UYU',
            'UZ' => 'UZS',
            'VU' => 'VUV',
            'VE' => 'VEF',
            'VN' => 'VND',
            'VI' => 'USD',
            'WF' => 'XPF',
            'EH' => 'MAD',
            'YE' => 'YER',
            'ZM' => 'ZMW',
            'ZW' => 'ZWD',
        );

        $value = $currency[$code];
        if ($value) {
            return $value;
        } else {
            return "nothing";
        }
    }

    static function currencyConverter($to, $amount)
    {

        $ci = &get_instance();
        $ci->load->model('Members');
        $dbAmount = $ci->Members->getCurrencyAmount($to);

        return $dbAmount ? round($dbAmount['amount'] * $amount, 2)  : "";
    }


    static function getAgentPackage()
    {

        $ci = &get_instance();
        $ci->load->model('Members');
        $res = $ci->Members->getAgentPackage();
        return $res;
    }
    static function checkAgentPackBought($uid)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $pack = $ci->Members->getlastpackid_agentPack($uid);
        return $pack;
    }

    static function getUserLastPack($uid)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $pack = $ci->Members->getlastpackidbyId($uid);
        return $pack;
    }

    static function checkUnlockPack($uid)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $pack = $ci->Members->alreadyUnlockPack($uid);
        return $pack;
    }

    static function checkPaypalLoginPack($uid)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $pack = $ci->Members->alreadyPaypalLoginPack($uid);
        return $pack;
    }

    static function getOrderCommission()
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $pack = $ci->Members->get_all_order_commission();
        return $pack ? array_sum(array_column($pack, 'amount')) : 0;
    }

    static function getAllsharePackages()
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $packages = $ci->Members->get_all_share_packages();
        return $packages;
    }

    static function isUniqueCode($code)
    {

        $query = "SELECT * FROM epin";

        $ci = &get_instance();

        $result = $ci->db->query($query);

        $row = $result->result_array();

        foreach ($row as $value) {

            $prev_code =  $value['epin'];

            if ($prev_code ==  $code) {

                $code = random_string('alnum', 5);
            }
        }

        return $code;
    }
    static function packageNameFromId($package_id, $model = false)
    {

        $ci = &get_instance();

        $ci->load->model('Members');

        $data = $ci->Members->getPackageFromId($package_id);

        if ($model) {

            return $data ? $data : '';
        }

        return $data ? $data["name"] : '';
    }

    static function generateUniquePin($length = false)
    {

        $length = $length ? $length : 5;

        $ci = &get_instance();

        $ci->load->helper('string');

        $code = random_string('alnum', $length);

        $uniqueCode = self::isUniqueCode($code);

        return $uniqueCode;
    }

    static function getTask($uid = false, $taskId)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $cid = Helpers::user_id();
        $uid = $uid ? $uid : $cid["id"];
        $username = $ci->Members->get_userid_taskid($uid, $taskId);
        return $username;
    }
    static function TaskData($taskId)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $username = $ci->Members->get_task($taskId);
        return $username;
    }
    static function getCompletedTaskRow($uid = false, $taskId)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $cid = Helpers::user_id();
        $uid = $uid ? $uid : $cid["id"];
        $username = $ci->Members->get_comp_task($uid, $taskId);
        return $username;
    }
    static function game_registration($uid = false)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $cid = Helpers::user_id();
        $uid = $uid ? $uid : $cid["id"];
        $username = $ci->Members->get_game_user($uid);
        return $username;
    }
    static function gamePackage($uid)
    {
        $ci = &get_instance();
        $ci->load->model('Members');
        $cid = Helpers::user_id();
        $username = $ci->Members->get_acess_code($uid);
        return $username;
    }
}
