<?php
defined('BASEPATH') OR exit('No direct script access allowed');
class Member extends CI_Controller {
	function __construct() {
		parent::__construct();
		$this->load->model(array('Members','Adm'));
		$res =  $this->Members->getMailsFromDatabase();
		$this->lastHourMails =  $res ? count($res) : 0;
		$this->username = $this->session->userdata('user'); 
		$this->currency = $this->username ? $this->username['currency'] : "KES";
		$this->userId = Helpers::user_id();       
		$this->load->library('paypal_lib');
		if ( ! $this->username)
		{ 
			redirect('login');
		}
	}
	public function getRefActiveUser(){
		$refUsers = MemberHelper::getref($this->userId["id"]);
		$i = 0; 
		foreach ($refUsers as $user) {
			$pack = MemberHelper::checkpackbought($user['user_id']);
			if($pack){
				$i++;
			}
		}
		return $i;
	}
	public function close(){
		 $this->Adm->updateuser($this->userId["id"],["notify"=> 0]);
		 redirect("member/dashboard");
	}

	public function dashboard(){

		$user = Helpers::getUserObj($this->userId["id"]);
		$data["user"]=$user;	
    	$packs = $this->Members->checkIfUserBoughtSubscription($this->userId["id"]);
		$agentPack = $this->Members->checkIfUserBoughtAgentSubscription($this->userId["id"]);
		// echo "<pre>";
		// print_r($packs);
		// exit;
		$pack = "";
		if(!empty($agentPack) && !empty($packs)){
			
			$agentDate = date("Y-m-d",strtotime($agentPack['purchase_date']));	
			$packsDate = date("Y-m-d",strtotime($packs['purchase_date']));	
			if($agentDate >= $packsDate){
				$pack = "Agent";
			}else{
				
				$pack = $packName = MemberHelper::packagename($packs['package_id']);
				
			}
		}else{
			if($packs != ""){
				$pack = $packName = MemberHelper::packagename($packs['package_id']);
			}elseif($agentPack != ""){
				$pack = "Agent";
			}
		}

		
		 $data["pack"] = $pack ? $pack : "";
		$data['wapp_earning'] = $this->Members->getSumEarnings($this->userId["id"]);
		$single_notification = $this->Members->get_last_notification($this->userId["id"]);
		$all_notification = $this->Members->get_last_notification_all();
		
		if(empty($single_notification)){
			$data['notification'] = $all_notification;

		}if(empty($all_notification)){
			$data['notification'] = $single_notification;

		}
		if(!empty($single_notification) && !empty($all_notification)){
		if($single_notification['date'] > $all_notification['date']){
			// echo "single";
			$data['notification'] = $single_notification;
		}else{
			// echo "All";
			$data['notification'] = $all_notification;
		}
	}
	    
	    $whatsAppWithdraw = $this->Members->get_whatsapp_withdraw_request($this->userId["id"]);
		$data['whatsapp_withdraw_total'] = $whatsAppWithdraw ? array_sum(array_column($whatsAppWithdraw, 'amount')) : 0;

		$gameWithdraw = $this->Members->get_game_withdraw_request($this->userId["id"]);
		$data['game_withdraw_total'] = $gameWithdraw ? array_sum(array_column($gameWithdraw, 'amount')) : 0;

		$appWithdraw = $this->Members->get_app_withdraw_request($this->userId["id"]);
		$data['app_withdraw_total'] = $appWithdraw ? array_sum(array_column($appWithdraw, 'amount')) : 0;

		$spiningWithdraw = $this->Members->get_spining_withdraw_request($this->userId["id"]);
		$data['spining_withdraw_total'] = $spiningWithdraw ? array_sum(array_column($spiningWithdraw, 'amount')) : 0;
		// print_r($gameWithdraw);
		// exit;

		$this->load->view("layouts/common", ["template"=>"pages/dashboard", "data"=>$data]);
	}
	public function change_password()
	{
		$user = Helpers::getUserObj($this->userId["id"]);
		if ($this->input->post()) {
			$currentPwd = $user['password'];
			$enteredCurrentPwd = sha1($this->input->post("current_password"));
			$newPwd = sha1($this->input->post("password"));
			$this->form_validation->set_rules('password', 'Password', 'required|min_length[6]|max_length[15]');
			$this->form_validation->set_rules('passconf', 'Password Confirmation', 'required|matches[password]');
			if (strcmp($currentPwd, $enteredCurrentPwd) !== 0) {
				$flash = Helpers::flash('danger', 'Incorrect current password!');
				$this->session->set_flashdata('response', $flash);
				return redirect("member/change_password");
			}
			if ($this->form_validation->run() == FALSE) {
			} else {
				$data["password"] = $newPwd;
				if ($this->Users->updateUser($this->userId["id"], $data)) {
					$flash = Helpers::flash('success', 'Your password has been changed!');
					$this->session->set_flashdata('response', $flash);
						return redirect("member/change_password");
				} else {
					$flash = Helpers::flash('danger', 'Something went wrong!');
					$this->session->set_flashdata('response', $flash);
						return redirect("member/change_password");
				}
				
			}
		}
		$this->load->view("layouts/common", ["template" => "pages/change_password"]);
	}
		public function valid_phone_number($num){
		if(!preg_match('/^[0-9 \-]+$/',$num)) {
			return 1;
		}else{
			return 0;
		}
	}
	public function deposit(){
            $this->load->helper('string');
		if($this->input->post()){
			$this->form_validation->set_rules('phone', 'Phone', 'required');
			$this->form_validation->set_rules('amount','Amount','required');
			if($this->form_validation->run()== False)
			{
			}
			else
			{

				$id = $this->userId["id"];
				$user=$this->username;
				$userid=$this->userId["id"];
				$data1["user_id"]=$userid;
				$data1["username"]=$user["username"];
				$data1["amount"]=$this->input->post("amount");
				$data1["phone"]=$this->input->post("phone");
				$data1["created_at"]=date('Y-m-d H:i:s');
				$transRef = "LLDEP$id".random_string('alnum', 8);
				$transRef2 = "LLDEP$id".random_string('alnum', 8);
				$data1["mpesa_trans_id"] = $transRef;
				
				$validPhone = $this->valid_phone_number($data1["phone"]);
				if($validPhone == 1){
					$flash = Helpers::flash('danger', 'Phone Number Not Valid');
					$this->session->set_flashdata('response', $flash);
					redirect("deposit");
				}
				
				$fundid=$this->Members->store_fund($data1);
				
                $api_key = 'IITAOK0XJVRYPKGJPIWUVTRY2Y2MWTUSJWNKTVNNXPP1IFI5';
				$api_secret = 'KON4YAUM0EA67DZWAD37HCGW4JYFENRD8AOBNFTYTYCVDQJZ';
				$endpoint = 'https://sapamacash.com/api/checkout';
                //Data to send a query string
                        $data = array(
                            'format' => 'json',
                            'location_id' => '421',
                            'phone' => $data1["phone"],
                            'first_name' => $user["first_name"],
                            'currency' => 'KES',
                            'bill_ref_number' => $user["username"],
                            'flow' => 'stkpush',
                            'environment' => 'live',
                            'type' => 'stkpush',
                            'amount' => $data1["amount"],
                            'description' => $user["username"],
                            'reference_number' =>  time(),
                            'api_key' => $api_key,
                            'api_secret' => $api_secret,
                        );
                        //Sort by keys in ascending order
                        ksort($data);
                        
                        //Implode the string
                        $string_to_hash = implode('.',$data);
                        
                        // echo 'String to hash: ' . $string_to_hash . '<p>';
                        
                        //Generate hash
                        $hash = hash('sha256', $string_to_hash, false);
                        
                        // echo 'Generated hash: ' . $hash . '<p>';
                        
                        //IMPORTANT: REMEMBER TO ADD THE GENERATED HASH TO TO THE DATA
                        $data['hash'] = $hash;
                        
                        //IMPORTANT: REMEMBER TO REMOVE THE API SECRET FROM THE DATA HASHED
                        unset($data['api_secret']);
                        // var_dump($data);
                        
                        $fields_string = '';
                        foreach ($data as $key => $value) {
                            $fields_string .= $key . '=' . $value . '&';
                        }//E# foreach statement
                        
                        rtrim($fields_string, '&');
                        
                        // echo 'Query string: ' . $fields_string . '<p>';
                        
                        // echo 'Full url: ' . $endpoint . '?' . $fields_string . '<p>';
                        
                        // Get cURL resource
                        $ch = curl_init();
                        
                        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                        
                        curl_setopt($ch, CURLOPT_URL, $endpoint);
                        curl_setopt($ch, CURLOPT_POST, count($data));
                        curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
                        
                        $result = curl_exec($ch);
                        // echo 'Result in JSON<p>' . $result . '<p>';
                        
                        $decoded_data = json_decode($result, true);
                        // echo 'Decoded array<p>';
                        //  echo '<pre>';
                        // var_dump($decoded_data);
                        // exit;
                        
                      	$flash = Helpers::flash('success', 'Request Submitted Successfully!');
				        $this->session->set_flashdata('response', $flash);
						return redirect("member/deposit");
                        
                        			
            		}
         	}
				$data = $this->Members->getmpesaerequests($this->userId["id"]);
				$this->load->view("layouts/common", ["template"=>"pages/deposit", "data"=>$data]);
			}
	public function deposit1(){
		if($this->input->post())
		{
			$this->form_validation->set_rules('phone', 'Phone', 'required');
			$this->form_validation->set_rules('mpesa_trans_id', 'Mpesa Transaction Id', 'required');
			$this->form_validation->set_rules('amount','Amount','required');
			if($this->form_validation->run()== False)
			{
			}
			else
			{
				$data= array();
				$user=$this->username;
				$userid=$this->userId["id"];
				$data["user_id"]=$userid;
				$data["username"]=$user["username"];
				$data["mpesa_trans_id"]=$this->input->post("mpesa_trans_id");
				$data["amount"]=$this->input->post("amount");
				$data["phone"]=$this->input->post("phone");
				$data["created_at"]=date('Y-m-d H:i:s');
				$fundid=$this->Members->store_fund($data);
				if($fundid) {
					$flash = Helpers::flash('success', 'Transaction successful.');
					$this->session->set_flashdata('response', $flash);
					redirect("deposit1");
				}
				else {
					$flash = Helpers::flash('danger', 'Something went wrong!');
					$this->session->set_flashdata('response', $flash);
					redirect("deposit1");
				}
			}
		}
		$data = $this->Members->getmpesaerequests($this->userId["id"]);
		$this->load->view("layouts/common", ["template"=>"pages/deposit1", "data"=>$data]);
	}
	public function deposit_oldlast(){
		if($this->input->post()){
			$this->form_validation->set_rules('phone', 'Phone', 'required');
			$this->form_validation->set_rules('amount','Amount','required');
			if($this->form_validation->run()== False)
			{
			}
			else
			{
				$this->load->helper('string');
				$userdetails= Helpers::userdetails($this->userId["id"]);
				$data= array();
				$id = $this->userId["id"];
				$user=$this->username;
				$userid=$this->userId["id"];
				$data1["user_id"]=$userid;
				$data1["username"]=$user["username"];
				$data1["amount"]=$this->input->post("amount");
				$data1["phone"]=$this->input->post("phone");
				$data1["created_at"]=date('Y-m-d H:i:s');
				$transRef = "LLDEP$id".random_string('alnum', 6);
				$data1["mpesa_trans_id"] = $transRef;
				$fundid=$this->Members->store_fund($data1);
				$amount=$this->input->post("amount");
				$phone = $userdetails["phone"];
				$username = $userdetails["username"];
				$endpoint = 'https://supabeta.com/api/payments/deposit/initiate';
				$data = array(
					"amount"=>$amount,
					"msisdn"=>$phone,					 
					"referrence"=>$username,
					"uniqRef"=>$transRef,
					"channel"=>"RealSimple_api"
				);
				$data = json_encode($data);
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
				curl_setopt($ch, CURLOPT_URL, $endpoint);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
				$response = curl_exec($ch);
				$response = json_decode($response, true);

				if($response["code"]=="200"){
					$flash = Helpers::flash('success', "Request sent successfully");
					$this->session->set_flashdata('response', $flash);
					return redirect('member/deposit');
				}
				else {
					$flash = Helpers::flash('danger', $response['response']);
					$this->session->set_flashdata('response', $flash);
					redirect("deposit");
				}
			}
		}
		$data = $this->Members->getmpesaerequests($this->userId["id"]);
		$this->load->view("layouts/common", ["template"=>"pages/deposit", "data"=>$data]);
	}
	public function notification(){
		$data = $this->Members->get_notification($this->userId["id"]);
		$res = $this->Adm->updateuser($this->userId["id"],["notify"=> 0]);
		$data1 = $this->Members->get_notification_all();
		$this->load->view("layouts/common", ["template"=>"pages/notification", "data"=>$data,"data1"=>$data1]);
	}
	
	public function view_ads(){
		$this->load->model('Members');
		$data = $this->Members->get_ads();
		$this->load->view("layouts/common", ["template"=>"pages/view_ads","data"=>$data]);
	}
	public function deposit_auto(){
		if($this->input->post())
		{
			$this->form_validation->set_rules('phone', 'Phone', 'required');
			$this->form_validation->set_rules('amount','Amount','required');
			if($this->form_validation->run()== False)
			{
			}
			else
			{
				//Set the api_key, api_secret and endpoint as configs in the system that can be setup during configuration
				$api_key = 'DQGUJ1ZO0SLM0Y64ENAZMV2NTZ39DWJQOXN6DKR5LO15HS4W';
				$api_secret = 'HBNMYTPOJTOIFYHS1EH7CZEXZJGDRJTJMD6KUCYBMGH9UZM2';
				$endpoint = 'https://sapamacash.com/api/checkout';
				$phone = $this->input->post("phone");
				$amount = $this->input->post("amount");
				$data1["amount"]=$this->input->post("amount");
				$data1["phone"]=$this->input->post("phone");
				$data1["user_id"]=$this->input->post("id");
				$data1["date"]=date('Y-m-d H:i:s');
				$fundid=$this->Members->store_mpesa_request($data1);
				if($fundid){
				//Data to send a query string
					$data = array(
						'format' => 'json',
						'location_id' => '313',
						'phone' => $phone,
						'first_name'=>'John',
						'currency'=>'KES',
						'bill_ref_number'=>'123',
						'flow'=>'stkpush',
						'environment'=>'live',
						'type' => 'stkpush',
						'amount' => $amount,
						'description' => '',
						'reference_number' => $fundid,
						'api_key' => $api_key,
						'api_secret' => $api_secret,
					);
				//Sort by keys in ascending order
					ksort($data);
				//Implode the string
					$string_to_hash = implode( '.',$data);
				//echo 'String to hash: ' . $string_to_hash . '<p>';
				//Generate hash
					$hash = hash('sha256', $string_to_hash, false);
				//echo 'Generated hash: ' . $hash . '<p>';
				//IMPORTANT: REMEMBER TO ADD THE GENERATED HASH TO TO THE DATA
					$data['hash'] = $hash;
				//IMPORTANT: REMEMBER TO REMOVE THE API SECRET FROM THE DATA HASHED
					unset($data['api_secret']);
				//var_dump($data);
					$fields_string = '';
					foreach ($data as $key => $value) {
						$fields_string .= $key . '=' . $value . '&';
				}//E# foreach statement
				rtrim($fields_string, '&');
				//echo 'Query string: ' . $fields_string . '<p>';
				//echo 'Full url: ' . $endpoint . '?' . $fields_string . '<p>';
				// Get cURL resource
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_URL, $endpoint);
				curl_setopt($ch, CURLOPT_POST, count($data));
				curl_setopt($ch, CURLOPT_POSTFIELDS, $fields_string);
				$result = curl_exec($ch);
				//echo 'Result in JSON<p>' . $result . '<p>';
				$decoded_data = json_decode($result, true);
				//echo 'Decoded array<p>';
				//var_dump($decoded_data);
				// if ($decoded_data['httpStatusCode'] == 200 && array_key_exists('data', $decoded_data['data'])) {
				//    // echo '<p>Success<p>';
				// 	$index = 0;
				// 	foreach ($decoded_data['data']['data'] as $single_transaction) {
				//         //echo "<p>Transaction " . $index . '<p>';
				//         //var_dump($single_transaction);
				// 		$index++;
				//     }//E# foreach statement
				// } else {
				//     //echo "<p>HTTP Status Code: " . $decoded_data['httpStatusCode'] . '<p>';
				//     //echo "System Code: " . $decoded_data['systemCode'] . '<p>';
				//     //echo "Message: " . $decoded_data['systemCode'] . '<p>';
				// }//E# if else statement
			}
		}
	}
	$data = $this->Members->get_single_mpesa_response($this->username['phone']);
	$this->load->view("layouts/common", ["template"=>"pages/deposit1","data"=>$data]);
}
public function deposit_confirm()
{
	$data["organization_id"] = 1;
	$this->Members->add_mpesa_response($data);
}
public function wallet_transfer()
{
	if($this->input->post())
	{
		$this->form_validation->set_rules('balance', 'Balance', 'required');
		$this->form_validation->set_rules('phone','Phone Number','required');
		$this->form_validation->set_rules('amount','Amount','required');
		if($this->form_validation->run()== False)
		{
		}
		else
		{	
			$balance = $this->input->post("balance");
			$phone = $this->input->post("phone");
			$amount = $this->input->post("amount");
			if($amount < 200)
			{	
				$currencyName =	$this->currency;
				$amt = MemberHelper::currencyConverter($this->currency , 200);
				$flash = Helpers::flash('danger', "Minimum transfer amount is $amt $currencyName !");
				$this->session->set_flashdata('response', $flash);
				redirect("wallet_transfer");
			}
			$ewallet = MemberHelper::ewallet();
			$topup = MemberHelper::user_wallet();
			$checkuser = Helpers::getuserbyphone($phone);
				if(empty($checkuser))
			{
				$flash = Helpers::flash('danger', 'User does not exist!');
				$this->session->set_flashdata('response', $flash);
				redirect("wallet_transfer");
			}
			$username = $checkuser["username"];
			$wallet = '';
			if($balance == 1)
			{
				$wallet = $ewallet;
			}else
			{
				$wallet = $topup;
			}
			if($amount > $wallet)
			{
				$flash = Helpers::flash('danger', 'You dont have sufficient amount!');
				$this->session->set_flashdata('response', $flash);
				redirect("wallet_transfer");
			}
		
			$otpRequest = $this->input->post("otp_request");
			if($otpRequest) {
				$userObj = Helpers::getUserObj();
				$this->load->helper('string');
				$otp = mt_rand(1111,9999);
				$otpData = array("user_id"=>$this->userId["id"],"reason"=> "transfer", "otp"=>$otp, "created_at"=>Helpers::date());
				$mailView = $this->load->view("emails/otp", array("user"=>$userObj, "data"=>$otp,"to_user"=>$checkuser["username"]), true);
				Helpers::sendEmail("Wallet to Wallet Transfer", $userObj['email'], $mailView);
				sleep(7);
				Helpers::saveMail($userObj['id'] ,"OTP - Wallet Transfer");
				$isSent = $this->Members->add_transfer_otp($otpData);
				$flash = Helpers::flash('success', 'OTP Sent to your email please check your email');
				$this->session->set_flashdata('response', $flash);
				$data['phone'] = $phone;
				$data['amount'] = $amount;
				$data['balance'] = $balance;
				$this->session->set_userdata("dataArray",$data);
				$phone = $userObj['phone'];
				$phonemessage = "Your Wallet to Wallet Money Transfer Verification Code To $username is $otp.";
				// Helpers::send_sms($phone, $phonemessage);
				return redirect('verify_transfer');
			} 
		}
	}
	$data["send"] = $this->Members->getwallettransferhistory($this->userId["id"]);
	$data["receive"] = $this->Members->getwalletreceivehistory($this->userId["id"]);
				// $data['otp_sent'] = $isSent;
	$this->load->view("layouts/common", ["template"=>"pages/wallet_transfer", "data"=>$data]);
}
public function verify_transfer() {
	if($this->input->post()) {
		$balance = $this->input->post("balance");
		$phone = $this->input->post("phone");
		$amount = $this->input->post("amount");
		$ewallet = MemberHelper::ewallet();
		$topup = MemberHelper::user_wallet();
		$checkuser = Helpers::getuserbyphone($phone);
		$username = $checkuser["username"];
		$otpRow = $this->Members->get_otp_transfer_row($this->userId["id"]);
		$otpEntered = $this->input->post("otp");
		if($otpRow['otp'] == $otpEntered) {
			$this->Members->update_otp_transfer_row($otpRow['id'], ['verify'=>true]);
							// $flash = Helpers::flash('success', 'OTP verification success!');
			$transfer["user_id"] = $checkuser["id"];
			$transfer['wallet_amount'] = $amount;
			$transfer['updated_at'] = date('Y-m-d H:i:s');
			$result = $this->Members->add_wallet_amount($checkuser["id"], $transfer);
			if($result) {
				$fundTransfer['user_id'] = $this->userId["id"];
				$fundTransfer['to_id'] = $checkuser["id"];
				$fundTransfer['amount'] = $amount;
				$fundTransfer['type'] = 'sent';
				$fundTransfer['wallet'] = ($balance == '1') ? 'Earning':'Deposit';
				$fundTransfer['created_at'] = date('Y-m-d H:i:s');
				$userdetailmailview = Helpers::getUserObj($this->userId["id"]);
			
					$mailView = $this->load->view("emails/sentwallettransfer", array("user"=>$userdetailmailview , "transfer" => $fundTransfer , "to_id" => $checkuser), true);
					Helpers::sendEmail("Amount successfully transfered", $userdetailmailview["email"], $mailView);
					Helpers::saveMail($userdetailmailview['id'] ,"Amount Transfered - Wallet Transfer");
				
				if($this->Members->add_fund_transfer($fundTransfer)) {
					$fundTransfer['user_id'] = $checkuser["id"];
					$fundTransfer['to_id'] = $this->userId["id"];
					$fundTransfer['type'] = 'receive';
					$userdetailmailview = Helpers::getUserObj($fundTransfer['user_id']);
				
						$mailView = $this->load->view("emails/receivewallettransfer", array("user"=>$userdetailmailview , "transfer" => $fundTransfer), true);
						Helpers::sendEmail("Amount Recieved !", $userdetailmailview["email"], $mailView);
					
						Helpers::saveMail($userdetailmailview['id'] ,"Amount Recieved - Wallet Transfer");
				
					$this->Members->add_fund_transfer($fundTransfer);                 
				}
				if($balance == 1) {
					$this->Members->substract_ewallet_amount($this->userId["id"], $amount);						
				} else {
					$this->Members->substract_wallet_amount($this->userId["id"], $amount);
				}
				$flash = Helpers::flash('success', "Amount successfully transfered to $username.");
				$this->session->set_flashdata('response', $flash);
				redirect('wallet_transfer');
			}
		} else {
			$flash = Helpers::flash('danger', 'Incorrect OTP, please try again!');
			$this->session->set_flashdata('response', $flash);
			redirect('verify_transfer');
		}
	}
	$this->load->view("layouts/common", ["template"=>"pages/verify_transfer"]);
}
public function wallet_transfer_old()
{
	if($this->input->post())
	{
		$this->form_validation->set_rules('balance', 'Balance', 'required');
		$this->form_validation->set_rules('phone','Phone Number','required');
		$this->form_validation->set_rules('amount','Amount','required');
		if($this->form_validation->run()== False)
		{
		}
		else
		{	
			$balance = $this->input->post("balance");
			$phone = $this->input->post("phone");
			$amount = $this->input->post("amount");
			if($amount < 200)
			{
				$flash = Helpers::flash('danger', 'Minimum transfer amount is 200!');
				$this->session->set_flashdata('response', $flash);
				redirect("wallet_transfer");
			}
			$ewallet = MemberHelper::ewallet();
			$topup = MemberHelper::user_wallet();
			$checkuser = Helpers::getuserbyphone($phone);
			$username = $checkuser["username"];
			$wallet = '';
			if($balance == 1)
			{
				$wallet = $ewallet;
			}else
			{
				$wallet = $topup;
			}
			if($amount > $wallet)
			{
				$flash = Helpers::flash('danger', 'You dont have sufficient amount!');
				$this->session->set_flashdata('response', $flash);
				redirect("wallet_transfer");
			}
			if(!$checkuser)
			{
				$flash = Helpers::flash('danger', 'This username does not existt!');
				$this->session->set_flashdata('response', $flash);
				redirect("wallet_transfer");
			}
			$transfer["user_id"] = $checkuser["id"];
			$transfer['wallet_amount'] = $amount;
			$transfer['updated_at'] = date('Y-m-d H:i:s');
			$result = $this->Members->add_wallet_amount($checkuser["id"], $transfer);
			if($result) {
				$fundTransfer['user_id'] = $this->userId["id"];
				$fundTransfer['to_id'] = $checkuser["id"];
				$fundTransfer['amount'] = $amount;
				$fundTransfer['type'] = 'sent';
				$fundTransfer['wallet'] = ($balance == '1') ? 'Earning':'Deposit';
				$fundTransfer['created_at'] = date('Y-m-d H:i:s');
				$userdetailmailview = Helpers::getUserObj($this->userId["id"]);
				if($this->Members->add_fund_transfer($fundTransfer)) {
					$fundTransfer['user_id'] = $checkuser["id"];
					$fundTransfer['to_id'] = $this->userId["id"];
					$fundTransfer['type'] = 'receive';
					$userdetailmailview = Helpers::getUserObj($fundTransfer['user_id']);
					$this->Members->add_fund_transfer($fundTransfer);                 
				}
				if($balance == 1) {
					$this->Members->substract_ewallet_amount($this->userId["id"], $amount);						
				} else {
					$this->Members->substract_wallet_amount($this->userId["id"], $amount);
				}
				$flash = Helpers::flash('success', "Amount successfully transfered to $username.");
				$this->session->set_flashdata('response', $flash);
				redirect('wallet_transfer');
			}
		}
	}
	$data["send"] = $this->Members->getwallettransferhistory($this->userId["id"]);
	$data["receive"] = $this->Members->getwalletreceivehistory($this->userId["id"]);
				// $data['otp_sent'] = $isSent;
	$this->load->view("layouts/common", ["template"=>"pages/wallet_transfer", "data"=>$data]);
}
public function request_withdraw_automatic(){
	if($this->input->post())
	{	
		$settings = Helpers::settings();
		$user = Helpers::getUserObj($this->userId["id"]);
		if($settings['withdraw_status'] == 0 || ($user['withdraw_status']) == 0){
			$flash = Helpers::flash('danger', 'Something went wrong. Kindly be patient as we sort it out.Try again later');
			$this->session->set_flashdata('response1', $flash);
			return redirect('request_withdraw');
		}
		$getReq = $this->Members->get_withdraw_request($this->userId["id"]);
		if(!empty($getReq)){
			if(($getReq[0]['status']) == 0){
				$flash = Helpers::flash('danger', 'You have already submitted request,  Please wait for admin reply.');
				$this->session->set_flashdata('response1', $flash);
				return redirect('request_withdraw');
			}    
		}
		$amount = $this->input->post("amount");
		$balance = MemberHelper::ewallet();
		$userdetails= Helpers::userdetails($this->userId["id"]);
		if($amount < 1000)
		{		
			$currencyName = $this->currency;
			$amt = MemberHelper::currencyConverter($this->currency , 1000);
			$flash = Helpers::flash('danger', "Minimum withdrawal is $amt $currencyName !");
			$this->session->set_flashdata('response1', $flash);
			return redirect('request_withdraw');
		}
		if($balance >= $amount)
		{
			$this->load->helper('string');
			$id = $this->userId["id"];
			$transRef = "LL$id".random_string('alnum', 6);
			$phone =$userdetails["phone"];
			$username= $userdetails["username"];
			$data1["user_id"] = $this->userId["id"];
			$data1["transactionref"] = $transRef;
			$data1["amount"] = $amount*0.93;
			$data1["before_earning_amount"] = $balance;
			$data1["after_earning_amount"] = $balance-$amount;
			$data1["phone"] = $phone;
			$data1["fee"] = $amount*0.07;
			$data1["created_at"] = date('Y-m-d H:i:s');
			$amountAfterFee = $amount*0.93;
		 
			$phone =$userdetails["phone"];
		
				
				$endpoint = 'https://supabeta.com/api/b2c/paymentrequest';
				$data = array(
					"amount"=>$amountAfterFee,
					"transRef"=>$transRef,
					"transPhone"=>$phone,
					"username"=>$username,
					"channel"=>"RealSimple"
				);
				// print_r($data);
				$data = json_encode($data);
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
				curl_setopt($ch, CURLOPT_URL, $endpoint);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
				$response = curl_exec($ch);
				$response = json_decode($response, true);
				// print_r($response);
				// exit;
				if($response["code"]=="200"){
				    $data1["after_earning_amount"] = $balance - $amount;
				    $this->Members->add_withraw_request($data1);
					$this->Members->substract_ewallet_amount($id, $amount);
					$data2["marked"] = 1;
					$data2["status"] = 1;
					$updateTransaction = $this->Members->updateTransaction($transRef, $data2);
					
				
                  $user =  Helpers::getUserObj($this->userId["id"]);
                  $user["amount"] = $amount;

            $mailView = $this->load->view("emails/withdrawal", array("user"=>$user), true);
            Helpers::sendEmail("Withdrawal", $user["email"], $mailView);
             
             Helpers::saveMail($user['id'] ,"Accepted Withdrawal Automatic");
         
					$flash = Helpers::flash('success', "Request sent successfully");
					$this->session->set_flashdata('response1', $flash);
					return redirect('member/request_withdraw');
				}
				else
				{   
				    $data1["after_earning_amount"] = $balance;
				    $this->Members->add_withraw_request($data1);
					$msg = $response["response"];
					$flash = Helpers::flash('danger', "Something went wrong $msg");
					$this->session->set_flashdata('response1', $flash);
					return redirect('member/request_withdraw');
				}
			
		}	
		else
		{
			$flash = Helpers::flash('danger', "You dont have balance!");
			$this->session->set_flashdata('response1', $flash);
			return redirect('member/request_withdraw');
		}
	}
	$request = $this->Members->get_withdraw_request($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/request_withdraw", "data"=>$request]);
}



public function request_withdraw(){
	if($this->input->post())
	{	
		$settings = Helpers::settings();
		$user = Helpers::getUserObj($this->userId["id"]);
		if($settings['withdraw_status'] == 0 || ($user['withdraw_status']) == 0){
			$flash = Helpers::flash('danger', 'Something went wrong. Kindly be patient as we sort it out.Try again later');
			$this->session->set_flashdata('response1', $flash);
			return redirect('request_withdraw');
		}
		$getReq = $this->Members->get_withdraw_request($this->userId["id"]);
		if(!empty($getReq)){
			if(($getReq[0]['status']) == 0){
				$flash = Helpers::flash('danger', 'You have already submitted request,  Please wait for admin reply.');
				$this->session->set_flashdata('response1', $flash);
				return redirect('request_withdraw');
			}    
		}
		$amount = $this->input->post("amount");
		$balance = MemberHelper::ewallet();
		$userdetails= Helpers::userdetails($this->userId["id"]);
		if($amount < 1000)
		{		
			$currencyName = $this->currency;
			$amt = MemberHelper::currencyConverter($this->currency , 1000);
			$flash = Helpers::flash('danger', "Minimum withdrawal is $amt $currencyName !");
			$this->session->set_flashdata('response1', $flash);
			return redirect('request_withdraw');
		}
		if($balance >= $amount)
		{
			$this->load->helper('string');
			$id = $this->userId["id"];
			$transRef = "LL$id".random_string('alnum', 6);
			$phone =$userdetails["phone"];
			$username= $userdetails["username"];
			$data1["user_id"] = $this->userId["id"];
			$data1["transactionref"] = $transRef;
			$data1["amount"] = $amount*0.93;
			$data1["before_earning_amount"] = $balance;
			$data1["after_earning_amount"] = $balance-$amount;
			$data1["phone"] = $phone;
			$data1["fee"] = $amount*0.07;
			$data1["created_at"] = date('Y-m-d H:i:s');
			$amountAfterFee = $amount*0.93;
			$phone =$userdetails["phone"];

			$res =	$this->Members->add_withraw_request($data1);

			if($res){

				$this->Members->substract_ewallet_amount($id, $amount);
				$flash = Helpers::flash('success', "Request sent successfully");
				$this->session->set_flashdata('response1', $flash);
				return redirect('member/request_withdraw');

			}

		
		}	
		else
		{
			$flash = Helpers::flash('danger', "You dont have balance!");
			$this->session->set_flashdata('response1', $flash);
			return redirect('member/request_withdraw');
		}
	}
	$request = $this->Members->get_withdraw_request($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/request_withdraw", "data"=>$request]);


}
public function request_game_withdraw(){
	if($this->input->post())
	{   
		$amount = $this->input->post("amount");
		$balance = MemberHelper::gamewallet();
		$userdetails= Helpers::userdetails($this->userId["id"]);
		if($amount < 2000)
		{	
			$currencyName = $this->currency;
			$amt = MemberHelper::currencyConverter($this->currency , 2000);

			$flash = Helpers::flash('danger', "Minimum withdrawal is $amt $currencyName !");
			$this->session->set_flashdata('response', $flash);
			return redirect('request_game_withdraw');
		}
		if($balance >= $amount)
		{
			$data["user_id"] = $this->userId["id"];
			$data["amount"] = $amount;
			// $data["fee"] = $amount*0.06;
			$data["created_at"] = date('Y-m-d H:i:s');
			$result = $this->Members->add_withraw_game_request($data);
			if($result)
			{
				$this->Members->substract_game_wallet_amount($this->userId["id"], $amount);
				$user["username"] = $userdetails["username"];
				$user["amount"] = $amount;
				$data["email"] = $userdetails["email"];
			
					$mailView = $this->load->view("emails/game_withdrawal", array("user"=>$user), true);
					Helpers::sendEmail("RealSimple Game Withdrawal", $data["email"], $mailView);
				
					Helpers::saveMail($this->userId["id"] ,"Game Withdrawal");
			
				$flash = Helpers::flash('success', 'Your Game withdrawal request has been sent!Payment will be processed after successful verification on time!');
				$this->session->set_flashdata('response', $flash);
				return redirect('request_game_withdraw');
			}
		}	else{
			$flash = Helpers::flash('danger', 'Sufficient balance is low!');
			$this->session->set_flashdata('response', $flash);
			return redirect('request_game_withdraw');
		}
	}
	$request = $this->Members->get_game_withdraw_request($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/request_game_withdraw", "data"=>$request]);
}
public function request_app_withdraw(){
	if($this->input->post())
	{
		$amount = $this->input->post("amount");
		$balance = MemberHelper::app_earnings();
		$userdetails= Helpers::userdetails($this->userId["id"]);
		if($amount < 2000)
		{
			$currencyName = $this->currency;
			$amt = MemberHelper::currencyConverter($this->currency , 2000);

			$flash = Helpers::flash('danger', "Minimum withdrawal is $amt $currencyName !");
			$this->session->set_flashdata('response', $flash);
			return redirect('request_app_withdraw');
		}
		if($balance >= $amount)
		{
			$data["user_id"] = $this->userId["id"];
			$data["amount"] = $amount;
			// $data["fee"] = $amount*0.06;
			$data["created_at"] = date('Y-m-d H:i:s');
			$result = $this->Members->add_withraw_app_request($data);
			if($result)
			{
				$this->Members->substract_app_amount($this->userId["id"], $amount);
				$user["username"] = $userdetails["username"];
				$user["amount"] = $amount;
				$data["email"] = $userdetails["email"];
				$mailView = $this->load->view("emails/app_withdrawal", array("user"=>$user), true);
			
					Helpers::sendEmail("RealSimple App Withdrawal", $data["email"], $mailView);
				
					Helpers::saveMail($this->userId['id'] ,"App Withdrawal");
				
				$flash = Helpers::flash('success', 'Your App withdrawal request has been sent!Payment will be processed after successful verification on time!');
				$this->session->set_flashdata('response', $flash);
				return redirect('request_app_withdraw');
			}
		}else{
			$flash = Helpers::flash('danger', 'Sufficient balance is low!');
			$this->session->set_flashdata('response', $flash);
			return redirect('request_app_withdraw');
		}	
	}
	$request = $this->Members->get_app_withdraw_request($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/request_app_withdraw", "data"=>$request]);
}
public function request_spining_withdraw(){
	if($this->input->post())
	{
		$amount = $this->input->post("amount");
		$balance = MemberHelper::spining_earnings();
		$userdetails= Helpers::userdetails($this->userId["id"]);
		if($amount < 2000)
		{
			$currencyName = $this->currency;
			$amt = MemberHelper::currencyConverter($this->currency , 2000);

			$flash = Helpers::flash('danger', "Minimum withdrawal is $amt $currencyName !");
			$this->session->set_flashdata('response', $flash);
			return redirect('request_spining_withdraw');
		}
		if($balance >= $amount)
		{
			$data["user_id"] = $this->userId["id"];
			$data["amount"] = $amount;
			// $data["fee"] = $amount*0.06;
			$data["created_at"] = date('Y-m-d H:i:s');
			$result = $this->Members->add_withraw_spining_request($data);
			if($result)
			{
				$this->Members->substract_spining_amount($this->userId["id"], $amount);
				$user["username"] = $userdetails["username"];
				$user["amount"] = $amount;
				$data["email"] = $userdetails["email"];
				$mailView = $this->load->view("emails/spining_withdrawal", array("user"=>$user), true);
			
					Helpers::sendEmail("RealSimple Spining Withdrawal", $data["email"], $mailView);
				
					Helpers::saveMail($this->userId["id"] ,"Spining Withdrawal");
				
				$flash = Helpers::flash('success', 'Your Spining withdrawal request has been sent!Payment will be processed after successful verification on time!');
				$this->session->set_flashdata('response', $flash);
				return redirect('request_spining_withdraw');
			}
		}else{
			$flash = Helpers::flash('danger', 'Sufficient balance is low!');
			$this->session->set_flashdata('response', $flash);
			return redirect('request_spining_withdraw');
		}
	}
	$request = $this->Members->get_spining_withdraw_request($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/request_spining_withdraw", "data"=>$request]);
}
public function request_whatsapp_withdraw(){
	if($this->input->post())
	{
		$settings = Helpers::settings();
		if($settings['whatsapp_withdraw_status'] == 0){
			$flash = Helpers::flash('danger', 'Something went wrong. Kindly be patient as we sort it out.Try again later');
			$this->session->set_flashdata('response', $flash);
			return redirect('request_whatsapp_withdraw');
		}
		$amount = $this->input->post("amount");
		$balance = MemberHelper::whatsapp_earnings();
		$userdetails= Helpers::userdetails($this->userId["id"]);
		$getRefActiveUser = $this->getRefActiveUser();
// 		if($getRefActiveUser < 20)
// 		{
// 			$flash = Helpers::flash('danger', 'Your active users are less than 20');
// 			$this->session->set_flashdata('response', $flash);
// 			return redirect('request_whatsapp_withdraw');
// 		}
		if($amount < 5000)
		{
			$currencyName = $this->currency;
			$amt = MemberHelper::currencyConverter($this->currency , 5000);

			$flash = Helpers::flash('danger', "Minimum withdrawal is $amt $currencyName !");
			$this->session->set_flashdata('response', $flash);
			return redirect('request_whatsapp_withdraw');
		}
		if($balance >= $amount)
		{
			$data["user_id"] = $this->userId["id"];
			$data["amount"] = $amount;
			// $data["fee"] = $amount*0.06;
			$data["created_at"] = date('Y-m-d H:i:s');
			$result = $this->Members->add_withraw_whatsapp_request($data);
			if($result)
			{
				$this->Members->substract_whatsapp_amount($this->userId["id"], $amount);
				$user["username"] = $userdetails["username"];
				$user["amount"] = $amount;
				$data["email"] = $userdetails["email"];
			$user = Helpers::getUserObj($this->userId["id"]);
				// 	$mailView = $this->load->view("emails/whatsapp_withdrawal", array("user"=>$user,"amount"=>$amount), true);
				// 	Helpers::sendEmail("RealSimple WhatsApp Withdrawal", $data["email"], $mailView);
					
				// 	Helpers::saveMail($this->userId["id"] ,"WhatsApp Withdrawal");
				
				$flash = Helpers::flash('success', 'Your WhatsApp withdrawal request has been sent!Payment will be processed after successful verification on time!');
				$this->session->set_flashdata('response', $flash);
				return redirect('request_whatsapp_withdraw');
			}
		}else{
			$flash = Helpers::flash('danger', 'Sufficient balance is low!');
			$this->session->set_flashdata('response', $flash);
			return redirect('request_whatsapp_withdraw');
		}	
	}
	$request = $this->Members->get_whatsapp_withdraw_request($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/request_whatsapp_withdraw", "data"=>$request]);
}
public function request_withdraw_old(){
	if($this->input->post())
	{
		$amount = $this->input->post("amount");
		$balance = MemberHelper::ewallet();
		$userdetails= Helpers::userdetails($this->userId["id"]);
		if($amount < 1000)
		{
			$flash = Helpers::flash('danger', 'Minimum withdrawal is 1000!');
			$this->session->set_flashdata('response', $flash);
			return redirect('request_withdraw');
		}
		if($amount > $balance)
		{
			$flash = Helpers::flash('danger', 'Sufficient balance is low!');
			$this->session->set_flashdata('response', $flash);
			return redirect('request_withdraw');
		}
		if($balance >= $amount)
		{
			$data["user_id"] = $this->userId["id"];
			$data["amount"] = $amount*0.93;
			$data["fee"] = $amount*0.07;
			$data["created_at"] = date('Y-m-d H:i:s');
			$data["before_earning_amount"] = $balance ? $balance : 0;
			$data["after_earning_amount"] =  $balance ? $balance-$amount : 0;
			$result = $this->Members->add_withraw_request($data);
			if($result)
			{
				$this->Members->substract_ewallet_amount($this->userId["id"], $amount);
				$user["username"] = $userdetails["username"];
				$user["amount"] = $amount;
				$data["email"] = $userdetails["email"];
				// $mailView = $this->load->view("emails/withdrawal", array("user"=>$user), true);
				// Helpers::sendEmail("RealSimple Withdrawal", $data["email"], $mailView);
				//  sleep(7);
			 // Helpers::saveMail($this->userId['id'] ,"Withdrawal");
				$flash = Helpers::flash('success', 'Your withdrawal request has been sent!Payment will be processed after successful verification on time!');
				$this->session->set_flashdata('response', $flash);
				return redirect('request_withdraw');
			}
		}	
	}
	$request = $this->Members->get_withdraw_request($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/request_withdraw", "data"=>$request]);
}
public function whatsapp(){
	if($this->input->post()) {
		$pack =MemberHelper::gethighestpack(); 
		if(!$pack){
			$flash = Helpers::flash('danger', 'Activate your account to start earning immediately!');
			$this->session->set_flashdata('response', $flash);
			return redirect('member/whatsapp');
		}
		$data1 = $this->Members->gettimelast($this->userId["id"]);
		if($data1){
			if($data1[0]['date']){
				$flash = Helpers::flash('danger', 'You can make 1 request per day!');
				$this->session->set_flashdata('response', $flash);
				return redirect('member/whatsapp');
			}
		}
		$fileName = '';
		if(!empty($_FILES['fileupload']['name'])) {
			$uploadPath = 'uploads/files/whatsapp/'.$this->userId["id"];
			if(!is_dir($uploadPath)){
				mkdir($uploadPath, 0777);
			}
			$config['upload_path'] = $uploadPath;
			$config['allowed_types'] = 'jpg|png';
                        // Load and initialize upload library
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
                        // Upload file to server
			if($this->upload->do_upload('fileupload')){
                            // Uploaded file data
				$fileData = $this->upload->data();
				$fileName = $fileData['file_name'];
			}
		}
		$pack = MemberHelper::gethighestpack($this->userId["id"]);
		$data['phone'] = $this->input->post('phone');
		$data['views'] = $this->input->post('views');
		$data['screenshot'] = $fileName;
		$data['user_id'] = $this->userId["id"];
		$data['package_id'] = $pack ? $pack['name']: "Not Active";
		$this->load->model('Members');
		$res = $this->Members->whatsapp_request($data);
		if($res) {
			$flash = Helpers::flash('success', 'Submit Successfully');
			$this->session->set_flashdata('response', $flash);
			return redirect('member/whatsapp');
		}
		else {
			$flash = Helpers::flash('danger', 'Something went wrong');
			$this->session->set_flashdata('response', $flash);
			return redirect('member/whatsapp');
		}
	}
	$this->load->model('Members');
	$data = $this->Members->getwhatsappscreenshot($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/whatsapp","data"=>$data]);
}
public function reedem_points(){
	if($this->input->post()){
		$pointsWallet = MemberHelper::pointsWallet();
		$points = $this->input->post('points');
		if($points < 1000){
			$flash = Helpers::flash('danger', "Minimum Convert 1000 Points!");
			$this->session->set_flashdata('response', $flash);
			redirect('reedem_points');
		}	
		if($pointsWallet < $points){
			$flash = Helpers::flash('danger', "Your Points is $pointsWallet");
			$this->session->set_flashdata('response', $flash);
			redirect('reedem_points');
		}
		$earnings = $points/2;
		$this->Members->substract_points_wallet($this->userId['id'],$points);
		$data['user_id'] = $this->userId['id'];
		$data['amount'] = $earnings;
		$this->Members->add_earning_amount($this->userId['id'],$data);
		$trans['user_id'] = $this->userId['id'];
		$trans['points'] = $points;
		$trans['points'] = $points;
		$trans['earn_amount'] = $earnings;
		$trans['created_at'] = date("Y-m-d H:i:s");
		$res = $this->Members->add_convert_points_history($trans);
		if($res){
		    
		    $user = Helpers::getUserObj($this->userId['id']);
			
						$mailView = $this->load->view("emails/reedem_points", array("user"=>$user,"points"=>$points,"earn"=>$earnings), true);
						Helpers::sendEmail("Reedem Points", $user["email"], $mailView);
						Helpers::saveMail($this->userId['id'] ,"Reedem Points");
				
			$currencyName = $this->currency;
			$flash = Helpers::flash('success', "Points Converted to $currencyName Successfully");
			$this->session->set_flashdata('response', $flash);
			redirect('reedem_points');
		}
	}
	$data = $this->Members->getHistoryConvertPoints($this->userId['id']);
	$this->load->view("layouts/common", ["template"=>"pages/reedem_points","data"=>$data]);
}
public function mini_statements(){
	$data = $this->Members->gettransactions($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/mini_statements", "data"=>$data]);
}
public function Support()
{
	$this->load->helper('text');
	$getAllSupport = $this->Members->get_user_support_message($this->userId["id"]);
	$this->load->view("layouts/common", ["template" => "pages/support", "data" => $getAllSupport]);
}
public function create_support()
{
	if ($this->input->post()) {
		$data = array();
		$emailTitle = 'Your message has been sent to the admin';
		$emailAdminTitle = 'New message from a user';
		$emailMsg = 'Your message has been sent to the user, you will get a revert very soon. Your ticket number is: ';
		if (!$this->input->post('subject') || !$this->input->post('message')) {
			$flash = Helpers::flash('danger', 'Subject and Message should not be empty');
			$this->session->set_flashdata('response', $flash);
			return redirect('member/create_support');
		}
		$data["user_id"] = $this->userId["id"];
		$data["subject"] = $this->input->post('subject');
		$message = $this->input->post('message');
		$data["message"] = $message;
		$token = Helpers::generateUniqueRefId(10) . '_' . $this->userId["id"];
		$data["ticket_no"] = $token;
		$data["created_at"] = Helpers::date();
		$res = $this->Members->add_support_ticket($data);
		if ($res) {
			$user = Helpers::user_id($this->userId["id"]);
			$emailMsg = $emailMsg . '' . $token;
		
				Helpers::sendEmail($emailTitle, $user["email"], $emailMsg);
			
				Helpers::saveMail($this->userId['id'] ,"Create Support");
		
			$admin = Helpers::getAdmin(true);
		
				Helpers::sendEmail($emailAdminTitle, $admin["email"], $message);
				Helpers::saveMail($admin['id'] ,"Admin Create Support");
			
			$flash = Helpers::flash('success', 'Message sent to admin');
		} else {
			$flash = Helpers::flash('danger', 'Something went wrong');
		}
		$this->session->set_flashdata('response', $flash);
	}
	$this->load->view("layouts/common", ["template" => "pages/send_message"]);
}
public function create_post(){
	if($this->input->post())
	{
		$this->form_validation->set_rules('type', 'Type', 'required');
		$this->form_validation->set_rules('title','Title','required');
		$this->form_validation->set_rules('post','Post','required');
		if($this->form_validation->run()== False)
		{
		}
		$fileName = '';
		// if($_FILES['image_url']['name']) {
		// 	$uploadPath = 'uploads/files/posts/'.$this->userId["id"];
		// 	if(!is_dir($uploadPath)){
		// 		mkdir($uploadPath, 0777);
		// 	}
		// 	$config['upload_path'] = $uploadPath;
		// 	$config['allowed_types'] = 'jpg|jpeg|png|gif';
		// 	$config['file_name'] = $_FILES['image_url']['name']; 
  //               // Load and initialize upload library
		// 	$this->load->library('upload', $config);
		// 	$this->upload->initialize($config);
  //               // Upload file to server
		// 	if($this->upload->do_upload('image_url')){
  //                   // Uploaded file data
		// 		$fileData = $this->upload->data();
		// 		$fileName = $_FILES['image_url']['name'];
		// 	}
		// }
		$data["user_id"] = $this->userId["id"];
		$data['type'] = $this->input->post("type");
		$data['title'] = $this->input->post("title");
		$data['content'] = $this->input->post("content");
		$data['image'] = $fileName? $fileName:"Null";
		$data["date"] = date('Y-m-d H:i:s');
		$result = $this->Members->insertpost($data);
		if($result)
		{
			$flash = Helpers::flash('success', 'You have successfully blogged,wait for the approval from the admin');
			$this->session->set_flashdata('response', $flash);
			redirect("create_post");
		}
		else
		{
			$flash = Helpers::flash('danger', 'Something went wrong!');
			$this->session->set_flashdata('response', $flash);
			redirect("create_post");
		}
	}
	$this->load->view("layouts/common", ["template"=>"pages/create_post"]);
}
public function manage_blogs(){
	$result = $this->Members->getarticles($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/manage_blogs", "data"=>$result]);
}
public function blog_statements(){
	$this->load->view("layouts/common", ["template"=>"pages/blog_statements"]);
}
public function loan(){
	if($this->input->post())
	{
		$this->form_validation->set_rules('time', 'Duration', 'required');
		$this->form_validation->set_rules('amount','Amount','required');
		if($this->form_validation->run()== False)
		{
		}
		else
		{
			$data= array();
			$user=$this->username;
			$userid=$this->userId["id"];
			$data["user_id"]=$userid;
			$data["username"]=$user["username"];
			$amount = $this->input->post("amount");
			if($amount < 500 || $amount >100000)
			{
				$currencyName = $this->currency;
				$amt = MemberHelper::currencyConverter($this->currency , 500);
				$amt2 = MemberHelper::currencyConverter($this->currency , 100000);
				$flash = Helpers::flash('danger', "Amount must be greater than $amt $currencyName and less than $amt2 $currencyName !");
				$this->session->set_flashdata('response', $flash);
				redirect("loan");

			}
			$data["amount"]=$amount;
			$data["duration"]=$this->input->post("time");
			$data["date"]=date('Y-m-d H:i:s');
			$fundid=$this->Members->store_loan($data);
			if($fundid) {
				$amountNeeded = 100;
				$this->Members->substract_wallet_amount($this->userId["id"], $amountNeeded);
				$flash = Helpers::flash('success', 'You have successfully requested for a loan');
				$this->session->set_flashdata('response', $flash);
				redirect("loan");
			}
			else {
				$flash = Helpers::flash('danger', 'Something went wrong!');
				$this->session->set_flashdata('response', $flash);
				redirect("loan");
			}
		}
	}
	$loan  = $this->Members->get_loan($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/loan" , "data" => $loan]);
}
public function packages(){
	if($this->input->post())
	{
		$getPackageId = $this->input->post("package"); 
		$getPackage = $this->Members->getPackageFromId($getPackageId);
		$adminId = Helpers::getAdmin();
		$walletAmount = MemberHelper::user_wallet();
		$parent = $this->Members->getParentByUserId($this->userId["id"]);
		$isAlreadyBought = $this->Members->checkIfUserBoughtSubscription($this->userId["id"], $getPackageId);
		$lastpack = $this->Members->getlastpackid($this->userId["id"]);
// 		if($lastpack){
// 			if($lastpack["package_id"] > $getPackageId)
// 			{
// 				$flash = Helpers::flash('danger', 'You cannot buy lower pack from the existing packs.');
// 				$this->session->set_flashdata('response', $flash);
// 				return redirect('packages');
// 			}
// 		}
// 		if($isAlreadyBought) {
// 			$flash = Helpers::flash('danger', 'You already have this package.');
// 			$this->session->set_flashdata('response', $flash);
// 			return redirect('packages');
// 		}
		$amountNeeded = $getPackage['amount'];
		if($walletAmount>=$amountNeeded){
			$addedMembership = $this->Members->add_membership_to_user_account($this->userId["id"], $getPackage["id"], $getPackage["amount"], $parent["id"]);
			if($addedMembership) {
				$this->Members->substract_wallet_amount($this->userId["id"], $amountNeeded);
				$salescount = $this->Members->get_membersales($parent["id"]);
				$countsales = $salescount?$salescount["sales"]:0;
				$getLastPackParentId = $this->Members->getlastpackid($parent["id"]);
				if($getLastPackParentId["package_id"] == 5){
					$pointsWallet = MemberHelper::pointsWallet($parent["id"]);
					if($getPackage["id"] == 4){
								// echo "star";
						$silverPoints['user_id'] = $parent["id"];
						$silverPoints['amount'] = 200;
						$this->Members->add_points_wallet($silverPoints['user_id'],$silverPoints);
						$points["user_id"] =  $this->userId["id"];
						$points["to_id"] = $parent["id"];
						$points["sponsor_id"] = $parent["id"];					
						$points["amount"] = $silverPoints['amount'];
						$points["before_earning_amount"] = $pointsWallet ? $pointsWallet : 0;
						$points["after_earning_amount"] = $pointsWallet ? $pointsWallet+$silverPoints['amount'] : $silverPoints['amount'];
						$points["package_id"] = $getPackage["id"];
						$points["type"] = "Star Pack Bought";
						$points["date"] = date('Y-m-d H:i:s');  
						$this->Members->add_points_transaction($points);
						$user= Helpers::userdetails($points["to_id"]);
					
						$mailView = $this->load->view("emails/earned_points", array("user"=>$user,"points"=>$silverPoints['amount']), true);
						Helpers::sendEmail("Earned Points", $user["email"], $mailView);
						Helpers::saveMail($this->userId['id'] ,"Earned Points");
					
					}
					if($getPackage["id"] == 5){
								// echo "premium";
						$goldPoints['user_id'] = $parent["id"];
						$goldPoints['amount'] = 400;
						$this->Members->add_points_wallet($goldPoints['user_id'],$goldPoints);
						$points["user_id"] =  $this->userId["id"];
						$points["to_id"] = $parent["id"];
						$points["sponsor_id"] = $parent["id"];					
						$points["amount"] = $goldPoints['amount'];
						$points["before_earning_amount"] = $pointsWallet ? $pointsWallet : 0;
						$points["after_earning_amount"] = $pointsWallet ? $pointsWallet+$goldPoints['amount'] : $goldPoints['amount'];
						$points["package_id"] = $getPackage["id"];
						$points["type"] = "Premium Pack Bought";
						$points["date"] = date('Y-m-d H:i:s');  
						$this->Members->add_points_transaction($points);
						$user= Helpers::userdetails($points["to_id"]);
					
						$mailView = $this->load->view("emails/earned_points", array("user"=>$user,"points"=>$goldPoints['amount']), true);
						Helpers::sendEmail("Earned Points", $user["email"], $mailView);
						Helpers::saveMail($this->userId['id'] ,"Earned Points");
					
					}
				}
				if($countsales < 2)
				{
					$level1income["amount"] = $getPackage["level1_amount"];
				}
				else
				{
					$level1income["amount"] = $getPackage["normal_amount"];
				}
				$level1income["user_id"] = $parent["id"];
				$level1check = $this->Members->getlastpackid($parent["id"]);
				if($level1check["package_id"])
				{	
					$eWalletAmount = MemberHelper::ewallet($parent["id"]);
					$this->Members->add_earning_amount($parent["id"], $level1income);	
					$transaction["user_id"] =  $this->userId["id"];
					$transaction["to_id"] = $parent["id"];
					$transaction["sponsor_id"] = $parent["id"];					
					$transaction["amount"] = $level1income["amount"];
					$transaction["before_earning_amount"] = $eWalletAmount ? $eWalletAmount : 0;
					$transaction["after_earning_amount"] = $eWalletAmount ? $eWalletAmount+$level1income["amount"] : $level1income["amount"];
					$transaction["package_id"] = $getPackage["id"];
					$transaction["type"] = "Direct Income";
					$transaction["date"] = date('Y-m-d H:i:s');  
					$this->Members->add_transaction($transaction);
					$level1email= Helpers::userdetails($parent["id"]);
					$userdetails= Helpers::userdetails($this->userId["id"]);
					$user["parent"] = $level1email["username"];
					$user["amount"] = $transaction["amount"];
					$user["from"] = $userdetails["username"];
					$user["package"] = $getPackage["name"];
					$data["email"] = $level1email["email"];
					
						$mailView = $this->load->view("emails/referral", array("user"=>$user,"level1"=>$level1email), true);
						Helpers::sendEmail("Referral Bonus", $data["email"], $mailView);
						Helpers::saveMail($level1email['id'] ,"Refferal Bonus");
					
					$salescount = $this->Members->get_membersales($parent["id"]);
				}
				if($countsales < 2)
				{
					$level2 = $this->Members->getParentByUserId($parent["id"]);
					if($level2)
					{
						$level2income["amount"] = $getPackage["level2_amount"];
						$level2income["user_id"] = $level2["id"];
						$level2check = $this->Members->getlastpackid($level2["id"]);
						if($level2check["package_id"])
						{
							$eWalletAmount = MemberHelper::ewallet($level2["id"]);
							$this->Members->add_earning_amount($level2["id"], $level2income);
							$level2email= Helpers::userdetails($level2["id"]);
							$userdetails= Helpers::userdetails($this->userId["id"]);
							$user["parent"] = $level2email["username"];
							$user["amount"] = $level2income["amount"];
							$transaction["before_earning_amount"] = $eWalletAmount ? $eWalletAmount : 0;
							$transaction["after_earning_amount"] = $eWalletAmount ? $eWalletAmount+$level2income["amount"] : $level2income["amount"];
							$user["from"] = $userdetails["username"];
							$user["package"] = $getPackage["name"];
							
								$mailView = $this->load->view("emails/indirect", array("user"=>$user,"level2"=>$level2email), true);
								Helpers::sendEmail("Indirect Referral Bonus", $level2email["email"], $mailView);
								Helpers::saveMail($level2email['id'] ,"Indirect Bonus");
							
							$transaction["type"] = "Indirect Income";
							$transaction["amount"] = $getPackage["level2_amount"];
							$transaction["to_id"] = $level2["id"];
							$this->Members->add_transaction($transaction);
						}
					}
				}	
				$sales["user_id"] = $parent["id"];
				$sales["sales"] = 1;						
				$countsales = $this->Members->countmembersales($parent["id"], $sales);
				$packname = $getPackage["name"];
				if($countsales)
				{	
					$userdetailmailview = Helpers::getUserObj($this->userId["id"]);
				
						$mailView = $this->load->view("emails/boughtpackage", array("user"=>$userdetailmailview ,"packname"=>$packname), true);
						Helpers::sendEmail("You Have bought Package Successfully", $userdetailmailview["email"], $mailView);
					
						Helpers::saveMail($userdetailmailview['id'] ,"Bought Package");
					
					$flash = Helpers::flash('success', "You have successfully bought $packname package.");
					$this->session->set_flashdata('response', $flash);
					return redirect('packages');
				}
			}
		}
		else
		{
			$flash = Helpers::flash('danger', 'You dont have sufficient funds to buy this package.');
			$this->session->set_flashdata('response', $flash);
			return redirect('packages');
		}
	}
	$packages = $this->Members->allpackages($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/packages", "data" => $packages]);
}
public function all_packages(){
	$users = $this->Members->direct_list($this->userId["id"]); 
	$this->load->view("layouts/common", ["template"=>"pages/all_packages" , "data"=> $users]);
}
public function basic_packages(){
	$users = $this->Members->getbasicpackusers($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/basic_packages", "data"=>$users]);
}
public function silver_packages(){
	$users = $this->Members->getsilverpackusers($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/silver_packages", "data"=>$users]);
}
public function gold_packages(){
	$users = $this->Members->getstarpackusers($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/gold_packages", "data"=>$users]);
}
public function executive_packages(){
	$users = $this->Members->getpremiumpackusers($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/executive_packages", "data"=>$users]);
}
public function vip_packages(){
	$users = $this->Members->getvippackusers($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/vip_packages", "data"=>$users]);
}
public function profile()
{
	$user=$this->username;
	if($this->input->post())
	{
		$data["first_name"]=$this->input->post("first_name");
		$data["phone"]= $this->input->post("phone");
		$res=$this->Members->updateprofile($user["id"], $data);
		if($res) {
			$flash = Helpers::flash('success', 'Profile updated successfully');
		}
		else {
			$flash = Helpers::flash('danger', 'Something went wrong!');
		}
		$this->session->set_flashdata('response', $flash);
	}
	$data = Helpers::getUserObj($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/edit_profile", "data"=>$data]);
}
public function spining_wheel_simple_old(){
	$user =	helpers::getUserObj($this->userId["id"]);
	if($this->input->get('click')){
		$countrow =  $this->Members->get_spining_wheel_rows();
		if(($countrow) <5){
			$check =  $this->Members->checkuser_spining_wheel($this->userId["id"]);
			if($check){
				$digits = array("500","1000","1500","2000","2500","3000");
				$random =  $digits[array_rand($digits)];
				$flash = Helpers::flash('success', "Congratulations !!! You Won $random");
				$this->session->set_flashdata('response', $flash);
				redirect('spining_wheel');
			}
			else{
				$data['user_id'] = $this->userId["id"];	
				$data['username'] = $user['username'];
				$res = $this->Members->add_spining_wheel($data);
				if($res){
					$amount = 100;
					$data['user_id'] = $this->userId["id"];	
					$data['username'] = $user['username'];
					$data['amount'] = $amount;
					$query = $this->Members->add_spining_wheel_rewards($data);
					if($query){
				// echo 'done';
						$flash = Helpers::flash('success', "Congratulations !!! You Won $amount");
						$this->session->set_flashdata('response', $flash);
						redirect('spining_wheel');
					} else{
						$flash = Helpers::flash('danger', 'Something went wrong!');
						$this->session->set_flashdata('response', $flash);
						redirect('spining_wheel');
					}
				} else{
					redirect('spining_wheel');
				}
			}
		}else{	
			$check =  $this->Members->checkuser_spining_wheel($this->userId["id"]);
			if($check){
				$digits = array("100","500","1500","2500","3000","3500","4000","4500");
				$random =  $digits[array_rand($digits)];
				$flash = Helpers::flash('success', "Congratulations !!! You Won $random");
				$this->session->set_flashdata('response', $flash);
				redirect('spining_wheel');
			}
			$data['user_id'] = $this->userId["id"];	
			$data['username'] = $user['username'];
			$res = $this->Members->add_spining_wheel($data);
			if($res){
				$this->load->helper('string');
				$digits = array("500","1000","1500","2000","2500","3000");
				$random =  $digits[array_rand($digits)];
				$flash = Helpers::flash('success', "Congratulations !!! You Won $random");
				$this->session->set_flashdata('response', $flash);
				redirect('spining_wheel');
			} else{
				$flash = Helpers::flash('danger', 'Something went wrong!');
				$this->session->set_flashdata('response', $flash);
				redirect('spining_wheel');
			}
		}
	}
	$this->load->view("layouts/common", ["template"=>"pages/spining_wheel"]);
}
public function upload_app_ss_first(){
	$this->load->view("layouts/common", ["template"=>"pages/upload_app_ss_first"]);
}
public function upload_app_ss(){
	if($this->input->post()){
		$fileName = '';
		if (!empty($_FILES['download_ss']['name'])) {
			$uploadPath = 'uploads/files/download_ss/' . $this->userId["id"];
			if (!is_dir($uploadPath)) {
				mkdir($uploadPath, 0777);
			}
			$config['upload_path'] = $uploadPath;
			$config['allowed_types'] = 'jpg|png|jpeg';
				// Load and initialize upload library
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
				// Upload file to server
			if ($this->upload->do_upload('download_ss')) {
					// Uploaded file data
				$fileData = $this->upload->data();
				$download_ss = $fileData['file_name'];
			}
		}
		if (!empty($_FILES['review_ss']['name'])) {
			$uploadPath = 'uploads/files/review_ss/' . $this->userId["id"];
			if (!is_dir($uploadPath)) {
				mkdir($uploadPath, 0777);
			}
			$config['upload_path'] = $uploadPath;
			$config['allowed_types'] = 'jpg|png|jpeg';
				// Load and initialize upload library
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
				// Upload file to server
			if ($this->upload->do_upload('review_ss')) {
					// Uploaded file data
				$fileData = $this->upload->data();
				$review_ss = $fileData['file_name'];
			}
		}
		if (!empty($_FILES['rating_ss']['name'])) {
			$uploadPath = 'uploads/files/rating_ss/' . $this->userId["id"];
			if (!is_dir($uploadPath)) {
				mkdir($uploadPath, 0777);
			}
			$config['upload_path'] = $uploadPath;
			$config['allowed_types'] = 'jpg|png|jpeg';
				// Load and initialize upload library
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
				// Upload file to server
			if ($this->upload->do_upload('rating_ss')) {
					// Uploaded file data
				$fileData = $this->upload->data();
				$rating_ss = $fileData['file_name'];
			}
		}
		$data = array();
		$data['mpesa_number'] = $this->input->post('mpesa_number');
		$data['user_id'] = $this->userId["id"];
		$data['download_ss'] =  $download_ss;
		$data['review_ss'] =  $review_ss;
		$data['rating_ss'] =  $rating_ss;
		$res = $this->Members->request_app_ss($data);
		if($res){
			$flash = Helpers::flash('success', 'Congratulations You Have Successful Earned Kshs 100 For App Reviewing!');
			$this->session->set_flashdata('response', $flash);
			redirect('upload_app_ss');
		}else{
			$flash = Helpers::flash('danger', 'Something Went Wrong !');
			$this->session->set_flashdata('response', $flash);
			redirect('upload_app_ss');
		}
	}
	$this->load->view("layouts/common", ["template"=>"pages/upload_app_ss"]);
}
public function game_start(){
	$walletAmount = MemberHelper::user_wallet($this->userId["id"]);
	$EwalletAmount = MemberHelper::ewallet($this->userId["id"]); 
	$gamewalletAmount = MemberHelper::gamewallet($this->userId["id"]); 
	if($this->input->post()){
		$wallet_type = $this->input->post('wallet_type');
		$amount = $this->input->post('amount');
		if($amount < 500)
		{	
			$currencyName = $this->currency;
			$amt = MemberHelper::currencyConverter($this->currency , 500);

			$flash = Helpers::flash('danger', "Minimum  amount is $amt $currencyName");
			$this->session->set_flashdata('response', $flash);
			redirect("game_start");
		}
		if(($wallet_type) == "topup"){
			if(($walletAmount) >= $amount){
				$data = array();
				$data['wallet_type'] = $wallet_type;
				$data['amount'] = $amount;
				$this->session->set_userdata('session_data',$data);
				redirect('game');
			}else{
				$flash = Helpers::flash('danger', 'Sorry You Dont Have Amount In Your Wallet To Play Game');
				$this->session->set_flashdata('response', $flash);
				redirect('game_start');
			}
		}
		if(($wallet_type) == "ewallet"){
			if(($EwalletAmount) >= $amount){
				$data = array();
				$data['wallet_type'] = $wallet_type;
				$data['amount'] = $amount;
				$this->session->set_userdata('session_data',$data);
				redirect('game');
			}else{
				$flash = Helpers::flash('danger', 'Sorry You Dont Have Amount In Your Wallet To Play Game');
				$this->session->set_flashdata('response', $flash);
				redirect('game_start');
			}
		}
		if(($wallet_type) == "game_wallet"){
			if(($gamewalletAmount) >= $amount){
				$data = array();
				$data['wallet_type'] = $wallet_type;
				$data['amount'] = $amount;
				$this->session->set_userdata('session_data',$data);
				redirect('game');
			}else{
				$flash = Helpers::flash('danger', 'Sorry You Dont Have Amount In Your Wallet To Play Game');
				$this->session->set_flashdata('response', $flash);
				redirect('game_start');
			}
		}
	}
	$this->load->view("layouts/common", ["template"=>"pages/game_start"]);
}
public function game(){
	if($this->input->post()){
		$wallet_type = $this->input->post('wallet_type');
		$amount = $this->input->post('amount');
		// $game = $this->input->post('game');
		$game_transaction['amount'] =	$amount;
		$game_transaction['user_id'] =	$this->userId["id"];
		if(($wallet_type) == "topup"){
			$sub_balance = $this->Members->substract_wallet_amount($this->userId["id"],$amount);
			if($sub_balance){
				$add_game_transaction = $this->Members->add_game_transaction($game_transaction);
				if($add_game_transaction){
					$reminder = fmod($add_game_transaction['id'], 10);
					if(($reminder) == 0){
						$game_reward['amount'] =	$add_game_transaction['amount']*2;
						$game_reward['user_id'] = $this->userId["id"];
						$this->Members->add_game_rewards($game_reward);
						$this->Members->add_game_wallet($this->userId["id"],$game_reward);
						$showamount = $game_reward['amount'];
						$flash = Helpers::flash('success', "Congratulations You Won $showamount !");
						$this->session->set_flashdata('response', $flash);
						redirect('game_start');
					}else{
						$flash = Helpers::flash('danger', 'Better Luck Next Time');
						$this->session->set_flashdata('response', $flash);
						redirect('game_start');
					}
				}
			}
		}
		if(($wallet_type) == "ewallet"){
			$sub_balance = $this->Members->substract_ewallet_amount($this->userId["id"],$amount);
			if($sub_balance){
				$add_game_transaction = $this->Members->add_game_transaction($game_transaction);
				if($add_game_transaction){
					$reminder = fmod($add_game_transaction['id'], 10);
					if(($reminder) == 0){
						$game_reward['amount'] =	$add_game_transaction['amount']*2;
						$game_reward['user_id'] = $this->userId["id"];
						$this->Members->add_game_rewards($game_reward);
						$this->Members->add_game_wallet($this->userId["id"],$game_reward);
						$showamount = $game_reward['amount'];
						$flash = Helpers::flash('success', "Congratulations You Won $showamount !");
						$this->session->set_flashdata('response', $flash);
						redirect('game_start');
					}else{
						$flash = Helpers::flash('danger', 'Better Luck Next Time');
						$this->session->set_flashdata('response', $flash);
						redirect('game_start');
					}
				}
			}
		}
		if(($wallet_type) == "game_wallet"){
			$sub_balance = $this->Members->substract_game_wallet_amount($this->userId["id"],$amount);
			if($sub_balance){
				$add_game_transaction = $this->Members->add_game_transaction($game_transaction);
				if($add_game_transaction){
					$reminder = fmod($add_game_transaction['id'], 10);
					if(($reminder) == 0){
						$game_reward['amount'] =	$add_game_transaction['amount']*2;
						$game_reward['user_id'] = $this->userId["id"];
						$this->Members->add_game_rewards($game_reward);
						$this->Members->add_game_wallet($this->userId["id"],$game_reward);
						$showamount = $game_reward['amount'];
						$flash = Helpers::flash('success', "Congratulations You Won $showamount !");
						$this->session->set_flashdata('response', $flash);
						redirect('game_start');
					}else{
						$flash = Helpers::flash('danger', 'Better Luck Next Time');
						$this->session->set_flashdata('response', $flash);
						redirect('game_start');
					}
				}
			}
		}
	}
	$this->load->view("layouts/common", ["template"=>"pages/game"]);
}
public function spining_wheel(){
	$pack =MemberHelper::gethighestpack(); 
	if($pack){
		$walletAmount = MemberHelper::user_wallet($this->userId["id"]);
		$EwalletAmount = MemberHelper::ewallet($this->userId["id"]); 
		$gamewalletAmount = MemberHelper::gamewallet($this->userId["id"]); 
		if($this->input->post()){
			$wallet_type = $this->input->post('wallet_type');
			$amount = $this->input->post('amount');
			if($amount < 100)
			{	
				$currencyName = $this->currency;
				$amt = MemberHelper::currencyConverter($this->currency , 100);

				$flash = Helpers::flash('danger', "Minimum  amount is $amt $currencyName !");
				$this->session->set_flashdata('response', $flash);
				redirect("spining_wheel");
			}
			if(($wallet_type) == "topup"){
				if(($walletAmount) >= $amount){
					$data = array();
					$data['wallet_type'] = $wallet_type;
					$data['amount'] = $amount;
					$this->session->set_userdata('session_data',$data);
					redirect('spining_wheel_start');
				}else{
					$flash = Helpers::flash('danger', 'Sorry You Dont Have Amount In Your Wallet To Play Game');
					$this->session->set_flashdata('response', $flash);
					redirect('spining_wheel');
				}
			}
			if(($wallet_type) == "ewallet"){
				if(($EwalletAmount) >= $amount){
					$data = array();
					$data['wallet_type'] = $wallet_type;
					$data['amount'] = $amount;
					$this->session->set_userdata('session_data',$data);
					redirect('spining_wheel_start');
				}else{
					$flash = Helpers::flash('danger', 'Sorry You Dont Have Amount In Your Wallet To Play Game');
					$this->session->set_flashdata('response', $flash);
					redirect('spining_wheel');
				}
			}
			if(($wallet_type) == "game_wallet"){
				if(($gamewalletAmount) >= $amount){
					$data = array();
					$data['wallet_type'] = $wallet_type;
					$data['amount'] = $amount;
					$this->session->set_userdata('session_data',$data);
					redirect('spining_wheel_start');
				}else{
					$flash = Helpers::flash('danger', 'Sorry You Dont Have Amount In Your Wallet To Play Game');
					$this->session->set_flashdata('response', $flash);
					redirect('spining_wheel');
				}
			}
		}	
		$data = $this->Members->spining_history($this->userId['id']);
		$this->load->view("layouts/common", ["template"=>"pages/spining_wheel","data"=>$data]);
	}else{
		redirect("free_spining_wheel");
	}
}
public function spining_wheel_start(){
	if($this->input->post()){
		$wallet_type = $this->input->post('wallet_type');
		$amount = $this->input->post('amount');
		// $game = $this->input->post('game');
		$game_transaction['amount'] =	$amount;
		$game_transaction['user_id'] =	$this->userId["id"];
		if(($wallet_type) == "topup"){
			$sub_balance = $this->Members->substract_wallet_amount($this->userId["id"],$amount);
			if($sub_balance){
				$add_spining_wheel = $this->Members->add_spining_wheel($game_transaction);
				if($add_spining_wheel){
					$game_reward['amount_charged'] = $add_spining_wheel['amount'];
					$game_reward['amount'] =	$add_spining_wheel['amount']*0.25;
					$game_reward['user_id'] = $this->userId["id"];
					$this->Members->add_spining_wheel_rewards($game_reward);
					$spining_earning['amount'] =	$add_spining_wheel['amount']*0.25;
					$spining_earning['user_id'] = $this->userId["id"];
					$this->Members->add_spining_earning($this->userId["id"],$spining_earning);
					$showamount = $game_reward['amount'];
					$flash = Helpers::flash('success', "Congratulations You Won $showamount !");
					$this->session->set_flashdata('response', $flash);
					redirect('spining_wheel');
				}else{
					$flash = Helpers::flash('danger', 'Better Luck Next Time');
					$this->session->set_flashdata('response', $flash);
					redirect('spining_wheel');
				}
			}
		}
		if(($wallet_type) == "ewallet"){
			$sub_balance = $this->Members->substract_ewallet_amount($this->userId["id"],$amount);
			if($sub_balance){
				$add_spining_wheel = $this->Members->add_spining_wheel($game_transaction);
				if($add_spining_wheel){
					$game_reward['amount_charged'] = $add_spining_wheel['amount'];
					$game_reward['amount'] =	$add_spining_wheel['amount']*0.25;
					$game_reward['user_id'] = $this->userId["id"];
					$this->Members->add_spining_wheel_rewards($game_reward);
					$spining_earning['amount'] =	$add_spining_wheel['amount']*0.25;
					$spining_earning['user_id'] = $this->userId["id"];
					$this->Members->add_spining_earning($this->userId["id"],$spining_earning);
					$showamount = $game_reward['amount'];
					$flash = Helpers::flash('success', "Congratulations You Won $showamount !");
					$this->session->set_flashdata('response', $flash);
					redirect('spining_wheel');
				}else{
					$flash = Helpers::flash('danger', 'Better Luck Next Time');
					$this->session->set_flashdata('response', $flash);
					redirect('spining_wheel');
				}
			}
		}
		if(($wallet_type) == "game_wallet"){
			$sub_balance = $this->Members->substract_game_wallet_amount($this->userId["id"],$amount);
			if($sub_balance){
				$add_spining_wheel = $this->Members->add_spining_wheel($game_transaction);
				if($add_spining_wheel){
					$game_reward['amount_charged'] = $add_spining_wheel['amount'];
					$game_reward['amount'] =	$add_spining_wheel['amount']*0.25;
					$game_reward['user_id'] = $this->userId["id"];
					$this->Members->add_spining_wheel_rewards($game_reward);
					$spining_earning['amount'] =	$add_spining_wheel['amount']*0.25;
					$spining_earning['user_id'] = $this->userId["id"];
					$this->Members->add_spining_earning($this->userId["id"],$spining_earning);
					$showamount = $game_reward['amount'];
					$flash = Helpers::flash('success', "Congratulations You Won $showamount !");
					$this->session->set_flashdata('response', $flash);
					redirect('spining_wheel');
				}else{
					$flash = Helpers::flash('danger', 'Better Luck Next Time');
					$this->session->set_flashdata('response', $flash);
					redirect('spining_wheel');
				}
			}
		}
	}
	$this->load->view("layouts/common", ["template"=>"pages/spining_wheel_start"]);
}
public function free_spining_wheel(){
	if($this->input->post()){
		$digits = array("500","1000","1500","2000","2500","3000");
		$random =  $digits[array_rand($digits)];
		$flash = Helpers::flash('success', "Congratulations !!! You Won $random");
		$this->session->set_flashdata('response', $flash);
		redirect('free_spining_wheel');
	}
	$this->load->view("layouts/common", ["template"=>"pages/free_spining_wheel"]);
}
public function paypal_deposit(){
	if($this->input->post()){
		$amount=$this->input->post("amount");
                 //Set variables for paypal form
        $returnURL = base_url().'paypal/success'; //payment success url
        $cancelURL = base_url().'paypal/cancel'; //payment cancel url
        $notifyURL = base_url().'paypal/ipn'; //ipn url
        $userID = $this->userId["id"] ? $this->userId["id"] : 1;
        $this->paypal_lib->add_field('return', $returnURL);
        $this->paypal_lib->add_field('cancel_return', $cancelURL);
        $this->paypal_lib->add_field('notify_url', $notifyURL);
        $this->paypal_lib->add_field('custom', $userID); 
        $this->paypal_lib->add_field('amount',  $amount);     
        $this->paypal_lib->paypal_auto_form();
    }
    $data = "";
    $this->load->view("layouts/common", ["template"=>"pages/deposit_paypal", "data"=>$data]);
}
function bank_log(){
	$data = $this->Members->getBankLogs();
	$this->load->view("layouts/common", ["template"=>"pages/bank_log","data"=>$data]);
}
function usa_paypal(){
	$data = $this->Members->getUSAPaypal();
	$this->load->view("layouts/common", ["template"=>"pages/usa_paypal","data"=>$data]);
}
function master_card(){
	$data = $this->Members->getMasterCard();
	$this->load->view("layouts/common", ["template"=>"pages/master_card","data"=>$data]);
}
function visa(){
	$data = $this->Members->getVisa();
	$this->load->view("layouts/common", ["template"=>"pages/visa","data"=>$data]);
}
public function add_funds(){
	$this->load->view("layouts/common", ["template"=>"pages/add_funds"]);
}

public function forex_package(){
	$data = "";
	$this->load->view("layouts/common", ["template"=>"pages/forex_package", "data"=>$data]);
}
public function buy_forex_package(){
	if($this->input->post()){
		$package = $this->input->post("package");
		// echo $package;
		if($package){
			$pack = $this->Members->getforexPackage();
			$walletAmount = MemberHelper::user_wallet();
			$parent = $this->Members->getParentByUserId($this->userId["id"]);
			$isAlreadyBought = MemberHelper::checkForexPackBought($this->userId["id"]);
		// print_r($pack);
		// print_r($walletAmount);
// 		print_r($parent);
// 		exit;
// 			if($isAlreadyBought){
// 				$flash = Helpers::flash('danger', "You already have this package.");
// 				$this->session->set_flashdata('response', $flash);
// 				redirect('forex_package');
// 			}
			if($walletAmount < $pack['amount']){
				$flash = Helpers::flash('danger', "Sufficient balance is low !");
				$this->session->set_flashdata('response', $flash);
				redirect('forex_package');
			}
			$data = array();
			$data['user_id'] = $this->userId['id'];
			$data['sponser_id'] = $parent['id'];
			$data['package_id'] = $pack['id'];
			$data['purchase_date'] = date("Y-m-d H:i:s");
			$res = $this->Members->add_forex_membership($data);
			if($res){
			    
			    $sponsorAmount = $pack['amount'] * 0.7;
			    $earning = array("user_id"=>$parent['id'],"amount"=> $sponsorAmount,"created_at"=>date("Y-m-d H:i:s"));
				$sub = $this->Members->add_earning_amount($parent['id'], $earning);
				$sub = $this->Members->substract_wallet_amount($this->userId["id"], $pack['amount']);
				if($sub){	
					$userdetailmailview = Helpers::getUserObj($this->userId["id"]);
					// if($this->lastHourMails < $this->requiredMails){
					// 	$mailView = $this->load->view("emails/boughtpackage", array("user"=>$userdetailmailview ,"packname"=>"Forex"), true);
					// 	Helpers::sendEmail("You Have bought Package Successfully", $userdetailmailview["email"], $mailView);
					// 	sleep(7);
					// 	Helpers::saveMail($userdetailmailview['id'] ,"Bought Package");
					// }
					$flash = Helpers::flash('success', "You have Successfully bought Forex package.!");
					$this->session->set_flashdata('response', $flash);
					redirect('forex_package');
				}
			}
		}
	}
}

public function e_learning(){

	$pack = MemberHelper::checkForexPackBought($this->userId["id"]);
	if($pack){
		$this->load->view("layouts/common", ["template"=>"pages/e_learning"]);
	}
}

public function become_an_ad_agent(){
	if($this->input->post())
	{
		$getPackageId = $this->input->post("package"); 
		$getPackage = $this->Members->getAgentPackageFromId($getPackageId);
		$adminId = Helpers::getAdmin();
		$walletAmount = MemberHelper::user_wallet();
		$parent = $this->Members->getParentByUserId($this->userId["id"]);
		$isAlreadyBought = $this->Members->checkIfUserBoughtAgentSubscription($this->userId["id"], $getPackageId);
		
// 		if($isAlreadyBought) {
// 			$flash = Helpers::flash('danger', 'You already have this package.');
// 			$this->session->set_flashdata('response', $flash);
// 			return redirect('become_an_ad_agent');
// 		}
		$amountNeeded = $getPackage['amount'];
		if($walletAmount>=$amountNeeded){
			$addedMembership = $this->Members->add_membership_to_user_account_agent_pack($this->userId["id"], $getPackage["id"], $getPackage["amount"], $parent["id"]);
			if($addedMembership) {
				$this->Members->substract_wallet_amount($this->userId["id"], $amountNeeded);
				$salescount = $this->Members->get_membersales_agent_pack($parent["id"]);
				$countsales = $salescount?$salescount["sales"]:0;
				
				
			}
			if($countsales < 2)
			{
				$level1income["amount"] = $getPackage["level1_amount"];
			}
			else
			{
				$level1income["amount"] = $getPackage["normal_amount"];
			}
			$level1income["user_id"] = $parent["id"];
			$level1check = $this->Members->getlastpackid_agentPack($parent["id"]);
			$level1checkNormalPack = $this->Members->getlastpackid($parent["id"]);
			if($level1check || $level1checkNormalPack["package_id"])
			{	
				$eWalletAmount = MemberHelper::ewallet($parent["id"]);
				$this->Members->add_earning_amount($parent["id"], $level1income);	
				$transaction["user_id"] =  $this->userId["id"];
				$transaction["to_id"] = $parent["id"];
				$transaction["sponsor_id"] = $parent["id"];					
				$transaction["amount"] = $level1income["amount"];
				$transaction["before_earning_amount"] = $eWalletAmount ? $eWalletAmount : 0;
				$transaction["after_earning_amount"] = $eWalletAmount ? $eWalletAmount+$level1income["amount"] : $level1income["amount"];
				$transaction["package_id"] = $getPackage["id"];
				$transaction["type"] = "Direct Income";
				$transaction["date"] = date('Y-m-d H:i:s');  
				$this->Members->add_transaction_agent_pack($transaction);

				$level1email= Helpers::userdetails($parent["id"]);
				$userdetails= Helpers::userdetails($this->userId["id"]);
				$user["parent"] = $level1email["username"];
				$user["amount"] = $transaction["amount"];
				$user["from"] = $userdetails["username"];
				$user["package"] = $getPackage["name"];
				$data["email"] = $level1email["email"];
				
						$mailView = $this->load->view("emails/referral", array("user"=>$user,"level1"=>$level1email), true);
						Helpers::sendEmail("Referral Bonus", $data["email"], $mailView);
						Helpers::saveMail($level1email['id'] ,"Refferal Bonus");
					
				$salescount = $this->Members->get_membersales_agent_pack($parent["id"]);
			}
// 			if($countsales < 2)
// 			{
// 				$level2 = $this->Members->getParentByUserId($parent["id"]);
// 				if($level2)
// 				{
// 					$level2income["amount"] = $getPackage["level2_amount"];
// 					$level2income["user_id"] = $level2["id"];
// 					$level2check = $this->Members->getlastpackid_agentPack($level2["id"]);
// 					$level2checkNormalPack = $this->Members->getlastpackid($level2["id"]);
// 					if($level2check || $level2checkNormalPack)
// 					{
// 						$eWalletAmount = MemberHelper::ewallet($level2["id"]);
// 						$this->Members->add_earning_amount($level2["id"], $level2income);
// 						$level2email= Helpers::userdetails($level2["id"]);
// 						$userdetails= Helpers::userdetails($this->userId["id"]);
// 						$user["parent"] = $level2email["username"];
// 						$user["amount"] = $level2income["amount"];
// 						$transaction["before_earning_amount"] = $eWalletAmount ? $eWalletAmount : 0;
// 						$transaction["after_earning_amount"] = $eWalletAmount ? $eWalletAmount+$level2income["amount"] : $level2income["amount"];
// 						$user["from"] = $userdetails["username"];
// 						$user["package"] = $getPackage["name"];
// 							if($this->lastHourMails < 60){
// 								$mailView = $this->load->view("emails/indirect", array("user"=>$user,"level2"=>$level2email), true);
// 								Helpers::sendEmail("Indirect Referral Bonus", $level2email["email"], $mailView);
// 								Helpers::saveMail($level2email['id'] ,"Indirect Bonus");
// 							}
// 						$transaction["type"] = "Indirect Income";
// 						$transaction["amount"] = $getPackage["level2_amount"];
// 						$transaction["to_id"] = $level2["id"];
// 						$this->Members->add_transaction_agent_pack($transaction);
// 					}
// 				}
// 			}	
			$sales["user_id"] = $parent["id"];
			$sales["sales"] = 1;						
			$countsales = $this->Members->countmembersales_agentpack($parent["id"], $sales);
			$packname = $getPackage["name"];
			if($countsales)
			{	
				$userdetailmailview = Helpers::getUserObj($this->userId["id"]);
				
						$mailView = $this->load->view("emails/boughtpackage", array("user"=>$userdetailmailview ,"packname"=>$packname), true);
						Helpers::sendEmail("You Have bought Package Successfully", $userdetailmailview["email"], $mailView);
					
						Helpers::saveMail($userdetailmailview['id'] ,"Bought Package");
					
				$flash = Helpers::flash('success', "You have successfully bought $packname package.");
				$this->session->set_flashdata('response', $flash);
				return redirect('become_an_ad_agent');
			}
		}

		else
		{
			$flash = Helpers::flash('danger', 'You dont have sufficient funds to buy this package.');
			$this->session->set_flashdata('response', $flash);
			return redirect('become_an_ad_agent');
		}
	}
	$data = $this->Members->agent_history($this->userId['id']);

	$this->load->view("layouts/common", ["template"=>"pages/become_an_ad_agent","data"=>$data]);
}
public function agent_verification()
{	
	if($this->input->post()){
        
            $getRej = $this->Members->get_agent_verification_request_rejected($this->username["id"]);
          $reqcheck = $getRej ? count($getRej): 0;
        if($reqcheck >= 2){
            		 $flash = Helpers::flash('danger', 'you cannot send request because you have already sent 2 requests which have been rejected by admin');
		 $this->session->set_flashdata('response', $flash);
		 redirect("agent_verification");
        }
        
        $getReq = $this->Members->get_agent_verification_request_pending($this->username["id"]);
        if($getReq){
            		 $flash = Helpers::flash('danger', 'Please Wait for admin response.');
		 $this->session->set_flashdata('response', $flash);
		 redirect("agent_verification");
        }

		$fileName = '';
		if(!empty($_FILES['fileupload']['name'])) {

			$uploadPath = 'uploads/files/av/'.$this->username["id"];
			if(!is_dir($uploadPath)){
				mkdir($uploadPath, 0777);
			}
			$config['upload_path'] = $uploadPath;
			$config['allowed_types'] = 'jpg|jpeg|png';
			$this->load->library('upload', $config);
			$this->upload->initialize($config);
					// Upload file to server
			if($this->upload->do_upload('fileupload')){
						// Uploaded file data
				$fileData = $this->upload->data();
				$fileName = $fileData['file_name'];
			}
		}
		$data['document'] = $fileName;
    	$data['user_id'] = $this->username["id"];
		$data['address'] = $this->input->post('address');
		$res = $this->Members->agent_verification_add($data);

		if($res){

			$flash = Helpers::flash('success', 'Request Submitted Successfully');
			$this->session->set_flashdata('response', $flash);
			redirect("agent_verification");

		}else{

		 $flash = Helpers::flash('danger', 'Something went wrong');
		 $this->session->set_flashdata('response', $flash);
		 redirect("agent_verification");

	 }


 }

 $request = $this->Members->get_agent_verification_request($this->username["id"]);
 $isAlreadyBought = $this->Members->alreadyVerficationPack($this->userId["id"]);
 $this->load->view("layouts/common", ["template"=>"pages/agent_verification","data"=>$request,"check_pack"=>$isAlreadyBought]);
}

public function welcome_verify_contract(){
	$this->load->view("layouts/common", ["template"=>"pages/welcome_verify_contract"]);

}


public function paypal_verification()
{	
	if($this->input->post()){
        
    	$data['user_id'] = $this->username["id"];
		$data['paypal_email'] =$this->input->post('paypal_email');
		$data['amount'] = $this->input->post('amount');
		$data['date'] = date("Y-m-d H:i:s");
		$res = $this->Members->paypal_verification_add($data);

		if($res){

// 			$flash = Helpers::flash('success', 'Request Submitted Successfully');
// 			$this->session->set_flashdata('response', $flash);
		redirect("https://www.paypal.com/");

		}else{

		 $flash = Helpers::flash('danger', 'Something went wrong');
		 $this->session->set_flashdata('response', $flash);
		 redirect("paypal_verification");

	 }


 }
 $request = $this->Members->get_paypal_verification_request($this->username["id"]);
 $this->load->view("layouts/common", ["template"=>"pages/paypal_verification","data"=>$request]);
}


public function request_paypal_withdraw(){
	if($this->input->post())
	{   
		$amount = $this->input->post("amount");
		$balance = MemberHelper::paypalWallet();
		$userdetails= Helpers::userdetails($this->userId["id"]);
		// if($amount < 50)
		// {	
		// 	$currencyName = $this->currency;
		// 	$amt = MemberHelper::currencyConverter($this->currency , 50);

		// 	$flash = Helpers::flash('danger', "Minimum withdrawal is $amt $currencyName !");
		// 	$this->session->set_flashdata('response', $flash);
		// 	return redirect('request_paypal_withdraw');
		// }
			$getRefActiveUser = $this->getRefActiveUser();
		if($getRefActiveUser < 20)
		{
			$flash = Helpers::flash('danger', 'Your active users are less than 20');
			$this->session->set_flashdata('response', $flash);
			return redirect('request_paypal_withdraw');
		}
		if($balance >= $amount)
		{
			$data["user_id"] = $this->userId["id"];
			$data["amount"] = $amount;
			// $data["fee"] = $amount*0.06;
			$data["created_at"] = date('Y-m-d H:i:s');
			$result = $this->Members->add_withraw_paypal_request($data);
			if($result)
			{
				$this->Members->substract_paypal_wallet($this->userId["id"], $amount);
				// $user["username"] = $userdetails["username"];
				// $user["amount"] = $amount;
				// $data["email"] = $userdetails["email"];
				// if($this->lastHourMails < 60){
				// 	$mailView = $this->load->view("emails/game_withdrawal", array("user"=>$user), true);
				// 	Helpers::sendEmail("RealSimple Game Withdrawal", $data["email"], $mailView);
				// 	sleep(7);
				// 	Helpers::saveMail($this->userId["id"] ,"Game Withdrawal");
				// }
				$flash = Helpers::flash('success', 'Your Paypal withdrawal request has been sent!Payment will be processed after successful verification on time!');
				$this->session->set_flashdata('response', $flash);
				return redirect('request_paypal_withdraw');
			}
		}	else{
			$flash = Helpers::flash('danger', 'Sufficient balance is low!');
			$this->session->set_flashdata('response', $flash);
			return redirect('request_paypal_withdraw');
		}
	}
	$request = $this->Members->get_paypal_withdraw_request($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/request_paypal_withdraw", "data"=>$request]);
}
public function request_bonus_withdraw(){
	if($this->input->post())
	{   
		$amount = $this->input->post("amount");
		$balance = 5000;
	    	$getRefActiveUser = $this->getRefActiveUser();
		if($getRefActiveUser < 20)
		{
			$flash = Helpers::flash('danger', 'Your active users are less than 20');
			$this->session->set_flashdata('response', $flash);
			return redirect('request_bonus_withdraw');
		}
		if($balance >= $amount)
		{
			
				$flash = Helpers::flash('success', 'Your Bonus withdrawal request has been sent!Payment will be processed after successful verification on time!');
				$this->session->set_flashdata('response', $flash);
				return redirect('request_bonus_withdraw');
			}
			else{
			$flash = Helpers::flash('danger', 'Sufficient balance is low!');
			$this->session->set_flashdata('response', $flash);
			return redirect('request_bonus_withdraw');
		}
	}
	
	$this->load->view("layouts/common", ["template"=>"pages/request_bonus_withdraw"]);
}


public function locked(){
	$this->load->view("layouts/common", ["template"=>"pages/locked"]);
}

public function buy_unlock_package(){

	if($this->input->post()){
		// echo "post";
		// exit;
		$packId = $this->input->post('package');
		$parent = $this->Members->getParentByUserId($this->userId["id"]);
		$topup = MemberHelper::user_wallet();

		$amount = 5500;
		$isAlreadyBought = $this->Members->alreadyUnlockPack($this->userId["id"]);
		if(!empty($isAlreadyBought)){
				$flash = Helpers::flash('danger', 'You have already this package');
			$this->session->set_flashdata('response', $flash);
			return redirect('locked');
		}
		if($amount > $topup){
			$flash = Helpers::flash('danger', 'Sufficient balance is low!');
			$this->session->set_flashdata('response', $flash);
			return redirect('locked');
		}

		$data['user_id'] = $this->userId["id"];
		$data['sponsor_id'] = $parent['id'];
		$data['package_id'] = $packId;
		$data['amount'] = $amount;
		$data['purchase_date'] = date("Y-m-d H:i:s");

		$res = $this->Members->add_unlock_package($data);
		if($res){
			$this->Members->substract_wallet_amount($this->userId["id"], $amount);

			$wallet['user_id'] = $parent['id'];
			$wallet['amount'] = 4000;
			$wallet['created_at'] = date("Y-m-d H:i:s");
            
	    	$this->Members->add_earning_amount($parent['id'],$wallet);
		
		
	       	$userObj = Helpers::getUserObj($this->userId["id"]);
			$mailView = $this->load->view("emails/unlock_referal", array("parent"=>$parent,"user"=>$userObj), true);
			Helpers::sendEmail("RealSimple Unlock Package", $parent["email"], $mailView);
			Helpers::saveMail($parent['id'] ,"Unlock Package Refferal Bonus");

			$flash = Helpers::flash('success', 'Congratulations ! You Have bought Package Successfully');
			$this->session->set_flashdata('response', $flash);
			return redirect('locked');


		}else{

			$flash = Helpers::flash('danger', 'Something went wrong!');
			$this->session->set_flashdata('response', $flash);
			return redirect('locked');

		}





	}

}


public function unlock_package_history(){
	$data = $this->Members->unlock_sales_history($this->userId['id']);
	$this->load->view("layouts/common", ["template"=>"pages/unlock_package_history","data"=>$data]);
}


public function verification_package(){
	$this->load->view("layouts/common", ["template"=>"pages/verification_package"]);
}


public function buy_verification_package(){

	if($this->input->post()){
		// echo "post";
		// exit;
		$packId = $this->input->post('package');
		$parent = $this->Members->getParentByUserId($this->userId["id"]);
		$topup = MemberHelper::user_wallet();

		$amount = 6500;
		$isAlreadyBought = $this->Members->alreadyVerficationPack($this->userId["id"]);
// 		if(!empty($isAlreadyBought)){
// 				$flash = Helpers::flash('danger', 'You have already this package');
// 			$this->session->set_flashdata('response', $flash);
// 			return redirect('verification_package');
// 		}
		if($amount > $topup){
			$flash = Helpers::flash('danger', 'Sufficient balance is low!');
			$this->session->set_flashdata('response', $flash);
			return redirect('verification_package');
		}

		$data['user_id'] = $this->userId["id"];
		$data['sponsor_id'] = $parent['id'];
		$data['package_id'] = $packId;
		$data['amount'] = $amount;
		$data['purchase_date'] = date("Y-m-d H:i:s");

		$res = $this->Members->add_verfication_package($data);
		if($res){
			$this->Members->substract_wallet_amount($this->userId["id"], $amount);

			$wallet['user_id'] = $parent['id'];
			$wallet['amount'] = 5000;
			$wallet['created_at'] = date("Y-m-d H:i:s");
            
	    	$this->Members->add_earning_amount($parent['id'],$wallet);
		
		
	       	$userObj = Helpers::getUserObj($this->userId["id"]);
			$mailView = $this->load->view("emails/verificion_package_user", array("parent"=>$parent,"user"=>$userObj), true);
			Helpers::sendEmail("RealSimple Verification Package", $userObj["email"], $mailView);
			Helpers::saveMail($userObj['id'] ,"Verification Package User");
        
             $userObj = Helpers::getUserObj($parent['id']);
             $parentUpline = $this->Members->getParentByUserId($parent['id']);
        	$sponsorMailView = $this->load->view("emails/verification_package_sponsor", array("parent"=>$parentUpline,"user"=>$userObj), true);
			Helpers::sendEmail("RealSimple Verification Package", $userObj["email"], $sponsorMailView);
			Helpers::saveMail($userObj['id'] ,"Verification Package Sponsor");
			
			$flash = Helpers::flash('success', 'Congratulations ! You Have bought Package Successfully');
			$this->session->set_flashdata('response', $flash);
			return redirect('verification_package');


		}else{

			$flash = Helpers::flash('danger', 'Something went wrong!');
			$this->session->set_flashdata('response', $flash);
			return redirect('verification_package');

		}





	}

}

public function verification_package_history(){
	$data = $this->Members->verfication_sales_history($this->userId['id']);
	$this->load->view("layouts/common", ["template"=>"pages/verification_package_history","data"=>$data]);
}



public function paypal_logins(){
	$this->load->view("layouts/common", ["template"=>"pages/paypal_logins"]);
}

public function buy_paypal_logins(){

	if($this->input->post()){
		// echo "post";
		// exit;
		$packId = $this->input->post('package');
		$parent = $this->Members->getParentByUserId($this->userId["id"]);
		$topup = MemberHelper::user_wallet();

		$amount = 10000;
		$directBonus = 7000;
		$isAlreadyBought = $this->Members->alreadyPaypalLoginPack($this->userId["id"]);
		if(!empty($isAlreadyBought)){
				$flash = Helpers::flash('danger', 'You have already this package');
			$this->session->set_flashdata('response', $flash);
			return redirect('paypal_logins');
		}
		if($amount > $topup){
			$flash = Helpers::flash('danger', 'Sufficient balance is low!');
			$this->session->set_flashdata('response', $flash);
			return redirect('paypal_logins');
		}

		$data['user_id'] = $this->userId["id"];
		$data['sponsor_id'] = $parent['id'];
		$data['package_id'] = $packId;
		$data['amount'] = $amount;
		$data['direct_bonus'] = $directBonus;
		$data['purchase_date'] = date("Y-m-d H:i:s");

		$res = $this->Members->add_Paypal_login($data);
		if($res){
			$this->Members->substract_wallet_amount($this->userId["id"], $amount);

			$wallet['user_id'] = $parent['id'];
			$wallet['amount'] = $directBonus;
			$wallet['created_at'] = date("Y-m-d H:i:s");
            
	    	$this->Members->add_earning_amount($parent['id'],$wallet);
		
		
	       	$userObj = Helpers::getUserObj($this->userId["id"]);
			$mailView = $this->load->view("emails/paypal_login_referal", array("parent"=>$parent,"user"=>$userObj), true);
			Helpers::sendEmail("RealSimple Paypal Login", $parent["email"], $mailView);
			Helpers::saveMail($parent['id'] ,"Paypal Login Refferal Bonus");

			$flash = Helpers::flash('success', 'Congratulations ! You Have bought Package Successfully');
			$this->session->set_flashdata('response', $flash);
			return redirect('paypal_logins');


		}else{

			$flash = Helpers::flash('danger', 'Something went wrong!');
			$this->session->set_flashdata('response', $flash);
			return redirect('paypal_logins');

		}





	}

}


public function paypal_login_history(){
	$data = $this->Members->paypal_login_history($this->userId['id']);
	$this->load->view("layouts/common", ["template"=>"pages/paypal_login_history","data"=>$data]);
}
public function compounding(){
	
	if($this->input->post()){
	$amount =	$this->input->post('amount');
	$days =	$this->input->post('days');
	$ewallet = MemberHelper::ewallet($this->userId['id']);
	if($days < 1){
		$flash = Helpers::flash('danger', "Minimum 1 day");
		$this->session->set_flashdata('response', $flash);
		return redirect('compounding');
	}
	if($amount > $ewallet){
		$flash = Helpers::flash('danger', "Sufficent amount is low");
		$this->session->set_flashdata('response', $flash);
		return redirect('compounding');
	}
	$amt  = MemberHelper::currencyConverter($this->currency, 10);	
	$currencyName  = $this->currency;	
	if($amount < 10){
		$flash = Helpers::flash('danger', "Minimum compound $amt $currencyName");
		$this->session->set_flashdata('response', $flash);
		return redirect('compounding');
	}
	$alreadyCompounding = $this->Members->get_compounding_amount($this->userId['id']);
	if($alreadyCompounding){
		$flash = Helpers::flash('danger', "You have already compounded");
		$this->session->set_flashdata('response', $flash);
		return redirect('compounding');
	}

	$data = array("user_id"=>$this->userId['id'],"amount"=>$amount,"days"=>$days,"created_at"=>date("Y-m-d H:i:s"));
	$this->Members->add_compounding_amount($data);	

	$this->Members->substract_ewallet_amount($this->userId['id'],$amount);

	$flash = Helpers::flash('success', "Amount compounding successfully");
		$this->session->set_flashdata('response', $flash);
		return redirect('compounding');

	}
            $hrs = "Not Invest";
		$today = date("Y-m-d H:i:s");
		$data['compounded'] = $this->Members->get_compounding_amount($this->userId['id']);


		if ($data['compounded']) {
			$lastROI =  $this->Members->get_last_roi_compound($data['compounded']['user_id'], $data['compounded']['id']);
			if ($lastROI) {
				$nextDay = date("Y-m-d H:i:s", strtotime($lastROI['created_at'] . "+1 day"));
				$datetime1 = new DateTime($today);
				$datetime2 = new DateTime($nextDay);

				$difference = $datetime1->diff($datetime2);
				$hours = $difference->h;
				if ($lastROI['day'] >= $data['compounded']['days']) {

					$hrs = "You have completed compounding earned , please wait for next invest after $hours hrs remaining";
				} else {

					$hrs = "$hours hrs remaining";
				}
			} else{
				$datetime1 = new DateTime($today);
				$timestamp = "00:00:00";
				$next = date("Y-m-d H:i:s",strtotime($timestamp));
				
				$datetime2 = new DateTime($next);

				$difference = $datetime1->diff($datetime2);
				$hours = $difference->h;
				$hrs = "$hours hrs remaining";
			}
		}
	$data['rois_list'] = $this->Members->get_all_roi_compound($this->userId['id']);
		$data['commission_list'] = $this->Members->get_all_commission_roi($this->userId['id']);
	$data['rois_amount'] = $data['rois_list'] ? array_sum(array_column($data['rois_list'],"amount")) : 0;
	$this->load->view("layouts/common", ["template"=>"pages/compounding","data"=>$data,"hrs"=>$hrs]);
}


public function compound_withdraw(){
	if($this->input->post())
	{   
		$amount = $this->input->post("amount");
		$balance = MemberHelper::compound_earning();
		$userdetails= Helpers::userdetails($this->userId["id"]);
		$alreadyCompounding = $this->Members->get_compounding_amount($this->userId['id']);
			if ($alreadyCompounding) {

				$flash = Helpers::flash('danger', "You can't withdraw because you have invested the amount");
				$this->session->set_flashdata('response', $flash);
				return redirect('compound_withdraw');
			}
		if($amount < 1)
		{	
			// $currencyName = $this->currency;
			// $amt = MemberHelper::currencyConverter($this->currency , 2000);

			$flash = Helpers::flash('danger', "Minimum withdrawal is 1 !");
			$this->session->set_flashdata('response', $flash);
			return redirect('compound_withdraw');
		}
		if($balance >= $amount)
		{
			$data["user_id"] = $this->userId["id"];
			$data["amount"] = $amount;
			// $data["fee"] = $amount*0.06;
			$data["created_at"] = date('Y-m-d H:i:s');
			$result = $this->Members->add_compound_withdraw($data);
			if($result)
			{
				$this->Members->substract_compounding_earning($this->userId["id"], $amount);
				$user["username"] = $userdetails["username"];
				$user["amount"] = $amount;
				$data["email"] = $userdetails["email"];
			
					// $mailView = $this->load->view("emails/game_withdrawal", array("user"=>$user), true);
					// Helpers::sendEmail("RealSimple Game Withdrawal", $data["email"], $mailView);
				
					// Helpers::saveMail($this->userId["id"] ,"Game Withdrawal");
			
				$flash = Helpers::flash('success', 'Your Compound withdrawal request has been sent!Payment will be processed after successful verification on time!');
				$this->session->set_flashdata('response', $flash);
				return redirect('compound_withdraw');
			}
		}	else{
			$flash = Helpers::flash('danger', 'Sufficient balance is low!');
			$this->session->set_flashdata('response', $flash);
			return redirect('compound_withdraw');
		}
	}
	$request = $this->Members->get_compound_withdraw_requests($this->userId["id"]);
	$this->load->view("layouts/common", ["template"=>"pages/compound_withdraw", "data"=>$request]);
}



	public function access_code_package()
	{
		$this->load->view("layouts/common", ["template" => "pages/access_code_package"]);
	}

	public function buy_access_code()
	{

		if ($this->input->post()) {
			// echo "post";
			// exit;
			$packId = $this->input->post('package');
			$parent = $this->Members->getParentByUserId($this->userId["id"]);
			$topup = MemberHelper::user_wallet();

			$amount = 10000;
			$directBonus = 7000;
			$isAlreadyBought = $this->Members->alreadyaccess_codePack($this->userId["id"]);
			if (!empty($isAlreadyBought)) {
				$flash = Helpers::flash('danger', 'You have already this package');
				$this->session->set_flashdata('response', $flash);
				return redirect('access_code_package');
			}
			if ($amount > $topup) {
				$flash = Helpers::flash('danger', 'Sufficient balance is low!');
				$this->session->set_flashdata('response', $flash);
				return redirect('access_code_package');
			}

			$data['user_id'] = $this->userId["id"];
			$data['sponsor_id'] = $parent['id'];
			$data['package_id'] = $packId;
			$data['amount'] = $amount;
			$data['direct_bonus'] = $directBonus;
			$data['purchase_date'] = date("Y-m-d H:i:s");

			$res = $this->Members->add_access_code($data);
			if ($res) {
				$this->Members->substract_wallet_amount($this->userId["id"], $amount);

				$wallet['user_id'] = $parent['id'];
				$wallet['amount'] = $directBonus;
				$wallet['created_at'] = date("Y-m-d H:i:s");

				$this->Members->add_earning_amount($parent['id'], $wallet);


				// $userObj = Helpers::getUserObj($this->userId["id"]);
				// $mailView = $this->load->view("emails/paypal_login_referal", array("parent"=>$parent,"user"=>$userObj), true);
				// Helpers::sendEmail("RealSimple Paypal Login", $parent["email"], $mailView);
				// Helpers::saveMail($parent['id'] ,"Paypal Login Refferal Bonus");

				$flash = Helpers::flash('success', 'Congratulations ! You Have bought Package Successfully');
				$this->session->set_flashdata('response', $flash);
				return redirect('access_code_package');
			} else {

				$flash = Helpers::flash('danger', 'Something went wrong!');
				$this->session->set_flashdata('response', $flash);
				return redirect('access_code_package');
			}
		}
	}

	public function access_code_history()
	{
		$data = $this->Members->access_code_history($this->userId['id']);
		$this->load->view("layouts/common", ["template" => "pages/access_code_history", "data" => $data]);
	}
	
	public function welcome_bonus()
	{
		$this->load->view("layouts/common", ["template" => "pages/welcome_bonus"]);
	}
	public function unlock_welcome_bonus()
	{	
		if ($this->input->post()) {
			// echo "post";
			// exit;
			$packId = $this->input->post('package');
			$parent = $this->Members->getParentByUserId($this->userId["id"]);
			$topup = MemberHelper::user_wallet();

			$amount = 1000;
			
			if ($amount > $topup) {
				$flash = Helpers::flash('danger', 'Sufficient balance is low!');
				$this->session->set_flashdata('response', $flash);
				return redirect('unlock_welcome_bonus');
			}

			$data['user_id'] = $this->userId["id"];
			$data['sponsor_id'] = $parent['id'];
			$data['package_id'] = $packId;
			$data['amount'] = $amount;
			$data['purchase_date'] = date("Y-m-d H:i:s");

			$res = $this->Members->add_unlock_welcome_bonus_sale($data);
			if ($res) {
				$this->Members->substract_wallet_amount($this->userId["id"], $amount);

				$wallet['user_id'] = $parent['id'];
				$wallet['amount'] = 500;
				$wallet['created_at'] = date("Y-m-d H:i:s");

				$this->Members->add_earning_amount($parent['id'], $wallet);


				// $userObj = Helpers::getUserObj($this->userId["id"]);
				// $mailView = $this->load->view("emails/unlock_referal", array("parent" => $parent, "user" => $userObj), true);
				// Helpers::sendEmail("RealSimple Unlock Package", $parent["email"], $mailView);
				// Helpers::saveMail($parent['id'], "Unlock Package Refferal Bonus");

				$flash = Helpers::flash('success', 'Congratulations ! You have claimed the welcome bonus successfully');
				$this->session->set_flashdata('response', $flash);
				return redirect('unlock_welcome_bonus');
			} else {

				$flash = Helpers::flash('danger', 'Something went wrong!');
				$this->session->set_flashdata('response', $flash);
				return redirect('unlock_welcome_bonus');
			}
		}
		$this->load->view("layouts/common", ["template" => "pages/unlock_welcome_bonus"]);
	}
	public function cashback_bonus()
	{
		$this->load->view("layouts/common", ["template" => "pages/cashback_bonus"]);
	}
	public function unlock_cashback_bonus()
	{	
		if ($this->input->post()) {
			// echo "post";
			// exit;
			$packId = $this->input->post('package');
			$parent = $this->Members->getParentByUserId($this->userId["id"]);
			$topup = MemberHelper::user_wallet();

			if($packId == 1){
				$amount = 1000;
			}elseif($packId == 2){
				$amount = 2000;
			}

			$parentAmount = $amount/2;
			
			if ($amount > $topup) {
				$flash = Helpers::flash('danger', 'Sufficient balance is low!');
				$this->session->set_flashdata('response', $flash);
				return redirect('cashback_bonus');
			}

			$data['user_id'] = $this->userId["id"];
			$data['sponsor_id'] = $parent['id'];
			$data['package_id'] = $packId;
			$data['amount'] = $amount;
			$data['purchase_date'] = date("Y-m-d H:i:s");

			$res = $this->Members->add_unlock_cashback_bonus_sale($data);
			if ($res) {
				$this->Members->substract_wallet_amount($this->userId["id"], $amount);

				$wallet['user_id'] = $parent['id'];
				$wallet['amount'] = $parentAmount;
				$wallet['created_at'] = date("Y-m-d H:i:s");

				$this->Members->add_earning_amount($parent['id'], $wallet);


				// $userObj = Helpers::getUserObj($this->userId["id"]);
				// $mailView = $this->load->view("emails/unlock_referal", array("parent" => $parent, "user" => $userObj), true);
				// Helpers::sendEmail("RealSimple Unlock Package", $parent["email"], $mailView);
				// Helpers::saveMail($parent['id'], "Unlock Package Refferal Bonus");

				$flash = Helpers::flash('success', 'Congratulations ! You have claimed the cashback bonus successfully');
				$this->session->set_flashdata('response', $flash);
				return redirect('cashback_bonus');
			} else {

				$flash = Helpers::flash('danger', 'Something went wrong!');
				$this->session->set_flashdata('response', $flash);
				return redirect('cashback_bonus');
			}
		}
		$id = $this->input->get('id');
		$this->load->view("layouts/common", ["template" => "pages/unlock_cashback_bonus","id"=>$id]);
	}

function logout()
{
	$this->session->sess_destroy();
	redirect('login');
}


}