<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Aviator extends CI_Controller
{
    function __construct()
    {

        parent::__construct();
        $this->load->model(array('Members', 'Adm'));

        $this->username = $this->session->userdata('game_user');

        $this->load->library(array('paypal_lib', 'cart', 'mpesa'));
        if (!$this->username) {
            redirect('aviator_login');
        }
        date_default_timezone_set('Africa/Nairobi');
    }
    public function home()
    {
        $this->load->view("game/layouts/common", ["template" => "game/pages/index"]);
    }
    public function access_code()
    {
        $this->load->helper('string');
        if ($this->input->post()) {
            $package = $this->input->post('package');
            $phone = $this->input->post('phone');
            $gtUser = Helpers::getGameUser($this->username['id']);

            $this->Members->update_game_users($gtUser['id'], ["phone" => $phone]);



            $pack = $this->Members->get_subscriptions_by_id($package);




            $settings = Helpers::settings();
            $amount = $pack['amount'] * $settings['exchange_rate'];
            // print_r($amount);
            // exit;
            $uname = $this->input->post("name");

            $user = $this->username;
            $username = $this->username['name'];
            // $phone = $this->username['phone'];

            $desc = "Paid by $username";


            $id = $user['id'];
            $data1["user_id"] =  $user['id'];
            $data1["username"] = $user['name'];
            $data1["amount"] = $amount;
            $data1["phone"] = $phone;
            $data1["paid_by"] = $desc;
            $data1["payment_type"] = 1;
            $data1["pack_id"] = $package;
            $data1["created_at"] = date('Y-m-d H:i:s');
            $transRef = "HVDEP$id" . random_string('numeric', 8);
            // 			$transRef2 = "LLDEP$id" . random_string('alnum', 8);
            $data1["mpesa_trans_id"] = $transRef;

            $fundid = $this->Members->store_fund_deposit_game($data1);

            $account = $user['name'];

            $phone_number = str_replace(' ', '', $phone); //remove spaces
            if (strlen($phone) != 12) {
                $phone_number = substr_replace($phone_number, '254', 0, 1); //Replace first zero with 254
            }
            //At this point, $phone_number should be 12 digits long
            if (strlen($phone_number) != 12 || !is_numeric($amount) || $amount < 1) {
                // $this->session->set_flashdata('alert', ['message' => "Phone number or amount is invalid"]);
                $flash = Helpers::flash('danger', 'Phone number or amount is invalid.');
                $this->session->set_flashdata('response', $flash);
                redirect("aviator/access_code");
                // echo json_encode([
                //     'status' => 'error',
                //     'title' => 'Error',
                //     'message' => "Phone number or amount is invalid.",
                //     'callback'  => '',
                // ]);
                // exit;
            }
            $phone = $phone_number;
            $amount = ceil($amount);

            //Request premium
            //TODO: Change callback URL accordingly to point to the Api.php Controller file
            $this->mpesa->callback_url = site_url('cron/callback_url_game/' . $transRef, 'https');
            //$this->mpesa->callback_url = "https://bennito254.com/home/playground/lnmo";

            $amount = ceil($amount);

            try {
                $status = FALSE;
                $checkoutID = FALSE;
                $result = $this->mpesa->lnmo_request($amount, $phone, $account);

                if ($result) {
                    $result = json_decode($result);

                    if ($result && isset($result->ResponseCode) && $result->ResponseCode == 0) {
                        //Sent successfully
                        $status = TRUE;
                        $checkoutID = $result->CheckoutRequestID;
                        $msg = 'Payment request sent successfully to ' . $phone . '. Kindly approve it on your phone';
                        $to_db = [
                            'phone' => $phone,
                            'amount' => $amount,
                            'checkout_id' => $checkoutID,
                            'mpesa_transfer_id' => $transRef,
                            'created_at' => date("Y-m-d H:i:s"),
                        ];


                        $this->Members->add_payment_mpesa_game($to_db);

                        //TODO: Request sent successfully, Redirect back
                        // $this->session->set_flashdata('alert', ['message' => $msg]);
                        $flash = Helpers::flash('success', $msg);
                        $this->session->set_flashdata('response', $flash);
                        redirect("aviator/access_code");
                        // exit;
                        // echo json_encode([
                        //     'status' => 'success',
                        //     'title' => 'Success',
                        //     'message' => $msg,
                        //     'callback'  => "startWaiting(.$checkoutID.)",
                        // ]);
                        // exit;
                    } else {
                        if (isset($result->errorMessage)) {
                            //return $this->response->setJSON(['status' => false, 'message' => $res->errorMessage]);
                            $msg = $result->errorMessage;
                        } else {
                            $msg = 'Something went wrong';
                        }
                    }
                } else {
                    //Failed
                    $msg = 'M-Pesa API error';
                }
            } catch (\Exception $e) {
                $msg = $e->getMessage();
            }

            //TODO: Something went wrong, check $msg, Redirect back
            // $flash = Helpers::flash('success', 'Request submitted successfully.');
            // 	$this->session->set_flashdata('response', $flash);
            // 	redirect("deposit");
            // $this->session->set_flashdata('alert', ['message' => $msg]);
            $flash = Helpers::flash('danger', $msg);
            $this->session->set_flashdata('response', $flash);
            redirect("aviator/access_code");
            // exit;
            // echo json_encode([
            //     'status' => 'error',
            //     'title' => 'Error',
            //     'message' => $msg,
            //     'callback'  => '',
            // ]);
            // exit;
        }

        $data = $this->Members->get_acess_code($this->username['id']);
        $packages = $this->Members->get_all_subscriptions();
        $this->load->view("game/layouts/common", ["template" => "game/pages/access_code", 'data' => $data, "user" => $this->username, "packages" => $packages]);
    }
    public function access_code_history()
    {
        $data = $this->Members->get_acess_code_all($this->username['id']);
        $this->load->view("game/layouts/common", ["template" => "game/pages/access_code_history", 'data' => $data]);
    }
    public function payments()
    {
        $this->load->helper('string');
        if ($this->input->post()) {
            $role = $this->input->post("role");
            $amount = $this->input->post("amount");
            $phone = $this->input->post("phone");
            $uname = $this->input->post("name");

            if ($role) {
                $username = $this->username['name'];


                if ($uname) {
                    $user = $this->Members->getuserbyuname_game($uname);
                    if (!$user) {
                        $flash = Helpers::flash('danger', 'User not found , please enter correct username');
                        $this->session->set_flashdata('response', $flash);
                        redirect("aviator/payments");
                        // echo json_encode([
                        //     'status' => 'error',
                        //     'title' => 'Error',
                        //     'message' => "User not found , please enter correct username",
                        //     'callback'  => '',
                        // ]);
                        // exit;
                    }
                    $phone = $this->input->post("phone");
                } else {
                    $user = $this->username;
                }
                $desc =  "Paid by $username";
            } else {
                $user = $this->username;
                $username = $this->username['name'];

                $desc = "Paid by $username";
            }

            $id = $user['id'];
            $data1["user_id"] =  $user['id'];
            $data1["username"] = $user['name'];
            $data1["amount"] = $amount;
            $data1["phone"] = $phone;
            $data1["paid_by"] = $desc;
            $data1["created_at"] = date('Y-m-d H:i:s');
            $transRef = "HVDEP$id" . random_string('alnum', 8);
            // 			$transRef2 = "LLDEP$id" . random_string('alnum', 8);
            $data1["mpesa_trans_id"] = $transRef;

            $fundid = $this->Members->store_fund_deposit_game($data1);

            $account = $user['name'];

            $phone_number = str_replace(' ', '', $phone); //remove spaces
            if (strlen($phone) != 12) {
                $phone_number = substr_replace($phone_number, '254', 0, 1); //Replace first zero with 254
            }
            //At this point, $phone_number should be 12 digits long
            if (strlen($phone_number) != 12 || !is_numeric($amount) || $amount < 1) {
                // $this->session->set_flashdata('alert', ['message' => "Phone number or amount is invalid"]);
                $flash = Helpers::flash('danger', 'Phone number or amount is invalid.');
                $this->session->set_flashdata('response', $flash);
                redirect("aviator/payments");
                // echo json_encode([
                //     'status' => 'error',
                //     'title' => 'Error',
                //     'message' => "Phone number or amount is invalid.",
                //     'callback'  => '',
                // ]);
                // exit;
            }
            $phone = $phone_number;
            $amount = ceil($amount);

            //Request premium
            //TODO: Change callback URL accordingly to point to the Api.php Controller file
            $this->mpesa->callback_url = site_url('cron/callback_url_game/' . $transRef, 'https');
            //$this->mpesa->callback_url = "https://bennito254.com/home/playground/lnmo";

            $amount = ceil($amount);

            try {
                $status = FALSE;
                $checkoutID = FALSE;
                $result = $this->mpesa->lnmo_request($amount, $phone, $account);

                if ($result) {
                    $result = json_decode($result);

                    if ($result && isset($result->ResponseCode) && $result->ResponseCode == 0) {
                        //Sent successfully
                        $status = TRUE;
                        $checkoutID = $result->CheckoutRequestID;
                        $msg = 'Payment request sent successfully to ' . $phone . '. Kindly approve it on your phone';
                        $to_db = [
                            'phone' => $phone,
                            'amount' => $amount,
                            'checkout_id' => $checkoutID,
                            'mpesa_transfer_id' => $transRef,
                            'created_at' => date("Y-m-d H:i:s"),
                        ];


                        $this->Members->add_payment_mpesa_game($to_db);

                        //TODO: Request sent successfully, Redirect back
                        // $this->session->set_flashdata('alert', ['message' => $msg]);
                        $flash = Helpers::flash('success', $msg);
                        $this->session->set_flashdata('response', $flash);
                        redirect("aviator/payments");
                        // exit;
                        // echo json_encode([
                        //     'status' => 'success',
                        //     'title' => 'Success',
                        //     'message' => $msg,
                        //     'callback'  => "startWaiting(.$checkoutID.)",
                        // ]);
                        // exit;
                    } else {
                        if (isset($result->errorMessage)) {
                            //return $this->response->setJSON(['status' => false, 'message' => $res->errorMessage]);
                            $msg = $result->errorMessage;
                        } else {
                            $msg = 'Something went wrong';
                        }
                    }
                } else {
                    //Failed
                    $msg = 'M-Pesa API error';
                }
            } catch (\Exception $e) {
                $msg = $e->getMessage();
            }

            //TODO: Something went wrong, check $msg, Redirect back
            // $flash = Helpers::flash('success', 'Request submitted successfully.');
            // 	$this->session->set_flashdata('response', $flash);
            // 	redirect("deposit");
            // $this->session->set_flashdata('alert', ['message' => $msg]);
            $flash = Helpers::flash('danger', $msg);
            $this->session->set_flashdata('response', $flash);
            redirect("aviator/payments");
            // exit;
            // echo json_encode([
            //     'status' => 'error',
            //     'title' => 'Error',
            //     'message' => $msg,
            //     'callback'  => '',
            // ]);
            // exit;
        }
        $this->load->view("game/layouts/common", ["template" => "game/pages/deposit", "user" => $this->username]);
    }
    public function predictor()
    {

        if ($this->input->post()) {
            $code = $this->input->post('code');
            $data = $this->Members->get_acess_code_by_code($this->username['id'], $code);
            if (!$data) {
                $flash = Helpers::flash('danger', 'Your code is mismatched !');
                $this->session->set_flashdata('response', $flash);
                redirect("aviator/predictor");
            }

            $now = date("Y-m-d H:i:s");
            $valid_date = $data['created_at'];
            $now = new DateTime();
            $valid_date = new DateTime($data['created_at']);

            $diff = $now->diff($valid_date);
            $hours = $diff->days * 24 + $diff->h;
            if ($hours >=  $data['valid']) {
                $flash = Helpers::flash('danger', 'Your code is expired , please buy new subscription !');
                $this->session->set_flashdata('response', $flash);
                redirect("aviator/predictor");
            }

            redirect("aviator/game");

            // echo "done";
            // exit;
        }
        $this->load->view("game/layouts/common", ["template" => "game/pages/predictor"]);
    }
    public function payment_history()
    {
        $data = $this->Members->get_mpesa_deposit_by_transfer_id_game_all($this->username['id']);
        $this->load->view("game/layouts/common", ["template" => "game/pages/payment_history", "data" => $data]);
    }
    public function logout()
    {
        $this->session->unset_userdata('game_user');
        redirect('aviator_login');
    }

    public function game()
    {

        $amount = MemberHelper::aviator_game_wallet($this->username['id']);
        $earning_amount = MemberHelper::ewallet($this->username['id']);

        $bet = $this->Members->get_all_bets_aviator_game($this->username['id']);
        $round_history = $this->Members->get_all_round_history_game($this->username['id']);

        $prediction_run = $this->Members->prediction_turn($this->username['id']);
        if ($prediction_run < 0) {
            $prediction_run = 0;
        }

        $access_code = $this->Members->get_acess_code($this->username['id']);
        $now = date("Y-m-d H:i:s");
        $valid_date = $access_code['created_at'];
        $now = new DateTime();
        $valid_date = new DateTime($access_code['created_at']);

        $diff = $now->diff($valid_date);
        $hours = $diff->days * 24 + $diff->h;
        if ($hours <  $access_code['valid']) {
            $this->load->view("game/pages/game", ['data' => $bet, 'rounds' => $round_history, 'amount' => $amount, 'earning_amount' => $earning_amount, 'prediction_run' => $prediction_run, 'user' => $this->username]);
        } else {
            redirect('aviator/access_code');
        }
    }

    public function cash_out()
    {
        // $gameId = $_GET['game_id'];
        $id = $this->username['id'];
        $betId = $_GET['bet_id'];



        $bet = $this->Members->get_single_bet_by_id_game($betId);


        $winAmount = $bet['amount'] * $_GET['win_multiplier'];

        $profit = $winAmount - $bet->amount;

        $this->Members->update_bet_by_id_game($bet['id'], [
            "earned" => $winAmount, "amount_x" => $_GET['win_multiplier'], "total_earned" => $bet['wallet_amount'] + $winAmount, "profit" => $profit
        ]);



        $data = [
            "user_id" =>  $id,
            "amount" =>   $winAmount,
            "created_at" => date('Y-m-d H:i:s')
        ];
        $this->Members->add_game_earning_amount($id, $data);

        $data = [
            'isSuccess' => true,
            "data" => [
                "wallet_balance" =>  MemberHelper::aviator_game_wallet($this->username['id']),
                "earning_balance" => MemberHelper::ewallet($this->username['id']),
                "cash_out_amount" => $winAmount,

            ],
            "message" => ""
        ];
        echo json_encode($data);
    }
    public function add_bet()
    {
        $id = $this->username['id'];

        if (count($_GET['all_bets']) == 2) {
            $betAmount = $_GET['all_bets'][0]['bet_amount'];
            $betAmount2 = $_GET['all_bets'][1]['bet_amount'];
        } else {
            $betAmount = $_GET['all_bets'][0]['bet_amount'];
            $betAmount2 = "";
        }

        $wallet = MemberHelper::aviator_game_wallet($this->username['id']);
        if (!empty($betAmount) && !empty($betAmount2)) {
            $totalAM = $betAmount + $betAmount2;
            if ($totalAM > $wallet) {
                $data = [
                    "isSuccess" => false,
                    "data" => [],
                    "message" => "Insufficient fund !"
                ];
            } else {

                $betData = [
                    "userid" =>   $id,
                    "wallet_amount" => $wallet - $betAmount,
                    "amount" => $betAmount,
                    "created_at" => date("Y-m-d H:i:s")
                ];
                $bet = $this->Members->insert_bet_game($betData);

                $betData2 = [
                    "userid" =>   $id,
                    "wallet_amount" => $wallet - $betAmount2,
                    "amount" => $betAmount2,
                    "created_at" => date("Y-m-d H:i:s")
                ];
                $bet2 = $this->Members->insert_bet_game($betData2);

                $pack = $this->Members->game_package_userid($id);
                if ($pack) {
                    if ($betAmount >= 100 && $betAmount2 >= 100) {
                        $this->Members->update_predict_turn($id, 2);
                    } elseif ($betAmount2 >= 100) {
                        $this->Members->update_predict_turn($id, 1);
                    } elseif ($betAmount >= 100) {
                        $this->Members->update_predict_turn($id, 1);
                    }
                }


                $this->Members->substract_aviator_game_amount($id, $totalAM);


                $wallet_after_update = MemberHelper::aviator_game_wallet($this->username['id']);
                $data = [
                    "isSuccess" => true,
                    "data" => [
                        "wallet_balance" => $wallet_after_update,
                        "return_bets" => [
                            [
                                "bet_id" =>  $bet
                            ],
                            [
                                "bet_id" =>  $bet2
                            ]


                        ]
                    ],
                    "message" => ""
                ];
            }
            echo json_encode($data);
        } elseif (!empty($betAmount)) {
            if ($betAmount > $wallet) {
                $data = [
                    "isSuccess" => false,
                    "data" => [],
                    "message" => "Insufficient fund !"
                ];
            } else {

                $betData = [
                    "userid" =>   $id,
                    "wallet_amount" => $wallet - $betAmount,
                    "amount" => $betAmount,
                    "created_at" => date("Y-m-d H:i:s")
                ];
                $bet = $this->Members->insert_bet_game($betData);

                $pack = $this->Members->game_package_userid($id);
                if ($pack) {
                    if ($betAmount >= 100) {
                        $this->Members->update_predict_turn($id, 1);
                    }
                }


                $this->Members->substract_aviator_game_amount($id, $betAmount);

                $wallet_after_update  = MemberHelper::aviator_game_wallet($this->username['id']);
                $data = [
                    "isSuccess" => true,
                    "data" => [
                        "wallet_balance" => $wallet_after_update,
                        "return_bets" => [
                            [
                                "bet_id" =>  $bet
                            ], [
                                "bet_id" =>  $bet
                            ]


                        ]
                    ],
                    "message" => ""
                ];
            }

            echo  json_encode($data);
        } elseif (!empty($betAmount2)) {
            if ($betAmount2 > $wallet) {
                $data = [
                    "isSuccess" => false,
                    "data" => [],
                    "message" => "Insufficient fund !"
                ];
            } else {

                $betData = [
                    "userid" =>   $id,
                    "wallet_amount" => $wallet - $betAmount2,
                    "amount" => $betAmount2,
                    "created_at" => date("Y-m-d H:i:s")
                ];
                $bet = $this->Members->insert_bet_game($betData);

                $pack = $this->Members->game_package_userid($id);
                if ($pack) {
                    if ($betAmount2 >= 100) {
                        $this->Members->update_predict_turn($id, 1);
                    }
                }

                $this->Members->substract_aviator_game_amount($id, $betAmount2);




                $wallet_after_update = MemberHelper::aviator_game_wallet($this->username['id']);
                $data = [
                    "isSuccess" => true,
                    "data" => [
                        "wallet_balance" => $wallet_after_update,
                        "return_bets" => [
                            [
                                "bet_id" =>  $bet
                            ], [
                                "bet_id" =>  $bet
                            ]
                        ]
                    ],
                    "message" => ""
                ];
            }

            echo json_encode($data);
        }
    }


    public function get_user_details()
    {
        echo json_encode($this->username);
    }
    public function new_game_generated()
    {

        $value = MemberHelper::aviator_game_wallet($this->username['id']);
        $data = round($value);
        echo json_encode($data);
    }

    public function game_over()
    {
        $this->Members->update_bet_by_status_uid_game($this->username['id'], ['status' => 1]);

        $value = MemberHelper::aviator_game_wallet($this->username['id']);
        $data = round($value);
        echo json_encode($data);
    }
    public function currentlybet()
    {
        $bet = $this->Members->get_all_active_bets_game();

        $data = [
            'currentGame' => '1',
            'currentGameBet' => $bet,
            'currentGameBetCount' => count($bet),
        ];
        echo json_encode($data);
    }
    public function increamentor()
    {
        $id = $this->username['id'];
        if ($id) {

            // $round = Round_history::where('user_id', $id)->get()->count();
            // if ($round >= 15) {
            //     $randomNumber = rand(10, 30) / 10;
            // } else {
            //     $settings =  Settings::where('id', 1)->first();
            //     $min_number = $settings->min_increment * 10;
            //     $max_number = $settings->max_increment * 10;
            //     $randomNumber = rand($min_number, $max_number) / 10;
            // }
            $betExists = $this->Members->get_active_bet_by_userid_aviator_game($this->username['id']);
            // $settings =  Settings::where('id', 1)->first();
            if ($betExists) {
                $min_number = 1 * 10;
                $max_number = 1.6 * 10;
            } else {

                // $min_number = $settings->min_increment * 10;
                $min_number = 1 * 10;
                $max_number = 6 * 10;
            }



            $randomNumber = rand($min_number, $max_number) / 10;

            $roundHistory = [
                "user_id" => $id,
                "round" => $randomNumber,
                "created_at" => date("Y-m-d H:i:s")
            ];
            $this->Members->insert_game_round_history($roundHistory);


            $prediction_row = $this->Members->get_prediction_earning($this->username['id']);
            $predicted_value = $prediction_row ? $prediction_row['amount'] : 0;
            if ($betExists && ($predicted_value != 0)) {
                if ($randomNumber == $predicted_value) {
                    // matched predicted
                    $predicted_earning_amount =  $betExists['amount'] * 1.5;

                    $earning['user_id'] = $this->username['id'];
                    $earning['predicted_value'] =  $predicted_value;
                    $earning['actual_value'] =  $randomNumber;
                    $earning['amount'] =  $betExists['amount'];
                    $earning['earning_amount'] =  $predicted_earning_amount;
                    $earning['created_at'] =  date("Y-m-d H:i:s");
                    $this->Members->insert_history_active($earning);


                    $earning1['user_id'] = $this->username['id'];
                    $earning1['amount'] =  $predicted_earning_amount;
                    $earning1['created_at'] =  date("Y-m-d H:i:s");
                    $this->Members->add_earning_amount($this->username['id'], $earning1);
                }
            }

            $data = [
                "status" => true,
                "result" => $randomNumber,
                // "result" => 2
            ];

            // var_dump($key, $iv);
            echo json_encode($data);
        }
    }

    public function my_bets_history()
    {
        $id = $this->username['id'];
        $bet = $this->Members->get_all_bets_aviator_game($this->username['id']);
        $data = $bet;
        echo json_encode($data);
    }
    public function pilot_prediction()
    {
        $this->load->view("game/layouts/common", ["template" => "game/pages/pilot_prediction"]);
    }
}
