<?php
defined('BASEPATH') or exit('No direct script access allowed');

/*
| -------------------------------------------------------------------------
| URI ROUTING
| -------------------------------------------------------------------------
| This file lets you re-map URI requests to specific controller functions.
|
| Typically there is a one-to-one relationship between a URL string
| and its corresponding controller class/method. The segments in a
| URL normally follow this pattern:
|
|	example.com/class/method/id/
|
| In some instances, however, you may want to remap this relationship
| so that a different class/function is called than the one
| corresponding to the URL.
|
| Please see the user guide for complete details:
|
|	https://codeigniter.com/user_guide/general/routing.html
|
| -------------------------------------------------------------------------
| RESERVED ROUTES
| -------------------------------------------------------------------------
|
| There are three reserved routes:
|
|	$route['default_controller'] = 'welcome';
|
| This route indicates which controller class should be loaded if the
| URI contains no data. In the above example, the "welcome" class
| would be loaded.
|
|	$route['404_override'] = 'errors/page_missing';
|
| This route will tell the Router which controller/method to use if those
| provided in the URL cannot be matched to a valid route.
|
|	$route['translate_uri_dashes'] = FALSE;
|
| This is not exactly a route, but allows you to automatically route
| controller and method names that contain dashes. '-' isn't a valid
| class or method name character, so it requires translation.
| When you set this option to TRUE, it will replace ALL dashes in the
| controller and method URI segments.
|
| Examples:	my-controller/index	-> my_controller/index
|		my-controller/my-method	-> my_controller/my_method
*/
$route['default_controller'] = 'auth/login';
$route['404_override'] = '';
$route['translate_uri_dashes'] = FALSE;

$route['login'] = 'auth/login';
$route['register'] = 'auth/register';
$route['forgot_password'] = 'auth/forgot_password';
$route['auth_admin'] = 'auth/auth_admin';
$route['verify'] = 'auth/verify';
$route['phone_number_update'] = 'auth/phone_number_update';

#shop
$route['product_list'] = 'member/product_list';
$route['buy'] = 'member/buy';
$route['cart'] = 'member/cart';
$route['cartDetails'] = 'member/cartDetails';
$route['remove_products'] = 'member/remove_products';
$route['product_details'] = 'member/product_details';
$route['update_quantity_products'] = 'member/update_quantity_products';
$route['delivery_address'] = 'member/delivery_address';
$route['order_confirm'] = 'member/order_confirm';
$route['payment'] = 'member/payment';
$route['order_placed'] = 'member/order_placed';
$route['orders'] = 'member/orders';
$route['pay_order'] = 'member/pay_order';



$route['dashboard'] = 'member/dashboard';
$route['deposit'] = 'member/deposit';
$route['paypal_deposit'] = 'member/paypal_deposit';
$route['wallet_transfer'] = 'member/wallet_transfer';
$route['request_withdraw'] = 'member/request_withdraw';
$route['verify_withdraw'] = 'member/verify_withdraw';
$route['request_game_withdraw'] = 'member/request_game_withdraw';
$route['request_app_withdraw'] = 'member/request_app_withdraw';
$route['request_spining_withdraw'] = 'member/request_spining_withdraw';
$route['request_whatsapp_withdraw'] = 'member/request_whatsapp_withdraw';
$route['reedem_points'] = 'member/reedem_points';
$route['mini_statements'] = 'member/mini_statements';
$route['create_post'] = 'member/create_post';
$route['blog_statements'] = 'member/blog_statements';
$route['manage_blogs'] = 'member/manage_blogs';
$route['loan'] = 'member/loan';
$route['packages'] = 'member/packages';
$route['forex_package'] = 'member/forex_package';
$route['all_packages'] = 'member/all_packages';
$route['silver_packages'] = 'member/silver_packages';
$route['first_packages'] = 'member/first_packages';
$route['second_packages'] = 'member/second_packages';
$route['third_packages'] = 'member/third_packages';
$route['premium_packages'] = 'member/premium_packages';
$route['star_packages'] = 'member/star_packages';
$route['change_password'] = 'member/change_password';
$route['profile'] = 'member/profile';
$route['support'] = 'member/support';
$route['spining_wheel'] = 'member/spining_wheel';
$route['spining_wheel_start'] = 'member/spining_wheel_start';
$route['free_spining_wheel'] = 'member/free_spining_wheel';
$route['upload_app_ss_first'] = 'member/upload_app_ss_first';
$route['upload_app_ss'] = 'member/upload_app_ss';
$route['game'] = 'member/game';
$route['game_start'] = 'member/game_start';
$route['notification'] = 'member/notification';
$route['verify_transfer'] = 'member/verify_transfer';
$route['bank_log'] = 'member/bank_log';
$route['usa_paypal'] = 'member/usa_paypal';
$route['master_card'] = 'member/master_card';
$route['visa'] = 'member/visa';
$route['add_funds'] = 'member/add_funds';
$route['e_learning'] = 'member/e_learning';
$route['become_an_ad_agent'] = 'member/become_an_ad_agent';
$route['agent_verification'] = 'member/agent_verification';
$route['paypal_verification'] = 'member/paypal_verification';
$route['welcome_verify_contract'] = 'member/welcome_verify_contract';
$route['request_paypal_withdraw'] = 'member/request_paypal_withdraw';
$route['request_bonus_withdraw'] = 'member/request_bonus_withdraw';
$route['locked'] = 'member/locked';
$route['unlock_package_history'] = 'member/unlock_package_history';
$route['verification_package'] = 'member/verification_package';
$route['verification_package_history'] = 'member/verification_package_history';

$route['paypal_logins'] = 'member/paypal_logins';
$route['paypal_login_history'] = 'member/paypal_login_history';
$route['compounding'] = 'member/compounding';
$route['compound_withdraw'] = 'member/compound_withdraw';
$route['compound_withdraw_history'] = 'member/compound_withdraw_history';
$route['access_code_package'] = 'member/access_code_package';
$route['access_code_history'] = 'member/access_code_history';
$route['welcome_bonus'] = 'member/welcome_bonus';
$route['unlock_welcome_bonus'] = 'member/unlock_welcome_bonus';
$route['cashback_bonus'] = 'member/cashback_bonus';
$route['unlock_cashback_bonus'] = 'member/unlock_cashback_bonus';
$route['create_support'] = 'member/create_support';
$route['direct_commission'] = 'member/direct_commission';
$route['whatsapp'] = 'member/whatsapp';
$route['view_ads'] = 'member/view_ads';
$route['spining_wheel'] = 'member/spining_wheel';
$route['mpesa_report'] = 'member/mpesa_report';
$route['pending_order'] = 'member/pending_order';
$route['shipping_order'] = 'member/shipping_order';
$route['delivered_order'] = 'member/delivered_order';
$route['order_commission'] = 'member/order_commission';
$route['compound_report'] = 'member/compound_report';
$route['user_to_user_notification'] = 'member/user_to_user_notification';
$route['forex_classes'] = 'member/forex_classes';
$route['google_ads'] = 'member/google_ads';
$route['online_writing'] = 'member/online_writing';

$route['agent_verification_request'] = 'admin/agent_verification_request';
$route['compounding_report'] = 'admin/compounding_report';
$route['remotask'] = 'member/remotask';
$route['remotask_package_history'] = 'member/remotask_package_history';
$route['shares'] = 'member/shares';
$route['whatsapp_package'] = 'member/whatsapp_package';
$route['whatsapp_package_history'] = 'member/whatsapp_package_history';
$route['trading'] = 'member/trading';
$route['buy_coins'] = 'member/buy_coins';
$route['kyc'] = 'member/kyc';
$route['withdraw_forex'] = 'member/withdraw_forex';
$route['trade_eth'] = 'member/trade_eth';
$route['trade_solana'] = 'member/trade_solana';
$route['trade_nas'] = 'member/trade_nas';
$route['trade_etc'] = 'member/trade_etc';
$route['trade_gbp'] = 'member/trade_gbp';
$route['trading_list'] = 'member/trading_list';
$route['trading_new'] = 'member/trading_new';
$route['demo'] = 'member/demo';
$route['demo_eth'] = 'member/demo_eth';
$route['demo_etc'] = 'member/demo_etc';
$route['demo_nas'] = 'member/demo_nas';
$route['demo_sol'] = 'member/demo_sol';
$route['demo_gbp'] = 'member/demo_gbp';
$route['generate_epin'] = 'member/generate_epin';
$route['demo_withdraw'] = 'member/demo_withdraw';
$route['jobs'] = 'member/jobs';
$route['downlines_user'] = 'member/downlines_user';
$route['send_email_to_refferal'] = 'member/send_email_to_refferal';
$route['change_sponsor'] = 'member/change_sponsor';
$route['search_user'] = 'member/search_user';
$route['karibu_withdraw'] = 'member/karibu_withdraw';
$route['refferal_link'] = 'member/refferal_link';
$route['tokens'] = 'member/tokens';
$route['tokens_package_history'] = 'member/tokens_package_history';
$route['logout'] = 'member/logout';

// AViator 
$route['aviator_game'] = 'game/aviator_game';
$route['currentlybet'] = 'game/currentlybet';
$route['new_game_generated'] = 'game/new_game_generated';
$route['get_user_details'] = 'game/get_user_details';

$route['online_task'] = 'member/online_task';
$route['game_prediction'] = 'game/game_prediction';
$route['game_user_create'] = 'game/game_user_create';
$route['game_package'] = 'game/game_package';
$route['aviator'] = 'auth/aviator';
$route['aviator_registration'] = 'auth/aviator_registration';
$route['aviator_registration_app'] = 'game/aviator_registration_app';
$route['acccess_code_page'] = 'game/acccess_code_page';
$route['aviator_login'] = 'auth/aviator_login';
$route['forgot_password_game'] = 'auth/forgot_password_game';
$route['the_summit'] = 'member/the_summit';
$route['summit_packages'] = 'member/summit_packages';
$route['ownership_packages'] = 'member/ownership_packages';