# Contributing to libSSE-php

We want to make contributing to this project as easy and transparent as possible.

## Reporting a Bugs
Whenever you find a bug in libSSE-php, we kindly ask you to report it.
It helps us make a better libSSE-php.
If you think you find out a security issue,
Please directly send an email to licson0729@gmail.com
and do not report on issue track.

Before submitting a bug,
please double-check the documentation to see
if you're not misusing the library;

If your problem definitely looks like a bug,
report it using the Github Issue and follow some basic rules:

- Use the title field to clearly describe the issue;
- Describe the steps needed to reproduce the bug with short code examples (providing a unit test that illustrates the bug is best);
- Give as much detail as possible about your environment (OS, PHP version, libSSE-php version, enabled extensions, ...);
- (optional) Attach a patch.

## Patch

1. Fork the libSSE-php to your own Github account
2. Clone the repo to your local mechine
3. Checkout the branch (mostly `v2.x` for now) by `git checkout -t origin/v2.x`
4. Create a new branch for bug fixing by `git checkout -b BRANCH_NAME v2.x`
5. Work on your patch and commit the change.
6. (optional) Write a test to show the fail in old new and success in the new branch
7. Run the test with phpunit
8. Push to your own github repo
8. Make a pull request for bug fix

## Pull Request
We are great to get a pull request from anyone.
Please remember the following things:

- Use the title field to clearly describe the pull request;
- Describe any change in dependencies, API and documentation


