<?php
$adminData = Helpers::getAdmin(true);
?>
<!-- PAGE HEADER -->
<div class="page-header-breadcrumb d-md-flex d-block align-items-center justify-content-between ">
    <h4 class="fw-medium mb-0">Pay Order</h4>
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);" class="-50">Pay Order</a>
        </li>
        <li class="breadcrumb-item active" aria-current="page"><?= Helpers::getPageName(); ?></li>
    </ol>
</div>
<div class="main-content app-content">
    <div class="container-fluid">

        <div class="container">
            <!-- Start::row-1 -->

            <div class="row">
                <div class="col-lg-12 mx-auto col-md-12 text-center ">

                    <?php if ($this->session->flashdata()) { ?>
                        <div class="mt-5 mb-2"><?php echo Helpers::showFlash($this->session->flashdata("response")); ?> </div>
                    <?php    } ?>
                </div>
                <div class="col-xl-6 col-lg-6">
                    <div class="card custom-card">
                        <div class="card-body p-0 product-checkout">
                            <ul class="nav nav-tabs tab-style-6 nav-justified d-sm-flex d-block border-bottom border-block-end-dashed" id="myTab1" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="order-tab" data-bs-toggle="tab"
                                        data-bs-target="#order-tab-pane" type="button" role="tab"
                                        aria-controls="order-tab" aria-selected="true">Pay Order</button>
                                </li>
                            </ul>
                            <div class="tab-content" id="myTabContent">
                                <div class="tab-pane fade show active border-0 p-0" id="order-tab-pane" role="tabpanel"
                                    aria-labelledby="order-tab-pane" tabindex="0">
                                    <div class="p-4">
                                        <div class="btn btn-danger fs-12 mb-3">Deposit Balance : <?= $wallet = MemberHelper::user_wallet(); ?> KES</div>
                                        <div class="row">
                                            <div class="col-xl-12">
                                                <div class="mb-3">
                                                    <?php $user = Helpers::getUserObj(); ?>
                                                    <form action="<?= base_url(); ?>member/pay_order_directly" method="post">
                                                        <label class="form-label">Delivery Address</label>
                                                        <div class="input-group">

                                                            <input type="hidden" name="payment_id" value="<?= $paymentId; ?>">
                                                            <input type="text" class="form-control" type="text" name="amount" id="example-search-input" value="<?= $amount; ?>" readonly>
                                                            <input type="submit" class="btn btn-primary input-group-text" id="payment-address" value="Submit">

                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-6">
                    <div class="card custom-card">
                        <div class="card-header">
                            <div class="card-title">
                                Orders
                            </div>
                        </div>
                        <div class="card-body table-card-body">
                            <div class="table-responsive">
                                <table id="datatable-basic" class="table table-bordered text-nowrap" style="width:100%">
                                    <thead>
                                        <tr>
                                            <th scope="col">Sr. No.</th>
                                            <th scope="col">Product Name </th>
                                            <th scope="col">Total Amount</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php if ($orders) {
                                            foreach ($orders as $key => $row) {
                                        ?>
                                                <tr>
                                                    <td><?= $key + 1; ?></td>
                                                    <td><?= $row['product_name']; ?></td>

                                                    <td><?= $row['total_price']; ?> KES</td>

                                                </tr>
                                        <?php }
                                        } ?>

                                    </tbody>
                                </table>

                            </div>
                        </div>

                    </div>
                </div>
                <!--End::row-1 -->
            </div>
        </div>
    </div>
</div>