<?php
$adminData = Helpers::getAdmin(true);
?>
<!-- PAGE HEADER -->
<div class="page-header-breadcrumb d-md-flex d-block align-items-center justify-content-between ">
    <h4 class="fw-medium mb-0">CartDetails</h4>
    <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="javascript:void(0);" class="-50">CartDetails</a>
        </li>
        <li class="breadcrumb-item active" aria-current="page"><?= Helpers::getPageName(); ?></li>
    </ol>
</div>
<!-- END PAGE HEADER -->
<div class="main-content app-content">
    <div class="container-fluid">

        <!-- Start::row-1 -->
        <div class="row justify-content-center">
            <div class="col-xl-10">
                <div class="col-lg-12 mx-auto col-md-12 text-center ">

                    <?php if ($this->session->flashdata()) { ?>
                        <div class="mt-5 mb-2"><?php echo Helpers::showFlash($this->session->flashdata("response")); ?> </div>

                    <?php    } ?>

                </div>
                <div class="row justify-content-center">

                    <div class="col-xxl-8">
                        <div class="card custom-card" id="cart-container-Deletee">
                            <div class="card-header">
                                <div class="card-title">
                                    Cart
                                </div>
                            </div>

                            <div class="card-body p-0">
                                <?php if ($this->cart->contents()) {
                                    $i = 1;

                                    foreach ($this->cart->contents() as $cart) { ?>
                                        <div class="d-sm-flex align-items-start p-4">
                                            <div class="d-flex flex-wrap align-items-center">
                                                <div class="me-3">
                                                    <span class="avatar avatar-xxxl bd-gray-200">
                                                        <img src="<?= base_url(); ?>uploads/files/products/1/<?= $cart['product_image']; ?>" alt="">
                                                    </span>
                                                </div>
                                                <div>
                                                    <div class="mb-1">
                                                        <a href="javascript:void(0);" class="fs-15 fw-bold"><?= $cart['name']; ?></a>
                                                        <!-- <span class="badge bg-success-transparent fw-semibold  fs-11 rounded-2 ms-2">72% off</span> -->
                                                    </div>


                                                    <div class="d-flex mb-1">
                                                        <h5 class="mb-1"><?= $cart['price']; ?> KES </h5>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="ms-auto align-items-center">
                                                <div class="align-items-center">
                                                    <form action="<?= base_url() . 'update_quantity_products'; ?>" method="post">
                                                        <div class="product-quantity-container text-center ">
                                                            <p class="mb-1">Quantity</p>
                                                            <div class="input-group border rounded-1 flex-nowrap">

                                                                <input class="form-control bg-light form-control-sm border-0 text-center w-100" type="number" min="1" max="9" step="1" name="<?= $i . '[quantity]'; ?>" value="1">

                                                            </div>
                                                        </div>
                                                        <div class="">
                                                            <a href="<?= base_url(); ?>remove_products?id=<?= $cart['rowid']; ?>" class="btn  btn-sm btn-danger-light fw-semibold mt-2 me-1"><i class="d-inline-flex fe fe-trash me-1"></i>Remove</a>
                                                            <button class="btn  btn-sm btn-info-light fw-semibold mt-2">Update Cart</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>

                                        </div>
                                    <?php }
                                } else { ?>
                                    <div class="col-xl-12">

                                        <h6 class="p-2">No Product Found...</h6>
                                        <a href="<?= base_url(); ?>product_list" class="card-link btn btn-primary btn-sm w-100 p-2" style="border-radius: 0px;">Continue Shopping</a>
                                    </div>
                                <?php } ?>
                                <div class="border-top"></div>
                            </div>
                        </div>

                    </div>
                    <div class="col-xxl-4">
                        <div class="card custom-card">
                            <div class="card-header justify-content-between">
                                <div class="card-title">
                                    Price Details
                                </div>
                            </div>
                            <div class="card-body p-0">
                                <div class="p-4 border-bottom border-block-end-dashed">
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                        <div class="text-muted ">Sub Total</div>
                                        <div class="fw-semibold fs-14"><?= $data['sub'] ?> KES</div>
                                    </div>
                                    <!-- <div class="d-flex align-items-center justify-content-between mb-3">
                                        <div class="text-muted ">Discount</div>
                                        <div class="fw-semibold fs-14 text-success">10% - $129</div>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-between mb-3">
                                        <div class="text-muted ">Delivery Charges</div>
                                        <div class="fw-semibold fs-14 text-danger">- $49</div>
                                    </div>
                                    <div class="d-flex align-items-center justify-content-between">
                                        <div class="text-muted ">Service Tax (18%)</div>
                                        <div class="fw-semibold fs-14">- $169</div>
                                    </div> -->
                                </div>
                                <div class=" py-3 px-4">
                                    <div class="d-flex align-items-center justify-content-between">
                                        <div class="fw-semibold fs-18 ">Total :</div>
                                        <div class="fw-semibold fs-18"> <?= $data['sub'] ?> KES</div>
                                    </div>

                                </div>
                                <div class="p-3 border-top text-center">
                                    <?php if ($this->cart->contents()) { ?>
                                        <form method="POST" action="<?= base_url() . 'delivery_address' ?>" enctype="multipart/form-data">
                                            <input type="hidden" name="amount" value="<?= $data['sub'] ?>">
                                            <input class="btn btn-primary m-1" type="submit" name="proceed" value="Proceed To Checkout">
                                        </form>
                                    <?php } ?>
                                    <!-- <a href="" class="btn btn-light m-1 ">Countinue Shopping</a> -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
        <!--End::row-1 -->

    </div>
</div>