<!-- PAGE HEADER -->
<div class="page-header-breadcrumb d-md-flex d-block align-items-center justify-content-between ">
  <h4 class="fw-medium mb-0"><?= Helpers::getPageName(); ?></h4>
  <ol class="breadcrumb">
    <li class="breadcrumb-item"><a href="javascript:void(0);" class="-50">Deposit</a>
    </li>
    <li class="breadcrumb-item active" aria-current="page"><?= Helpers::getPageName(); ?></li>
  </ol>
</div>
<!-- END PEAGE HEADER -->

<!-- APP CONTENT -->
<div class="main-content app-content">
  <div class="container-fluid">
   
  <div class="row">
    <div class="col-lg-12">
      <?php if ($this->session->flashdata()) {
        echo Helpers::showFlash($this->session->flashdata("response"));
      }

      ?>
    </div>
  </div>

  <div class="row">
    <div class="col-12">
      <div class="card custom-card">
        <div class="card-header">
          <div class="card-title">
            <?= Helpers::getPageName(); ?>
          </div>
        </div>

        <div class="card-body table-card-body">
          <div class="table-responsive">
            <table id="datatable-basic" class="table table-bordered text-nowrap" style="width:100%">
              <thead>
                <tr>
                  <th>Sr No.</th>
                  <th>Payment Gateway</th>
                  <th>Amount</th>
                  <th>Mpesa Transaction ID</th>
                  <th>Date</th>
                </tr>
              </thead>
              <tbody>
                <?php $key = 1;
                if ($data) {
                  foreach ($data as $key => $user) {
                    $date = $user["created_at"];
                    $payment = Helpers::get_payment_request_mpesa_id($user["mpesa_trans_id"]);
                ?>
                    <tr>
                      <td><?= $key + 1; ?></td>
                      <td><img src="<?= base_url(); ?>assets/images/mpesa.png" width="100" /></td>
                      <td><?= $user["amount"] ?></td>
                      <td><?= $payment ? $payment["trx_id"] : ""; ?></td>
                      <td><?= date("d-F-Y H:i", strtotime($date)); ?></td>
                    </tr>
                <?php $key = $key + 1;
                  }
                } ?>

              </tbody>

            </table>
          </div>
        </div>
      </div>
    </div>

  </div>
</div>
</div>