<!DOCTYPE html>
<html lang="en" dir="ltr" data-nav-layout="vertical" data-vertical-style="overlay" data-theme-mode="light" data-header-styles="light" data-menu-styles="light" data-toggled="close">

<head>

  <!-- Meta Data -->
  <meta charset="UTF-8">
  <meta name='viewport' content='width=device-width, initial-scale=1.0'>
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <!-- TITLE -->
  <title> LazadaTechnologies - Sign In</title>

  <!-- FAVICON -->
  <link rel="icon" href="<?= base_url() ?>assets/images/fav.png" type="image/x-icon">

  <!-- BOOTSTRAP CSS -->
  <link id="style" href="<?= base_url() ?>assets/libs/bootstrap/css/bootstrap.min.css" rel="stylesheet">

  <!-- ICONS CSS -->
  <link href="<?= base_url() ?>assets/icon-fonts/icons.css" rel="stylesheet">

  <!-- APP SCSS -->
  <link rel="preload" as="style" href="<?= base_url() ?>assets/app-O9WfkUrZ.css" />
  <link rel="stylesheet" href="<?= base_url() ?>assets/app-O9WfkUrZ.css" />

  <!-- MAIN JS -->
  <script src="<?= base_url() ?>assets/authentication-main.js"></script>




</head>

<body>



  <div class="page error-bg" id="particles-js">
    <!-- Start::error-page -->
    <div class="error-page  ">
      <div class="container">

        <!-- Start::row-1 -->
        <div class="row justify-content-center">
          <div class="col-xl-8 col-md-12 col-sm-10 ">
            <div class="card custom-card  rectangle2">
              <div class="card-body p-0 ">
                <div class="row">
                  <div class="col-xl-6 col-md-6 pe-sm-0">
                    
                    <div class="p-sm-5 p-3">
                      <p class="h4 fw-semibold mb-2">Sign In</p>
                      <p class="mb-3 text-muted op-7 fw-normal">Welcome Back ! </p>
<?php if ($this->session->flashdata()) {
                      echo Helpers::showFlash($this->session->flashdata("response"));
                    } ?>
                      <form method="post">
                        <div class="row gy-3 mt-3">
                          <div class="col-xl-12 mt-0">
                            <label for="signin-username" class="form-label text-default">Email</label>
                            <input type="text" class="form-control form-control-lg" id="signin-username" name="email" placeholder="Email">
                          </div>
                          <div class="col-xl-12 mb-3">
                            <label for="signin-password" class="form-label text-default d-block">Password<a href="<?= base_url() ?>forgot_password" class="float-end text-primary">Forget password ?</a></label>
                            <div class="input-group">
                              <input type="password" name="password" class="form-control form-control-lg" id="signin-password" placeholder="Password">
                              <button class="btn btn-light bg-transparent" type="button" onclick="createpassword('signin-password',this)" id="button-addon2"><i class="ri-eye-off-line align-middle"></i></button>
                            </div>

                          </div>
                          <div class="col-xl-12 d-grid mt-3">

                            <button class="btn btn-lg btn-primary" type="submit">Sign in </button>
                          </div>
                        </div>

                      </form>

                      <div class="text-center ">
                        <p class="fs-12 text-muted mt-4 mb-0">Dont have an account? <a href="<?= base_url(); ?>register" class="text-primary">Sign Up</a></p>
                      </div>
                    </div>
                  </div>
                  <div class="col-xl-6 col-md-6 ps-0 text-fixed-white rounded-0 d-none d-md-block  ">
                    <div class="card custom-card mb-0 cover-background overflow-hidden rounded-end rounded-0">
                      <div class="card-img-overlay d-flex  align-items-center p-0 rounded-0">
                        <div class="card-body p-5 rectangle3">
                          <div>
                            <a href="#"> <img src="<?= base_url() ?>assets/images/logo.png" alt="logo" class="desktop-dark"></a>
                          </div>
                          <h6 class="mt-4 fs-15 op-9  text-fixed-white">Sign In</h6>
                          <div class="d-flex mt-3">
                            <p class="mb-0 fw-normal fs-14 op-7  text-fixed-white"> Lorem ipsum dolor sit amet, consectetur adipisicing elit. Ipsa eligendi expedita aliquam quaerat nulla voluptas facilis.
                              Porro rem voluptates possimus, ad, autem quae culpa architecto, quam labore blanditiis at ratione.</p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!--End::row-1 -->
    </div>
    <!-- End::error-page -->
  </div>


  <!-- SCRIPTS -->

  <!-- BOOTSTRAP JS -->
  <script src="<?= base_url() ?>assets/libs/bootstrap/js/bootstrap.bundle.min.js"></script>


  <!-- SHOW PASSWORD JS -->
  <script src="<?= base_url() ?>assets/show-password.js"></script>


  <!-- END SCRIPTS -->

</body>

</html>