 <!-- PAGE HEADER -->
 <div class="page-header-breadcrumb d-md-flex d-block align-items-center justify-content-between ">
     <h4 class="fw-medium mb-0"><?= Helpers::getPageName(); ?></h4>
     <ol class="breadcrumb">
         <li class="breadcrumb-item"><a href="javascript:void(0);" class="-50">Fiscal Affairs</a>
         </li>
         <li class="breadcrumb-item active" aria-current="page"><?= Helpers::getPageName(); ?></li>
     </ol>
 </div>
 <!-- END PEAGE HEADER -->

 <!-- APP CONTENT -->
 <div class="main-content app-content">
     <div class="container-fluid">

         <?php $user = Helpers::getUserObj();
            if ($user['transfer_block'] == 0) { ?>
             <div class="row">
                 <div class="col-lg-12">
                     <div class="card m-b-20">
                         <div class="card-body table-card-body">
                             <div class="alert alert-danger">
                                 Something went wrong. Kindly be patient as we sort it out.Try again later
                             </div>
                         </div>
                     </div>
                 </div>
             </div>
         <?php
            } else {
            ?>
             <div class="row">
                 <div class="col-lg-6 mx-auto">

                     <div class="card custom-card">
                              <div class="row mt-2">
                                 <div class="col-md-6 mx-auto text-center">
                         <?php if ($this->session->flashdata()) {
                                echo Helpers::showFlash($this->session->flashdata("response"));
                            } ?>
                                 </div>
                              </div>
                         <?php if (validation_errors()) { ?>
                             <div class="row">
                                 <div class="col-md-6 mx-auto text-center">
                                     <div class="form-group">
                                         <div class="alert alert-danger"><?php echo validation_errors(); ?></div>
                                     </div>
                                 </div>
                             </div>
                         <?php } ?>
                         <div class="card-header">
                             <div class="card-title">
                                 Send Money
                             </div>
                         </div>
                         <div class="card-body table-card-body">
                             <div class="basic-form col-10" style="margin: auto;">
                                 <form class="form-valide-with-icon" action="<?= base_url(); ?>wallet_transfer" method="post">
                                     <div class="mb-3">
                                         <label class="text-label form-label required" for="validationCustomUsername">Select Account</label>
                                         <div class="input-group">
                                             <select name="balance" id="inputState" class="default-select form-control wide">
                                                 <?php $eWallet = MemberHelper::ewallet(); ?>
                                                 <option value="1">Earning Balance - <?= MemberHelper::currencyConverter($this->currency, $eWallet); ?> <?= $this->currency; ?></option>
                                             </select>
                                         </div>
                                     </div>

                                     <div class="mb-3">
                                         <label class="text-label form-label required" for="dlab-password">o <small>--- Receiver Phone Number </small></label>
                                         <div class="input-group transparent-append">

                                             <input type="text" name="phone" class="form-control" id="validationCustomUsername" required>
                                         </div>
                                     </div>

                                     <div class="mb-3">
                                         <label class="text-label form-label required" for="dlab-password">Amount in KES</label>
                                         <div class="input-group transparent-append">

                                             <input type="text" name="amount" class="form-control" id="validationCustomUsername" required>
                                         </div>
                                     </div>
                                     <input type="hidden" name="otp_request" value="1">
                                     <button type="submit" class="btn me-2 btn-primary">Get Verification</button>
                                 </form>





                             </div>
                         </div>
                     </div>
                 </div>
             </div>


             <div class="row">
                 <div class="col-12">
                     <div class="card default-price-plans">
                         <div class="card-header table-header card-no-border pb-0">
                         </div>
                         <div class="card-body table-card-body">
                             <div class="table-responsive">
                                 <table id="datatable-basic" class="table table-bordered text-nowrap" style="width:100%">
                                     <thead>
                                         <tr>
                                             <th><strong>Transation Id</strong></th>
                                             <th><strong>Amount</strong></th>
                                             <th><strong>To</strong></th>
                                             <th><strong>Date</strong></th>
                                         </tr>
                                     </thead>
                                     <tbody>
                                         <?php $key = 1;
                                            if ($data["send"]) {
                                                foreach ($data["send"] as $user) {
                                                    $to = Helpers::getUserObj($user["to_id"]);
                                                    $date = $user["created_at"];
                                            ?>
                                                 <tr>
                                                     <td><?= $key ?></td>
                                                     <td><?= MemberHelper::currencyConverter($this->currency, $user["amount"]); ?> <?= $this->currency; ?></td>
                                                     <td><?= $to["username"] ?></td>
                                                     <td><?= date("d-F-Y", strtotime($date)); ?></td>
                                                 </tr>
                                         <?php $key = $key + 1;
                                                }
                                            } ?>
                                     </tbody>
                                     <tfoot>
                                         <tr>
                                             <th><strong>Transation Id</strong></th>
                                             <th><strong>Amount</strong></th>
                                             <th><strong>To</strong></th>
                                             <th><strong>Date</strong></th>
                                         </tr>
                                     </tfoot>
                                 </table>
                             </div>
                         </div>
                     </div>
                 </div>

             </div>


             <div class="row">
                 <div class="col-12">
                     <div class="card default-price-plans">
                         <div class="card-header table-header card-no-border pb-0">
                         </div>
                         <div class="card-body table-card-body">
                             <div class="table-responsive">
                                 <table id="datatable-basic2" class="table table-bordered text-nowrap" style="width:100%">
                                     <thead>
                                         <tr>
                                             <th><strong>S.no</strong></th>
                                             <th><strong>Amount</strong></th>
                                             <th><strong>From</strong></th>
                                             <th><strong>Date</strong></th>
                                         </tr>
                                     </thead>
                                     <tbody>
                                         <?php $key = 1;
                                            if ($data["receive"]) {
                                                foreach ($data["receive"] as $user) {
                                                    $from = Helpers::getUserObj($user["to_id"]);
                                                    $date = $user["created_at"];
                                            ?>
                                                 <tr>
                                                     <td><?= $key ?></td>
                                                     <td><?= MemberHelper::currencyConverter($this->currency, $user["amount"]); ?> <?= $this->currency; ?></td>
                                                     <td><?= $from["username"]; ?></td>
                                                     <td><?= date("d-F-Y", strtotime($date)); ?></td>
                                                 </tr>
                                         <?php $key = $key + 1;
                                                }
                                            } ?>
                                     </tbody>
                                     <tfoot>
                                         <tr>
                                             <th><strong>S.no</strong></th>
                                             <th><strong>Amount</strong></th>
                                             <th><strong>From</strong></th>
                                             <th><strong>Date</strong></th>
                                         </tr>
                                     </tfoot>
                                 </table>
                             </div>
                         </div>
                     </div>
                 </div>

             </div>
         <?php } ?>
     </div>
 </div>