<!DOCTYPE html>
<html lang="en" dir="ltr" data-nav-layout="vertical" data-theme-mode="light" data-header-styles="gradient" data-menu-styles="dark">

<head>

  <!-- Meta Data -->
  <meta charset="UTF-8">
  <meta name='viewport' content='width=device-width, initial-scale=1.0'>
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="Description" content="Velvet - Laravel Bootstrap5 Admin & Dashboard Template">
  <meta name="Author" content="Spruko Technologies Private Limited">
  <meta name="keywords" content="laravel dashboard, laravel vite, laravel template, template dashboard, admin template, admin, dashboard admin, laravel admin panel, template admin, admin panel for laravel, laravel admin, alaravel, laravel framework, dashboard, laravel template admin">

  <!-- TITLE -->
  <title> LazadaTechnologies </title>

  <!-- FAVICON -->
  <link rel="icon" href="<?= base_url() ?>assets/images/fav.png" type="image/x-icon">

  <!-- BOOTSTRAP CSS -->
  <link id="style" href="<?= base_url() ?>assets/libs/bootstrap/css/bootstrap.min.css" rel="stylesheet">

  <!-- ICONS CSS -->
  <link href="<?= base_url() ?>assets/icon-fonts/icons.css" rel="stylesheet">

  <!-- APP SCSS -->
  <link rel="preload" as="style" href="<?= base_url() ?>assets/app-O9WfkUrZ.css" />
  <link rel="stylesheet" href="<?= base_url() ?>assets/app-O9WfkUrZ.css" />

  <!-- NODE WAVES CSS -->
  <link href="<?= base_url() ?>assets/libs/node-waves/waves.min.css" rel="stylesheet">

  <!-- SIMPLEBAR CSS -->
  <link rel="stylesheet" href="<?= base_url() ?>assets/libs/simplebar/simplebar.min.css">

  <!-- COLOR PICKER CSS -->
  <link rel="stylesheet" href="<?= base_url() ?>assets/libs/flatpickr/flatpickr.min.css">
  <link rel="stylesheet" href="<?= base_url() ?>assets/libs/@simonwep/pickr/themes/nano.min.css">

  <!-- CHOICES CSS -->
  <link rel="stylesheet" href="<?= base_url() ?>assets/libs/choices.js/public/assets/styles/choices.min.css">

  <!-- CHOICES JS -->
  <script src="<?= base_url() ?>assets/libs/choices.js/public/assets/scripts/choices.min.js"></script>

  <!-- MAIN JS -->
  <script src="<?= base_url() ?>assets/main.js"></script>


  <!-- JSVECTOR MAPS CSS -->
  <link rel="stylesheet" href="<?= base_url() ?>assets/libs/jsvectormap/css/jsvectormap.min.css">

  <!-- DATA-TABLES CSS -->
  <link rel="stylesheet" href="https://cdn.datatables.net/1.12.1/css/dataTables.bootstrap5.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.3.0/css/responsive.bootstrap.min.css">
  <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.3/css/buttons.bootstrap5.min.css">


</head>

<body>

  <?php
  // $user = $this->session->userdata('user'); 
  // print_r($user);

  $user = Helpers::getUserObj();
  ?>

  <!-- SWITCHER -->

  <!-- END SWITCHER -->

  <!-- LOADER -->
  <div id="loader">
    <img src="<?= base_url() ?>assets/images/media/loader.svg" alt="">
  </div>
  <!-- END LOADER -->

  <!-- PAGE -->
  <div class="page">

    <!-- HEADER -->

    <header class="app-header">

      <!-- Start::main-header-container -->
      <div class="main-header-container container-fluid">

        <!-- Start::header-content-left -->
        <div class="header-content-left">

          <!-- Start::header-element -->
          <div class="header-element">
            <div class="horizontal-logo">
              <a href="https://laravelui.spruko.com/velvet/index" class="header-logo">
                <img src="<?= base_url() ?>assets/images/fav.png" alt="logo" class="desktop-logo">
                <img src="<?= base_url() ?>assets/images/fav.png" alt="logo" class="toggle-logo">
                <img src="<?= base_url() ?>assets/images/fav.png" alt="logo" class="desktop-dark">
                <img src="<?= base_url() ?>assets/images/fav.png" alt="logo" class="toggle-dark">
              </a>
            </div>
          </div>
          <!-- End::header-element -->

          <!-- Start::header-element -->
          <div class="header-element">
            <!-- Start::header-link -->
            <a aria-label="anchor" href="javascript:void(0);" class="sidemenu-toggle header-link" data-bs-toggle="sidebar">
              <span class="open-toggle me-2">
                <i class="bx bx-menu header-link-icon"></i>
              </span>
            </a>


            <!-- End::header-link -->
          </div>
          <!-- End::header-element -->


        </div>
        <!-- End::header-content-left -->

        <!-- Start::header-content-right -->
        <div class="header-content-right">

          <!-- Start::header-element -->



          <!-- Start::header-element -->


          <!-- Start::header-element -->





  <div class="offcanvas offcanvas-end wd-330" tabindex="-1" id="apps" aria-labelledby="appsLabel">
            <div class="offcanvas-header border-bottom">
              <h5 id="appsLabel" class="mb-0 fs-18">Start trade</h5>
              <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas"
                aria-label="Close"> <i class="bx bx-x   apps-btn-close"></i></button>
            </div>
            <div class="row">
              <div class="col-xl-10 m-auto">
                <?php if ($this->session->flashdata()) { ?>
                  <div class="mt-5 mb-2"><?php echo Helpers::showFlash($this->session->flashdata("response")); ?></div>
                <?php   } ?>
                <div class="card card-body">
                  <form method="post" action="<?= base_url() ?><?= Helpers::getPagelink(); ?>">
                    <div class="mb-3 mt-5">
                      <label for="exampleInputEmail1" class="form-label">Quantity of warehouse opening</label>
                      <input type="text" name="amount" class="form-control" required>

                    </div>
                    <div class="mb-3">
                      <label for="choices-single-default" class="form-label">Open Time</label>
                      <select class="form-control" data-trigger name="time" id="choices-single-default " required>
                        <option value disabled selected>Choose...</option>
                        <option value="2">120</option>
                        <option value="3">180</option>
                        <option value="5">300</option>
                        <option value="10">600</option>
                      </select>
                    </div>
                    <div class="mb-3"><?php $settings = Helpers::settings(); ?>
                      <label for="choices-single-default" class="form-label">Profit Rate : <span class="text-primary"> <?= $settings['profite_rate']; ?>%</span></label>
                    </div>
                    <div class="mb-3">
                      <label for="choices-single-default" class="form-label">Account Balance : <span class="text-primary"><?= MemberHelper::forex_wallet(); ?> USD</span></label>
                    </div>
                    <div class="d-flex justify-content-between">
                      <button type="submit" value="1" name="movement" class="btn btn-primary">Buy up </button>
                      <button type="submit" value="0" name="movement" class="btn btn-danger">Buy down </button>
                    </div>
                  </form>
                </div>
              </div>
            </div>
          </div>

          <!-- Start::header-element -->
          <div class="header-element mainuserProfile">
            <!-- Start::header-link|dropdown-toggle -->
            <a href="javascript:void(0);" class="header-link dropdown-toggle" id="mainHeaderProfile" data-bs-toggle="dropdown" data-bs-auto-close="outside" aria-expanded="false">
              <div class="d-flex align-items-center">
                <div class="d-sm-flex wd-100p">
                  <div class="avatar avatar-sm"><img alt="avatar" class="rounded-circle" src="<?= base_url() ?>assets/images/faces/1.jpg"></div>
                  <div class="ms-2 my-auto d-none d-xl-flex">
                    <h6 class=" font-weight-semibold mb-0 fs-13 user-name d-sm-block d-none"><?= $user['username']; ?> </h6>
                  </div>
                </div>
              </div>
            </a>
            <!-- End::header-link|dropdown-toggle -->
            <ul class="dropdown-menu  border-0 main-header-dropdown  overflow-hidden header-profile-dropdown" aria-labelledby="mainHeaderProfile">
               <li><a class="dropdown-item border-bottom" href="<?= base_url() ?>profile"><i class="fs-13 me-2 bx bx-user"></i>Persona</a></li>
              <li><a class="dropdown-item border-bottom" href="<?= base_url() ?>change_password"><i class="fs-13 me-2 bx bx-comment"></i>Change Password</a></li>
              <?php if ($user['user_to_user_notification'] == 1) { ?>
                <li><a class="dropdown-item border-bottom" href="<?= base_url() ?>user_to_user_notification"><i class="fs-13 me-2 bx bx-cog"></i>Send Message</a></li>
              <?php } ?>

              <!--<?php if ($user['refferal_email'] == 1) { ?>-->
              <!--  <li><a class="dropdown-item border-bottom" href="<?= base_url() ?>downlines_user"><i class="fs-13 me-2 bx bx-help-circle"></i>Refferal Email</a></li>-->
              <!--<?php } ?> -->
              <li><a class="dropdown-item" href="<?= base_url(); ?>logout"><i class="fs-13 me-2 bx bx-arrow-to-right"></i>Log Out</a></li>
            </ul>
          </div>
          <!-- End::header-element -->



        </div>
        <!-- End::header-content-right -->

      </div>
      <!-- End::main-header-container -->

    </header>
    <!-- END HEADER -->

    <!-- SIDEBAR -->

    <aside class="app-sidebar" id="sidebar">

      <!-- Start::main-sidebar-header -->
      <div class="main-sidebar-header">
        <a href="https://laravelui.spruko.com/velvet/index" class="header-logo">
          <img src="<?= base_url() ?>assets/images/logo.png" alt="logo" class="desktop-logo" width="150">
          <img src="<?= base_url() ?>assets/images/logo.png" alt="logo" class="toggle-logo" width="150">
          <img src="<?= base_url() ?>assets/images/logo.png" alt="logo" class="desktop-dark" width="150">
          <img src="<?= base_url() ?>assets/images/logo.png" alt="logo" class="toggle-dark" width="150">
        </a>
      </div>
      <!-- End::main-sidebar-header -->

      <!-- Start::main-sidebar -->
      <div class="main-sidebar" id="sidebar-scroll">

        <!-- Start::nav -->
        <nav class="main-menu-container nav nav-pills flex-column sub-open">
          <div class="slide-left" id="slide-left">
            <svg xmlns="http://www.w3.org/2000/svg" fill="#7b8191" width="24" height="24" viewBox="0 0 24 24">
              <path d="M13.293 6.293 7.586 12l5.707 5.707 1.414-1.414L10.414 12l4.293-4.293z"></path>
            </svg>
          </div>
          <ul class="main-menu">
            <!-- Start::slide__category -->
            <li class="slide__category"><span class="category-name">Main Menu</span></li>
            <!-- End::slide__category -->

            <!-- Start::slide -->

            <!-- Start::slide -->
            <li class="slide">
              <a href="<?= base_url(); ?>dashboard" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-smile'></i>
                </span>
                <span class="side-menu__label">Dashboard</span>
              </a>
            </li>
            <!-- End::slide -->
            <li class="slide has-sub">
              <a href="javascript:void(0);" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-desktop'></i>
                </span>
                <span class="side-menu__label">Deposit<span class=" ms-2 d-inline-block"></span></span>
                <i class="fe fe-chevron-right side-menu__angle"></i>
              </a>
              <ul class="slide-menu child1">

                <li class="slide">
                  <a href="<?= base_url(); ?>deposit" class="side-menu__item">Deposit</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>mpesa_report" class="side-menu__item">Mpesa Report</a>
                </li>

              </ul>
            </li>

            <li class="slide">
              <a href="<?= base_url(); ?>packages" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-smile'></i>
                </span>
                <span class="side-menu__label">Packages</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>generate_epin" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-smile'></i>
                </span>
                <span class="side-menu__label">Generate Epin</span>
              </a>
            </li>


            <li class="slide has-sub">
              <a href="javascript:void(0);" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-desktop'></i>
                </span>
                <span class="side-menu__label">Fiscal Affairs<span class=" ms-2 d-inline-block"></span></span>
                <i class="fe fe-chevron-right side-menu__angle"></i>
              </a>
              <ul class="slide-menu child1">

                <li class="slide">
                  <a href="<?= base_url(); ?>wallet_transfer" class="side-menu__item">Wallet Transfer</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>request_withdraw" class="side-menu__item">Withdraw</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>mini_statements" class="side-menu__item">Mini Statements</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>reedem_points" class="side-menu__item">Reedem Points</a>
                </li>

              </ul>
            </li>
            <li class="slide">
              <a href="<?= base_url() . 'register?ref=' . $user['username']; ?>" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-globe header-link-icon'></i>
                </span>
                <span class="side-menu__label">Fresh Registration</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>the_summit" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-smile'></i>
                </span>
                <span class="side-menu__label">Summit</span>
              </a>
            </li>

            <li class="slide">
              <a href="<?= base_url(); ?>ownership_packages" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-smile'></i>
                </span>
                <span class="side-menu__label">Ownership Tiers</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>jobs" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-layout'></i>
                </span>
                <span class="side-menu__label">Jobs</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>online_task" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-menu'></i>
                </span>
                <span class="side-menu__label">Online Tasks</span>
              </a>
            </li>
             <?php $user = Helpers::getUserObj();
            ?>
            <?php if ($user['demo_trading'] == 1) {  ?>
              <li class="slide has-sub">
                <a href="javascript:void(0);" class="side-menu__item">
                  <span class=" side-menu__icon">
                    <i class='bx bx-category  header-link-icon'></i>
                  </span>
                  <span class="side-menu__label">Fx Trading<span class=" ms-2 d-inline-block"></span></span>
                  <i class="fe fe-chevron-right side-menu__angle"></i>
                </a>
                <ul class="slide-menu child1">

                  <li class="slide">
                    <a href="<?= base_url(); ?>demo" class="side-menu__item">Fx Trading BTC</a>
                  </li>
                  <li class="slide">
                    <a href="<?= base_url(); ?>demo_eth" class="side-menu__item">Fx Trading ETH</a>
                  </li>
                  <li class="slide">
                    <a href="<?= base_url(); ?>demo_etc" class="side-menu__item">Fx Trading ETC</a>
                  </li>
                  <li class="slide">
                    <a href="<?= base_url(); ?>demo_nas" class="side-menu__item">Fx Trading NAS</a>
                  </li>
                  <li class="slide">
                    <a href="<?= base_url(); ?>demo_sol" class="side-menu__item">Fx Trading SOL</a>
                  </li>
                  <li class="slide">
                    <a href="<?= base_url(); ?>demo_gbp" class="side-menu__item">Fx Trading GBP</a>
                  </li>
                  <li class="slide">
                    <a href="<?= base_url(); ?>demo_withdraw" class="side-menu__item">Fx Trading Withdraw</a>
                  </li>
                </ul>
              </li>
            <?php } ?>
            <li class="slide has-sub">
              <a href="javascript:void(0);" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-category  header-link-icon'></i>
                </span>
                <span class="side-menu__label">Trade<span class=" ms-2 d-inline-block"></span></span>
                <i class="fe fe-chevron-right side-menu__angle"></i>
              </a>
              <ul class="slide-menu child1">

                <li class="slide">
                  <a href="<?= base_url(); ?>trading_list" class="side-menu__item">Trading</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>kyc" class="side-menu__item">KYC</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>buy_coins" class="side-menu__item">Buy Coins</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>withdraw_forex" class="side-menu__item">Withdraw Forex</a>
                </li>
              </ul>
            </li>
            <li class="slide has-sub">
              <a href="javascript:void(0);" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-category  header-link-icon'></i>
                </span>
                <span class="side-menu__label">Tokens<span class=" ms-2 d-inline-block"></span></span>
                <i class="fe fe-chevron-right side-menu__angle"></i>
              </a>
              <ul class="slide-menu child1">

                <li class="slide">
                  <a href="<?= base_url(); ?>tokens?id=1" class="side-menu__item">Agent Token</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>tokens?id=2" class="side-menu__item">Verified Token</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>tokens?id=3" class="side-menu__item">Ad Agent Token</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>tokens?id=4" class="side-menu__item">Whatsapp Token</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>tokens?id=5" class="side-menu__item">Linking Token</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>tokens?id=6" class="side-menu__item">Access Token</a>
                </li>
              </ul>
            </li>
            <li class="slide__category"><span class="category-name">Orders</span></li>
            <li class="slide">
              <a href="<?= base_url(); ?>product_list" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Shop</span>
              </a>
            </li>
            
            <li class="slide has-sub">
              <a href="javascript:void(0);" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-category  header-link-icon'></i>
                </span>
                <span class="side-menu__label">Orders<span class=" ms-2 d-inline-block"></span></span>
                <i class="fe fe-chevron-right side-menu__angle"></i>
              </a>
              <ul class="slide-menu child1">

                <li class="slide">
                  <a href="<?= base_url(); ?>pending_order" class="side-menu__item">Pending</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>shipping_order" class="side-menu__item">Shipping</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>delivered_order" class="side-menu__item">Delivered</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>orders" class="side-menu__item">Orders History</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>order_commission" class="side-menu__item">Orders Commission</a>
                </li>

              </ul>
            </li>
<li class="slide__category"><span class="category-name">Supplies</span></li>
            <li class="slide">
              <a href="<?= base_url(); ?>whatsapp" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Whatsapp</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>view_ads" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Elite Promotions</span>
              </a>
            </li>
            <li class="slide has-sub">
              <a href="javascript:void(0);" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-category  header-link-icon'></i>
                </span>
                <span class="side-menu__label">Opportunities<span class=" ms-2 d-inline-block"></span></span>
                <i class="fe fe-chevron-right side-menu__angle"></i>
              </a>
              <ul class="slide-menu child1">
                <?php $packages = MemberHelper::getAllPackages(); ?>
                <li class="slide">
                  <a href="<?= base_url(); ?>all_packages" class="side-menu__item">All</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>first_packages" class="side-menu__item"><?= $packages[0]['name']; ?></a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>second_packages" class="side-menu__item"><?= $packages[1]['name']; ?></a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>third_packages" class="side-menu__item"><?= $packages[2]['name']; ?></a>
                </li>
              </ul>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>loan" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Credit</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>profile" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Persona</span>
              </a>
            </li>

            <li class="slide__category"><span class="category-name">Add-Ons</span></li>
            <li class="slide">
              <a href="<?= base_url(); ?>forex_classes" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Forex Classes</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>remotask" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Remo Task</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>whatsapp_package" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Whatsapp Linking</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>forex_package" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Forex Package</span>
              </a>
            </li>
            <!--<li class="slide">-->
            <!--  <a href="<?= base_url(); ?>google_ads" class="side-menu__item">-->
            <!--    <span class=" side-menu__icon">-->
            <!--      <i class='bx bx-basket'></i>-->
            <!--    </span>-->
            <!--    <span class="side-menu__label">Google Ads</span>-->
            <!--  </a>-->
            <!--</li>-->
            <li class="slide">
              <a href="<?= base_url(); ?>online_writing" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Digital Writing</span>
              </a>
            </li>
            <!-- <li class="slide">
              <a href="<?= base_url(); ?>compounding" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Investment</span>
              </a>
            </li> -->
        <li class="slide__category"><span class="category-name">Additional Features</span></li>
            <li class="slide has-sub">
              <a href="javascript:void(0);" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-category  header-link-icon'></i>
                </span>
                <span class="side-menu__label">Value Zone<span class=" ms-2 d-inline-block"></span></span>
                <i class="fe fe-chevron-right side-menu__angle"></i>
              </a>
              <ul class="slide-menu child1">

                <li class="slide">
                  <a href="<?= base_url(); ?>agent_verification" class="side-menu__item">Agent Verification</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>verification_package" class="side-menu__item">Verification Package</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>paypal_verification" class="side-menu__item">Paypal Request</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>access_code_package" class="side-menu__item">Access Code Package</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>become_an_ad_agent" class="side-menu__item">Become an Ad Agent</a>
                </li>
              </ul>
            </li>
            <li class="slide has-sub">
              <a href="javascript:void(0);" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-category  header-link-icon'></i>
                </span>
                <span class="side-menu__label">History<span class=" ms-2 d-inline-block"></span></span>
                <i class="fe fe-chevron-right side-menu__angle"></i>
              </a>
              <ul class="slide-menu child1">

                <li class="slide">
                  <a href="<?= base_url(); ?>unlock_package_history" class="side-menu__item">Unlock Package History</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>verification_package_history" class="side-menu__item">Verification Package History</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>paypal_login_history" class="side-menu__item">Paypal Package History</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>access_code_history" class="side-menu__item">Code Package History</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>remotask_package_history" class="side-menu__item">Remotask Package History</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>whatsapp_package_history" class="side-menu__item">WhatsApp Package History</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>tokens_package_history" class="side-menu__item">Token Package History</a>
                </li>

              </ul>
            </li>
            <li class="slide has-sub">
              <a href="javascript:void(0);" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-category  header-link-icon'></i>
                </span>
                <span class="side-menu__label">Financial Flow<span class=" ms-2 d-inline-block"></span></span>
                <i class="fe fe-chevron-right side-menu__angle"></i>
              </a>
              <ul class="slide-menu child1">

                <li class="slide">
                  <a href="<?= base_url(); ?>request_game_withdraw" class="side-menu__item">Game Withdraw</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>request_app_withdraw" class="side-menu__item">App Withdraw</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>request_spining_withdraw" class="side-menu__item">Spining Withdraw</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>request_whatsapp_withdraw" class="side-menu__item">WhatsApp Withdraw</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>request_paypal_withdraw" class="side-menu__item">Paypal Withdraw</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>request_bonus_withdraw" class="side-menu__item">Bonus Withdraw</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>karibu_withdraw" class="side-menu__item">Karibu Withdraw</a>
                </li>
              </ul>
            </li>
            <li class="slide has-sub">
              <a href="javascript:void(0);" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-category  header-link-icon'></i>
                </span>
                <span class="side-menu__label">Extra Payment<span class=" ms-2 d-inline-block"></span></span>
                <i class="fe fe-chevron-right side-menu__angle"></i>
              </a>
              <ul class="slide-menu child1">

                <li class="slide">
                  <a href="<?= base_url(); ?>welcome_bonus" class="side-menu__item">Welcome Bonus</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>cashback_bonus" class="side-menu__item">Cashback Bonus</a>
                </li>
              </ul>
            </li>
            <li class="slide has-sub">
              <a href="javascript:void(0);" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-category  header-link-icon'></i>
                </span>
                <span class="side-menu__label">Blog<span class=" ms-2 d-inline-block"></span></span>
                <i class="fe fe-chevron-right side-menu__angle"></i>
              </a>
              <ul class="slide-menu child1">

                <li class="slide">
                  <a href="<?= base_url(); ?>create_post" class="side-menu__item">Create Post</a>
                </li>
                <li class="slide">
                  <a href="<?= base_url(); ?>manage_blogs" class="side-menu__item">Manage Blog</a>
                </li>
              </ul>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>notification" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Reminder</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>support" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Contact Admin</span>
              </a>
            </li>
 <li class="slide">
              <a href="<?= base_url(); ?>aviator" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Aviator Prediction</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>aviator_game" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Aviator</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>refferal_link" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Aviator Pro Link</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>spining_wheel" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Spin</span>
              </a>
            </li>
            <li class="slide">
              <a href="<?= base_url(); ?>logout" class="side-menu__item">
                <span class=" side-menu__icon">
                  <i class='bx bx-basket'></i>
                </span>
                <span class="side-menu__label">Logout</span>
              </a>
            </li>
          </ul>
          <div class="slide-right" id="slide-right"><svg xmlns="http://www.w3.org/2000/svg" fill="#7b8191" width="24" height="24" viewBox="0 0 24 24">
              <path d="M10.707 17.707 16.414 12l-5.707-5.707-1.414 1.414L13.586 12l-4.293 4.293z"></path>
            </svg></div>
        </nav>
        <!-- End::nav -->

      </div>
      <!-- End::main-sidebar -->

    </aside>
    <!-- END SIDEBAR -->

    <!-- MAIN-CONTENT -->