<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Meta Tags -->
    <meta charset="utf-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1" />

    <!-- Site Title -->
    <title>Skyview </title>

    <!-- Site Fav Icon -->
    <link rel="shortcut icon" href="<?= base_url(); ?>website/assets/images/favicon.png" />

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@100;200;300;400;500;600;700;800;900&family=Roboto:wght@300;400;700&display=swap" rel="stylesheet">

    <!-- Template CSS Styles -->
    <link rel="stylesheet" id="colors" href="<?= base_url(); ?>website/assets/css/style.css" />

    <script src="<?= base_url(); ?>website/assets/js/modernizr.min.js"></script>
    <!-- Google Tag Manager -->
    <script>
        (function(w, d, s, l, i) {
            w[l] = w[l] || [];
            w[l].push({
                'gtm.start': new Date().getTime(),
                event: 'gtm.js'
            });
            var f = d.getElementsByTagName(s)[0],
                j = d.createElement(s),
                dl = l != 'dataLayer' ? '&l=' + l : '';
            j.async = true;
            j.src =
                'https://www.googletagmanager.com/gtm.js?id=' + i + dl;
            f.parentNode.insertBefore(j, f);
        })(window, document, 'script', 'dataLayer', 'GTM-TJT8ZKDT');
    </script>
    <!-- End Google Tag Manager -->
</head>

<body data-spy="scroll" data-offset="170" data-target=".navigation-area">

    <div class="page-wrapper">
        <!-- Site Header -->
        <header class="site-header header-style-three">
            <div class="container-fluid">
                <div class="row align-items-center">
                    <div class="col-12">
                        <div class="navigation-area">
                            <!-- Site Branding -->
                            <div class="site-branding">
                                <a href="#">
                                    <img class="logo-white" src="<?= base_url(); ?>website/assets/images/logo_dark.png" alt="Site Logo" style="    width: 69%;" />
                                    <img class="logo-dark" src="<?= base_url(); ?>website/assets/images/logo_dark.png" alt="Site Logo" style="    width: 69%;" />
                                </a>
                            </div><!--  /.site-branding -->

                            <!-- Site Navigation -->
                            <div class="site-navigation">
                                <nav class="navigation">
                                    <!-- Main Menu -->
                                    <div class="menu-wrapper">
                                        <div class="menu-content">
                                            <ul class="mainmenu">





                                                <li>
                                                    <a class="nav-link" href="#">Home</a>
                                                </li>
                                                <li>
                                                    <a class="nav-link" href="#">How It Work</a>
                                                </li>
                                                <li>
                                                    <a class="nav-link" href="#">Faqs</a>
                                                </li>
                                                <li>
                                                    <a class="nav-link" href="#">Testimonials</a>
                                                </li>
                                                <li>
                                                    <a class="nav-link" href="<?= base_url(); ?>login">Login</a>
                                                </li>

                                            </ul> <!-- /.menu-list -->
                                        </div> <!-- /.hours-content-->
                                    </div><!-- /.menu-wrapper -->
                                </nav>
                            </div><!--  /.site-navigation -->

                            <div class="header-navigation-right">
                                <div class="btn-sign-area">
                                    <a class="btn btn-primary btn-gradient radius-1" href="<?= base_url(); ?>register">Register</a>
                                </div>
                                <!--~./ btn-sign-area ~-->
                                <div class="hamburger-menus">
                                    <span></span>
                                    <span></span>
                                    <span></span>
                                </div>
                            </div>
                            <!--~./ header-navigation-right ~-->
                        </div><!-- /.navigation-area -->
                    </div><!-- /.col-12 -->
                </div><!-- /.row -->
            </div><!-- /.container-fluid -->
            <div class="mobile-sidebar-menu sidebar-menu">
                <div class="overlaybg"></div>
            </div>
        </header>
        <!-- Site Header End -->

        <!-- Sticky Header -->
        <div id="sticky-header" class="active"></div>
        <!-- End Sticky Header ~-->

        <!-- Start Frontpage Banner Section -->
        <div class="frontpage-banner-section frontpage-banner-style-one bg-image bg-overlay bg-parallax2 ptb-100" style="background-image:url('<?= base_url(); ?>website/assets/images/hero-banners/hero-banner-1.jpg')">
            <div class="container">
                <div class="row align-items-center">
                    <div class="col-md-12">
                        <div class="frontpage-banner-content">
                            <h2 class="hero-title aos-item" data-aos="fade-up" data-aos-duration="300" data-aos-once="true">Skyview</h2><!-- /.hero-title -->
                            <div class="hero-desc" data-aos="fade-up" data-aos-duration="400" data-aos-once="true">
                                <p>Skyview is a premier online marketing platform, providing high-quality products, services, and a remarkable compensation plan.</p>
                            </div><!-- /.hero-desc -->
                            <div class="form-group-btn" data-aos="fade-up" data-aos-duration="500" data-aos-once="true">
                                <a class="btn btn-primary btn-gradient radius-1" href="<?= base_url(); ?>login">Login</a>
                            </div><!-- /.form-group-btn -->
                        </div><!-- /.hero-content-area -->
                    </div>
                </div>
            </div>
        </div>
        <!-- End Frontpage Banner Section -->

        <!-- Start Services Block -->
        <div class="services-block style-two ptb-130">
            <div class="container ml-b-30">
                <div class="row mrb-80">
                    <div class="col-lg-12">
                        <div class="text-feature-block ms-mrb-50 text-center">
                            <h4 class="sub-title text-gradient aos-item" data-aos="fade-up" data-aos-duration="300" data-aos-once="true">What We Offer</h4>
                            <h2 class="title aos-item" data-aos="fade-up" data-aos-duration="400" data-aos-once="true"></h2>
                            <h5 class="description aos-item" data-aos="fade-up" data-aos-duration="500" data-aos-once="true">
                                Discover our curated range of premium products and services, crafted to uphold the highest standards of quality and innovation. Experience what makes us unique and enjoy the very best we provide.</h5>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-4 col-md-6 aos-item" data-aos="fade-up" data-aos-duration="600" data-aos-once="true">
                        <div class="service-item style-three flex radius-2">
                            <div class="service-icon mrr-30">
                                <i class="icofont-cube"></i>
                            </div>
                            <!-- /.service-icon -->
                            <div class="service-info">
                                <h6 class="title mrb-5">Affiliate Program </h6>
                                <p>
                                    Earn generous commissions by referring your friends and family to our website.
                                </p>
                            </div>
                            <!-- /.service-info -->
                        </div>
                        <!-- /.service-item -->
                    </div>
                    <!-- /.col-lg-6 -->
                    <div class="col-lg-4 col-md-6 aos-item" data-aos="fade-up" data-aos-duration="700" data-aos-once="true">
                        <div class="service-item style-three flex radius-2">
                            <div class="service-icon mrr-30">
                                <i class="icofont-light-bulb"></i>
                            </div>
                            <!-- /.service-icon -->
                            <div class="service-info">
                                <h3 class="title mrb-5">Money Transfer </h3>
                                <p>
                                    Our platform offers account-to-account transfers, allowing you to send and receive money effortlessly from friends and family.
                                </p>
                            </div>
                            <!-- /.service-info -->
                        </div>
                        <!-- /.service-item -->
                    </div>
                    <!-- /.col-lg-6 -->
                    <div class="col-lg-4 col-md-6 aos-item" data-aos="fade-up" data-aos-duration="800" data-aos-once="true">
                        <div class="service-item style-three flex radius-2">
                            <div class="service-icon mrr-30">
                                <i class="icofont-bell"></i>
                            </div>
                            <!-- /.service-icon -->
                            <div class="service-info">
                                <h3 class="title mrb-5">Blog Platform
                                </h3>
                                <p>
                                    We provide a blog space for our users to write and share stories, news, and more with a global audience.
                                </p>
                            </div>
                            <!-- /.service-info -->
                        </div>
                        <!-- /.service-item -->
                    </div>
                    <!-- /.col-lg-6 -->
                </div>
            </div>
            <!-- /.container -->
        </div>
        <!--~~./ End Services Block ~~-->

        <!-- Start Our Skill Block -->
        <div class="our-skill-block ptb-130 style-one">
            <div class="container">
                <div class="row align-items-center justify-content-between experience-numbers">
                    <div class="col-lg-7 col-md-6">
                        <div class="mock-up-thumb">
                            <img src="<?= base_url(); ?>website/assets/images/about/about1.png" />
                        </div>
                        <!-- /.mock-up-block -->
                        <div class="year-counter">
                            <div class="odometer-wrap">
                                <div class="odometer" data-odometer-final="12">0</div>
                            </div>
                            <h4 class="exp-title">Successful Years</h4>
                            <!-- /.exp-title -->
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-6">
                        <div class="text-feature-block style-three ms-mrb-50 xs-mrt-50 lg-mrt-0">
                            <h4 class="sub-title text-gradient aos-item" data-aos="fade-up" data-aos-duration="700" data-aos-once="true">Who We Are? </h4>
                            <h2 class="title aos-item" data-aos="fade-up" data-aos-duration="800" data-aos-once="true">

                            </h2>
                            <p class="con-text aos-item" data-aos="fade-up" data-aos-duration="950" data-aos-once="true">
                                Skyview is a reliable and registered company, in collaboration with Skyview, boasting years of experience in the MLM industry. We provide a diverse range of products and services to our clients. Skyview also offers a platform for secure online money transfers and the chance to earn significant commissions by referring family and friends, all backed by our exceptional compensation plan, available for download as a PDF. At Skyview, we are dedicated to giving back to the community through our investments, training initiatives, and opportunities for residual income.
                            </p>

                            <!-- /.skill-list -->

                            <a class="btn btn-primary btn-gradient radius-1 aos-item" data-aos="fade-up" data-aos-duration="1250" data-aos-once="true" href="#">Read More</a>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.container -->
        </div>
        <!--~~./ End Our Skill Block ~~-->

        <!-- Start Services Block -->
        <div class="services-block style-two ptb-130">
            <div class="container ml-b-30">
                <div class="row mrb-80">
                    <div class="col-lg-12">
                        <div class="text-feature-block ms-mrb-50 text-center">
                            <h4 class="sub-title text-gradient aos-item" data-aos="fade-up" data-aos-duration="300" data-aos-once="true">How It Work ?</h4>
                            <h2 class="title aos-item" data-aos="fade-up" data-aos-duration="400" data-aos-once="true"></h2>
                            <h5 class="description aos-item" data-aos="fade-up" data-aos-duration="500" data-aos-once="true">
                            Our compensation plan is highly comprehensive, ensuring you earn money consistently on our platform..</h5>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-lg-4 col-md-6 aos-item" data-aos="fade-up" data-aos-duration="600" data-aos-once="true">
                        <div class="service-item style-three flex radius-2">
                            <div class="service-icon mrr-30">
                                <i class="icofont-cube"></i>
                            </div>
                            <!-- /.service-icon -->
                            <div class="service-info">
                                <h6 class="title mrb-5">Activate your account </h6>
                                <p>
                                Activate your account by selecting your preferred package. Payments can be made via Mpesa or Bitcoin for users outside Kenya.
                                </p>
                            </div>
                            <!-- /.service-info -->
                        </div>
                        <!-- /.service-item -->
                    </div>
                   
                    <div class="col-lg-4 col-md-6 aos-item" data-aos="fade-up" data-aos-duration="800" data-aos-once="true">
                        <div class="service-item style-three flex radius-2">
                            <div class="service-icon mrr-30">
                                <i class="icofont-bell"></i>
                            </div>
                            <!-- /.service-icon -->
                            <div class="service-info">
                                <h3 class="title mrb-5">Register your account
                                </h3>
                                <p>
                                Create a new account or sign up through a referral link from a friend by entering accurate information on our registration page.
                                </p>
                            </div>
                            <!-- /.service-info -->
                        </div>
                        <!-- /.service-item -->
                    </div>
                    <!-- /.col-lg-6 -->
                      <!-- /.col-lg-6 -->
                    <div class="col-lg-4 col-md-6 aos-item" data-aos="fade-up" data-aos-duration="700" data-aos-once="true">
                        <div class="service-item style-three flex radius-2">
                            <div class="service-icon mrr-30">
                                <i class="icofont-light-bulb"></i>
                            </div>
                            <!-- /.service-icon -->
                            <div class="service-info">
                                <h3 class="title mrb-5">Enjoy our services </h3>
                                <p>
                                Access your referral link to earn through affiliates, own a blog platform, send and receive money globally, and much more. </p>
                            </div>
                            <!-- /.service-info -->
                        </div>
                        <!-- /.service-item -->
                    </div>
                    <!-- /.col-lg-6 -->
                </div>
            </div>
            <!-- /.container -->
        </div>

        <!-- Start Portfolio Block -->

        <!--~~./ End Portfolio Block ~~-->

        <!-- Start Pricing Block -->
        <div class="pricing-block ptb-130">
            <div class="container ml-b-30">
                <div class="row mrb-80">
                    <div class="col-lg-12">
                        <div class="text-feature-block ms-mrb-50 text-center">
                            <h4 class="sub-title text-gradient aos-item" data-aos="fade-up" data-aos-duration="300" data-aos-once="true">PRICING TABLE</h4>
                            <h2 class="title aos-item" data-aos="fade-up" data-aos-duration="400" data-aos-once="true">Choose the plan</h2>
                        </div>
                    </div>
                    <!-- /.section-title -->

                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="tab-content filter-pricing-tab-content">
                            <!--~~~~~ Start Tab Pane ~~~~~-->
                            <div class="tab-pane fade active show" id="monthly_pricing" role="tabpanel">
                                <div class="row pricing-table-list">
                                    <div class="col-lg-6 col-md-6 aos-item" data-aos="fade-up" data-aos-duration="500" data-aos-once="true">
                                        <!--~~~~~ Start Pricing Box ~~~~~-->
                                        <div class="pricing-box">
                                            <div class="pricing-header">
                                                <h2 class="pricing-title">Star Plan</h2>
                                                <p>
                                                    For Everyone
                                                </p>
                                            </div>
                                            <!-- /.pricing-header -->
                                            <div class="package-price">
                                                <sup>$</sup>16 <sub>/Lifetime</sub>
                                            </div>
                                            <!-- /.pricing-price -->

                                            <div class="pricing-content">
                                                <ul class="list">
                                                    <li>Entitled to blog platform</li>
                                                    <li>Send and receive money worldwide</li>
                                                    <li>Unlimited referrals</li>
                                                    <li>Annual fee</li>
                                                    <li>Eligible to Skyview products and services</li>
                                                    <li>Earns normally</li>
                                                    <li>24/7 Phone Support</li>
                                                </ul>
                                            </div>
                                            <!-- /.pricing-content -->
                                            <div class="pricing-btn-area text-center mrt-30">
                                                <a href="<?= base_url(); ?>login" class="btn btn-primary btn-gradient radius-1">Get Started</a>
                                            </div>
                                        </div>
                                        <!--~./ end pricing box ~-->
                                    </div>
                                    <!--~./ col-lg-4 ~-->
                                    <div class="col-lg-6 col-md-6 aos-item" data-aos="fade-up" data-aos-duration="600" data-aos-once="true">
                                        <!--~~~~~ Start Pricing Box ~~~~~-->
                                        <div class="pricing-box">
                                            <div class="pricing-header">
                                                <h2 class="pricing-title">Premium Plan</h2>

                                            </div>
                                            <!-- /.pricing-header -->
                                            <div class="package-price">
                                                <sup>$</sup> 48 <sub>/Lifetime</sub>
                                            </div>
                                            <!-- /.pricing-price -->

                                            <div class="pricing-content">
                                                <ul class="list">
                                                    <li>Entitled to blog platform</li>
                                                    <li>Send and receive money worldwide</li>
                                                    <li>Unlimited referrals</li>
                                                    <li>Lifetime fee</li>
                                                    <li>Eligible to Skyview products and services</li>
                                                    <li>Earns normally</li>
                                                    <li>24/7 Phone Support</li>
                                                </ul>
                                            </div>
                                            <!-- /.pricing-content -->
                                            <div class="pricing-btn-area text-center mrt-30">
                                                <a href="<?= base_url(); ?>login" class="btn btn-primary btn-gradient radius-1">Get Started</a>
                                            </div>
                                        </div>
                                        <!--~./ end pricing box ~-->
                                    </div>
                                    <!--~./ col-lg-4 ~-->

                                    <!--~./ col-lg-4 ~-->
                                </div>
                                <!--~./ row ~-->
                            </div>
                            <!--~./ end tab pane ~-->

                        </div><!-- /.filter-pricing-tab-content -->
                    </div><!-- /.col-12 -->
                </div><!-- /.row -->
            </div>
            <!-- /.container -->
        </div>
        <!--~~./ End Pricing Block ~~-->

        <!-- Start Testimonial Block -->
        <div class="testimonial-block ptb-130">
            <div class="container">
                <div class="row justify-content-center mrb-80">
                    <div class="col-lg-6 col-md-8">
                        <div class="text-feature-block style-three ms-mrb-50 text-center">
                            <h4 class="sub-title text-gradient aos-item" data-aos="fade-up" data-aos-duration="300" data-aos-once="true">Our Testimonials</h4>
                            <h2 class="title aos-item" data-aos="fade-up" data-aos-duration="400" data-aos-once="true">
                                Best Feedback from our clients
                            </h2>
                        </div>
                        <!-- /.section-title -->
                    </div>
                </div>
                <div class="row justify-content-center">
                    <div class="col-lg-8">
                        <!-- Testimonial Slider -->
                        <div class="swiper-container testimonial-slider-two">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <div class="client-testimonial style-two radius-1">
                                        <div class="client-thumb">
                                            <img src="<?= base_url(); ?>website/assets/images/testimonial/1.png" alt="Daniel Watson" />
                                        </div>
                                        <div class="details">
                                            <p>
                                                Outstanding service and a seamless process. Keep up the great work, Skyview team. Thank you for your prompt responses at every stage. Kudos to the entire team!
                                            </p>
                                        </div>
                                        <div class="client-info">
                                            <h4 class="client-name text-gradient w-500">Daniel Watson</h4>
                                        </div>
                                        <!-- /.client-info -->
                                    </div>
                                    <!-- /.client-testimonial -->
                                </div>
                                <div class="swiper-slide">
                                    <div class="client-testimonial style-two radius-1">
                                        <div class="client-thumb">
                                            <img src="<?= base_url(); ?>website/assets/images/testimonial/2.png" alt="Daniel Watson" />
                                        </div>
                                        <div class="details">
                                            <p>
                                                Proactively delay the distribution of relationships while focusing on equity-invested intellectual capital and all essential elements.
                                            </p>
                                        </div>
                                        <div class="client-info">
                                            <h4 class="client-name text-gradient w-500">Olivia Berlin</h4>
                                        </div>
                                        <!-- /.client-info -->
                                    </div>
                                    <!-- /.client-testimonial -->
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container -->
        </div>
        <!--~~./ End Testimonial Block ~~-->

        <!-- Start Call To Action -->
        <div class="section-call-to-action ptb-130 bg-image bg-overlay-gradient parallaxie" style="background-image: url('<?= base_url(); ?>website/assets/images/bg/action-bg.jpg');">
            <div class="container">
                <div class="row justify-content-center">
                    <div class="col-md-12">
                        <div class="text-feature-block ms-mrb-50 text-center">
                            <h2 class="title color-white aos-item" data-aos="fade-up" data-aos-duration="300" data-aos-once="true">More leads and a higher conversion rate with your website?</h2>
                            <h5 class="description color-white aos-item" data-aos="fade-up" data-aos-duration="400" data-aos-once="true">Your website should be the place where your clients fall in love with your product or service.</h5>
                        </div>
                        <!-- /.section-title -->
                    </div>
                </div>
                <div class="row mrt-50">
                    <div class="col-md-12 text-center aos-item" data-aos="fade-up" data-aos-duration="500" data-aos-once="true">
                        <a class="btn btn-primary radius-1 btn-black" href="#">Get in Touch</a>
                    </div>
                </div>
            </div>
        </div>
        <!--~~./ End Call To Action Block ~~-->

        <!-- Start Latest News Block -->
        <div class="latest-news-block ptb-130">
            <div class="container ml-b-50">
                <div class="row justify-content-center mrb-80">
                    <div class="col-lg-8">
                        <div class="text-feature-block style-three ms-mrb-50 text-center">
                            <h4 class="sub-title text-gradient aos-item" data-aos="fade-up" data-aos-duration="300" data-aos-once="true">Skyview News</h4>
                            <h2 class="title aos-item" data-aos="fade-up" data-aos-duration="400" data-aos-once="true">
                                Upcoming News
                            </h2>
                        </div>
                        <!-- /.section-title -->
                    </div>
                    <!-- /.col-lg-8 -->
                </div>
                <!-- /.row -->

                <div class="row">
                    <div class="col-lg-4 col-md-6">
                        <article class="post post-grid aos-item" data-aos="fade-up" data-aos-duration="500" data-aos-once="true">
                            <div class="post-thumb-area">
                                <figure class="post-thumb">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/assets/images/blog/post/grid/1.jpg" alt="Blog Image" />
                                    </a>
                                </figure>
                                <!-- /.post-thumb -->
                            </div>
                            <!-- /.post-thumb-area -->

                            <div class="post-details">
                                <div class="entry-meta entry-meta-date">
                                    <div class="entry-date text-gradient">
                                        13 June 2022
                                    </div>
                                </div>
                                <!--./ entry-meta-date -->
                                <h2 class="entry-title">
                                    <a href="#">
                                        What credit limit should I apply for?
                                    </a>
                                </h2>
                                <!-- /.entry-title -->
                                <div class="entry-meta">
                                    <div class="entry-meta-author">
                                        <div class="entry-author-thumb">
                                            <img class="avatar photo" src="<?= base_url(); ?>website/assets/images/author/a1.png" alt="author" />
                                        </div>
                                        <div class="entry-author-name">
                                            By <a href="#">Bruce Eric</a>
                                        </div>
                                    </div>
                                    <!--./ entry-meta-author -->

                                    <div class="entry-love">
                                        <i class="icofont-heart-alt"></i>
                                        1k
                                    </div>
                                    <!--./ entry-date -->
                                </div>
                                <!-- /.entry-meta -->
                            </div>
                            <!-- /.post-details -->
                        </article>
                        <!-- /.post -->
                    </div>
                    <!-- /.col-lg-4 -->
                    <div class="col-lg-4 col-md-6">
                        <article class="post post-grid aos-item" data-aos="fade-up" data-aos-duration="600" data-aos-once="true">
                            <div class="post-thumb-area">
                                <figure class="post-thumb">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/assets/images/blog/post/grid/2.jpg" alt="Blog Image" />
                                    </a>
                                </figure>
                                <!-- /.post-thumb -->
                            </div>
                            <!-- /.post-thumb-area -->

                            <div class="post-details">
                                <div class="entry-meta entry-meta-date">
                                    <div class="entry-date text-gradient">
                                        01 May 2022
                                    </div>
                                </div>
                                <!--./ entry-meta-date -->
                                <h2 class="entry-title">
                                    <a href="#">
                                        Which bank account should I choose to open?
                                    </a>
                                </h2>
                                <!-- /.entry-title -->
                                <div class="entry-meta">
                                    <div class="entry-meta-author">
                                        <div class="entry-author-thumb">
                                            <img class="avatar photo" src="<?= base_url(); ?>website/assets/images/author/a2.png" alt="author" />
                                        </div>
                                        <div class="entry-author-name">
                                            By <a href="#">Emma James</a>
                                        </div>
                                    </div>
                                    <!--./ entry-meta-author -->

                                    <div class="entry-love">
                                        <i class="icofont-heart-alt"></i>
                                        22k
                                    </div>
                                    <!--./ entry-date -->
                                </div>
                                <!-- /.entry-meta -->
                            </div>
                            <!-- /.post-details -->
                        </article>
                        <!-- /.post -->
                    </div>
                    <!-- /.col-lg-4 -->
                    <div class="col-lg-4 col-md-6">
                        <article class="post post-grid aos-item" data-aos="fade-up" data-aos-duration="700" data-aos-once="true">
                            <div class="post-thumb-area">
                                <figure class="post-thumb">
                                    <a href="#">
                                        <img src="<?= base_url(); ?>website/assets/images/blog/post/grid/3.jpg" alt="Blog Image" />
                                    </a>
                                </figure>
                                <!-- /.post-thumb -->
                            </div>
                            <!-- /.post-thumb-area -->

                            <div class="post-details">
                                <div class="entry-meta entry-meta-date">
                                    <div class="entry-date text-gradient">
                                        6 April 2022
                                    </div>
                                </div>
                                <!--./ entry-meta-date -->
                                <h2 class="entry-title">
                                    <a href="#">
                                        Banking Fundamentals: Understand your bank account better.
                                    </a>
                                </h2>
                                <!-- /.entry-title -->
                                <div class="entry-meta">
                                    <div class="entry-meta-author">
                                        <div class="entry-author-thumb">
                                            <img class="avatar photo" src="<?= base_url(); ?>website/assets/images/author/a3.png" alt="author" />
                                        </div>
                                        <div class="entry-author-name">
                                            By <a href="#">Andy Walker</a>
                                        </div>
                                    </div>
                                    <!--./ entry-meta-author -->

                                    <div class="entry-love">
                                        <i class="icofont-heart-alt"></i>
                                        10m
                                    </div>
                                    <!--./ entry-date -->
                                </div>
                                <!-- /.entry-meta -->
                            </div>
                            <!-- /.post-details -->
                        </article>
                        <!-- /.post -->
                    </div>
                    <!-- /.col-lg-4 -->
                </div>
                <!-- /.row -->
            </div>
            <!-- /.container -->
        </div>
        <!--~~./ End Latest News Block ~~-->

        <!-- Start Site Footer -->
        <footer class="site-footer bg-black-russian pd-t-100">
            <!-- Start Footer Widget Area -->
            <div class="footer-widget-area">
                <div class="container">
                    <div class="row">
                        <!--~~~~~ Start Widget About us ~~~~~-->
                        <div class="col-lg-3 col-md-6 aos-item" data-aos="fade-up" data-aos-duration="500" data-aos-once="true">
                            <aside class="widget widget_about">
                                <h2 class="widget-title color-white">About Us</h2>
                                <div class="widget-content">
                                    <p>Skyview offers premium products, services, and a top compensation plan.</p>
                                    <div class="social-status">
                                        <a href="#"><i class="icofont-facebook"></i></a>
                                        <a href="#"><i class="icofont-twitter"></i></a>
                                        <a href="#"><i class="icofont-linkedin"></i></a>
                                    </div>
                                </div>
                            </aside>
                        </div>
                        <!--~./ end about us widget ~-->

                        <!--~~~~~ Start Widget Links ~~~~~-->
                        <div class="col-lg-3 col-md-6 aos-item" data-aos="fade-up" data-aos-duration="600" data-aos-once="true">
                            <aside class="widget widget_links">
                                <h2 class="widget-title color-white">Quick Links</h2>
                                <div class="widget-content">
                                    <ul>
                                        <li><a href="#">How It Work</a></li>
                                        <li><a href="#">Faqs</a></li>
                                        <li><a href="#">Testimonials</a></li>
                                        <li><a href="#">Login</a></li>
                                        <li><a href="#">Regitser</a></li>
                                    </ul>
                                </div>
                            </aside>
                        </div>
                        <!--~./ end links widget ~-->

                        <!--~~~~~ Start Post List Widget ~~~~~-->

                        <!--~./ end post list widget ~-->

                        <!--~~~~~ Start Address Widget~~~~~-->
                        <div class="col-lg-3 col-md-6 aos-item" data-aos="fade-up" data-aos-duration="600" data-aos-once="true">
                            <aside class="widget widget_links">
                                <h2 class="widget-title color-white">Product</h2>
                                <div class="widget-content">
                                    <ul>
                                        <li><a href="#">Business Loans | Main</a></li>
                                        <li><a href="#">Loan Calculator</a></li>
                                        <li><a href="#">Refer a Friend</a></li>
                                        <li><a href="#">Partner Program</a></li>
                                    </ul>
                                </div>
                            </aside>
                        </div>
                        <div class="col-lg-3 col-md-6 aos-item" data-aos="fade-up" data-aos-duration="600" data-aos-once="true">
                            <aside class="widget widget_links">
                                <h2 class="widget-title color-white">Help</h2>
                                <div class="widget-content">
                                    <ul>
                                        <li><a href="#">Customer Carey</a></li>
                                        <li><a href="#">Contact Us</a></li>
                                        <li><a href="#">Security Center</a></li>
                                        <li><a href="#">Blog</a></li>
                                    </ul>
                                </div>
                            </aside>
                        </div>
                        <!--~./ end address widget ~-->
                    </div>
                </div>
            </div>
            <!--~./ end footer widgets area ~-->

            <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
                Start Footer Bottom Area
            ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
            <div class="footer-bottom-area br-top">
                <div class="container">
                    <div class="row">
                        <div class="col-12 aos-item" data-aos="fade-up" data-aos-duration="900" data-aos-once="true">
                            <div class="footer-bottom-content text-center">
                                <a class="footer-logo-area" href="#">
                                    <img src="<?= base_url(); ?>website/assets/images/logo_dark.png" alt="Logo" />
                                </a>
                                <div class="copyright-text text-center">
                                    <p>© 2025 Skyview </p>
                                </div>
                                <!--~./ end copyright text ~-->
                            </div>
                        </div>
                        <!--~./ col-12 ~-->
                    </div>
                </div>
            </div>
            <!--~./ end footer bottom area ~-->
        </footer>
        <!--~./ end site footer ~-->
    </div>
    <!--~~./ End Page Wrapper ~~-->

    <!-- All The JS Files  -->
    <script src="<?= base_url(); ?>website/assets/js/jquery.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/popper.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/bootstrap.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/plugins.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/aos.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/imagesloaded.pkgd.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/simple-scrollbar.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/background-parallax.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/jquery.magnific-popup.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/theia-sticky-sidebar.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/ResizeSensor.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/swiper.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/isotope.pkgd.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/packery-mode.pkgd.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/scrolla.jquery.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/odometer.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/parallaxie.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/isInViewport.jquery.js"></script>
    <!-- <script src="<?= base_url(); ?>website/assets/js/color-switcher.js"></script> -->
    <script src="<?= base_url(); ?>website/assets/js/jscolor.min.js"></script>
    <script src="<?= base_url(); ?>website/assets/js/main.js"></script>
    <!-- All The JS Files  -->
    <!-- Google Tag Manager (noscript) -->
    <noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-TJT8ZKDT" height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>
    <!-- End Google Tag Manager (noscript) -->
</body>

</html>