  <div class="content-wrapper">


    <div class="row">
      <div class="col-lg-12">
        <div class="card">
          <div class="card-body">
            <h4 class="card-title">Complaints</h4>
            <?php if ($this->session->flashdata()) {
              echo Helpers::showFlash($this->session->flashdata("response"));
            } ?>
            <div class="row">
              <div class="col-12">

                <div class="table-responsive">
                  <table id="order-listing" class="table">
                    <thead>
                      <tr>
                        <th>ID</th>
                        <th>Email</th>
                        <th>Subject</th>
                        <th>Message</th>
                        <th>Status</th>
                        <th>Date</th>

                      </tr>
                    </thead>
                    <tbody>
                      <?php if (!empty($data)) { ?>
                        <?php foreach ($data as $complaint) {
                          $user = Helpers::userdetails($complaint["user_id"]); ?>
                          <tr>
                            <td><a href="<?= base_url() . '/admin/single_complaint?id=' . $complaint['id']; ?>"><?= $complaint["id"]; ?></td>
                            <td><?= $user["email"]; ?></td>
                            <td><?= $complaint["subject"]; ?></td>
                            <td><?= word_limiter($complaint["message"], 2); ?></td>
                            <td><?= ($complaint["status"] == 0) ? "Not resolved" : "Resolved"; ?></td>
                            <td><?= $complaint["created_at"]; ?></td>
                          </tr>
                        <?php }
                      } ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>

  </div>