<?php

class Adm extends ci_model
{

	public function get_settings()
	{
		$this->db->where('id', 1);
		$query = $this->db->get('settings');
		return $query->row_array();
	}

	public function update_settings($data)
	{
		$query = $this->db->update("settings", $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	function get_withdraw_approved_details($id)
	{
		$this->db->where("id", $id);
		$this->db->where('status', 1);
		$result = $this->db->get("withdraw_request")->row_array();
		return $result;
	}
	public function update_currencies($name, $data)
	{
		$this->db->where('name', $name);
		$query = $this->db->update("currencies", $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	// public function update_xtc()
	// {
	// 	$query = $this->db->update("users", array("auto_withdraw" => $data ));
	// 	if($this->db->affected_rows()) {
	// 		return true;
	// 	}
	// 	else {
	// 		return false;
	// 	}
	// }
	public function add_adm_msg($data)
	{
		if ($this->db->insert('adm_msg', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('adm_msg', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}
	public function get_kyc_request()
	{
		$this->db->order_by('id', 'RANDOM');
		$this->db->where('document_update', 1);
		$query = $this->db->get('users');
		return $query->result_array();
	}
	public function get_all_users($limit = false, $start = false)
	{

		$this->db->order_by("id", "desc");
		$this->db->where_not_in('role ', 1);
		// exclude admin
		$query = $this->db->get('users');
		return $query->result_array();
	}
	public function get_single_user($username)
	{
		$this->db->where('username', $username);
		$query = $this->db->get('users');
		return $query->row_array();
	}
	public function getuserbyphone($phone)
	{
		$this->db->where('phone', $phone);
		$query = $this->db->get('users');
		return $query->row_array();
	}
	public function getuserbyusername($username)
	{
		$this->db->where('username', $username);
		$query = $this->db->get('users');
		return $query->row_array();
	}
	public function getUsersdates($first, $second)
	{

		$this->db->select('*');
		// $this->db->where("register_date BETWEEN '$first' AND '$second'");
		$this->db->where('register_date >=', $first);
		$this->db->where('register_date <=', $second);
		$query = $this->db->get('users');
		return $query->result_array();
	}
	public function getpackagedates($first, $second)
	{

		$this->db->select('*');
		$this->db->where('purchase_date >=', $first);
		$this->db->where('purchase_date <=', $second);
		$query = $this->db->get('sales');
		return $query->result_array();
	}
	public function whatsapp_all_request()
	{
		$this->db->where('status', 0);
		$query = $this->db->get('whatsapp_request');
		return $query->result_array();
	}
	public function get_approved_whatsapp_requests()
	{

		$this->db->where('status', 1);
		$query = $this->db->get('whatsapp_request');
		return $query->result_array();
	}
	function update_whatsapp_request($id, $data)
	{
		$this->db->where('id', $id);
		$query = $this->db->update('whatsapp_request', $data);

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	function getsingleRow($id)
	{
		$this->db->where("id", $id);
		$query = $this->db->get("whatsapp_request")->row_array();
		return $query;
	}


	public function get_users()
	{
		// 		if (($id) == "") {
		// 			$this->db->limit(1000);
		// 		}
		// 		if (($id) == "0") {
		// 			$this->db->limit(1000);
		// 		}
		// 		if (($id) == '1') {
		// 			$this->db->limit(1000, 1000);
		// 		}
		// 		if (($id) == '2') {
		// 			$this->db->limit(1000, 2000);
		// 		}
		// 		if (($id) == '3') {
		// 			$this->db->limit(1000, 3000);
		// 		}
		// 		if (($id) == '4') {
		// 			$this->db->limit(1000, 4000);
		// 		}

		// 		if (($id) == '5') {
		// 			$this->db->limit(1000, 5000);
		// 		}
		// 		if (($id) == '6') {
		// 			$this->db->limit(1000, 6000);
		// 		}
		// 		if (($id) == '7') {
		// 			$this->db->limit(1000, 7000);
		// 		}
		// 		if (($id) == '8') {
		// 			$this->db->limit(1000, 8000);
		// 		}
		// 		if (($id) == '9') {
		// 			$this->db->limit(1000, 9000);
		// 		}
		// 		if (($id) == '10') {
		// 			$this->db->limit(1000, 10000);
		// 		}
		// 		if (($id) == '11') {
		// 			$this->db->limit(1000, 11000);
		// 		}
		// 		if (($id) == '12') {
		// 			$this->db->limit(1000, 12000);
		// 		}
		// 		if (($id) == '13') {
		// 			$this->db->limit(1000, 13000);
		// 		}
		// 		if (($id) == '14') {
		// 			$this->db->limit(1000, 14000);
		// 		}
		// 		if (($id) == '15') {
		// 			$this->db->limit(1000, 15000);
		// 		}
		// 		if (($id) == '16') {
		// 			$this->db->limit(1000, 16000);
		// 		}
		// 		if (($id) == '17') {
		// 			$this->db->limit(1000, 17000);
		// 		}
		// 		if (($id) == '18') {
		// 			$this->db->limit(1000, 18000);
		// 		}
		// 		if (($id) == '19') {
		// 			$this->db->limit(1000, 19000);
		// 		}
		// 		if (($id) == '20') {
		// 			$this->db->limit(1000, 20000);
		// 		}
		// 		if (($id) == '21') {
		// 			$this->db->limit(1000, 21000);
		// 		}
		// 		if (($id) == '22') {
		// 			$this->db->limit(1000, 22000);
		// 		}
		// 		if (($id) == '23') {
		// 			$this->db->limit(1000, 23000);
		// 		}
		// 		if (($id) == '24') {
		// 			$this->db->limit(1000, 24000);
		// 		}
		// 		if (($id) == '25') {
		// 			$this->db->limit(1000, 25000);
		// 		}
		// 		if (($id) == '26') {
		// 			$this->db->limit(1000, 26000);
		// 		}

		// 		if (($id) == '27') {
		// 			$this->db->limit(1000, 27000);
		// 		}
		// 		if (($id) == '28') {
		// 			$this->db->limit(1000, 28000);
		// 		}
		// 		if (($id) == '29') {
		// 			$this->db->limit(1000, 29000);
		// 		}
		// 		if (($id) == '30') {
		// 			$this->db->limit(1000, 30000);
		// 		}

		// 		if (($id) == '31') {
		// 			$this->db->limit(1000, 31000);
		// 		}
		// 		if (($id) == '32') {
		// 			$this->db->limit(1000, 32000);
		// 		}
		$this->db->where_not_in('role ', 1);
		// $this->db->order_by("id", "asc");
		$query = $this->db->get('users');
		return $query->result_array();
	}
	public function get_member_details($id)
	{
		$this->db->where('id', $id);
		$query = $this->db->get('users');
		return $query->row_array();
	}

	public function admin_login($data)
	{
		// $this->db->where('role', '1');
		$this->db->where('username', $data["username"]);
		$this->db->where('password', $data["password"]);
		$user = $this->db->get('admin_details')->row_array();
		return $user;
	}
	public function get_all_fund_requests()
	{
		$data = $this->db->get("mpesa")->result_array();
		return $data;
	}
	public function get_all_fund_response()
	{
		$this->db->order_by('id', 'desc');
		$data = $this->db->get("mpesa_deposit")->result_array();
		return $data;
	}
	public function update_admin($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("users", $data);
		return $resp;
	}
	public function get_admin_details($id)
	{
		$this->db->where("id", $id);
		$data = $this->db->get("users")->row_array();
		return $data;
	}
	public function get_support_messages()
	{
		return $this->db->where(array("status" => 0, "to_id" => NULL))->get('support')->result_array();
	}

	public function get_support_single_message($id)
	{
		return $this->db->where("id", $id)->get('support')->row_array();
	}

	public function get_support_reply($userId, $ticket_no)
	{
		return $this->db->where(array("ticket_no" => $ticket_no, "to_id" => $userId))->get('support')->row_array();
	}
	public function update_support($id, $data)
	{
		$this->db->where('id', $id);
		$this->db->update('support', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}

	function update_status($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("mpesa", $data);
		return $resp;
	}
	function update_withdraw($id, $data)
	{
		$this->db->where("id", $id);
		$this->db->update("withdraw_request", $data);
		$result = $this->db->where('id', $id)->get("withdraw_request")->row_array();
		return $result;
	}
	function get_withdraw_details($id)
	{
		$this->db->where("id", $id);
		$result = $this->db->get("withdraw_request")->row_array();
		return $result;
	}

	function update_game_withdraw($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("withdraw_game_request", $data);
		return $resp;
	}
	function get_game_withdraw_details($id)
	{
		$this->db->where("id", $id);
		$result = $this->db->get("withdraw_game_request")->row_array();
		return $result;
	}

	function update_whatsapp_withdraw($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("withdraw_whatsapp_request", $data);
		return $resp;
	}
	function get_whatsapp_withdraw_details($id)
	{
		$this->db->where("id", $id);
		$result = $this->db->get("withdraw_whatsapp_request")->row_array();
		return $result;
	}


	function update_app_withdraw($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("withdraw_app_request", $data);
		return $resp;
	}
	function get_app_withdraw_details($id)
	{
		$this->db->where("id", $id);
		$result = $this->db->get("withdraw_app_request")->row_array();
		return $result;
	}


	function update_spining_withdraw($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("withdraw_spining_request", $data);
		return $resp;
	}
	function get_spining_withdraw_details($id)
	{
		$this->db->where("id", $id);
		$result = $this->db->get("withdraw_spining_request")->row_array();
		return $result;
	}
	public function showcounter()
	{
		$data = $this->db->get("setting")->row_array();
		return $data;
	}
	public function counter($id, $data)
	{
		$this->db->where('id', $id);
		$this->db->update('setting', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	public function create_contract($data)
	{
		if ($this->db->insert('contracts', $data)) {
			$id = $this->db->insert_id();
			$cid = $this->db->get_where('contracts', array('id' => $id))->row_array();
			return $cid;
		} else {
			return false;
		}
	}

	public function add_ads($data)
	{
		if ($this->db->insert('ads', $data)) {
			$id = $this->db->insert_id();
			$cid = $this->db->get_where('ads', array('id' => $id))->row_array();
			return $cid;
		} else {
			return false;
		}
	}
	public function add_banner($data)
	{
		if ($this->db->insert('banner', $data)) {
			$id = $this->db->insert_id();
			$cid = $this->db->get_where('banner', array('id' => $id))->row_array();
			return $cid;
		} else {
			return false;
		}
	}

	function remove_ads($id)
	{

		$this->db->where('id', $id);
		$this->db->delete('ads');
		if ($this->db->affected_rows()) {
			return true;
		} else {

			return false;
		}
	}

	function remove_banner($id)
	{

		$this->db->where('id', $id);
		$this->db->delete('banner');
		if ($this->db->affected_rows()) {
			return true;
		} else {

			return false;
		}
	}
	public function get_all_contracts($limit = false, $start = false)
	{
		$this->db->limit($limit, $start);
		$this->db->order_by("id", "desc");
		$query = $this->db->get('contracts');
		return $query->result_array();
	}

	public function getcontract($cid)
	{
		$this->db->where('contract_no', $cid);
		$query = $this->db->get('contracts')->row_array();

		return $query;
	}
	public function update_contract($contract, $data)
	{
		$this->db->where('contract_no', $contract);
		$this->db->update('contracts', $data);

		if ($this->db->affected_rows()) {
			return true;
		} else {

			return false;
		}
	}
	function get_row_by_id($id)
	{
		$result = $this->db->get_where('mpesa', array('id' => $id))->row_array();
		return $result;
	}
	function add_wallet_amount($userId, $data)
	{
		$user = $this->get_user_wallet($userId);
		if ($user) {
			$response = $this->db->query("UPDATE topupwallet SET wallet_amount = wallet_amount + {$data["wallet_amount"]} WHERE user_id = {$userId}");
			//$response = $query->result_array();
		} else {
			$response = $this->db->insert('topupwallet', $data);
		}
		return $response;
	}

	function get_app_earning_wallet($id)
	{
		return $this->db->get_where('app_earning', array('user_id' => $id))->row_array();
	}
	function add_app_earnings($userId, $data)
	{
		$user = $this->get_app_earning_wallet($userId);
		if ($user) {
			$response = $this->db->query("UPDATE app_earning SET amount = amount + {$data["amount"]} WHERE user_id = {$userId}");
			//$response = $query->result_array();
		} else {
			$response = $this->db->insert('app_earning', $data);
		}
		return $response;
	}
	function get_user_wallet($id)
	{
		return $this->db->get_where('topupwallet', array('user_id' => $id))->row_array();
	}
	function substract_wallet_amount($userId, $amount)
	{
		$user = $this->get_user_wallet($userId);
		$response = false;
		if ($user) {
			$response = $this->db->query("UPDATE topupwallet SET wallet_amount = wallet_amount - {$amount} WHERE user_id = {$userId}");
		}
		return $response;
	}

	function get_newuser($limit)
	{

		$this->db->order_by("id", "desc");
		$data = $this->db->get("users", $limit, 0)->result_array();
		return $data;
	}
	function addtransfer_entry($data)
	{
		$response = $this->db->insert("transferhistory", $data);
		return $response;
	}
	function get_withdraw_requests()
	{
		$this->db->where("status =", 0);
		$response = $this->db->get("withdraw_request")->result_array();
		return $response;
	}
	function get_approved_withdraw_requests()
	{
		// $this->db->where('status', 1);
		$response = $this->db->get("withdraw_request")->result_array();
		return $response;
	}

	function get_earning_requests()
	{

		$response = $this->db->get("transaction")->result_array();
		return $response;
	}
	function get_earning_requests_agent()
	{

		$response = $this->db->get("agent_transaction")->result_array();
		return $response;
	}

	function get_withdraw_game_requests()
	{

		$response = $this->db->get("withdraw_game_request")->result_array();
		return $response;
	}

	function get_withdraw_whatsapp_requests()
	{
		$this->db->where('status', 0);
		$response = $this->db->get("withdraw_whatsapp_request")->result_array();
		return $response;
	}
	function get_withdraw_whatsapp_history()
	{

		$this->db->where('status !=', 0);
		$response = $this->db->get("withdraw_whatsapp_request")->result_array();
		return $response;
	}
	function get_withdraw_whatsapp_history_by_date($fdate = false, $ldate = false)
	{
		if ($fdate || $ldate) {
			$this->db->where('created_at >=', $fdate);
			$this->db->where('created_at <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$this->db->where('status !=', 0);
		$response = $this->db->get("withdraw_whatsapp_request")->result_array();
		return $response;
	}


	function get_withdraw_app_requests()
	{

		$response = $this->db->get("withdraw_app_request")->result_array();
		return $response;
	}


	function get_withdraw_spining_requests()
	{

		$response = $this->db->get("withdraw_spining_request")->result_array();
		return $response;
	}

	function updateuser($id, $data)
	{
		$this->db->where('id', $id);
		$query = $this->db->update('users', $data);

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	function updateAllUser($data)
	{

		$query = $this->db->update('users', $data);

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}

	function getpackagecount($id)
	{
		$this->db->where("package_id", $id);
		$data = $this->db->get("sales")->num_rows();
		return $data ? $data : 0;
	}
	function getSoldPack()
	{

		$data = $this->db->get("sales")->num_rows();
		return $data ? $data : 0;
	}
	function usersleverage()
	{
		$response = $this->db->get("max_amount")->result_array();
		return $response;
	}
	function updateslip($id, $data)
	{
		$this->db->where('id', $id);
		$this->db->update('withdraw_request', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {

			return false;
		}
	}
	function get_single_withdrawal($id)
	{
		$this->db->where("id", $id);
		$query = $this->db->get("withdraw_request")->row_array();
		return $query;
	}
	function get_blogs()
	{
		$query = $this->db->get("posts")->result_array();
		return $query;
	}
	function get_post_details($id)
	{
		$this->db->where("id", $id);
		$query = $this->db->get("posts")->row_array();
		return $query;
	}
	function update_post($id, $data)
	{
		$this->db->where('id', $id);
		$this->db->update('posts', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {

			return false;
		}
	}
	function get_loans()
	{
		$query = $this->db->get("loan")->result_array();
		return $query;
	}
	function get_loan_details($id)
	{
		$this->db->where("id", $id);
		$query = $this->db->get("loan")->row_array();
		return $query;
	}
	function update_loan($id, $data)
	{
		$this->db->where('id', $id);
		$this->db->update('loan', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {

			return false;
		}
	}

	function get_topup_deposit_history()
	{

		$this->db->where('wallet_type', 'Deposit');
		$this->db->where('wallet', 'Topup');
		$response = $this->db->get("transferhistory")->result_array();
		return $response;
	}
	function get_topup_deduct_history()
	{
		$this->db->where('wallet_type', 'Deduct');
		$this->db->where('wallet', 'Topup');
		$response = $this->db->get("transferhistory")->result_array();
		return $response;
	}
	function add_earning_amount($userId, $data)
	{
		$user = $this->Members->get_user_earning($userId);
		if ($user) {
			$response = $this->db->query("UPDATE ewallet SET amount = amount + {$data["amount"]} WHERE user_id = {$userId}");
			//$response = $query->result_array();
		} else {
			$response = $this->db->insert('ewallet', $data);
		}
		return $response;
	}

	function substract_ewallet_amount($userId, $amount)
	{
		$user = $this->Members->get_user_earning($userId);
		$response = false;
		if ($user) {
			$response = $this->db->query("UPDATE ewallet SET amount = amount - {$amount} WHERE user_id = {$userId}");
			//$response = $query->result_array();
		}
		return $response;
	}
	function add_ewallet_history_entry($data)
	{
		$response = $this->db->insert("ewallet_history", $data);
		return $response;
	}

	function get_ewallet_deposit_history()
	{

		$this->db->where('wallet_type', 'Deposit');
		$this->db->where('wallet', 'ewallet');
		$response = $this->db->get("transferhistory")->result_array();
		return $response;
	}
	function get_ewallet_deduct_history()
	{
		$this->db->where('wallet_type', 'Deduct');
		$this->db->where('wallet', 'ewallet');
		$response = $this->db->get("transferhistory")->result_array();
		return $response;
	}

	public function get_mpesa_response()
	{



		$this->db->order_by('id', 'desc');
		$query = $this->db->get("mpesa_response");
		return $query->result_array();
	}

	function get_app_ss_request()
	{

		$response = $this->db->get("app_ss")->result_array();
		return $response;
	}

	public function update_app_ss_request($id, $data)
	{

		$this->db->where('id', $id);
		$this->db->update('app_ss', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {

			return false;
		}
	}

	function getsingleRow_app_ss($id)
	{

		$this->db->where("id", $id);
		$query = $this->db->get("app_ss")->row_array();
		return $query;
	}

	function get_spining_report()
	{
		$this->db->order_by("id", "desc");
		$query = $this->db->get("spining_wheel_rewards")->result_array();
		return $query;
	}
	function topEarnedUsers()
	{

		$this->db->select('*');
		$this->db->where('created_at BETWEEN DATE_SUB(NOW(), INTERVAL 15 DAY) AND NOW()');
		$this->db->where("status", 1);
		$query = $this->db->get("withdraw_request");

		return $query->result_array();
	}

	function topEarned()
	{

		$this->db->order_by('amount', 'desc');
		$this->db->select('*');
		$this->db->where("status", 1);

		$query = $this->db->get("withdraw_request");

		return $query->result_array();
	}
	function sumSameRows($user_id)
	{

		$this->db->select_sum('amount');
		$this->db->where("status", 1);
		$this->db->where("user_id", $user_id);
		$result = $this->db->get('withdraw_request')->row();
		return $result->amount;
	}

	public function getDeniedUsers()
	{


		$this->db->where("withdraw_status", 0);
		$result = $this->db->get('users')->result_array();
		return $result;
	}

	public function getactiveusers()

	{



		$result = $this->db->get("sales")->result_array();

		return $result;
	}

	public function getAllusers()

	{
		$this->db->where('role', 2);
		return $result = $this->db->get("users")->result_array();
	}
	public function clearWhatsAppEarnigs()
	{


		return $this->db->empty_table('whatsapp_earning');
	}


	public function getBankLogs()
	{

		$result = $this->db->get("bank_logs")->result_array();
		return $result;
	}
	public function addBankLogs($data)
	{

		$query = $this->db->insert('bank_logs', $data);
		return $query;
	}
	public function getSingleRowBankLog($id)
	{
		$this->db->where('id', $id);
		$result = $this->db->get("bank_logs")->row_array();
		return $result;
	}

	public function updateBankLog($id, $data)
	{

		$this->db->where('id', $id);
		$this->db->update('bank_logs', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {

			return false;
		}
	}

	public function getUSAPaypal()
	{

		$result = $this->db->get("usa_paypal")->result_array();
		return $result;
	}
	public function addUSAPaypal($data)
	{

		$query = $this->db->insert('usa_paypal', $data);
		return $query;
	}

	public function getSingleRowUSAPaypal($id)
	{
		$this->db->where('id', $id);
		$result = $this->db->get("usa_paypal")->row_array();
		return $result;
	}

	public function updateUSAPaypal($id, $data)
	{

		$this->db->where('id', $id);
		$this->db->update('usa_paypal', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {

			return false;
		}
	}

	public function getMasterCard()
	{

		$result = $this->db->get("master_card")->result_array();
		return $result;
	}
	public function addMasterCard($data)
	{

		$query = $this->db->insert('master_card', $data);
		return $query;
	}

	public function getSingleRowMasterCard($id)
	{
		$this->db->where('id', $id);
		$result = $this->db->get("master_card")->row_array();
		return $result;
	}

	public function updateMasterCard($id, $data)
	{

		$this->db->where('id', $id);
		$this->db->update('master_card', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {

			return false;
		}
	}

	public function getVisa()
	{

		$result = $this->db->get("visa_card")->result_array();
		return $result;
	}
	public function addVisa($data)
	{

		$query = $this->db->insert('visa_card', $data);
		return $query;
	}

	public function getSingleRowVisa($id)
	{
		$this->db->where('id', $id);
		$result = $this->db->get("visa_card")->row_array();
		return $result;
	}

	public function updateVisa($id, $data)
	{

		$this->db->where('id', $id);
		$this->db->update('visa_card', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {

			return false;
		}
	}

	public function add_adm_msg_all_users($data)
	{
		if ($this->db->insert('adm_msg_all_users', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('adm_msg_all_users', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}

	function wallet_transfer_history_all()

	{



		$this->db->where("type", "sent");
		$query = $this->db->get("wallet_funds_transfer")->result_array();

		return $query;
	}

	function wallet_transfer_history_all_by_date($fdate = false, $ldate = false)

	{

		if ($fdate || $ldate) {
			$this->db->where('created_at >=', $fdate);
			$this->db->where('created_at <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$this->db->where("type", "sent");
		$query = $this->db->get("wallet_funds_transfer")->result_array();

		return $query;
	}

	public function block_users()
	{
		$this->db->where('is_blocked', 0);
		$query = $this->db->get('users');
		return $query->result_array();
	}

	// public function (){
	// 	$this->db->order_by('id', 'RANDOM');
	// 	$this->db->where('document_update', 1);
	// 	$query = $this->db->get('users');
	// 	return $query->result_array();
	// }

	public function get_agent_verification_request()
	{

		$this->db->order_by('id', 'desc');
		$this->db->where('status', 0);
		$query = $this->db->get('agent_verification')->result_array();
		return $query;
	}

	public function get_approved_agent_verification_requests()
	{

		$this->db->where('status', 1);
		$query = $this->db->get('agent_verification');
		return $query->result_array();
	}
	function update_agent_verification_request($id, $data)
	{
		$this->db->where('id', $id);
		$query = $this->db->update('agent_verification', $data);

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	public function get_all_pending_agent_verification_request()
	{

		$this->db->order_by('id', 'desc');
		$this->db->where('status', 0);
		$query = $this->db->get('agent_verification')->result_array();
		return $query;
	}
	public function get_single_row_agent($id)
	{

		$this->db->where('id', $id);
		$query = $this->db->get('agent_verification');
		return $query->row_array();
	}

	public function get_history_agent()
	{

		$this->db->where('status !=', 0);
		$query = $this->db->get('agent_verification');
		return $query->result_array();
	}

	public function get_history_agent_by_date($fdate = false, $ldate = false)
	{


		if ($fdate || $ldate) {
			$this->db->where('date >=', $fdate);
			$this->db->where('date <=', $ldate);
		}
		$this->db->where('status !=', 0);
		$this->db->order_by('id', 'desc');
		$query = $this->db->get('agent_verification');
		return $query->result_array();
	}

	public function get_paypal_verification_request()
	{

		$this->db->order_by('id', 'desc');
		$this->db->where('status', 0);
		$query = $this->db->get('paypal_verification')->result_array();
		return $query;
	}

	function update_paypal_verification_request($id, $data)
	{
		$this->db->where('id', $id);
		$query = $this->db->update('paypal_verification', $data);

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}

	public function get_single_row_paypal($id)
	{

		$this->db->where('id', $id);
		$query = $this->db->get('paypal_verification');
		return $query->row_array();
	}

	public function get_history_paypal()
	{

		$this->db->where('status !=', 0);
		$query = $this->db->get('paypal_verification');
		return $query->result_array();
	}

	public function get_history_paypal_by_date($fdate = false, $ldate = false)
	{

		if ($fdate || $ldate) {
			$this->db->where('date >=', $fdate);
			$this->db->where('date <=', $ldate);
		}

		$this->db->order_by('id', 'desc');

		$this->db->where('status !=', 0);
		$query = $this->db->get('paypal_verification');
		return $query->result_array();
	}


	function get_withdraw_paypal_requests()
	{

		$response = $this->db->get("withdraw_paypal_request")->result_array();
		return $response;
	}

	function get_paypal_withdraw_details($id)
	{
		$this->db->where("id", $id);
		$result = $this->db->get("withdraw_paypal_request")->row_array();
		return $result;
	}

	function update_paypal_withdraw($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("withdraw_paypal_request", $data);
		return $resp;
	}

	function get_unlock_package_history()
	{

		$response = $this->db->get("unlock_sales")->result_array();
		return $response;
	}

	function get_unlock_package_history_by_date($fdate = false, $ldate = false)
	{

		if ($fdate || $ldate) {
			$this->db->where('purchase_date >=', $fdate);
			$this->db->where('purchase_date <=', $ldate);
		}

		$this->db->order_by('id', 'desc');
		$response = $this->db->get("unlock_sales")->result_array();
		return $response;
	}

	function get_verification_package_history()
	{

		$response = $this->db->get("verification_sales")->result_array();
		return $response;
	}

	function get_verification_package_history_by_date($fdate = false, $ldate = false)
	{

		if ($fdate || $ldate) {
			$this->db->where('purchase_date >=', $fdate);
			$this->db->where('purchase_date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');

		$response = $this->db->get("verification_sales")->result_array();
		return $response;
	}

	public function get_all_pending_paypal_request()
	{

		$this->db->order_by('id', 'desc');
		$this->db->where('status', 0);
		$query = $this->db->get('paypal_verification')->result_array();
		return $query;
	}

	function get_paypal_package_history()
	{

		$response = $this->db->get("paypal_login_sales")->result_array();
		return $response;
	}

	function get_paypal_package_history_by_date($fdate = false, $ldate = false)
	{
		if ($fdate || $ldate) {
			$this->db->where('purchase_date >=', $fdate);
			$this->db->where('purchase_date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$response = $this->db->get("paypal_login_sales")->result_array();
		return $response;
	}


	public function get_transfer_blocked_users()
	{


		$this->db->where('transfer_block', 0);
		$query = $this->db->get('users')->result_array();
		return $query;
	}

	function get_withdraw_compounding_requests()
	{
		$this->db->where('status', 0);
		$response = $this->db->get("compounding_withdraw")->result_array();
		return $response;
	}
	function get_withdraw_compounding_history()
	{
		$this->db->where('status !=', 0);
		$response = $this->db->get("compounding_withdraw")->result_array();
		return $response;
	}

	function update_compound_withdraw($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("compounding_withdraw", $data);
		return $resp;
	}
	function get_compound_withdraw_details($id)
	{
		$this->db->where("id", $id);
		$result = $this->db->get("compounding_withdraw")->row_array();
		return $result;
	}

	public function add_email_msg_to_all($data)
	{
		if ($this->db->insert('email_msg', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('email_msg', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}


	# shop

	public function add_product($data)
	{
		if ($this->db->insert('products', $data)) {
			$id = $this->db->insert_id();
			$cid = $this->db->get_where('products', array('id' => $id))->row_array();
			return $cid;
		} else {
			return false;
		}
	}
	public function add_category($data)
	{
		if ($this->db->insert('category', $data)) {
			$id = $this->db->insert_id();
			$cid = $this->db->get_where('category', array('id' => $id))->row_array();
			return $cid;
		} else {
			return false;
		}
	}

	public function get_all_categories()
	{

		$this->db->order_by("id", "desc");
		$this->db->where('status', 1);
		$query = $this->db->get('category');
		return $query->result_array();
	}
	public function getAllProducts()
	{

		$this->db->order_by("id", "desc");
		$this->db->where('status', 1);
		$query = $this->db->get('products');
		return $query->result_array();
	}


	public function getSingleProductById($id)
	{

		$data = $this->db->get_where('products',  array('id' => $id))->row_array();
		return $data ? $data : false;
	}

	public function update_products($id, $data)
	{

		$this->db->where('id', $id);
		$this->db->update("products", $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	public function update_orders($id, $data)
	{

		$this->db->where('id', $id);
		$this->db->update("orders", $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	public function update_orders_by_payment($id, $data)
	{

		$this->db->where('payment_id', $id);
		$this->db->update("orders", $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	function get_changed_sponsor_enabled()
	{
		$this->db->where('sponsor_settings', 1);
		$response = $this->db->get("users")->result_array();
		return $response;
	}

	public function get_all_orders()
	{
		$data = $this->db->get('orders')->result_array();
		return $data ? $data : false;
	}

	public function get_all_orders_by_status($status)
	{
		$this->db->where('status', $status);
		$data = $this->db->get('orders')->result_array();
		return $data ? $data : false;
	}

	public function get_all_pending_orders()
	{
		$this->db->where('status', 0);
		$data = $this->db->get('orders')->result_array();
		return $data ? $data : false;
	}


	public function get_all_fund_requests_deposit()
	{
		$data = $this->db->get("mpesa_deposit")->result_array();
		return $data;
	}

	function update_status_deposit($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("mpesa_deposit", $data);
		return $resp;
	}
	function get_row_by_id_deposit($id)
	{
		$result = $this->db->get_where('mpesa_deposit', array('id' => $id))->row_array();
		return $result;
	}
	function get_compounding_report()
	{

		$result = $this->db->get("compounding_roi")->result_array();
		return $result;
	}

	function get_all_commission_roi()
	{

		$this->db->order_by('id', 'DESC');
		$query = $this->db->get('compounding_direct_bonus');
		$data =  $query->result_array();
		return $data ? $data : false;
	}

	function get_enabled_users_for_user_to_user_noti()
	{
		$this->db->where('user_to_user_notification', 1);
		$response = $this->db->get("users")->result_array();
		return $response;
	}

	public function get_all_fund_deposits()
	{

		$this->db->order_by('id', 'DESC');
		$this->db->where('status', 1);
		$this->db->where('marked', 1);
		$data = $this->db->get("mpesa_deposit")->result_array();
		return $data;
	}

	public function get_all_fund_deposits_by_date($fdate = false, $ldate = false)
	{
		if ($fdate || $ldate) {
			$this->db->where('created_at >=', $fdate);
			$this->db->where('created_at <=', $ldate);
		}
		$this->db->order_by('id', 'DESC');
		$this->db->where('status', 1);
		$this->db->where('marked', 1);
		$data = $this->db->get("mpesa_deposit")->result_array();
		return $data;
	}

	public function get_all_fund_response_by_date($fdate = false, $ldate = false)
	{
		if ($fdate || $ldate) {
			$this->db->where('created_at >=', $fdate);
			$this->db->where('created_at <=', $ldate);
		}

		$this->db->where('status', 1);
		$this->db->where('marked', 1);
		$this->db->order_by('id', 'desc');
		$data = $this->db->get("mpesa_deposit")->result_array();
		return $data;
	}

	function get_all_approved_withdraw_requests($fdate = false, $ldate = false)
	{
		if ($fdate || $ldate) {
			$this->db->where('created_at >=', $fdate);
			$this->db->where('created_at <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$this->db->where('status =', 1);
		$response = $this->db->get("withdraw_request")->result_array();
		return $response;
	}

	function get_all_reject_withdraw_requests($fdate = false, $ldate = false)
	{
		if ($fdate || $ldate) {
			$this->db->where('created_at >=', $fdate);
			$this->db->where('created_at <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$this->db->where('status =', 2);
		$response = $this->db->get("withdraw_request")->result_array();
		return $response;
	}

	function get_earning_requests_by_date($fdate = false, $ldate = false)
	{
		if ($fdate || $ldate) {
			$this->db->where('date >=', $fdate);
			$this->db->where('date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$response = $this->db->get("transaction")->result_array();
		return $response;
	}
	function get_earning_requests_agent_by_date($fdate = false, $ldate = false)
	{
		if ($fdate || $ldate) {
			$this->db->where('date >=', $fdate);
			$this->db->where('date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$response = $this->db->get("agent_transaction")->result_array();
		return $response;
	}

	public function get_approved_whatsapp_requests_by_date($fdate = false, $ldate = false)
	{

		if ($fdate || $ldate) {
			$this->db->where('date >=', $fdate);
			$this->db->where('date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$this->db->where('status', 1);
		$query = $this->db->get('whatsapp_request');
		return $query->result_array();
	}
	public function getactiveusers_by_date($fdate = false, $ldate = false)

	{
		if ($fdate || $ldate) {
			$this->db->where('purchase_date >=', $fdate);
			$this->db->where('purchase_date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$result = $this->db->get("sales")->result_array();
		return $result;
	}
	public function getAllusers_by_date($fdate = false, $ldate = false)

	{

		if ($fdate || $ldate) {
			$this->db->where('register_date >=', $fdate);
			$this->db->where('register_date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$this->db->where('role', 2);
		return $result = $this->db->get("users")->result_array();
	}

	function get_topup_deposit_history_by_date($fdate = false, $ldate = false)
	{

		if ($fdate || $ldate) {
			$this->db->where('date >=', $fdate);
			$this->db->where('date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$this->db->where('wallet_type', 'Deposit');
		$this->db->where('wallet', 'Topup');
		$response = $this->db->get("transferhistory")->result_array();
		return $response;
	}
	function get_topup_deduct_history_by_date($fdate = false, $ldate = false)
	{

		if ($fdate || $ldate) {
			$this->db->where('date >=', $fdate);
			$this->db->where('date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$this->db->where('wallet_type', 'Deduct');
		$this->db->where('wallet', 'Topup');
		$response = $this->db->get("transferhistory")->result_array();
		return $response;
	}

	function get_ewallet_deposit_history_by_date($fdate = false, $ldate = false)
	{

		if ($fdate || $ldate) {
			$this->db->where('date >=', $fdate);
			$this->db->where('date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');

		$this->db->where('wallet_type', 'Deposit');
		$this->db->where('wallet', 'ewallet');
		$response = $this->db->get("transferhistory")->result_array();
		return $response;
	}
	function get_ewallet_deduct_history_by_date($fdate = false, $ldate = false)
	{

		if ($fdate || $ldate) {
			$this->db->where('date >=', $fdate);
			$this->db->where('date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');
		$this->db->where('wallet_type', 'Deduct');
		$this->db->where('wallet', 'ewallet');
		$response = $this->db->get("transferhistory")->result_array();
		return $response;
	}

	public function get_history_google_ads_by_date($fdate = false, $ldate = false)
	{

		if ($fdate || $ldate) {
			$this->db->where('purchase_date >=', $fdate);
			$this->db->where('purchase_date <=', $ldate);
		}

		$this->db->order_by('id', 'desc');
		$query = $this->db->get('google_sales');
		return $query->result_array();
	}
	public function get_history_ow_by_date($fdate = false, $ldate = false)
	{

		if ($fdate || $ldate) {
			$this->db->where('purchase_date >=', $fdate);
			$this->db->where('purchase_date <=', $ldate);
		}

		$this->db->order_by('id', 'desc');
		$query = $this->db->get('online_writing_sales');
		return $query->result_array();
	}
	public function get_allowed_users()
	{
		$this->db->where('whatsapp_req', 1);
		$query = $this->db->get('users');
		return $query->result_array();
	}

	public function add_admin($data)
	{
		if ($this->db->insert('admin_details', $data)) {
			$id = $this->db->insert_id();
			$user = $this->db->get_where('users', array('id' => $id))->row_array();
			return $user;
		}
		return false;
	}
	public function getActivationDate($id)
	{
		$this->db->where('user_id', $id);
		$user = $this->db->get('sales')->row_array();
		return $user;
	}
	public function update_sponsor($userid, $sponsorid)
	{
		$this->db->set('referral_id', $sponsorid);
		$this->db->where('user_id', $userid);
		$query = $this->db->update('user_logs');
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	public function get_all_sub_admin()
	{

		$this->db->where('id !=', 4);
		$data = $this->db->get("admin_details")->result_array();
		return $data;
	}
	public function delete_subadmin($id)
	{
		// Assuming 'subadmins' is the name of your table containing subadmins
		$this->db->where('id', $id);
		$this->db->delete('admin_details');

		// Check if any row was affected
		if ($this->db->affected_rows() > 0) {
			return true; // Deleted successfully
		} else {
			return false; // Deletion failed
		}
	}
	//    function updatesub_admin($id, $data)
	// {
	// 	$this->db->where('id', $id);
	// 	$query = $this->db->update('admin_details', $data);

	// 	if ($this->db->affected_rows()) {
	// 		return true;
	// 	} else {
	// 		return false;
	// 	}
	// }
	public function updatesub_admin($id, $data)
	{
		$this->db->where('id', $id);
		if ($this->db->update('admin_details', $data)) {
			// Check if any rows were affected by the update
			if ($this->db->affected_rows() > 0) {
				// Fetch the updated user data
				$updated_user = $this->db->get_where('admin_details', array('id' => $id))->row_array();
				return $updated_user;
			} else {
				// No rows were affected by the update
				return false;
			}
		} else {
			// Update query failed
			return false;
		}
	}

	function getadmindetails($id)

	{

		$this->db->where("id", $id);

		$data = $this->db->get("admin_details")->row_array();

		return $data ? $data : false;
	}

	function get_all_kyc_already_exists()
	{

		$this->db->order_by('id', 'DESC');
		$this->db->where("status", 0);
		$query = $this->db->get('kyc');
		$data =  $query->result_array();
		return $data ? $data : false;
	}
	function get_all_kyc_already_exists_accpeted()
	{

		$this->db->order_by('id', 'DESC');
		$this->db->where("status !=", 0);
		$query = $this->db->get('kyc');
		$data =  $query->result_array();
		return $data ? $data : false;
	}

	public function update_kyc($id, $sponsorid)
	{
		$this->db->set('status', $sponsorid);
		$this->db->where('id', $id);
		$query = $this->db->update('kyc');
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}

	function get_all_forex_withdrawal()
	{

		$this->db->order_by('id', 'DESC');
		$this->db->where('status', 0);
		$query = $this->db->get('withdraw_request_forex');
		$data =  $query->result_array();
		return $data ? $data : false;
	}
	function get_all_approved_forex_withdrawal()
	{

		$this->db->order_by('id', 'DESC');
		$this->db->where('status', 1);
		$query = $this->db->get('withdraw_request_forex');
		$data =  $query->result_array();
		return $data ? $data : false;
	}

	function get_single_withdrawal_forex($id)
	{
		$this->db->order_by('id', 'DESC');
		$this->db->where('id', $id);
		$query = $this->db->get('withdraw_request_forex');
		$data =  $query->row_array();
		return $data ? $data : false;
	}

	public function update_forex_withdraw($id, $sponsorid)
	{
		$this->db->set('status', $sponsorid);
		$this->db->where('id', $id);
		$query = $this->db->update('withdraw_request_forex');
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}

	function get_forex_wallet_deposit_history_by_date($fdate = false, $ldate = false)
	{

		if ($fdate || $ldate) {
			$this->db->where('date >=', $fdate);
			$this->db->where('date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');

		$this->db->where('wallet_type', 'Deposit');
		$this->db->where('wallet', 'forex_wallet');
		$response = $this->db->get("transferhistory")->result_array();
		return $response;
	}

	function get_forex_wallet_deduct_history_by_date($fdate = false, $ldate = false)
	{

		if ($fdate || $ldate) {
			$this->db->where('date >=', $fdate);
			$this->db->where('date <=', $ldate);
		}
		$this->db->order_by('id', 'desc');

		$this->db->where('wallet_type', 'Deduct');
		$this->db->where('wallet', 'forex_wallet');
		$response = $this->db->get("transferhistory")->result_array();
		return $response;
	}

	function get_all_demo_balances()
	{
		return $this->db->get("demo_wallet")->result_array();
	}
	function get_all_demo_trader()
	{

		$this->db->where('demo_trading', 1);
		return $this->db->get("users")->result_array();
	}
	function get_all_demo_withdrawal()
	{

		$this->db->order_by('id', 'DESC');
		$this->db->where('status', 0);
		$query = $this->db->get('withdraw_request_demo');
		$data =  $query->result_array();
		return $data ? $data : false;
	}

	function get_all_approved_demo_withdrawal()
	{

		$this->db->order_by('id', 'DESC');
		$this->db->where('status', 1);
		$query = $this->db->get('withdraw_request_demo');
		$data =  $query->result_array();
		return $data ? $data : false;
	}

	function get_single_withdrawal_demo($id)
	{
		$this->db->order_by('id', 'DESC');
		$this->db->where('id', $id);
		$query = $this->db->get('withdraw_request_demo');
		$data =  $query->row_array();
		return $data ? $data : false;
	}

	public function update_demo_withdraw($id, $sponsorid)
	{
		$this->db->set('status', $sponsorid);
		$this->db->where('id', $id);
		$query = $this->db->update('withdraw_request_demo');
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}

	public function add_jobs($data)
	{
		return $this->db->insert('jobs', $data);
	}

	public function get_all_jobs()
	{
		$this->db->where('status', 1);
		return $this->db->get('jobs')->result_array();
	}
	public function delete_job($id)
	{
		$this->db->set('status', 0);
		$this->db->where('id', $id);
		$query = $this->db->update('jobs');
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}

	function get_refferal_emails()
	{
		$this->db->where('refferal_email', 1);
		$response = $this->db->get("users")->result_array();
		return $response;
	}


	public function get_all_online_tasks()
	{
		$this->db->where('status', 1);
		return $this->db->get('online_tasks')->result_array();
	}

	public function get_all_online_tasks_applied()
	{
		// $this->db->where('status', 1);
		return $this->db->get('online_tasks_apply')->result_array();
	}
	public function get_task_by_id($id)
	{
		$this->db->where('id', $id);
		return $this->db->get('online_tasks_apply')->row_array();
	}

	public function add_online_tasks($data)
	{
		return $this->db->insert('online_tasks', $data);
	}

	public function update_task_by_taskid($id, $data)
	{

		$this->db->where('task_id', $id);
		$query = $this->db->update('online_tasks_apply', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	public function update_task_by_id($id, $data)
	{

		$this->db->where('id', $id);
		$query = $this->db->update('online_tasks_apply', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}


	public function get_all_completed_tasks_applied()
	{
		// $this->db->where('status', 1);
		return $this->db->get('online_tasks_completed')->result_array();
	}

	public function get_comp_task_by_id($id)
	{
		$this->db->where('id', $id);
		return $this->db->get('online_tasks_completed')->row_array();
	}

	public function update_comp_task_by_id($id, $data)
	{

		$this->db->where('id', $id);
		$query = $this->db->update('online_tasks_completed', $data);
		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}
	function get_karibu_withdraw_details($id)
	{
		$this->db->where("id", $id);
		$result = $this->db->get("withdraw_karibu_request")->row_array();
		return $result;
	}
	function update_karibu_withdraw($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("withdraw_karibu_request", $data);
		return $resp;
	}

	function get_withdraw_karibu_requests()
	{

		$response = $this->db->get("withdraw_karibu_request")->result_array();
		return $response;
	}

	function updateGameuser($id, $data)
	{
		$this->db->where('id', $id);
		$query = $this->db->update('game_users', $data);

		if ($this->db->affected_rows()) {
			return true;
		} else {
			return false;
		}
	}

	public function get_all_fund_requests_deposit_game()
	{
		$data = $this->db->get("game_mpesa_deposit")->result_array();
		return $data;
	}

	function update_status_deposit_game($id, $data)
	{
		$this->db->where("id", $id);
		$resp = $this->db->update("game_mpesa_deposit", $data);
		return $resp;
	}

	function get_row_by_id_deposit_game($id)
	{
		$result = $this->db->get_where('game_mpesa_deposit', array('id' => $id))->row_array();
		return $result;
	}

	public function get_all_fund_deposits_by_date_game()
	{

		$this->db->order_by('id', 'DESC');
		$this->db->where('status', 1);
		$this->db->where('marked', 1);
		$data = $this->db->get("game_mpesa_deposit")->result_array();
		return $data;
	}
}
