<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');


class Ujumbesms
{
    public $apiKey;
    public $email;
    public $senderID;

    /**
     * @var string $message Error message of message from the API
     */
    public $message;
    /**
     * @var mixed $response Response from the API
     */
    public $response = "";

    public function __construct()
    {
        $this->apiKey = "NzhjMTM2NzM5MGMwYzdmNDAwYmM0NWM0ODQyY2Zl";
        $this->email = "motendejunior@gmail.com";
        $this->senderID = "SURELIFE";
        $this->message = "";
    }

    /**
     * @param string $url URL to send data
     * @param array $data Data to send
     * @return bool|string
     */
    public function sendRequest($url, $data)
    {
        $data = json_encode($data);
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_HTTPHEADER, array('Content-Type: application/json','X-Authorization: '.$this->apiKey,'email: '.$this->email));
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($curl, CURLOPT_POST, TRUE);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);

        $response = curl_exec($curl);
        curl_close($curl);

        return $response;
    }

    public function sendSMS(string $phone, string $message): bool
    {
        $phone = str_replace(
            [' ', '<', '>', '&', '{', '}', '*', '-', '_', '!', '@', '#', "$", '%', '^', '&', '='],
            '', $phone); //Special characters are a b*tch

        $numbers = explode(',', $phone);
        $validated_numbers = [];
        if (is_array($numbers)) {
            foreach ($numbers as $number) {
                if (!$this->validateKenyanPhoneNumber($number)){
                    $this->message = "The phone number '{$number}' is not a valid Kenyan phone number";
                    return FALSE;
                }
                $validated_numbers[] = $number;
            }
        } else {
            if (!$this->validateKenyanPhoneNumber($numbers)){
                $this->message = "The phone number '{$numbers}' is not a valid Kenyan phone number";
                return FALSE;
            }
            $validated_numbers[] = $numbers;
        }

        $phone = implode(',', $validated_numbers);

        $data = [
            'data'  => [
                [
                    'message_bag'   => [
                        'numbers'   => $phone,
                        'message'   => $message,
                        'sender'    => $this->senderID
                    ]
                ]
            ]
        ];

        $url = "https://ujumbesms.co.ke/api/messaging";

        $response = $this->sendRequest($url, $data);

        if ($response) {
            $res = json_decode($response);
            $this->message = $res->status->description;
            $this->response = $res;
            if ($res->status->type == 'success') {
                return TRUE;
            } else {
                return FALSE;
            }
        } else {
            $this->message = "No response from API";
            return FALSE;
        }

    }

    public function validateKenyanPhoneNumber($number): bool
    {
        if ($this->startsWith($number, '0') && strlen($number) == 10) {
            return TRUE;
        }

        if ($this->startsWith($number, '254') && strlen($number) == 12) {
            return TRUE;
        }

        if ($this->startsWith($number, '+254') && strlen($number) == 13) {
            return TRUE;
        }

        return FALSE;
    }

    private function startsWith($haystack, $needle)
    {
        $length = strlen( $needle );
        return substr( $haystack, 0, $length ) === $needle;
    }
}
