<?php

class Helpers
{
	static function flash($cssClass, $message, $extraClass='') {
        $res = array();
        if($cssClass && $message) {
            $res = array("class"=>$cssClass, "message"=>$message, "extraClass"=>$extraClass);
        }
        return $res;
    }
    static function showFlash($flash) {
        return "<div class='alert alert-".$flash['class']." ".$flash['extraClass']. "'>".$flash['message']."</div>";
    }
    static function user_id() {
        $ci =& get_instance();
        if(isset($ci->session->userdata["user"])) {
            $user = $ci->session->userdata["user"];
            return $user;
        }
    }
     static function get_notification($user_id)
    {
        $ci = & get_instance();
        $ci->load->model('Members');
        $notification = $ci->Members->get_notification($user_id);
        return $notification;
    }
    static function getreferrallink()
    {
        $cid = self::user_id();
        $link = base_url().'auth/register?ref='.$cid["username"];
        return $link;
    }
        static function generateLink($url=false) {
        $link = '#';
        if($url) {
            $link = base_url().'member/'.$url;
        }
        return $link;
    }
    static function generateUniqueRefId($length = false) {
        $length = $length ? $length:6;
        $ci =& get_instance();
        $ci->load->helper('string');
        $code = random_string('alnum', $length);
        $uniqueCode = $code;
        return $uniqueCode;
    }
        static function date($date = false) {
        $res = false;
        if($date)
            $res =  date ('F d, Y ',strtotime($date));
        else
            $res = date('Y-m-d H:i:s');
        return $res;
    }
    static function getuserbyusername($username)
    {
        $ci = & get_instance();
        $ci->load->model('Members');
        $username = $ci->Members->getuserbyuname($username);
        return $username;
    }
     static function getuserbyphone($phone)
    {
        $ci = & get_instance();
        $ci->load->model('Adm');
        $username = $ci->Adm->getuserbyphone($phone);
        return $username;
    }
    static function getAdmin($model = false) {
        $ci =& get_instance();
        $ci->load->model('Users');
        $adminUser = $ci->Users->getAdminAccount();
        return $model ? $adminUser : $adminUser["id"];
    }
    static function getUserObj($uid=false) {
        $cid = self::user_id();
        $uid = $uid ? $uid : $cid["id"];
        $ci =& get_instance();
        $ci->load->model('Users');
        $user = $ci->Users->getUserById($uid);
        return $user;
    }
    static function totalusers()
    {
        $ci = & get_instance();
        $ci->load->model('Members');
        $totalusers = $ci->Members->gettotalusers();
        return $totalusers ? $totalusers : 0;
    }
    static function totalpaidusers()
    {
        $ci = & get_instance();
        $ci->load->model('Members');
        $totalpaidusers = $ci->Members->gettotalpaidusers();
        return $totalpaidusers ? $totalpaidusers : 0;
    }
    static function totalpackagesold()
    {
        $ci = & get_instance();
        $ci->load->model('Members');
        $totalpackagesold = $ci->Members->gettotalpackagesold();
        return $totalpackagesold ? $totalpackagesold : 0;
    }
    static function totalamountearned()
    {
        $ci = & get_instance();
        $ci->load->model('Members');
        $totalamountearned = $ci->Members->gettotalamountearned();
        return $totalamountearned ? $totalamountearned : 0;
    }
    static function userdetails($id)
    {
        $ci = & get_instance();
        $ci->load->model("Members");
        $user= $ci->Members->getuserdetails($id);
        return $user;
    }
    static function sendEmail($emailTitle,$userEmail, $viewMessage) {

        $ci =& get_instance();

        $ci->load->library('email');

        $config['protocol'] = 'sendmail';
        $config['mailpath'] = '/usr/sbin/sendmail';
        $config['charset'] = 'iso-8859-1';
        $config['wordwrap'] = TRUE;
        $ci->email->initialize($config);
        $ci->email->set_mailtype("html");
        $ci->email->set_newline("\r\n");

        //Email content

        $ci->email->to($userEmail);
        $ci->email->from('noreply@betterdine.net','BetterDine');
        $ci->email->subject($emailTitle);
        $ci->email->message($viewMessage);

        //Send email
        $ci->email->send();
    }

    static function send_sms($phoneNumber, $message)
    {
        $endpoint   = 'https://account.softwareske.com/smsAPI?sendsms&';
        $_apiEndpointStatus = 'https://account.softwareske.com/smsAPI?groupstatus&';
        $_apiCreateContact  = 'https://account.softwareske.com/smsAPI?create_contact&';
        $_route             = 0;
        $apiKey     = 'd0Oz1taBbqzKggGrOm9IcKDWftDTIXd0';
        $apiToken   = '6cpe1632480621';
        $senderID   = 'BETTERDINE';
        // $phoneNumber = "+254746899412";
        // $message ="Welcome Jesse";

        $params = http_build_query([

            'apikey'       => $apiKey,
            'apitoken'     => $apiToken,
            'type'         => 'sms',
            'from'         => $senderID,
            'to'           => $phoneNumber,
            'text'         => $message,
            'scheduledate' => date('Y-m-d H:i:s'),
            'route'        => $_route 

        ]);

        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $endpoint.$params);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array('application/x-www-form-urlencoded'));
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "GET");
        curl_setopt($ch, CURLOPT_CAINFO, getcwd() . "/cacert.cer");
        curl_setopt($ch, CURLOPT_VERBOSE,true);
        $response = curl_exec($ch);

        /*
        // enable the below to debug any boolean(false) response
        $res=(object)array(

        'response'  =>  curl_exec( $ch ),
        'info'      =>  curl_getinfo( $ch ),
        'errors'    =>  curl_error( $ch )
        );
        curl_close($ch);
        */

        $response = json_decode($response, true);
        if($response['status'] == "queued")
        {
            return true;
        }
        elseif ($response['status'] == "error") {
            return  $response['message'];
        }
        else {
            return false;
        }

    }

     static function settings()
    {
        $ci = & get_instance();
        $ci->load->model("adm");
        $settings = $ci->adm->get_settings();
        return $settings;
    }

     static function sumRows($uid)
    {
        $ci = & get_instance();
        $ci->load->model("adm");
        $total = $ci->adm->sumSameRows($uid);
        return $total;
    }


    
}
class MemberHelper
{

    static function getUserFromRefCode($data)
    {
        $ci = & get_instance();
        $ci->load->model("Members");
        $user= $ci->Members->getUserByRefCode($data);
        return $user? $user : 0;
    }
    static function user_wallet($id = false, $type = 'dollar') {
        $ci =& get_instance();
        $uid = helpers::user_id();
        $ci->load->model('Members');
        if($id)
        {
            $amount = $ci->Members->get_user_wallet($id);
        }
        else
        {
            $amount = $ci->Members->get_user_wallet($uid["id"]);
        }

        $walletAmount = $amount ? $amount['wallet_amount']: 0;

        return $walletAmount ? round($walletAmount, 2):0;
    }
    static function ewallet($id = false)
    {
        $uid = Helpers::user_id();
        $ci = & get_instance();
        $ci->load->model('Members');
        if($id)
        {
            $ewallet = $ci->Members->get_user_earning($id);
        }
        else
        {
            $ewallet = $ci->Members->get_user_earning($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }
     static function gamewallet($id = false)
    {
        $uid = Helpers::user_id();
        $ci = & get_instance();
        $ci->load->model('Members');
        if($id)
        {
            $ewallet = $ci->Members->get_game_earning($id);
        }
        else
        {
            $ewallet = $ci->Members->get_game_earning($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }

     static function app_earnings($id = false)
    {
        $uid = Helpers::user_id();
        $ci = & get_instance();
        $ci->load->model('Members');
        if($id)
        {
            $ewallet = $ci->Members->get_app_earning($id);
        }
        else
        {
            $ewallet = $ci->Members->get_app_earning($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }

      static function whatsapp_earnings($id = false)
    {
        $uid = Helpers::user_id();
        $ci = & get_instance();
        $ci->load->model('Members');
        if($id)
        {
            $ewallet = $ci->Members->get_whatsapp_earning($id);
        }
        else
        {
            $ewallet = $ci->Members->get_whatsapp_earning($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }

    static function spining_earnings($id = false)
    {
        $uid = Helpers::user_id();
        $ci = & get_instance();
        $ci->load->model('Members');
        if($id)
        {
            $ewallet = $ci->Members->get_spining_earning($id);
        }
        else
        {
            $ewallet = $ci->Members->get_spining_earning($uid["id"]);
        }
        return $ewallet ? round($ewallet["amount"], 2) : 0;
    }
    
    static function getAllPackages()
    {
        $ci = & get_instance();
        $ci->load->model('Members');
        $packages=$ci->Members->get_all_packages();
        return $packages;
    }
    static function getuserreferrals()
    {
        $uid = Helpers::user_id();
        $ci = & get_instance();
        $ci->load->model('Members');
        $query = $ci->Members->getreferrals($uid["id"]);
        return $query;
    }
    static function getuseractivemembers()
    {
        $uid = Helpers::user_id();
        $ci = & get_instance();
        $ci->load->model('Members');
        $query = $ci->Members->getactiveusers($uid["id"]);
        return $query;
    }
    static function gethighestpack($id = false)
    {
        $cid = Helpers::user_id();
        $uid = $id ? $id : $cid["id"];
        $ci = & get_instance();
        $ci->load->model('Members');
        $package = $ci->Members->gethighestpackage($uid);
        $packagename = $ci->Members->get_packagename($package["package_id"]);
        return $packagename;
    }
    
    static function packagename($id)
    {
        $uid = Helpers::user_id();
        $ci = & get_instance();
        $ci->load->model('Members');
        $packagename = $ci->Members->get_packagename($id);
        return $packagename["name"];
    }
      static function getref($id)
    {
        
        $ci = & get_instance();
        $ci->load->model('Members');
        $query = $ci->Members->getreferralsarray($id);
        return $query;
    }
    static function getsponsordetails($id = false)
    {
        $cid = Helpers::user_id();
        $uid = $id ? $id : $cid["id"];
        $ci = & get_instance();
        $ci->load->model('Members');
        $sponsor = $ci->Members->getsponsor($uid);
        return $sponsor;
    }
    static function amountwithdrawn($id = false)
    {
        $cid = Helpers::user_id();
        $uid = $id ? $id : $cid["id"];
        $ci = & get_instance();
        $ci->load->model('Members');
        $sponsor = $ci->Members->getamountwithdrawn($uid);
        return $sponsor;
    }
    static function checkpackbought($id = false)
    {
        $cid = Helpers::user_id();
        $uid = $id ? $id : $cid["id"];
        $ci = & get_instance();
        $ci->load->model('Members');
        $pack = $ci->Members->checkpackagebought($uid);
        return $pack;
    }

     static function checkpackboughtpremium($id = false)
    {
        $cid = Helpers::user_id();
        $uid = $id ? $id : $cid["id"];
        $ci = & get_instance();
        $ci->load->model('Members');
        $pack = $ci->Members->checkpackboughtpremium($uid);
        return $pack;
    }
    static function getearned(){

             $ci = & get_instance();
        $ci->load->model('Members');
        $sum = $ci->Members->get_ewallet_sum();
        return $sum['amount'];
    }
    

}


?>