<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Game extends CI_Controller
{

    function __construct()
    {

        parent::__construct();
        $this->load->model(array('Members', 'Adm'));
        $res =  $this->Members->getMailsFromDatabase();
        $this->lastHourMails =  $res ? count($res) : 0;
        $this->username = $this->session->userdata('user');
        $this->currency = $this->username ? $this->username['currency'] : "KES";
        $this->userId = Helpers::user_id();
        $this->load->library(array('paypal_lib', 'cart', 'mpesa'));
        if (!$this->username) {
            redirect('login');
        }
        date_default_timezone_set('Africa/Nairobi');
        $this->banner =  $this->Members->get_banner();
    }

    public function aviator_game()
    {

        $amount = MemberHelper::user_wallet($this->userId['id']);
        $earning_amount = MemberHelper::ewallet($this->userId['id']);

        $bet = $this->Members->get_all_bets_aviator($this->userId['id']);
        $round_history = $this->Members->get_all_round_history($this->userId['id']);

        $prediction_run = $this->Members->prediction_turn($this->userId['id']);
        if ($prediction_run < 0) {
            $prediction_run = 0;
        }
        $this->load->view("pages/game/game", ['data' => $bet, 'rounds' => $round_history, 'amount' => $amount, 'earning_amount' => $earning_amount, 'prediction_run' => $prediction_run]);
    }
    public function cash_out()
    {
        // $gameId = $_GET['game_id'];
        $id = $this->userId['id'];
        $betId = $_GET['bet_id'];



        $bet = $this->Members->get_single_bet_by_id($betId);


        $winAmount = $bet['amount'] * $_GET['win_multiplier'];

        $profit = $winAmount - $bet->amount;

        $this->Members->update_bet_by_id($bet['id'], [
            "earned" => $winAmount, "amount_x" => $_GET['win_multiplier'], "total_earned" => $bet['wallet_amount'] + $winAmount, "profit" => $profit
        ]);



        $data = [
            "user_id" =>  $id,
            "amount" =>   $winAmount,
            "created_at" => date('Y-m-d H:i:s')
        ];
        $this->Members->add_earning_amount($id, $data);
        
        $earningHistory = array("from_id"=> "","user_id"=> $id,"reason" => "Bet Game", "amount" => $winAmount , "date"=> date("Y-m-d H:i:s"));
        $this->Members->add_ewallet_history($earningHistory);

        $data = [
            'isSuccess' => true,
            "data" => [
                "wallet_balance" =>  MemberHelper::user_wallet($this->userId['id']),
                "earning_balance" => MemberHelper::ewallet($this->userId['id']),
                "cash_out_amount" => $winAmount,

            ],
            "message" => ""
        ];
        echo json_encode($data);
    }
    public function add_bet()
    {
        $id = $this->userId['id'];

        if (count($_GET['all_bets']) == 2) {
            $betAmount = $_GET['all_bets'][0]['bet_amount'];
            $betAmount2 = $_GET['all_bets'][1]['bet_amount'];
        } else {
            $betAmount = $_GET['all_bets'][0]['bet_amount'];
            $betAmount2 = "";
        }

        $wallet = MemberHelper::user_wallet($this->userId['id']);
        if (!empty($betAmount) && !empty($betAmount2)) {
            $totalAM = $betAmount + $betAmount2;
            if ($totalAM > $wallet) {
                $data = [
                    "isSuccess" => false,
                    "data" => [],
                    "message" => "Insufficient fund !"
                ];
            } else {

                $betData = [
                    "userid" =>   $id,
                    "wallet_amount" => $wallet - $betAmount,
                    "amount" => $betAmount,
                    "created_at" => date("Y-m-d H:i:s")
                ];
                $bet = $this->Members->insert_bet($betData);

                $betData2 = [
                    "userid" =>   $id,
                    "wallet_amount" => $wallet - $betAmount2,
                    "amount" => $betAmount2,
                    "created_at" => date("Y-m-d H:i:s")
                ];
                $bet2 = $this->Members->insert_bet($betData2);

                $pack = $this->Members->game_package_userid($id);
                if ($pack) {
                    if ($betAmount >= 100 && $betAmount2 >= 100) {
                        $this->Members->update_predict_turn($id, 2);
                    } elseif ($betAmount2 >= 100) {
                        $this->Members->update_predict_turn($id, 1);
                    } elseif ($betAmount >= 100) {
                        $this->Members->update_predict_turn($id, 1);
                    }
                }


                $this->Members->substract_wallet_amount($id, $totalAM);


                $wallet_after_update = MemberHelper::user_wallet($this->userId['id']);
                $data = [
                    "isSuccess" => true,
                    "data" => [
                        "wallet_balance" => $wallet_after_update,
                        "return_bets" => [
                            [
                                "bet_id" =>  $bet
                            ],
                            [
                                "bet_id" =>  $bet2
                            ]


                        ]
                    ],
                    "message" => ""
                ];
            }
            echo json_encode($data);
        } elseif (!empty($betAmount)) {
            if ($betAmount > $wallet) {
                $data = [
                    "isSuccess" => false,
                    "data" => [],
                    "message" => "Insufficient fund !"
                ];
            } else {

                $betData = [
                    "userid" =>   $id,
                    "wallet_amount" => $wallet - $betAmount,
                    "amount" => $betAmount,
                    "created_at" => date("Y-m-d H:i:s")
                ];
                $bet = $this->Members->insert_bet($betData);

                $pack = $this->Members->game_package_userid($id);
                if ($pack) {
                    if ($betAmount >= 100) {
                        $this->Members->update_predict_turn($id, 1);
                    }
                }


                $this->Members->substract_wallet_amount($id, $betAmount);

                $wallet_after_update  = MemberHelper::user_wallet($this->userId['id']);
                $data = [
                    "isSuccess" => true,
                    "data" => [
                        "wallet_balance" => $wallet_after_update,
                        "return_bets" => [
                            [
                                "bet_id" =>  $bet
                            ], [
                                "bet_id" =>  $bet
                            ]


                        ]
                    ],
                    "message" => ""
                ];
            }

            echo  json_encode($data);
        } elseif (!empty($betAmount2)) {
            if ($betAmount2 > $wallet) {
                $data = [
                    "isSuccess" => false,
                    "data" => [],
                    "message" => "Insufficient fund !"
                ];
            } else {

                $betData = [
                    "userid" =>   $id,
                    "wallet_amount" => $wallet - $betAmount2,
                    "amount" => $betAmount2,
                    "created_at" => date("Y-m-d H:i:s")
                ];
                $bet = $this->Members->insert_bet($betData);

                $pack = $this->Members->game_package_userid($id);
                if ($pack) {
                    if ($betAmount2 >= 100) {
                        $this->Members->update_predict_turn($id, 1);
                    }
                }

                $this->Members->substract_wallet_amount($id, $betAmount2);




                $wallet_after_update = MemberHelper::user_wallet($this->userId['id']);
                $data = [
                    "isSuccess" => true,
                    "data" => [
                        "wallet_balance" => $wallet_after_update,
                        "return_bets" => [
                            [
                                "bet_id" =>  $bet
                            ], [
                                "bet_id" =>  $bet
                            ]
                        ]
                    ],
                    "message" => ""
                ];
            }

            echo json_encode($data);
        }
    }


    public function get_user_details()
    {
        echo json_encode($this->userId);
    }
    public function new_game_generated()
    {

        $value = MemberHelper::user_wallet($this->userId['id']);
        $data = round($value);
        echo json_encode($data);
    }

    public function game_over()
    {
        $this->Members->update_bet_by_status_uid($this->userId['id'], ['status' => 1]);

        $value = MemberHelper::user_wallet($this->userId['id']);
        $data = round($value);
        echo json_encode($data);
    }
    public function currentlybet()
    {
        $bet = $this->Members->get_all_active_bets();

        $data = [
            'currentGame' => '1',
            'currentGameBet' => $bet,
            'currentGameBetCount' => count($bet),
        ];
        echo json_encode($data);
    }
    public function increamentor()
    {
        $id = $this->userId['id'];
        if ($id) {

            // $round = Round_history::where('user_id', $id)->get()->count();
            // if ($round >= 15) {
            //     $randomNumber = rand(10, 30) / 10;
            // } else {
            //     $settings =  Settings::where('id', 1)->first();
            //     $min_number = $settings->min_increment * 10;
            //     $max_number = $settings->max_increment * 10;
            //     $randomNumber = rand($min_number, $max_number) / 10;
            // }
            $betExists = $this->Members->get_active_bet_by_userid_aviator($this->userId['id']);
            // $settings =  Settings::where('id', 1)->first();
            if ($betExists) {
                $min_number = 1 * 10;
                $max_number = 1.6 * 10;
            } else {

                // $min_number = $settings->min_increment * 10;
                $min_number = 1 * 10;
                $max_number = 6 * 10;
            }



            $randomNumber = rand($min_number, $max_number) / 10;

            $roundHistory = [
                "user_id" => $id,
                "round" => $randomNumber,
                "created_at" => date("Y-m-d H:i:s")
            ];
            $this->Members->insert_round_history($roundHistory);


            $prediction_row = $this->Members->get_prediction_earning($this->userId['id']);
            $predicted_value = $prediction_row ? $prediction_row['amount'] : 0;
            if ($betExists && ($predicted_value != 0)) {
                if ($randomNumber == $predicted_value) {
                    // matched predicted
                    $predicted_earning_amount =  $betExists['amount'] * 1.5;

                    $earning['user_id'] = $this->userId['id'];
                    $earning['predicted_value'] =  $predicted_value;
                    $earning['actual_value'] =  $randomNumber;
                    $earning['amount'] =  $betExists['amount'];
                    $earning['earning_amount'] =  $predicted_earning_amount;
                    $earning['created_at'] =  date("Y-m-d H:i:s");
                    $this->Members->insert_history_active($earning);


                    $earning1['user_id'] = $this->userId['id'];
                    $earning1['amount'] =  $predicted_earning_amount;
                    $earning1['created_at'] =  date("Y-m-d H:i:s");
                    $this->Members->add_earning_amount($this->userId['id'], $earning1);
                    
                     $earningHistory = array("from_id"=>"","user_id"=> $this->userId['id'],"reason" => "Increament", "amount" => $predicted_earning_amount , "date"=> date("Y-m-d H:i:s"));
                        $this->Members->add_ewallet_history($earningHistory);
                }
            }

            $data = [
                "status" => true,
                "result" => $randomNumber,
                // "result" => 2
            ];

            // var_dump($key, $iv);
            echo json_encode($data);
        }
    }

    public function my_bets_history()
    {
        $id = $this->userId['id'];
        $bet = $this->Members->get_all_bets_aviator($this->userId['id']);
        $data = $bet;
        echo json_encode($data);
    }


    public function game_prediction()
    {
        if ($this->input->post()) {
            $prediction =  $this->input->post('prediction');

            $data1['user_id'] = $this->userId['id'];
            $data1['amount'] = $prediction;
            $data1['created_at'] = date("Y-m-d H:i:s");
            $this->Members->add_prediction_update($this->userId['id'], $data1);

            $flash = Helpers::flash('success', 'Your Prediction Updated');
            $this->session->set_flashdata('response', $flash);
            redirect('game_prediction');
        }
        $data = $this->Members->get_game_prediction($this->userId['id']);
        $this->load->view("layouts/common", ["template" => "pages/game/game_prediction", "data" => $data]);
    }

    public function game_user_create()
    {
        if ($this->input->post()) {

            $name =  $this->input->post('name');
            $email =  $this->input->post('email');
            $phone =  $this->input->post('phone');
            $code =  $this->input->post('code');
            if ($name) {
                $getUser = $this->Members->get_game_user_by_name($name);
                $getUserEmail = $this->Members->get_game_user_by_email($email);
                if ($getUser) {
                    $flash = Helpers::flash('danger', 'User already exists');
                    $this->session->set_flashdata('response', $flash);
                    redirect('game_user_create');
                }
                if ($getUserEmail) {
                    $flash = Helpers::flash('danger', 'Email already exists');
                    $this->session->set_flashdata('response', $flash);
                    redirect('game_user_create');
                }
                $data1['user_id'] = $this->userId['id'];
                $data1['name'] = $name;
                $data1['email'] =  $email;
                $data1['phone']  = $phone;
                $data1['code'] = Helpers::generateUniqueRefId(6) . $this->userId['id'];
                $data1['balance'] = 0;
                $data1['created_at'] = date("Y-m-d H:i:s");
                $this->Members->add_game_user($data1);


                $mailView = $this->load->view("emails/game_code", array("user" => $data1, "code" => $data1['code']), true);
                Helpers::sendEmail("Aviator Game Code", $email, $mailView);
                Helpers::saveMail($this->userId['id'], "Aviator Game Code");

                $flash = Helpers::flash('success', 'User added successfully');
                $this->session->set_flashdata('response', $flash);
                redirect('game_user_create');
            }

            if ($code) {

                $verify =  $this->input->post('code');

                $getUserBYId = $this->Members->get_game_user_by_id($this->userId['id']);
                if ($getUserBYId['code'] != $verify) {
                    $flash = Helpers::flash('danger', 'Access code mismatch !');
                    $this->session->set_flashdata('response', $flash);
                    redirect('game_user_create');
                }
                redirect('game_package');
            }
        }
        $data = $this->Members->get_game_user($this->userId['id']);
        $this->load->view("layouts/common", ["template" => "pages/game/user_create", "data" => $data]);
    }

    public function game_package()
    {
        if ($this->input->post()) {
            // echo "done";
            // exit;
            $package =  $this->input->post('package');
            $amount = 1000;
            $topup = MemberHelper::user_wallet();
            // $isAlreadyBought = $this->Members->alreadygame_package($this->userId["id"]);
            $parent = $this->Members->getParentByUserId($this->userId["id"]);
            // if (!empty($isAlreadyBought)) {
            //     $flash = Helpers::flash('danger', 'You have already this package');
            //     $this->session->set_flashdata('response', $flash);
            //     return redirect('game_package');
            // }
            if ($amount > $topup) {
                $flash = Helpers::flash('danger', 'Sufficient balance is low!');
                $this->session->set_flashdata('response', $flash);
                return redirect('game_package');
            }

            $data['user_id'] = $this->userId["id"];
            $data['sponsor_id'] = $parent['id'];
            $data['package_id'] = $package;
            $data['amount'] = $amount;
            $data['direct_bonus'] = 0;
            $data['purchase_date'] = date("Y-m-d H:i:s");

            $this->Members->add_game_package($data);

            $this->Members->update_game_balc($this->userId["id"], $amount);


            $this->Members->substract_wallet_amount($this->userId["id"], $amount);

            // $flash = Helpers::flash('success', 'Package bought successfully!');
            // $this->session->set_flashdata('response', $flash);
            // return redirect('game_package');

            $this->Members->add_predict_turn($this->userId["id"]);

            $this->session->set_userdata('show_modal', true);
            return redirect('game_package');
        }
        if ($this->session->userdata('show_modal')) {
            $data['show_modal'] = $this->session->userdata('show_modal');
            $this->session->unset_userdata('show_modal');
            $this->load->view('pages/game/game_package', ["data" => $data]);
            // $this->load->view("layouts/common", ["template" => "pages/game/game_package", "data" => $data]);
        } else {
            $packagesCount = $this->Members->game_package_list_userid($this->userId['id']);
            $game_played = $this->Members->get_all_bets_aviator_count($this->userId['id']);
            $game_entries =  $packagesCount ? $packagesCount * 10 : 0;
            if ($game_played < $game_entries) {
                redirect('aviator_game');
            } else {

                $this->load->view('pages/game/game_package', ["data" => ""]);
                // $this->load->view("layouts/common", ["template" => "pages/game/game_package", "data" => ""]);
            }
        }
    }


   

    public function aviator_registration()
    {
        $this->load->model('Members');
        if ($this->input->post()) {

            $this->form_validation->set_rules('name', 'Username', 'required|is_unique[game_users.name]|alpha_numeric');
            $this->form_validation->set_rules('country', 'Country', 'required');
            $this->form_validation->set_rules('phone', 'Phone Number', 'required|is_unique[game_users.phone]');

            $this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[game_users.email]');
            $this->form_validation->set_rules(
                'password',
                'Password',
                'required',
                array('required' => 'You must provide a %s.')
            );
            $this->form_validation->set_rules('password', 'Password', 'required|min_length[6]|max_length[15]');
            $this->form_validation->set_rules('confirm_password', 'Password Confirmation', 'required|matches[password]');
            if ($this->form_validation->run() == FALSE) {
            } else {


                $phoneCode = $this->input->post("countryCode");



                $name =  $this->input->post('name');
                $email =  $this->input->post('email');
                $country =  $this->input->post('countryfullname');
                $phone =  $this->input->post('phone');
                $password =  $this->input->post('password');


                $getUser = $this->Members->get_game_user_by_name($name);
                $getUserEmail = $this->Members->get_game_user_by_email($email);
                $getUserbyUid = $this->Members->get_game_user_by_id($this->userId['id']);
                if ($getUserbyUid) {
                    $flash = Helpers::flash('danger', 'Your account already exists');
                    $this->session->set_flashdata('response', $flash);
                    redirect('aviator_registration');
                }
                if ($getUser) {
                    $flash = Helpers::flash('danger', 'User already exists');
                    $this->session->set_flashdata('response', $flash);
                    redirect('aviator_registration');
                }
                if ($getUserEmail) {
                    $flash = Helpers::flash('danger', 'Email already exists');
                    $this->session->set_flashdata('response', $flash);
                    redirect('aviator_registration');
                }
                $data1['user_id'] = $this->userId['id'];
                $data1['name'] = $name;
                $data1['email'] =  $email;
                $data1['country']  = $country;
                $data1['phone']  = $phoneCode . $phone;
                $data1['password']  = $password;
                $data1['code'] = Helpers::generateUniqueRefId(6) . $this->userId['id'];
                $data1['balance'] = 0;
                $data1['created_at'] = date("Y-m-d H:i:s");
                $this->Members->add_game_user($data1);


                $mailView = $this->load->view("emails/aviator_email", array("user" => $data1, "code" => $data1['code']), true);
                Helpers::sendEmail("Aviator Game Registration", $email, $mailView);
                Helpers::saveMail($this->userId['id'], "Aviator Game Registration");

                $mailView = $this->load->view("emails/aviator_code_email", array("user" => $data1, "code" => $data1['code']), true);
                Helpers::sendEmail("Aviator Game Code", $email, $mailView);
                Helpers::saveMail($this->userId['id'], "Aviator Game Code");

                $flash = Helpers::flash('success', 'Registration successfully completed !');
                $this->session->set_flashdata('response', $flash);
                redirect('aviator_registration_app');
            }
        }

        $this->load->view('pages/game/aviator_registration');
    }

    public function aviator_registration_app()
    {

        $this->load->view('pages/game/aviator_registration_app');
    }
    public function acccess_code_page()
    {
        if ($this->input->post()) {


            $code = $this->input->post('code');


            $getUserbyUid = $this->Members->get_game_user_by_id($this->userId['id']);
            if (!$getUserbyUid) {
                $flash = Helpers::flash('danger', 'Something went wrong');
                $this->session->set_flashdata('response', $flash);
                redirect('acccess_code_page');
            }

            if ($getUserbyUid['code'] != $code) {
                $flash = Helpers::flash('danger', 'Access code mismatched');
                $this->session->set_flashdata('response', $flash);
                redirect('acccess_code_page');
            }
            redirect('game_package');
        }

        $this->load->view('pages/game/acccess_code_page');
    }
}
