<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Cron extends CI_Controller
{

    public function giveROIToUsers()
    {
        $this->load->model("Members");
        $subscriptions = $this->Members->get_all_compound_wallet();
        // echo "<pre>";
        // print_r($subscriptions);
        // // exit;
        if ($subscriptions) {
            foreach ($subscriptions as $subscription) {
                // echo "<br>";
                $percentage = 0.1;
                $amount = $subscription['amount'] * $percentage;

                $lastROI =  $this->Members->get_last_roi_compound($subscription['user_id'], $subscription['id']);
                if ($lastROI) {

                    if ($lastROI['day'] <  $subscription['days']) {

                        $data = array("user_id" => $subscription['user_id'], "amount" => $amount, "day" => $lastROI['day'] + 1, "invest_amount" => $subscription['amount'], "invest_id" => $subscription['id'], "created_at" => date("Y-m-d H:i:s"));
                        $this->Members->add_roi_compound($data);
                        $addEarn = array("user_id" => $subscription['user_id'], "amount" => $amount, "created_at" => date("Y-m-d H:i:s"));
                        $this->Members->add_compounding_earning($subscription['user_id'], $addEarn);
                    } else {

                        $compoundWallet =  $this->Members->get_compounding_amount($subscription['user_id']);
                        $this->Members->substract_compound_amount($subscription['user_id'], $compoundWallet['amount'], $subscription['id']);
                        $earnings = array("user_id" => $subscription['user_id'], "wallet_amount" => $compoundWallet['amount'], "created_at" => date("Y-m-d H:i:s"));
                        $this->Members->add_wallet_amount($subscription['user_id'], $earnings);
                    }
                } else {
                    $data = array("user_id" => $subscription['user_id'], "amount" => $amount, "day" => 1, "invest_amount" => $subscription['amount'], "invest_id" => $subscription['id'], "created_at" => date("Y-m-d H:i:s"));
                    $this->Members->add_roi_compound($data);
                    $addEarn = array("user_id" => $subscription['user_id'], "amount" => $amount, "created_at" => date("Y-m-d H:i:s"));
                    $this->Members->add_compounding_earning($subscription['user_id'], $addEarn);
                }
            }
        }
    }


    public function sendMailToAllUsers()
    {

        $this->load->model("Members");

        $mails = $this->Members->get_50_mail();
        // echo "<pre>";
        // print_r($mails);
        // exit;
        if ($mails) {
            foreach ($mails as $mail) {
                $user =  Helpers::getUserObj($mail['user_id']);
                $mailView = $this->load->view("emails/mail_user", array("user" => $user, "msg" => $mail));
                Helpers::sendEmail("Message By Admin", $user['email'], $mailView);
                // echo $user['email']."<br>";
                $this->Members->delete_mail($mail['id']);
            }
        }
    }

    public function callback_url($key = "testing")
    {
        $this->load->model("Members");
        $data = file_get_contents('php://input');
        // header('Content-Type: application/json');
        $data = json_encode($data);

        // $resp['response'] = $data;
        // $this->Members->add_payment_response($resp);
        // exit;

        if ($data = $this->format_lnmo($data)) {
            //Get Checkout Request ID
            $checkoutID = $data->CheckoutRequestID;
            $entry = $this->Members->get_payment_request($checkoutID);
            // $entry = $this->db->where('checkout_id', $checkoutID)->get('payment_requests')->result();
            $entry = @$entry[0];
            if ($entry) {
                if ($data->ResultCode == 0) {
                    //Payment successful
                    //TODO: Handle successful payment
                    $amount = $data->Amount;
                    $account_number = $data->MpesaReceiptNumber;

                    $this->Members->update_payment_request($entry['id'], ['status' => '1', 'trx_id' => $data->MpesaReceiptNumber, 'response' => json_encode($data)]);

                    $mpesaDeposit = $this->Members->get_mpesa_deposit_by_transfer_id($entry['mpesa_transfer_id']);

                    $this->Members->update_mpesa_deposit($mpesaDeposit['id'], ["status" => 1, "marked" => 1]);

                    $wallet['user_id'] = $mpesaDeposit['user_id'];
                    $wallet['wallet_amount'] = $amount;
                    $wallet['updated_at'] = date("Y-m-d H:i:s");
                    $this->Members->add_wallet_amount($mpesaDeposit['user_id'], $wallet);
                } else {
                    //Payment failed

                    $this->Members->update_payment_request($entry['id'], ['status' => '2', 'response' => json_encode($data)]);

                    $mpesaDeposit = $this->Members->get_mpesa_deposit_by_transfer_id($entry['mpesa_transfer_id']);

                    $this->Members->update_mpesa_deposit($mpesaDeposit['id'], ["status" => 0, "marked" => 1]);
                }
            } else {
                //Payment request does not exist, probably a hack or a bot scan
            }
        }

        echo json_encode([
            'ResultCode'    => 0,
            'ResultDesc'    => "success"
        ]);

        exit;
    }

    private function format_lnmo($data)
    {
        $data = json_decode(json_decode($data));
        $tmp = $data->Body->stkCallback;
        $master = array();
        if (isset($data->Body->stkCallback->CallbackMetadata)) {
            foreach ($data->Body->stkCallback->CallbackMetadata->Item as $item) {
                $item = (array) $item;
                $master[$item['Name']] = ((isset($item['Value'])) ? $item['Value'] : NULL);
            }
        }
        $master = (object) $master;
        $master->ResultCode = $tmp->ResultCode;
        $master->MerchantRequestID = $tmp->MerchantRequestID;
        $master->CheckoutRequestID = $tmp->CheckoutRequestID;
        $master->ResultDesc = $tmp->ResultDesc;
        return $master; //or cast to array for array
    }

    public function get_all_bets()
    {

        date_default_timezone_set('Africa/Nairobi');
        $this->load->model("Members");
        $data =  $this->Members->get_all_bets_all();
        if ($data) {
            foreach ($data as $row) {
                $cur = $row['currency'];
                $now = date("Y-m-d H:i:s");
                if ($row['bet_date_time'] <= $now) {
                           
                    // $row1 = file_get_contents("https://min-api.cryptocompare.com/data/generateAvg?fsym=BTC&tsym=USDT&e=coinbase&api_key=48c2d3f6478ac042d20d1210745492f677e5183c2ff4b876b1730eeaa76246b0");
                    
                    // $coinRate = json_decode($row1);
                    // $livePrice = $coinRate->RAW->PRICE;
                      $livePrice = $this->get_btc_price_cron($cur);
                    $settings = Helpers::settings();
                    if ($row['movement'] == 1) {
                        if ($livePrice > $row['btc_price']) {
                            // Win
                            $data1['status'] = 1;
                            $data1['result'] = 1;
                            $data1['win_amount'] = $row['amount'] * ($settings['profite_rate'] / 100);
                            $data1['after_btc_price'] = $livePrice;
                            $this->Members->update_bet_data($row['id'], $data1);
                            $wallet['user_id'] = $row['user_id'];
                            $wallet['amount'] = $row['amount'] + $data1['win_amount'];
                            $this->Members->add_forex_amount($row['user_id'], $wallet);
                        } else {
                            // Loss
                            $data1['status'] = 1;
                            $data1['result'] = 0;
                            $data1['win_amount'] = 0;
                            $data1['after_btc_price'] = $livePrice;
                            $this->Members->update_bet_data($row['id'], $data1);
                        }
                    } else {
                        if ($livePrice < $row['btc_price']) {
                            // Win
                            $data1['status'] = 1;
                            $data1['result'] = 1;
                            $data1['win_amount'] = $row['amount'] * ($settings['profite_rate'] / 100);
                            $data1['after_btc_price'] = $livePrice;
                            $this->Members->update_bet_data($row['id'], $data1);
                            $wallet['user_id'] = $row['user_id'];
                            $wallet['amount'] = $row['amount'] + $data1['win_amount'];
                            $this->Members->add_forex_amount($row['user_id'], $wallet);
                        } else {
                            // Loss
                            $data1['status'] = 1;
                            $data1['result'] = 0;
                            $data1['win_amount'] = 0;
                            $data1['after_btc_price'] = $livePrice;
                            $this->Members->update_bet_data($row['id'], $data1);
                        }
                    }
                }
            }
        }

          if ($cur == "BTC") {
            $redirect = 'trading';
        } elseif ($cur == "ETH") {
            $redirect = 'trade_eth';
        } elseif ($cur == "SOL") {
            $redirect = 'trade_solana';
        } elseif ($cur == "NAS") {
            $redirect = 'trade_nas';
        } elseif ($cur == "ETC") {
            $redirect = 'trade_etc';
        } elseif ($cur == "GBP") {
            $redirect = 'trade_gbp';
        } 
        
         return redirect($redirect);
    }
    
       public function get_btc_price_cron($id)
    {
        $to = "USDT";
        //    $id = $this->input->get('id');
        if ($id == "BTC" || $id == "ETH" || $id == "SOL") {
            $e = 'coinbase';
        } elseif ($id == "NAS") {
            $e = 'gateio';
        } elseif ($id == "ETC") {
            $e = 'binance';
        } elseif ($id == "GBP") {
            $e = 'bitstamp';
            $to = "USD";
        }

            $row1 = file_get_contents("https://min-api.cryptocompare.com/data/generateAvg?fsym={$id}&tsym={$to}&e={$e}&api_key=48c2d3f6478ac042d20d1210745492f677e5183c2ff4b876b1730eeaa76246b0");
            $coinRate = json_decode($row1);
            return $coinRate->RAW->PRICE;
        
    }
    public function get_btc_price($id)
    {
        $to = "USDT";
        //    $id = $this->input->get('id');
        if ($id == "BTC" || $id == "ETH" || $id == "SOL") {
            $e = 'coinbase';
        } elseif ($id == "NAS") {
            $e = 'gateio';
        } elseif ($id == "ETC") {
            $e = 'binance';
        } elseif ($id == "GBP") {
            $e = 'bitstamp';
            $to = "USD";
        }
        
            $row1 = file_get_contents("https://min-api.cryptocompare.com/data/generateAvg?fsym={$id}&tsym={$to}&e={$e}&api_key=48c2d3f6478ac042d20d1210745492f677e5183c2ff4b876b1730eeaa76246b0");
            $coinRate = json_decode($row1);
            echo $coinRate->RAW->PRICE;
        
    }
    
     public function get_btc_price_all_data($id, $type)
    {
        $to = "USDT";
        //    $id = $this->input->get('id');
        if ($id == "BTC" || $id == "ETH" || $id == "SOL") {
            $e = 'coinbase';
        } elseif ($id == "NAS") {
            $e = 'gateio';
        } elseif ($id == "ETC") {
            $e = 'binance';
        } elseif ($id == "GBP") {
            $e = 'bitstamp';
            $to = "USD";
        }

        $row1 = file_get_contents("https://min-api.cryptocompare.com/data/generateAvg?fsym={$id}&tsym={$to}&e={$e}&api_key=48c2d3f6478ac042d20d1210745492f677e5183c2ff4b876b1730eeaa76246b0");
        $coinRate = json_decode($row1);
        if ($type == "Price") {
            echo $coinRate->RAW->PRICE;
        } elseif ($type == "Volume") {
            echo $coinRate->RAW->VOLUME24HOUR;
        } elseif ($type == "Percentage") {
            echo $coinRate->RAW->CHANGEPCT24HOUR;
        }
    }
}
