<?php

class Admin extends ci_controller
{
    function __construct()
    {
        parent::__construct();
        $this->load->model(array('Adm', 'Users', 'Members'));
        $res = $this->Members->getMailsFromDatabase();
        $this->lastHourMails = $res ? count($res) : 0;
        $this->username = $this->session->userdata('adminlogin');

        if (!$this->username) {
            redirect('master');
        }
        date_default_timezone_set('Africa/Nairobi');
    }
    public function settings()
    {
        if ($this->input->post()) {
            $xtc = $this->input->post("status");
            $update = $this->Adm->update_settings($xtc);
            if ($update) {
                if ($xtc == 0) {
                    $data["auto_withdraw"] = 0;
                    $xtcall = $this->Adm->update_xtc($data);
                }
                $flash = Helpers::flash('success', 'Your Details are updated');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/settings");
            }
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/settings"]);
    }
    public function dashboard()
    {
        $users = $this->Adm->get_all_users();
        $data["allusers"] = $users ? count($users) : 0;
        $data["newusers"] = $this->Adm->get_newuser(5);
        $data["soldPack"] = $this->Adm->getSoldPack();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/dashboard", "data" => $data]);
    }



    public function change_password()
    {

        if ($this->input->post()) {
            $phone = $this->input->post('phone');

            $getuser = $this->Adm->getuserbyphone($phone);
            if ($getuser) {
                $id = $getuser['id'];
                redirect("admin/edit_password?id=$id");
            } else {
                // echo 'User Not Found';

                $this->session->set_flashdata('err', 'User Not Found');
                redirect("admin/change_password");
            }
        }


        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/change_password"]);
    }

    public function edit_password()
    {

        if ($this->input->post()) {
            $id = $this->input->post("id");
            $data["password"] = sha1($this->input->post("password"));

            $update = $this->Adm->updateuser($id, $data);
            if ($update) {
                $flash = Helpers::flash('success', 'Password Changed Successfully');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/change_password');
            } else {

                $flash = Helpers::flash('danger', "Something went wrong");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/change_password');
            }
        }
        $id = $this->input->get("id");
        $user = Helpers::userdetails($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_password", "data" => $user]);
    }

    public function matric()
    {
        $res = "";
        if ($this->input->post()) {

            $first_date = $this->input->post('first_date');
            $second_date = $this->input->post('second_date');
            $res = $this->Adm->getUsersdates($first_date, $second_date);
            if ($res) {
                // print_r($res);



            } else {
                // echo "not found";
                // exit;
            }
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/matric", "data" => $res]);
    }
    public function package_matric()
    {
        $res = "";
        if ($this->input->post()) {

            $first_date = $this->input->post('first_date');
            $second_date = $this->input->post('second_date');
            $res = $this->Adm->getpackagedates($first_date, $second_date);
            if ($res) {
                // print_r($res);



            } else {
                // echo "not found";
                // exit;
            }
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/package_metric", "data" => $res]);
    }


    public function order_request()
    {
        $requests = $this->Adm->get_all_fund_requests();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/order_request", "data" => $requests]);
    }
    public function kyc_request()
    {
        $allUsers = $this->Adm->get_kyc_request();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/kyc_request", "allusers" => $allUsers]);
    }
    public function search_user()
    {

        if ($this->input->post('phone_number')) {
            $phone = $this->input->post('phone');

            $getuser = $this->Adm->getuserbyphone($phone);
            if ($getuser) {
                $id = $getuser['id'];
                redirect("admin/edit_users?id=$id");
            } else {
                // echo 'User Not Found';

                $this->session->set_flashdata('err', 'User Not Found');
                redirect("admin/search_user");
            }
        }
        if ($this->input->post('uname')) {
            $username = $this->input->post('username');

            $getuser = $this->Adm->getuserbyusername($username);
            if ($getuser) {
                $id = $getuser['id'];
                redirect("admin/edit_users?id=$id");
            } else {
                // echo 'User Not Found';

                $this->session->set_flashdata('err', 'User Not Found');
                redirect("admin/search_user");
            }
        }



        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/search_user"]);
    }


    public function add_ads()
    {
        if ($this->input->post()) {

            $fileName = '';
            if (!empty($_FILES['fileupload']['name'])) {
                $uploadPath = 'uploads/files/ads/' . $this->username["id"];
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0777);
                }
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'jpg|jpeg|png';
                // $config['max_size'] = 0;


                // Load and initialize upload library
                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                // Upload file to server
                if ($this->upload->do_upload('fileupload')) {
                    // Uploaded file data

                    $fileData = $this->upload->data();
                    $fileName = $fileData['file_name'];
                }

                // else{
                //          $error = array('error' => $this->upload->display_errors());
                //     print_r($error);
                //     exit;

                // }
            }
            $data['ads_name'] = $this->input->post('ads_name');
            $data['ads_file'] = $fileName;

            $this->load->model('Adm');
            $res = $this->Adm->add_ads($data);

            if ($res) {
                $this->session->set_flashdata('msg', 'Updated Successfully');
                redirect(base_url() . 'admin/add_ads');
            } else {
                $this->session->set_flashdata('err', 'Something Went Wrong !');
                redirect(base_url() . 'admin/add_ads');
            }
        }
        $this->load->model('Members');
        $data = $this->Members->get_ads();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/add_ads", "data" => $data]);
    }


    public function remove_ads()
    {


        $id = $this->uri->segment(3);
        $this->load->model('Adm');
        $res = $this->Adm->remove_ads($id);

        if ($res) {
            // echo "delete";
            $this->session->set_flashdata('remove', 'Removed Successfully');
            redirect("admin/add_ads");
        } else {
            // echo "not delete";

            redirect("admin/add_ads");
        }
    }
    public function accept_kyc()
    {


        $id = $this->uri->segment(3);
        $data = array();
        $data["accept_kyc"] = 1;

        $res = $this->Users->updateUser($id, $data);

        if ($res) {


            redirect("admin/kyc_request");
        } else {

            redirect("admin/kyc_request");
        }
    }


    public function reject_kyc()
    {


        $id = $this->uri->segment(3);
        $data = array();
        $data["accept_kyc"] = 2;

        $res = $this->Users->updateUser($id, $data);

        if ($res) {


            redirect("admin/kyc_request");
        } else {

            redirect("admin/kyc_request");
        }
    }
    public function wallet_details()
    {
        if ($this->input->post()) {
            $data["user_wallet_address"] = $this->input->post("btc");
            $data["eth_address"] = $this->input->post("eth");
            $data["usdt_address"] = $this->input->post("usdt");
            $data["password"] = $this->input->post("password");
            $id = $this->username["id"];
            $resp = $this->Adm->update_admin($id, $data);
            if ($resp) {
                $flash = Helpers::flash('success', 'Your Details are updated');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/wallet_details");
            }
        }
        $id = $this->username["id"];
        $requests = $this->Adm->get_admin_details($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/wallet_details", "data" => $requests]);
    }
    public function disapprove_funds()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $data = $wallet = array();
            $data["status"] = 0;
            $data["marked"] = 1;

            $resp = $this->Adm->update_status($id, $data);
            $fundRow = $this->Adm->get_row_by_id($id);
            if ($resp) {
                $status['status'] = 2;
                $status['canceled_date'] = date("Y-m-d H:i:s");
                $this->Adm->update_orders_by_payment($fundRow['payment_id'], $status);
                $flash = Helpers::flash('danger', 'Request has been rejected.');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/order_request");
            } else {
                echo "failed";
            }
        }
    }
    public function approve_funds()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $data = $wallet = array();
            $data["status"] = 1;
            $data["marked"] = 1;

            $resp = $this->Adm->update_status($id, $data);
            $fundRow = $this->Adm->get_row_by_id($id);
            if ($resp) {
                // $userId = $fundRow["user_id"];
                // $wallet = array();
                // $wallet["user_id"] = $userId;
                // // $walletInUSD = Coinpayments::get_btc_dollars($fundRow['wallet_type'], $fundRow['amount']);
                // $walletInUSD = $fundRow['amount'];
                // $wallet['wallet_amount'] = $walletInUSD;
                // $wallet['updated_at'] = date("Y-m-d");
                // $this->Adm->add_wallet_amount($userId, $wallet);
                $parent = $this->Members->getParentByUserId($fundRow['user_id']);
                $wallet['user_id'] = $parent['id'];
                $wallet['amount'] = $fundRow['amount'] * 0.7;
                $wallet['created_at'] = date("Y-m-d H:i:s");
                $this->Members->add_earning_amount($parent['id'], $wallet);


                $commission['from_id'] = $fundRow['user_id'];
                $commission['to_id'] = $parent['id'];
                $commission['amount'] = $wallet['amount'];
                $commission['created_at'] = date("Y-m-d H:i:s");
                $this->Members->add_orders_commission($commission);

                $status['status'] = 1;
                $status['shipped_date'] = date("Y-m-d H:i:s");
                $this->Adm->update_orders_by_payment($fundRow['payment_id'], $status);
                $flash = Helpers::flash('success', 'Your request has been updated');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/order_request");
            } else {
                echo "failed";
            }
        }
    }



    public function all_users()
    {

        $id = $this->input->get('id');

        $users = $this->Adm->get_users($id);

        $data['users'] = $users;

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/all_users", "data" => $data, "id" => $id]);
    }

    public function user_status()
    {
        $this->load->library('pagination');

        $config = array();
        $config['base_url'] = base_url() . 'admin/user_status';
        $config["total_rows"] = count($this->Adm->get_all_users());
        $config["per_page"] = 20;
        $config["uri_segment"] = 3;
        $config['full_tag_open'] = "<div class='pagination'>";

        $config['full_tag_close'] = "</div>";



        $config['use_page_numbers'] = TRUE;

        $config['next_link'] = 'Next';
        $config['next_tag_open'] = '<li class="next page">';
        $config['next_tag_close'] = '</li>';

        $config['prev_link'] = ' Previous';
        $config['prev_tag_open'] = '<li class="prev page">';
        $config['prev_tag_close'] = '</li>';

        $config['cur_tag_open'] = '<li class="active"><a href="">';
        $config['cur_tag_close'] = '</a></li>';

        $config['num_tag_open'] = '<li class="page">';
        $config['num_tag_close'] = '</li>';
        // $config['attributes'] = array('class' => 'pagination');


        $this->pagination->initialize($config);
        $segment = $this->uri->segment(3);
        $page = $segment ? $segment : 0;

        $data["links"] = $this->pagination->create_links();
        $users = $this->Adm->get_all_users($config["per_page"], $page);
        $data['users'] = $users;
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/user_status", "data" => $data]);
    }



    public function edit_status()
    {
        if ($this->input->post()) {
            $id = $this->input->post("id");
            $data['first_name'] = $this->input->post("full_name");
            $data["status"] = $this->input->post("status");
            $update = $this->Adm->updateuser($id, $data);
            if ($update) {
                $flash = Helpers::flash('success', 'User Update Successfully');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/user_status');
            } else {

                $flash = Helpers::flash('danger', "Something went wrong");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/user_status');
            }
        }
        $id = $this->input->get("id");
        $user = Helpers::userdetails($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_status", "data" => $user]);
    }
    public function whatsapp_request()
    {

        $data = $this->Adm->whatsapp_all_request();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/whatsapp_request", "data" => $data]);
    }
    public function whatsapp_history()
    {

        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $whatsAppHistroy = $this->Adm->get_approved_whatsapp_requests_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $whatsAppHistroy = $this->Adm->get_approved_whatsapp_requests_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $whatsAppHistroy = $this->Adm->get_approved_whatsapp_requests_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $whatsAppHistroy = $this->Adm->get_approved_whatsapp_requests_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $whatsAppHistroy = $this->Adm->get_approved_whatsapp_requests_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $whatsAppHistroy = $this->Adm->get_approved_whatsapp_requests_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $whatsAppHistroy = $this->Adm->get_approved_whatsapp_requests_by_date($endDate, $today);
        } else {
            $whatsAppHistroy = $this->Adm->get_approved_whatsapp_requests_by_date();
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/whatsapp_history", "data" => $whatsAppHistroy]);
    }
    public function accept_whatsapp_request()
    {


        $id = $this->uri->segment(3);
        $res = $this->Adm->getsingleRow($id);
        $earning = $res['views'] * 100;
        $data = array();
        $data["status"] = 1;
        $data["earning"] = $earning;
        $this->Adm->update_whatsapp_request($id, $data);


        $data1 = array();
        $data1["amount"] = $earning;
        $data1['user_id'] = $res['user_id'];

        $result = $this->Members->add_whatsapp_earning($data1['user_id'], $data1);

        if ($result) {

            $user = Helpers::getUserObj($data1['user_id']);

            $mailView = $this->load->view("emails/whatsapp_approvel", array("user" => $user, "amount" => $data1["amount"], "views" => $res['views']), true);
            Helpers::sendEmail("WhatsApp Earnings", $user['email'], $mailView);

            Helpers::saveMail($user['id'], "WhatsApp Approvel By Admin");

            redirect("admin/whatsapp_request");
        } else {

            redirect("admin/whatsapp_request");
        }
    }


    public function reject_whatsapp_request()
    {


        $id = $this->uri->segment(3);
        $data = array();
        $data["status"] = 2;

        $res = $this->Adm->update_whatsapp_request($id, $data);

        if ($res) {


            redirect("admin/whatsapp_request");
        } else {

            redirect("admin/whatsapp_request");
        }
    }

    public function edit_users()
    {
        if ($this->input->post()) {
            $id = $this->input->post("id");
            $data["first_name"] = $this->input->post("first_name");
            $data["email"] = $this->input->post("email");
            $data["phone"] = $this->input->post("phone");
            $data["username"] = $this->input->post("username");
            $data["referral_id"] = $data["username"];



            if (($this->input->post("status")) != "") {
                $status = $this->input->post("status");
            } else {
                $user = helpers::getUserObj($id);
                $status = $user['is_blocked'];
            }
            $data['is_blocked'] = $status;
            $update = $this->Adm->updateuser($id, $data);
            if ($update) {
                $flash = Helpers::flash('success', 'User Update Successfully');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/all_users');
            } else {

                $flash = Helpers::flash('danger', "Something went wrong");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/all_users');
            }
        }
        $id = $this->input->get("id");
        $user = Helpers::userdetails($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_user", "data" => $user]);
    }

    public function support()
    {
        $this->load->helper('text');
        $getAllSupport = $this->Adm->get_support_messages();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/complaints", "data" => $getAllSupport]);
    }
    public function single_complaint()
    {
        $id = $this->input->get("id");
        $complaint = $this->Adm->get_support_single_message($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/single_complain", "data" => $complaint]);
    }
    public function send_reply()
    {
        if ($this->input->post()) {
            $id = $this->input->post("id");
            $msg = $this->input->post("message");
            $complaint = $this->Adm->get_support_single_message($id);

            // add to support table
            $data["to_id"] = $complaint["user_id"];
            $data["user_id"] = 1;
            $data["subject"] = $complaint['subject'];
            $data["message"] = $msg;
            $data["ticket_no"] = $complaint['ticket_no'];
            $data["created_at"] = date('Y-m-d');
            $this->load->model('Members');

            $res = $this->Members->add_support_ticket($data);
            $update = $this->Adm->update_support($id, array("status" => 1));
            $getUser = Helpers::userdetails($complaint["user_id"]);

            Helpers::sendEmail($complaint["subject"], $getUser["email"], $msg);

            Helpers::saveMail($getUser['id'], "Support Reply By Admin");

            $flash = Helpers::flash('success', 'Message Sent Successfully');
            $this->session->set_flashdata('response', $flash);
            redirect("admin/support");
        }
    }
    public function withdraw_history()
    {


        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getccrequests = $this->Adm->get_all_approved_withdraw_requests($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getccrequests = $this->Adm->get_all_approved_withdraw_requests($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getccrequests = $this->Adm->get_all_approved_withdraw_requests($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getccrequests = $this->Adm->get_all_approved_withdraw_requests($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getccrequests = $this->Adm->get_all_approved_withdraw_requests($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_all_approved_withdraw_requests($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_all_approved_withdraw_requests($endDate, $today);
        } else {
            $getccrequests = $this->Adm->get_all_approved_withdraw_requests();
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/withdraw_history", "data" => $getccrequests]);
    }

    public function earning_history()
    {
        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getEarningRequest = $this->Adm->get_earning_requests_by_date($endDate, $today);
            $getEarningRequestAgent = $this->Adm->get_earning_requests_agent_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getEarningRequest = $this->Adm->get_earning_requests_by_date($endDate, $today);
            $getEarningRequestAgent = $this->Adm->get_earning_requests_agent_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getEarningRequest = $this->Adm->get_earning_requests_by_date($endDate, $today);
            $getEarningRequestAgent = $this->Adm->get_earning_requests_agent_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getEarningRequest = $this->Adm->get_earning_requests_by_date($endDate, $today);
            $getEarningRequestAgent = $this->Adm->get_earning_requests_agent_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getEarningRequest = $this->Adm->get_earning_requests_by_date($endDate, $today);
            $getEarningRequestAgent = $this->Adm->get_earning_requests_agent_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getEarningRequest = $this->Adm->get_earning_requests_by_date($endDate, $today);
            $getEarningRequestAgent = $this->Adm->get_earning_requests_agent_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getEarningRequest = $this->Adm->get_earning_requests_by_date($endDate, $today);
            $getEarningRequestAgent = $this->Adm->get_earning_requests_agent_by_date($endDate, $today);
        } else {
            $getEarningRequest = $this->Adm->get_earning_requests_by_date();
            $getEarningRequestAgent = $this->Adm->get_earning_requests_agent_by_date();
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/earning_history", "data" => $getEarningRequest, "agent" => $getEarningRequestAgent]);
    }
    public function withdraw_requests()
    {
        $getccrequests = $this->Adm->get_withdraw_requests();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/withdraw_fund_requests", "data" => $getccrequests]);
    }

    public function withdraw_game_requests()
    {
        $getccrequests = $this->Adm->get_withdraw_game_requests();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/withdraw_game_requests", "data" => $getccrequests]);
    }


    public function approve_game_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_game_withdraw_details($id);
            $data = $wallet = array();
            $data["status"] = 1;
            $data["marked"] = 1;
            $resp = $this->Adm->update_game_withdraw($id, $data);
            if ($resp) {

                $flash = Helpers::flash('success', ' Withdrawal Successfully.');
                $this->session->set_flashdata('response', $flash);
                // $url="admin/".$getdetails["type"]."_requests";
                return redirect("admin/withdraw_game_requests");
            } else {
                echo "failed";
            }
        }
    }

    public function withdraw_whatsapp_requests()
    {
        $getccrequests = $this->Adm->get_withdraw_whatsapp_requests();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/withdraw_whatsapp_requests", "data" => $getccrequests]);
    }

    public function approve_whatsapp_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_whatsapp_withdraw_details($id);
            $data = $wallet = array();
            $data["status"] = 1;
            // $data["marked"] = 1;            
            $resp = $this->Adm->update_whatsapp_withdraw($id, $data);
            if ($resp) {

                $user = Helpers::getUserObj($getdetails["user_id"]);
                $amount = $getdetails['amount'];
                $mailView = $this->load->view("emails/whatsapp_withdrawal", array("user" => $user, "amount" => $amount), true);
                Helpers::sendEmail("Flibcart WhatsApp Withdrawal", $user["email"], $mailView);

                Helpers::saveMail($getdetails["user_id"], "WhatsApp Withdrawal");

                $flash = Helpers::flash('success', ' Withdrawal Successfully.');
                $this->session->set_flashdata('response', $flash);
                // $url="admin/".$getdetails["type"]."_requests";
                return redirect("admin/withdraw_whatsapp_requests");
            } else {
                echo "failed";
            }
        }
    }

    public function disapprove_whatsapp_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_whatsapp_withdraw_details($id);
            $data = $wallet = array();
            $data["status"] = 2;
            // $data["marked"] = 1;            
            $resp = $this->Adm->update_whatsapp_withdraw($id, $data);
            if ($resp) {

                $wallet['user_id'] = $getdetails['user_id'];
                $wallet['amount'] = $getdetails['amount'];
                $this->Members->add_whatsapp_earning($wallet['user_id'], $wallet);

                $flash = Helpers::flash('danger', ' Withdrawal Rejected Successfully.');
                $this->session->set_flashdata('response', $flash);
                // $url="admin/".$getdetails["type"]."_requests";
                return redirect("admin/withdraw_whatsapp_requests");
            } else {
                echo "failed";
            }
        }
    }

    public function withdraw_whatsapp_history()
    {
        // $getccrequests = $this->Adm->get_withdraw_whatsapp_history();

        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getccrequests = $this->Adm->get_withdraw_whatsapp_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getccrequests = $this->Adm->get_withdraw_whatsapp_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getccrequests = $this->Adm->get_withdraw_whatsapp_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getccrequests = $this->Adm->get_withdraw_whatsapp_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getccrequests = $this->Adm->get_withdraw_whatsapp_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_withdraw_whatsapp_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_withdraw_whatsapp_history_by_date($endDate, $today);
        } else {
            $getccrequests = $this->Adm->get_withdraw_whatsapp_history_by_date();
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/withdraw_whatsapp_history", "data" => $getccrequests]);
    }

    public function accept_all_whatsapp_withdraw_request()
    {

        $data = $this->Adm->get_withdraw_whatsapp_requests();

        foreach ($data as $row) {
            // echo "<pre>";
            $id = $row['id'];

            $res = $this->Adm->get_whatsapp_withdraw_details($id);

            $data = array();
            $data["status"] = 1;

            $this->Adm->update_whatsapp_withdraw($id, $data);
        }



        redirect('admin/withdraw_whatsapp_requests');
    }

    public function withdraw_app_requests()
    {
        $getccrequests = $this->Adm->get_withdraw_app_requests();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/withdraw_app_requests", "data" => $getccrequests]);
    }

    public function approve_app_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_app_withdraw_details($id);
            $data = $wallet = array();
            $data["status"] = 1;
            $data["marked"] = 1;
            $resp = $this->Adm->update_app_withdraw($id, $data);
            if ($resp) {

                $flash = Helpers::flash('success', ' Withdrawal Successfully.');
                $this->session->set_flashdata('response', $flash);
                // $url="admin/".$getdetails["type"]."_requests";
                return redirect("admin/withdraw_app_requests");
            } else {
                echo "failed";
            }
        }
    }

    public function withdraw_spining_requests()
    {
        $getccrequests = $this->Adm->get_withdraw_spining_requests();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/withdraw_spining_requests", "data" => $getccrequests]);
    }


    public function approve_spining_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_spining_withdraw_details($id);
            $data = $wallet = array();
            $data["status"] = 1;
            $data["marked"] = 1;
            $resp = $this->Adm->update_spining_withdraw($id, $data);
            if ($resp) {

                $flash = Helpers::flash('success', ' Withdrawal Successfully.');
                $this->session->set_flashdata('response', $flash);
                // $url="admin/".$getdetails["type"]."_requests";
                return redirect("admin/withdraw_spining_requests");
            } else {
                echo "failed";
            }
        }
    }


    public function approve_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_withdraw_details($id);
            $amount = $getdetails['amount'] + $getdetails['fee'];
            $balance = MemberHelper::ewallet($getdetails['user_id']);
            $data = $wallet = array();
            $data["status"] = 1;
            $data["marked"] = 1;

            $resp = $this->Adm->update_withdraw($id, $data);
            if ($resp) {
                $uid = $getdetails['user_id'];
                // $amount = $getdetails['amount']+$getdetails['fee'];
                // $this->Adm->substract_ewallet_amount($uid,$amount);
                $user = Helpers::getUserObj($uid);


                $user = Helpers::getUserObj($uid);
                $user["amount"] = $getdetails['amount'];

                $mailView = $this->load->view("emails/withdrawal", array("user" => $user), true);
                Helpers::sendEmail("Withdrawal", $user["email"], $mailView);

                Helpers::saveMail($user['id'], "Accepted Withdrawal By Admin");


                $flash = Helpers::flash('success', 'Withdrawal Successfully.');
                $this->session->set_flashdata('response', $flash);
                $url = "admin/" . $getdetails["type"] . "_requests";
                return redirect("admin/withdraw_requests");
            } else {
                echo "failed";
            }
        }
    }
    public function disapprove_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_withdraw_details($id);
            $amount = $getdetails['amount'] + $getdetails['fee'];
            $balance = MemberHelper::ewallet($getdetails['user_id']);
            $data["status"] = 2;
            $data["marked"] = 1;
            $data["after_earning_amount"] = $balance + $amount;
            $resp = $this->Adm->update_withdraw($id, $data);
            if ($resp) {
                $wallet['user_id'] = $getdetails['user_id'];
                $wallet['amount'] = $getdetails['amount'] + $getdetails['fee'];
                $this->Adm->add_earning_amount($wallet['user_id'], $wallet);

                $flash = Helpers::flash('danger', 'Withdrawal Rejected.');
                $this->session->set_flashdata('response', $flash);

                return redirect("admin/withdraw_requests");
            } else {
                $flash = Helpers::flash('danger', 'Something went wrong.');
                $this->session->set_flashdata('response', $flash);
                // $url="admin/".$getdetails["type"]."_requests";
                return redirect("admin/withdraw_requests");
            }
        }
    }
    public function package_status()
    {
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/package_status"]);
    }
    public function leverage_amount()
    {
        $data = $this->Adm->usersleverage();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/leverage_amount", "data" => $data]);
    }
    function edit_withdraw()
    {
        if ($this->input->post()) {
            $id = $this->input->post("id");

            $fileName = '';
            if (!empty($_FILES['image_url']['name'])) {
                $uploadPath = 'uploads/files/withdrawslip/' . $id;
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0777);
                }
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'jpg|jpeg|png|gif';

                // Load and initialize upload library
                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                // Upload file to server
                if ($this->upload->do_upload('image_url')) {
                    // Uploaded file data
                    $fileData = $this->upload->data();
                    $fileName = $fileData['file_name'];
                }
            }
            $data['slip'] = $fileName;
            $res = $this->Adm->updateslip($id, $data);
            if ($res) {
                $flash = Helpers::flash('success', 'Slip Updated Successfully');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/cc_requests');
            } else {

                $flash = Helpers::flash('danger', "Something went wrong");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/cc_requests');
            }
        }
        $id = $this->input->get("id");
        $withdrawal = $this->Adm->get_single_withdrawal($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_withdraw", "data" => $withdrawal]);
    }
    function manage_blogs()
    {
        $blogs = $this->Adm->get_blogs();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/manage_blogs", "data" => $blogs]);
    }
    public function approve_post()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_post_details($id);
            $data = $wallet = array();
            $data["status"] = 1;
            $data["marked"] = 1;
            $resp = $this->Adm->update_post($id, $data);
            if ($resp) {

                $flash = Helpers::flash('success', 'Updated Successfully.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/manage_blogs");
            } else {
                echo "failed";
            }
        }
    }
    public function disapprove_post()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_post_details($id);
            $data = $wallet = array();
            $data["status"] = 0;
            $data["marked"] = 1;
            $resp = $this->Adm->update_post($id, $data);
            if ($resp) {

                $flash = Helpers::flash('danger', 'Post Rejected.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/manage_blogs");
            } else {
                echo "failed";
            }
        }
    }
    function manage_loans()
    {
        $blogs = $this->Adm->get_loans();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/manage_loans", "data" => $blogs]);
    }
    public function approve_loan()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_loan_details($id);
            $data = $wallet = array();
            $data["status"] = 1;
            $data["marked"] = 1;
            $resp = $this->Adm->update_loan($id, $data);
            if ($resp) {
                $wallet["amount"] = $getdetails["amount"];
                $wallet["user_id"] = $getdetails["user_id"];
                $this->load->model("Members");
                $this->Members->add_earning_amount($getdetails["user_id"], $wallet);
                $flash = Helpers::flash('success', 'Updated Successfully.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/manage_loans");
            } else {
                echo "failed";
            }
        }
    }
    public function disapprove_loan()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_loan_details($id);
            $data = $wallet = array();
            $data["status"] = 0;
            $data["marked"] = 1;
            $resp = $this->Adm->update_loan($id, $data);
            if ($resp) {

                $this->Members->add_earning_amount($getdetails["user_id"], $wallet);
                $flash = Helpers::flash('success', 'Updated Successfully.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/manage_loans");
            } else {
                echo "failed";
            }
        }
    }
    public function add_funds()
    {
        if ($this->input->post()) {
            $username = $this->input->post("username");
            $amount = $this->input->post("amount");
            $reason = $this->input->post("reason");
            $getuser = Helpers::getuserbyusername($username);
            if (!$getuser) {
                $flash = Helpers::flash('danger', 'This user does not exist.');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/add_funds');
            }

            $userid = $getuser["id"];
            $data["user_id"] = $getuser["id"];
            $data["wallet_amount"] = $amount;
            $data["updated_at"] = date('Y-m-d');
            $update = $this->Adm->add_wallet_amount($userid, $data);
            if ($update) {
                $entry["from_id"] = "1";
                $entry["to_id"] = $getuser["id"];
                $entry["amount"] = $amount;
                $entry["wallet_type"] = "Deposit";
                $entry["wallet"] = "Topup";
                $entry["reason"] = $reason;
                $entry["date"] = date('Y-m-d');
                $addhsitory = $this->Adm->addtransfer_entry($entry);
                $flash = Helpers::flash('success', "Amount Transferred");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/add_funds');
            }
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/add_funds"]);
    }
    public function deduct_funds()
    {
        if ($this->input->post()) {
            $username = $this->input->post("username");
            $amount = $this->input->post("amount");
            $reason = $this->input->post("reason");
            $getuser = Helpers::getuserbyusername($username);
            if (!$getuser) {
                $flash = Helpers::flash('danger', 'This user does not exist.');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/deduct_funds');
            }
            $userWallet = MemberHelper::user_wallet($getuser['id']);

            if ($amount > $userWallet) {

                $flash = Helpers::flash('danger', "Balance is $userWallet");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/deduct_funds');
            }

            $userid = $getuser["id"];
            $data["user_id"] = $getuser["id"];
            $data["wallet_amount"] = $amount;
            $data["updated_at"] = date('Y-m-d');
            $update = $this->Adm->substract_wallet_amount($userid, $amount);
            if ($update) {
                $entry["from_id"] = "1";
                $entry["to_id"] = $getuser["id"];
                $entry["amount"] = $amount;
                $entry["wallet_type"] = "Deduct";
                $entry["wallet"] = "Topup";
                $entry["reason"] = $reason;
                $entry["date"] = date('Y-m-d');
                $addhsitory = $this->Adm->addtransfer_entry($entry);
                $flash = Helpers::flash('success', "Amount Deducted");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/deduct_funds');
            }
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/deduct_funds"]);
    }

    public function deposit_history()
    {


        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $data = $this->Adm->get_topup_deposit_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $data = $this->Adm->get_topup_deposit_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $data = $this->Adm->get_topup_deposit_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $data = $this->Adm->get_topup_deposit_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $data = $this->Adm->get_topup_deposit_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));
            $data = $this->Adm->get_topup_deposit_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));


            $data = $this->Adm->get_topup_deposit_history_by_date($endDate, $today);
        } else {
            $data = $this->Adm->get_topup_deposit_history_by_date();
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/topup_wallet_deposit_history", "data" => $data]);
    }

    public function deduct_history()
    {



        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $data = $this->Adm->get_topup_deduct_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $data = $this->Adm->get_topup_deduct_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $data = $this->Adm->get_topup_deduct_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $data = $this->Adm->get_topup_deduct_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $data = $this->Adm->get_topup_deduct_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));
            $data = $this->Adm->get_topup_deduct_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));


            $data = $this->Adm->get_topup_deduct_history_by_date($endDate, $today);
        } else {
            $data = $this->Adm->get_topup_deduct_history_by_date();
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/topup_wallet_deduct_history", "data" => $data]);
    }


    public function ewallet_add_funds()
    {
        if ($this->input->post()) {
            $username = $this->input->post("username");
            $amount = $this->input->post("amount");
            $reason = $this->input->post("reason");
            $getuser = Helpers::getuserbyusername($username);
            if (!$getuser) {
                $flash = Helpers::flash('danger', 'This user does not exist.');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/ewallet_add_funds');
            }

            $userid = $getuser["id"];
            $data["user_id"] = $getuser["id"];
            $data["amount"] = $amount;
            $data["created_at"] = date('Y-m-d');
            $update = $this->Adm->add_earning_amount($userid, $data);
            if ($update) {
                $entry["from_id"] = "1";
                $entry["to_id"] = $getuser["id"];
                $entry["amount"] = $amount;
                $entry["wallet_type"] = "Deposit";
                $entry["wallet"] = "ewallet";
                $entry["reason"] = $reason;
                $entry["date"] = date('Y-m-d');
                $addhsitory = $this->Adm->addtransfer_entry($entry);
                $flash = Helpers::flash('success', "Amount Transferred");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/ewallet_add_funds');
            }
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/ewallet_add_funds"]);
    }

    public function ewallet_deduct_funds()
    {

        if ($this->input->post()) {
            $username = $this->input->post("username");
            $amount = $this->input->post("amount");
            $reason = $this->input->post("reason");
            $getuser = Helpers::getuserbyusername($username);
            if (!$getuser) {
                $flash = Helpers::flash('danger', 'This user does not exist.');
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/ewallet_deduct_funds');
            }

            $userWallet = MemberHelper::ewallet($getuser['id']);

            if ($amount > $userWallet) {

                $flash = Helpers::flash('danger', "Balance is $userWallet");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/deduct_funds');
            }

            $userid = $getuser["id"];
            $data["user_id"] = $getuser["id"];
            $data["amount"] = $amount;
            $data["created_at"] = date('Y-m-d');
            $update = $this->Adm->substract_ewallet_amount($userid, $amount);
            if ($update) {
                $entry["from_id"] = "1";
                $entry["to_id"] = $getuser["id"];
                $entry["amount"] = $amount;
                $entry["wallet_type"] = "Deduct";
                $entry["wallet"] = "ewallet";
                $entry["reason"] = $reason;
                $entry["date"] = date('Y-m-d');
                $addhsitory = $this->Adm->addtransfer_entry($entry);
                $flash = Helpers::flash('success', "Amount Deducted");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/ewallet_deduct_funds');
            }
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/ewallet_deduct_funds"]);
    }

    public function ewallet_deposit_history()
    {


        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $data = $this->Adm->get_ewallet_deposit_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $data = $this->Adm->get_ewallet_deposit_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $data = $this->Adm->get_ewallet_deposit_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $data = $this->Adm->get_ewallet_deposit_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $data = $this->Adm->get_ewallet_deposit_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));
            $data = $this->Adm->get_ewallet_deposit_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));


            $data = $this->Adm->get_ewallet_deposit_history_by_date($endDate, $today);
        } else {
            $data = $this->Adm->get_ewallet_deposit_history_by_date();
        }


        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/ewallet_deposit_history", "data" => $data]);
    }

    public function ewallet_deduct_history()
    {
        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $data = $this->Adm->get_ewallet_deduct_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $data = $this->Adm->get_ewallet_deduct_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $data = $this->Adm->get_ewallet_deduct_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $data = $this->Adm->get_ewallet_deduct_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $data = $this->Adm->get_ewallet_deduct_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));
            $data = $this->Adm->get_ewallet_deduct_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));


            $data = $this->Adm->get_ewallet_deduct_history_by_date($endDate, $today);
        } else {
            $data = $this->Adm->get_ewallet_deduct_history_by_date();
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/ewallet_deduct_history", "data" => $data]);
    }

    public function mpesa_response()
    {


        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getccrequests = $this->Adm->get_all_fund_deposits_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getccrequests = $this->Adm->get_all_fund_deposits_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getccrequests = $this->Adm->get_all_fund_deposits_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getccrequests = $this->Adm->get_all_fund_deposits_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getccrequests = $this->Adm->get_all_fund_deposits_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_all_fund_deposits_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_all_fund_deposits_by_date($endDate, $today);
        } else {
            $getccrequests = $this->Adm->get_all_fund_deposits_by_date();
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/mpesa_response", "data" => $getccrequests]);
    }


    public function app_ss_request()
    {

        $data = $this->Adm->get_app_ss_request();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/app_ss_request", "data" => $data]);
    }

    public function accept_app_ss_request()
    {


        $id = $this->uri->segment(3);

        $request = $this->Adm->getsingleRow_app_ss($id);

        $data = array();
        $data["status"] = 1;

        $res = $this->Adm->update_app_ss_request($id, $data);

        if ($res) {

            // $amount['wallet_amount'] = 30;
            $app_amount['amount'] = 100;
            $app_amount['user_id'] = $request['user_id'];
            $response = $this->Adm->add_app_earnings($request['user_id'], $app_amount);
            //  $this->Adm->add_wallet_amount($request['user_id'],$amount);
            if ($response) {
                $user = Helpers::getUserObj($app_amount['user_id']);

                $mailView = $this->load->view("emails/app_review", array("user" => $user), true);
                Helpers::sendEmail("App Review Earnings", $user["email"], $mailView);

                Helpers::saveMail($user['id'], "Accepted App Reviewing ScreenShot By Admin");


                redirect("admin/app_ss_request");
            }
        } else {

            redirect("admin/app_ss_request");
        }
    }


    public function reject_app_ss_request()
    {


        $id = $this->uri->segment(3);
        $data = array();
        $data["status"] = 2;

        $res = $this->Adm->update_app_ss_request($id, $data);

        if ($res) {


            redirect("admin/app_ss_request");
        } else {

            redirect("admin/app_ss_request");
        }
    }

    public function get_spining_report()
    {

        $data = $this->Adm->get_spining_report();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/spining_report", "data" => $data]);
    }
    // public function topEarnedUsers(){

    //       $data = $this->Adm->topEarnedUsers();

    //     $this->load->view("admin/layouts/adminview", ["template"=>"admin/pages/top_earned","data"=>$data]);

    // }

    public function whatsapp_withdraw_status()
    {

        if ($this->input->post('whatsapp_withdraw_status')) {
            $data = array();
            $data['whatsapp_withdraw_status'] = $this->input->post('active');
            $res = $this->Adm->update_settings($data);
            if ($res) {
                $flash = Helpers::flash('success', "Status Updated");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/whatsapp_withdraw_status');
            } else {

                $flash = Helpers::flash('danger', "Somthing Went Wrong");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/whatsapp_withdraw_status');
            }
        }


        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/whatsapp_withdraw_status"]);
    }

    public function withdraw_status()
    {

        if ($this->input->post('withdraw_status')) {
            $data = array();
            $data['withdraw_status'] = $this->input->post('active');
            $res = $this->Adm->update_settings($data);
            if ($res) {
                $flash = Helpers::flash('success', "Status Updated");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/withdraw_status');
            } else {

                $flash = Helpers::flash('danger', "Somthing Went Wrong");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/withdraw_status');
            }
        }

        if ($this->input->post('single_user')) {
            $username = $this->input->post('username');
            if ($username) {


                $user = Helpers::getuserbyusername($username);
                if (!$user) {

                    $flash = Helpers::flash('danger', "Username Not Exists !");
                    $this->session->set_flashdata('response1', $flash);
                    return redirect('admin/withdraw_status');
                }
                $id = $user['id'];
                redirect('admin/change_withdraw_status?id=' . $id);
            }
        }





        $deniedUser = $this->Adm->getDeniedUsers();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/withdraw_status", "data" => $deniedUser]);
    }

    public function change_withdraw_status()
    {

        if ($this->input->get('id')) {
            $id = $this->input->get('id');

            $user = Helpers::getUserObj($id);

            $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/change_withdraw_status", "data" => $user]);
        }
    }


    public function allow_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $user = Helpers::getUserObj($id);
            $data = array();

            $data["withdraw_status"] = 1;

            $resp = $this->Adm->updateuser($user['id'], $data);
            if ($resp) {


                $flash = Helpers::flash('success', 'Withdraw Status Allowed Successfully.');
                $this->session->set_flashdata('response1', $flash);
                return redirect("admin/withdraw_status");
            } else {
                echo "failed";
            }
        }
    }
    public function deny_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $user = Helpers::getUserObj($id);
            $data = array();

            $data["withdraw_status"] = 0;

            $resp = $this->Adm->updateuser($user['id'], $data);
            if ($resp) {


                $flash = Helpers::flash('danger', 'Withdraw Status Denied Successfully.');
                $this->session->set_flashdata('response1', $flash);
                return redirect("admin/withdraw_status");
            } else {
                echo "failed";
            }
        }
    }

    //GET UNIQUE VALUE IN MULTI DIMENSIONAL ARRAY
    function unique_multidim_array($array, $key)
    {
        $temp_array = array();
        $i = 0;
        $key_array = array();

        foreach ($array as $val) {
            if (!in_array($val[$key], $key_array)) {
                $key_array[$i] = $val[$key];
                $temp_array[$i] = $val;
            }
            $i++;
        }
        return $temp_array;
    }


    public function topEarned()
    {

        $data = $this->Adm->topEarned();
        $key = array();
        foreach ($data as $row) {

            //SUM ROWS SINGLE USER
            $total = Helpers::sumRows($row["user_id"]);


            array_push($key, ["user_id" => $row['user_id'], "total" => $total]);
        }

        //UNIQUE
        $uniqueArray = $this->unique_multidim_array($key, 'user_id');

        //SORTING
        $sortbyTotal = array_column($uniqueArray, 'total');

        array_multisort($sortbyTotal, SORT_DESC, $uniqueArray);

        //LIMIT

        $limitArray = array_slice($uniqueArray, 0, 20);

        $finalArray = array();
        foreach ($limitArray as $user) {

            $eWallet = MemberHelper::ewallet($user['user_id']);

            $finalPrice = $user['total'] + $eWallet;

            array_push($finalArray, ["user_id" => $user['user_id'], "finalPrice" => $finalPrice]);
        }

        $sortbyFinalPrice = array_column($finalArray, 'finalPrice');

        array_multisort($sortbyFinalPrice, SORT_DESC, $finalArray);
        // echo "<pre>";
        // print_r($finalArray);
        // exit;   






        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/topEarned", "data" => $finalArray]);
    }

    public function accept_all_wApp_request()
    {

        $data = $this->Adm->whatsapp_all_request();

        foreach ($data as $row) {
            // echo "<pre>";
            $id = $row['id'];

            $res = $this->Adm->getsingleRow($id);
            $earning = $res['views'] * 100;
            $data = array();
            $data["status"] = 1;
            $data["earning"] = $earning;
            $this->Adm->update_whatsapp_request($id, $data);


            $data1 = array();
            $data1["amount"] = $earning;
            $data1['user_id'] = $res['user_id'];

            $result = $this->Members->add_whatsapp_earning($data1['user_id'], $data1);

            $user = Helpers::getUserObj($data1['user_id']);

            $mailView = $this->load->view("emails/whatsapp_approvel", array("user" => $user, "amount" => $data1["amount"], "views" => $res['views']), true);
            Helpers::sendEmail("WhatsApp Earnings", $user['email'], $mailView);


            Helpers::saveMail($user['id'], "Accept WhatsApp Approvel By Admin");
        }



        redirect('admin/whatsapp_request');
    }

    public function active_users()
    {


        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $data = $this->Adm->getactiveusers_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $data = $this->Adm->getactiveusers_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $data = $this->Adm->getactiveusers_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $data = $this->Adm->getactiveusers_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $data = $this->Adm->getactiveusers_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $data = $this->Adm->getactiveusers_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $data = $this->Adm->getactiveusers_by_date($endDate, $today);
        } else {
            $data = $this->Adm->getactiveusers_by_date();
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/active_users", "data" => $data]);
    }


    public function dormant_users()
    {


        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $data = $this->Adm->getAllusers_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $data = $this->Adm->getAllusers_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $data = $this->Adm->getAllusers_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $data = $this->Adm->getAllusers_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $data = $this->Adm->getAllusers_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));
            $data = $this->Adm->getAllusers_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));


            $data = $this->Adm->getAllusers_by_date($endDate, $today);
        } else {
            $data = $this->Adm->getAllusers_by_date();
        }

        $notExistsUsers = array();
        foreach ($data as $row) {

            $pack = MemberHelper::checkpackbought($row['id']);

            if (!$pack) {

                array_push($notExistsUsers, ["user_id" => $row['id']]);
            }
        }
        //      echo "<pre>";
        // print_r($notExistsUsers);
        // exit;

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/dormant_users", "data" => $notExistsUsers]);
    }



    public function whatsapp_earning_clear()
    {

        if ($this->input->post('clear_all')) {

            $del = $this->Adm->clearWhatsAppEarnigs();
            if ($del) {

                $flash = Helpers::flash('success', 'Cleared All Earnings !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/whatsapp_earning_clear");
            }
        }



        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/whatsapp_earning_clear"]);
    }


    public function bank_log()
    {

        if ($this->input->post()) {

            $values['logs_name'] = $this->input->post('logs_name');
            $values['vendor'] = $this->input->post('vendor');
            $values['includes'] = $this->input->post('includes');
            $values['balance'] = $this->input->post('balance');
            $values['price'] = $this->input->post('price');
            $values['status'] = $this->input->post('status');
            $values['created_at'] = date("Y-m-d H:i:s");
            $res = $this->Adm->addBankLogs($values);
            if ($res) {

                $flash = Helpers::flash('success', 'Bank Logs Successfully Added !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/bank_log");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/bank_log");
            }
        }

        $data = $this->Adm->getBankLogs();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/bank_log", "data" => $data]);
    }

    public function edit_bank_log()
    {
        if ($this->input->post()) {
            $id = $this->input->post('id');
            $values['logs_name'] = $this->input->post('logs_name');
            $values['vendor'] = $this->input->post('vendor');
            $values['includes'] = $this->input->post('includes');
            $values['balance'] = $this->input->post('balance');
            $values['price'] = $this->input->post('price');

            $res = $this->Adm->updateBankLog($id, $values);
            if ($res) {

                $flash = Helpers::flash('success', 'Bank Logs Successfully Updated !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/bank_log");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/bank_log");
            }
        }
        $id = $this->input->get('id');
        $row = $this->Adm->getSingleRowBankLog($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_bank_log", "data" => $row]);
    }

    public function edit_bank_log_status()
    {
        if ($this->input->post()) {
            $id = $this->input->post('id');
            $values['status'] = $this->input->post('status');
            $res = $this->Adm->updateBankLog($id, $values);
            if ($res) {

                $flash = Helpers::flash('success', 'Bank Logs Status Successfully Updated !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/bank_log");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/bank_log");
            }
        }
        $id = $this->input->get('id');
        $row = $this->Adm->getSingleRowBankLog($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_bank_log_status", "data" => $row]);
    }
    public function usa_paypal()
    {

        if ($this->input->post()) {

            $values['logs_name'] = $this->input->post('logs_name');
            $values['vendor'] = $this->input->post('vendor');
            $values['includes'] = $this->input->post('includes');
            $values['balance'] = $this->input->post('balance');
            $values['price'] = $this->input->post('price');
            $values['status'] = $this->input->post('status');
            $values['created_at'] = date("Y-m-d H:i:s");
            $res = $this->Adm->addUSAPaypal($values);
            if ($res) {

                $flash = Helpers::flash('success', 'USA Paypal Successfully Added !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/usa_paypal");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/usa_paypal");
            }
        }

        $data = $this->Adm->getUSAPaypal();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/usa_paypal", "data" => $data]);
    }


    public function edit_usa_paypal()
    {
        if ($this->input->post()) {
            $id = $this->input->post('id');
            $values['logs_name'] = $this->input->post('logs_name');
            $values['vendor'] = $this->input->post('vendor');
            $values['includes'] = $this->input->post('includes');
            $values['balance'] = $this->input->post('balance');
            $values['price'] = $this->input->post('price');

            $res = $this->Adm->updateUSAPaypal($id, $values);
            if ($res) {

                $flash = Helpers::flash('success', 'USA Paypal Successfully Updated !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/usa_paypal");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/usa_paypal");
            }
        }
        $id = $this->input->get('id');
        $row = $this->Adm->getSingleRowUSAPaypal($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_usa_paypal", "data" => $row]);
    }


    public function edit_usa_paypal_status()
    {
        if ($this->input->post()) {
            $id = $this->input->post('id');
            $values['status'] = $this->input->post('status');


            $res = $this->Adm->updateUSAPaypal($id, $values);
            if ($res) {

                $flash = Helpers::flash('success', 'USA Paypal Status Successfully Updated !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/usa_paypal");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/usa_paypal");
            }
        }
        $id = $this->input->get('id');
        $row = $this->Adm->getSingleRowUSAPaypal($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_usa_paypal_status", "data" => $row]);
    }


    public function master_card()
    {

        if ($this->input->post()) {

            $values['logs_name'] = $this->input->post('logs_name');
            $values['bin'] = $this->input->post('bin');
            $values['includes'] = $this->input->post('includes');
            $values['card_number'] = $this->input->post('card_number');
            $values['price'] = $this->input->post('price');
            $values['status'] = $this->input->post('status');
            $values['created_at'] = date("Y-m-d H:i:s");
            $res = $this->Adm->addMasterCard($values);
            if ($res) {

                $flash = Helpers::flash('success', 'Master Card Successfully Added !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/master_card");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/master_card");
            }
        }

        $data = $this->Adm->getMasterCard();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/master_card", "data" => $data]);
    }

    public function edit_master_card()
    {
        if ($this->input->post()) {
            $id = $this->input->post('id');
            $values['logs_name'] = $this->input->post('logs_name');
            $values['bin'] = $this->input->post('bin');
            $values['includes'] = $this->input->post('includes');
            $values['card_number'] = $this->input->post('card_number');
            $values['price'] = $this->input->post('price');

            $res = $this->Adm->updateMasterCard($id, $values);
            if ($res) {

                $flash = Helpers::flash('success', 'Master Card Successfully Updated !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/master_card");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/master_card");
            }
        }
        $id = $this->input->get('id');
        $row = $this->Adm->getSingleRowMasterCard($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_master_card", "data" => $row]);
    }


    public function edit_master_card_status()
    {
        if ($this->input->post()) {
            $id = $this->input->post('id');
            $values['status'] = $this->input->post('status');


            $res = $this->Adm->updateMasterCard($id, $values);
            if ($res) {

                $flash = Helpers::flash('success', 'Master Card Status Successfully Updated !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/master_card");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/master_card");
            }
        }
        $id = $this->input->get('id');
        $row = $this->Adm->getSingleRowMasterCard($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_master_card_status", "data" => $row]);
    }

    public function visa()
    {

        if ($this->input->post()) {

            $values['logs_name'] = $this->input->post('logs_name');
            $values['bin'] = $this->input->post('bin');
            $values['includes'] = $this->input->post('includes');
            $values['balance'] = $this->input->post('balance');
            $values['price'] = $this->input->post('price');
            $values['status'] = $this->input->post('status');
            $values['created_at'] = date("Y-m-d H:i:s");
            $res = $this->Adm->addVisa($values);
            if ($res) {

                $flash = Helpers::flash('success', 'Visa Successfully Added !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/visa");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/visa");
            }
        }

        $data = $this->Adm->getVisa();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/visa", "data" => $data]);
    }

    public function edit_visa()
    {
        if ($this->input->post()) {
            $id = $this->input->post('id');
            $values['logs_name'] = $this->input->post('logs_name');
            $values['bin'] = $this->input->post('bin');
            $values['includes'] = $this->input->post('includes');
            $values['balance'] = $this->input->post('balance');
            $values['price'] = $this->input->post('price');

            $res = $this->Adm->updateVisa($id, $values);
            if ($res) {

                $flash = Helpers::flash('success', 'Visa Successfully Updated !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/visa");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/visa");
            }
        }
        $id = $this->input->get('id');
        $row = $this->Adm->getSingleRowVisa($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_visa", "data" => $row]);
    }

    public function edit_visa_status()
    {
        if ($this->input->post()) {
            $id = $this->input->post('id');
            $values['status'] = $this->input->post('status');


            $res = $this->Adm->updateVisa($id, $values);
            if ($res) {

                $flash = Helpers::flash('success', 'Visa Status Successfully Updated !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/visa");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong !');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/visa");
            }
        }
        $id = $this->input->get('id');
        $row = $this->Adm->getSingleRowVisa($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_visa_status", "data" => $row]);
    }

    public function deposit_response()
    {


        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getccrequests = $this->Adm->get_all_fund_response_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getccrequests = $this->Adm->get_all_fund_response_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getccrequests = $this->Adm->get_all_fund_response_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getccrequests = $this->Adm->get_all_fund_response_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getccrequests = $this->Adm->get_all_fund_response_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_all_fund_response_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_all_fund_response_by_date($endDate, $today);
        } else {
            $getccrequests = $this->Adm->get_all_fund_response_by_date();
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/deposit_response", "data" => $getccrequests]);
    }


    public function send_mail_user()
    {

        if ($this->input->post()) {

            $uname = $this->input->post('username');
            $user['subject'] = $this->input->post('subject');
            $user['msg'] = $this->input->post('message');
            $single_user = $this->Adm->get_single_user($uname);

            if ($single_user) {
                $data['user_id'] = $single_user['id'];
                $data['msg'] = $user['msg'];
                $data['subject'] = $user['subject'];
                $this->Adm->add_adm_msg($data);
                $this->Adm->updateUser($data['user_id'], ["notify" => 1]);


                $mailView = $this->load->view("emails/sendmailtouser", array("user" => $user), true);
                Helpers::sendEmail("Welcome to Flibcart", $single_user['email'], $mailView);
                // sleep(7);
                Helpers::saveMail($single_user['id'], "Send Mail To User By Admin");

                $this->session->set_flashdata('msg', 'Mail Sent Successfully');
                redirect(base_url() . 'admin/send_mail_user');
            } else {
                $this->session->set_flashdata('err', 'Username Not found');
                redirect(base_url() . 'admin/send_mail_user');
            }
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/send_mail_user"]);
    }

    public function send_mail_all_user()
    {

        if ($this->input->post()) {

            $user['subject'] = $this->input->post('subject');
            $user['msg'] = $this->input->post('message');
            $data['msg'] = $user['msg'];
            $data['subject'] = $user['subject'];
            $this->Adm->add_adm_msg_all_users($data);
            $this->Adm->updateAllUser(["notify" => 1]);

            $this->session->set_flashdata('msg', 'Notification Sent Successfully');
            redirect(base_url() . 'admin/send_mail_all_user');
        }



        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/send_mail_all_user"]);
    }

    public function wallet_transfer_history()
    {



        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getccrequests = $this->Adm->wallet_transfer_history_all_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getccrequests = $this->Adm->wallet_transfer_history_all_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getccrequests = $this->Adm->wallet_transfer_history_all_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getccrequests = $this->Adm->wallet_transfer_history_all_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getccrequests = $this->Adm->wallet_transfer_history_all_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->wallet_transfer_history_all_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->wallet_transfer_history_all_by_date($endDate, $today);
        } else {
            $getccrequests = $this->Adm->wallet_transfer_history_all_by_date();
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/wallet_transfer_history", "data" => $getccrequests]);
    }

    public function block_users()
    {

        $data = $this->Adm->block_users();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/block_users", "data" => $data]);
    }

    public function agent_verification_request()
    {

        $data = $this->Adm->get_agent_verification_request();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/agent_verification_request", "data" => $data]);
    }



    public function accept_agent_verification_request()
    {


        $id = $this->input->get('id');
        $data = array();
        $data["status"] = 1;
        $row = $this->Adm->get_single_row_agent($id);
        $res = $this->Adm->update_agent_verification_request($id, $data);

        if ($res) {


            $userObj = Helpers::getUserObj($row['user_id']);
            $sponsor = MemberHelper::getsponsordetails($row['user_id']);
            $mailView = $this->load->view("emails/accept-agent", array("user" => $userObj, "sponsor" => $sponsor["username"]), true);
            Helpers::sendEmail("Approved Agent Verification", $userObj['email'], $mailView);
            // sleep(7);
            Helpers::saveMail($userObj['id'], "Approved Agent Verification");

            redirect("admin/agent_verification_request");
        } else {

            redirect("admin/agent_verification_request");
        }
    }



    public function reject_agent_verification()
    {
        $id = $this->input->get('id');
        $data = array();
        $data["status"] = 2;

        $res = $this->Adm->update_agent_verification_request($id, $data);

        if ($res) {


            redirect("admin/agent_verification_request");
        } else {

            redirect("admin/agent_verification_request");
        }
    }


    public function accept_all_agent_verification_request()
    {

        $data = $this->Adm->get_all_pending_agent_verification_request();

        foreach ($data as $row) {
            // echo "<pre>";
            $id = $row['id'];

            $res = $this->Adm->get_single_row_agent($id);

            $data = array();
            $data["status"] = 1;

            $this->Adm->update_agent_verification_request($id, $data);
        }



        redirect('admin/agent_verification_request');
    }
    public function agent_verification_history()
    {

        // $data = $this->Adm->get_history_agent();

        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getccrequests = $this->Adm->get_history_agent_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getccrequests = $this->Adm->get_history_agent_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getccrequests = $this->Adm->get_history_agent_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getccrequests = $this->Adm->get_history_agent_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getccrequests = $this->Adm->get_history_agent_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_history_agent_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_history_agent_by_date($endDate, $today);
        } else {
            $getccrequests = $this->Adm->get_history_agent_by_date();
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/agent_history", "data" => $getccrequests]);
    }

    public function paypal_verification_history()
    {

        // $data = $this->Adm->get_history_paypal();

        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getccrequests = $this->Adm->get_history_paypal_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getccrequests = $this->Adm->get_history_paypal_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getccrequests = $this->Adm->get_history_paypal_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getccrequests = $this->Adm->get_history_paypal_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getccrequests = $this->Adm->get_history_paypal_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_history_paypal_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_history_paypal_by_date($endDate, $today);
        } else {
            $getccrequests = $this->Adm->get_history_paypal_by_date();
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/paypal_history", "data" => $getccrequests]);
    }

    public function paypal_verification_request()
    {

        $data = $this->Adm->get_paypal_verification_request();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/paypal_verification_request", "data" => $data]);
    }



    public function accept_paypal_verification_request()
    {


        $id = $this->input->get('id');
        $data = array();
        $data["status"] = 1;
        $row = $this->Adm->get_single_row_paypal($id);
        $res = $this->Adm->update_paypal_verification_request($id, $data);

        if ($res) {
            $wallet['user_id'] = $row['user_id'];
            $wallet['amount'] = $row['amount'];
            $wallet['created_at'] = date("Y-m-d H:i:s");
            $this->Members->add_paypal_wallet($wallet['user_id'], $wallet);


            $flash = Helpers::flash('success', 'Accepted Successfully !');
            $this->session->set_flashdata('response', $flash);
            redirect("admin/paypal_verification_request");
        } else {

            redirect("admin/paypal_verification_request");
        }
    }



    public function reject_paypal_verification()
    {
        $id = $this->input->get('id');
        $data = array();
        $data["status"] = 2;

        $res = $this->Adm->update_paypal_verification_request($id, $data);

        if ($res) {
            $flash = Helpers::flash('danger', 'Rejected Successfully !');
            $this->session->set_flashdata('response', $flash);

            redirect("admin/paypal_verification_request");
        } else {

            redirect("admin/paypal_verification_request");
        }
    }


    public function withdraw_paypal_requests()
    {
        $getccrequests = $this->Adm->get_withdraw_paypal_requests();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/withdraw_paypal_requests", "data" => $getccrequests]);
    }


    public function approve_paypal_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_paypal_withdraw_details($id);
            $data = $wallet = array();
            $data["status"] = 1;
            // $data["marked"] = 1;            
            $resp = $this->Adm->update_paypal_withdraw($id, $data);
            if ($resp) {

                $flash = Helpers::flash('success', ' Withdrawal Accepted Successfully.');
                $this->session->set_flashdata('response', $flash);
                // $url="admin/".$getdetails["type"]."_requests";
                return redirect("admin/withdraw_paypal_requests");
            } else {
                echo "failed";
            }
        }
    }
    public function reject_paypal_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_paypal_withdraw_details($id);
            $data = $wallet = array();
            $data["status"] = 2;
            // $data["marked"] = 1;            
            $resp = $this->Adm->update_paypal_withdraw($id, $data);
            if ($resp) {
                $wallet['user_id'] = $getdetails['user_id'];
                $wallet['amount'] = $getdetails['amount'];
                $this->Members->add_paypal_wallet($wallet['user_id'], $wallet);

                $flash = Helpers::flash('danger', ' Withdrawal Rejected Successfully.');
                $this->session->set_flashdata('response', $flash);
                // $url="admin/".$getdetails["type"]."_requests";
                return redirect("admin/withdraw_paypal_requests");
            } else {
                echo "failed";
            }
        }
    }

    public function unlock_package_history()
    {

        // $data = $this->Adm->get_unlock_package_history();

        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getccrequests = $this->Adm->get_unlock_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getccrequests = $this->Adm->get_unlock_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getccrequests = $this->Adm->get_unlock_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getccrequests = $this->Adm->get_unlock_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getccrequests = $this->Adm->get_unlock_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_unlock_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_unlock_package_history_by_date($endDate, $today);
        } else {
            $getccrequests = $this->Adm->get_unlock_package_history_by_date();
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/unlock_package_history", "data" => $getccrequests]);
    }

    public function verification_package_history()
    {

        // $data = $this->Adm->get_verification_package_history();

        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getccrequests = $this->Adm->get_verification_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getccrequests = $this->Adm->get_verification_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getccrequests = $this->Adm->get_verification_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getccrequests = $this->Adm->get_verification_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getccrequests = $this->Adm->get_verification_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_verification_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_verification_package_history_by_date($endDate, $today);
        } else {
            $getccrequests = $this->Adm->get_verification_package_history_by_date();
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/verification_package_history", "data" => $getccrequests]);
    }


    public function accept_all_paypal_request()
    {

        $data = $this->Adm->get_all_pending_paypal_request();

        foreach ($data as $row) {
            // echo "<pre>";
            $id = $row['id'];

            $res = $this->Adm->get_single_row_paypal($id);

            $data = array();
            $data["status"] = 1;

            $this->Adm->update_paypal_verification_request($id, $data);
        }

        redirect('admin/paypal_verification_request');
    }

    public function paypal_package_history()
    {

        // $data = $this->Adm->get_paypal_package_history();

        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getccrequests = $this->Adm->get_paypal_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getccrequests = $this->Adm->get_paypal_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getccrequests = $this->Adm->get_paypal_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getccrequests = $this->Adm->get_paypal_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getccrequests = $this->Adm->get_paypal_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_paypal_package_history_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_paypal_package_history_by_date($endDate, $today);
        } else {
            $getccrequests = $this->Adm->get_paypal_package_history_by_date();
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/paypal_package_history", "data" => $getccrequests]);
    }

    public function transfer_block()
    {

        if ($this->input->post()) {

            $username = $this->input->post('username');
            $user = $this->Adm->get_single_user($username);

            if (!$user) {
                $flash = Helpers::flash('danger', ' User not found');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/transfer_block");
            }

            $data['transfer_block'] = $this->input->post('status');

            $res = $this->Adm->updateuser($user['id'], $data);
            if ($res) {
                if ($data['transfer_block'] == 0) {
                    $flash = Helpers::flash('success', 'Wallet transfer blocked successfully');
                } else {
                    $flash = Helpers::flash('success', 'Wallet transfer Unblocked successfully');
                }

                $this->session->set_flashdata('response', $flash);
                return redirect("admin/transfer_block");
            } else {
                $flash = Helpers::flash('danger', ' Something went wrong');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/transfer_block");
            }
        }
        $data = $this->Adm->get_transfer_blocked_users();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/transfer_block", "data" => $data]);
    }



    public function withdraw_compounding_history()
    {
        $getccrequests = $this->Adm->get_withdraw_compounding_history();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/withdraw_compounding_history", "data" => $getccrequests]);
    }
    public function withdraw_compounding_requests()
    {
        $getccrequests = $this->Adm->get_withdraw_compounding_requests();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/withdraw_compounding_requests", "data" => $getccrequests]);
    }


    public function approve_compound_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_compound_withdraw_details($id);
            $data = $wallet = array();
            $data["status"] = 1;
            $data["marked"] = 1;
            $resp = $this->Adm->update_compound_withdraw($id, $data);
            if ($resp) {

                $flash = Helpers::flash('success', ' Withdrawal Accepted Successfully.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/withdraw_compounding_requests");
            } else {
                echo "failed";
            }
        }
    }
    public function reject_compound_withdraw()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $getdetails = $this->Adm->get_compound_withdraw_details($id);
            $data = $wallet = array();
            $data["status"] = 2;
            $data["marked"] = 1;
            $resp = $this->Adm->update_compound_withdraw($id, $data);
            if ($resp) {

                $data = array("user_id" => $getdetails['user_id'], "amount" => $getdetails['amount'], "created_at" => date("Y-m-d H:i:s"));

                $this->Members->add_compounding_earning($getdetails['user_id'], $data);

                $flash = Helpers::flash('danger', ' Withdrawal Rejected Successfully.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/withdraw_compounding_requests");
            } else {
                echo "failed";
            }
        }
    }

    public function banner()
    {
        if ($_POST) {

            $fileName = '';
            if (!empty($_FILES['fileupload']['name'])) {
                $uploadPath = 'uploads/files/banner/' . $this->username["id"];
                if (!is_dir($uploadPath)) {
                    mkdir($uploadPath, 0777);
                }
                $config['upload_path'] = $uploadPath;
                $config['allowed_types'] = 'jpg|png';
                // $config['max_size'] = 0;


                // Load and initialize upload library
                $this->load->library('upload', $config);
                $this->upload->initialize($config);

                // Upload file to server
                if ($this->upload->do_upload('fileupload')) {
                    // Uploaded file data

                    $fileData = $this->upload->data();
                    $fileName = $fileData['file_name'];
                }

                // else{
                //          $error = array('error' => $this->upload->display_errors());
                //     print_r($error);
                //     exit;

                // }
            }

            $banner = $this->Members->get_banner();
            if ($banner) {
                $flash = Helpers::flash('danger', ' Banner Already Exists.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/banner");
            }

            $data['banner'] = $fileName;

            $this->load->model('Adm');
            $res = $this->Adm->add_banner($data);

            if ($res) {
                $flash = Helpers::flash('success', ' Banner uploaded successfully.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/banner");
            } else {
                $flash = Helpers::flash('danger', ' Something went wrong.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/banner");
            }
        }
        $this->load->model('Members');
        $data = $this->Members->get_banner();

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/banner", "data" => $data]);
    }


    public function remove_banner()
    {
        $id = $this->uri->segment(3);
        $this->load->model('Adm');
        $res = $this->Adm->remove_banner($id);

        if ($res) {

            $flash = Helpers::flash('danger', ' Banner removed successfully.');
            $this->session->set_flashdata('response', $flash);
            return redirect("admin/banner");
        } else {


            redirect("admin/banner");
        }
    }

    public function packages_edit()
    {
        $data = $this->Members->get_all_packages();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/packages_edit", "data" => $data]);
    }

    public function pack_edit()
    {

        if ($this->input->post()) {

            $id = $this->input->post('id');
            $data['name'] = $this->input->post('name');
            $data['amount'] = $this->input->post('amount');

            $res = $this->Members->updatePackages($id, $data);
            if ($res) {
                $flash = Helpers::flash('success', ' Package updated successfully.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/packages_edit");
            } else {
                $flash = Helpers::flash('danger', ' Something went wrong.');
                $this->session->set_flashdata('response', $flash);
                return redirect("admin/packages_edit");
            }
        }
        $id = $this->input->get('id');
        $data = $this->Members->getPackageFromId($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/pack_edit", "data" => $data]);
    }


    public function send_mail_to_all()
    {

        if ($this->input->post()) {
            $users = $this->Adm->get_all_users();
            foreach ($users as $user) {
                $data['subject'] = $this->input->post('subject');
                $data['msg'] = $this->input->post('message');
                $data['user_id'] = $user['id'];
                $data['created_at'] = date("Y-m-d H:i:s");
                $res = $this->Adm->add_email_msg_to_all($data);
            }
            $flash = Helpers::flash('success', ' Mail Sent Successfully.');
            $this->session->set_flashdata('response', $flash);
            return redirect("admin/send_mail_to_all");
        }



        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/send_mail_to_all"]);
    }
    public function send_mail_to_dormant_users()
    {

        if ($this->input->post()) {
            $users = $this->Adm->get_all_users();

            foreach ($users as $user) {

                $pack = $this->Members->getlastpackidbyId($user['id']);
                if (empty($pack)) {

                    $data['subject'] = $this->input->post('subject');
                    $data['msg'] = $this->input->post('message');
                    $data['user_id'] = $user['id'];
                    $data['created_at'] = date("Y-m-d H:i:s");
                    $res = $this->Adm->add_email_msg_to_all($data);
                }
            }

            $flash = Helpers::flash('success', ' Mail Sent Successfully.');
            $this->session->set_flashdata('response', $flash);
            return redirect("admin/send_mail_to_dormant_users");
        }



        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/send_mail_to_dormant_users"]);
    }

    #products

    public function add_products()
    {
        $data = array();
        if ($this->input->post()) {
            // echo "post";
            // exit;
            if (!empty($_FILES['files']['name'])) {
                $filesCount = count($_FILES['files']['name']);
                for ($i = 0; $i < $filesCount; $i++) {
                    $_FILES['file']['name'] = $_FILES['files']['name'][$i];
                    $_FILES['file']['type'] = $_FILES['files']['type'][$i];
                    $_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
                    $_FILES['file']['error'] = $_FILES['files']['error'][$i];
                    $_FILES['file']['size'] = $_FILES['files']['size'][$i];

                    // File upload configuration
                    $uploadPath = 'uploads/files/products/1';
                    // $user_folder = './upload/' . $this->session->userdata('id');
                    if (!is_dir($uploadPath)) {
                        mkdir($uploadPath, 0777);
                    }
                    $config['upload_path'] = $uploadPath;
                    $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
                    // $config['min_width'] = '960';
                    // $config['min_height'] = '640';
                    // $config['max_width'] = '960';
                    // $config['max_height'] = '640';

                    // Load and initialize upload library
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);

                    // Upload file to server
                    if ($this->upload->do_upload('file')) {
                        // Uploaded file data
                        $fileData = $this->upload->data();
                        $upload[$i]['file_name'] = $fileData['file_name'];
                    } else {

                        $error = $this->upload->display_errors();
                        $flash = Helpers::flash('danger', "$error");
                        $this->session->set_flashdata('response', $flash);
                        redirect("admin/add_products");
                    }
                }
                $data['image1'] = $upload[0]['file_name'];
                $data['image2'] = $upload[0]['file_name'];
                $data['image3'] = $upload[0]['file_name'];
                $data['image4'] = $upload[0]['file_name'];
                $data['name'] = $this->input->post('name');
                // $data['bp'] = $this->input->post('bp');
                $data['cat_id'] = $this->input->post('cat_id');
                // $data['display_id'] = $this->input->post('display_id');
                // $data['cost_price'] = $this->input->post('cost_price');
                $data['selling_price'] = $this->input->post('price');
                $data['description'] = $this->input->post('description');
                $data['quantity'] = $this->input->post('quantity');
                $data['created_at'] = date("Y-m-d H:i:s");

                // echo "<pre>";
                // print_r($data);
                // exit;

                $res = $this->Adm->add_product($data);
                if ($res) {
                    $flash = Helpers::flash('success', 'Product Added Successfully');
                    $this->session->set_flashdata('response', $flash);
                    redirect("admin/add_products");
                } else {

                    $flash = Helpers::flash('danger', 'Something went wrong!');
                    $this->session->set_flashdata('response', $flash);
                    redirect("admin/add_products");
                }
            }
        }

        $categories = $this->Adm->get_all_categories();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/add_products", "cat" => $categories]);
    }

    public function view_products()
    {
        $data = $this->Adm->getAllProducts();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/view_products", "data" => $data]);
    }

    public function edit_products()
    {
        $data = array();
        if ($this->input->post()) {

            if (!empty($_FILES['files']['name'])) {
                $filesCount = count($_FILES['files']['name']);
                for ($i = 0; $i < $filesCount; $i++) {
                    $_FILES['file']['name'] = $_FILES['files']['name'][$i];
                    $_FILES['file']['type'] = $_FILES['files']['type'][$i];
                    $_FILES['file']['tmp_name'] = $_FILES['files']['tmp_name'][$i];
                    $_FILES['file']['error'] = $_FILES['files']['error'][$i];
                    $_FILES['file']['size'] = $_FILES['files']['size'][$i];

                    // File upload configuration
                    $uploadPath = 'uploads/files/products/1';
                    // $user_folder = './upload/' . $this->session->userdata('id');
                    if (!is_dir($uploadPath)) {
                        mkdir($uploadPath, 0777);
                    }
                    $config['upload_path'] = $uploadPath;
                    $config['allowed_types'] = 'jpg|jpeg|png|gif|pdf';
                    // $config['min_width'] = '960';
                    //    $config['min_height'] = '640';
                    //    $config['max_width'] = '960';
                    //    $config['max_height'] = '640';

                    // Load and initialize upload library
                    $this->load->library('upload', $config);
                    $this->upload->initialize($config);

                    // Upload file to server
                    if ($this->upload->do_upload('file')) {
                        // Uploaded file data
                        $fileData = $this->upload->data();
                        $upload[$i]['file_name'] = $fileData['file_name'];
                    } else {

                        $error = $this->upload->display_errors();
                        $flash = Helpers::flash('danger', $error);
                        $this->session->set_flashdata('response', $flash);
                        redirect("admin/view_products");
                    }
                }
                $id = $this->input->post('id');
                $data['image1'] = $upload[0]['file_name'];
                $data['image2'] = $upload[1]['file_name'];
                $data['image3'] = $upload[2]['file_name'];
                $data['image4'] = $upload[3]['file_name'];
                $data['name'] = $this->input->post('name');
                $data['bp'] = NULL;
                $data['cat_id'] = NULL;
                $data['display_id'] = NULL;
                $data['cost_price'] = NULL;
                $data['selling_price'] = $this->input->post('price');
                $data['description'] = $this->input->post('description');
                $data['quantity'] = $this->input->post('quantity');
                $data['created_at'] = date("Y-m-d H:i:s");

                //    echo "<pre>";
                //    print_r($data);
                //    exit;
                $res = $this->Adm->update_products($id, $data);
                if ($res) {
                    $flash = Helpers::flash('success', 'Product Updated Successfully');
                    $this->session->set_flashdata('response', $flash);
                    redirect("admin/view_products");
                } else {

                    $flash = Helpers::flash('danger', 'Something went wrong!');
                    $this->session->set_flashdata('response', $flash);
                    redirect("admin/view_products");
                }
            }
        }
        $id = $this->input->get('id');
        $getRow = $this->Adm->getSingleProductById($id);
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/edit_products", "data" => $getRow]);
    }

    public function delete_products()
    {

        $id = $this->input->get('id');
        $data['status'] = 0;
        $res = $this->Adm->update_products($id, $data);
        if ($res) {
            $flash = Helpers::flash('success', 'Product Deleted Successfully');
            $this->session->set_flashdata('response', $flash);
            redirect("admin/view_products");
        } else {

            $flash = Helpers::flash('danger', 'Something went wrong!');
            $this->session->set_flashdata('response', $flash);
            redirect("admin/view_products");
        }
    }

    public function orders()
    {
        if ($this->input->post()) {
            $id = $this->input->post('id');
            $data['status'] = $this->input->post('status');

            if ($data['status'] == 3) {
                $data['shipped_date'] = date("Y-m-d H:i:s");
            } elseif ($data['status'] == 4) {
                $data['delivered_date'] = date("Y-m-d H:i:s");
            }

            $res = $this->Adm->update_orders($id, $data);
            if ($res) {
                $flash = Helpers::flash('success', 'Order Updated Successfully');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/orders");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong!');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/orders");
            }
        }


        $orderStatus = $this->input->get('order_status');

        if ($orderStatus) {
            if ($orderStatus == 'pending') {
                $data = $this->Adm->get_all_pending_orders();
            } else {
                $data = $this->Adm->get_all_orders_by_status($orderStatus);
            }
        } else {
            $data = $this->Adm->get_all_orders();
        }



        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/orders", "data" => $data]);
    }

    public function order_commission()
    {
        $data = $this->Members->get_all_order_commission();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/order_commission", "data" => $data]);
    }

    public function edit_orders()
    {
        $id = $this->input->get('id');
        $data['status'] = 1;
        $data['shipped_date'] = date("Y-m-d H:i:s");
        $res = $this->Adm->update_orders($id, $data);
        if ($res) {
            $flash = Helpers::flash('success', 'Order Updated Successfully');
            $this->session->set_flashdata('response', $flash);
            redirect("admin/orders");
        } else {

            $flash = Helpers::flash('danger', 'Something went wrong!');
            $this->session->set_flashdata('response', $flash);
            redirect("admin/orders");
        }
    }

    public function add_category()
    {

        if ($this->input->post()) {

            $data['name'] = $this->input->post('name');
            $data['created_at'] = date("Y-m-d H:i:s");

            $res = $this->Adm->add_category($data);
            if ($res) {
                $flash = Helpers::flash('success', 'Category Added Successfully');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/add_category");
            } else {

                $flash = Helpers::flash('danger', 'Something went wrong!');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/add_category");
            }
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/add_category"]);
    }
    public function view_category()
    {
        $data = $this->Adm->get_all_categories();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/view_category", "data" => $data]);
    }

    public function deposit_request()
    {
        $requests = $this->Adm->get_all_fund_requests_deposit();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/deposit_request", "data" => $requests]);
    }

    public function deposit_disapprove_funds()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $data = $wallet = array();
            $data["status"] = 0;
            $data["marked"] = 1;

            $resp = $this->Adm->update_status_deposit($id, $data);
            $fundRow = $this->Adm->get_row_by_id_deposit($id);
            if ($resp) {

                $flash = Helpers::flash('danger', 'Request has been rejected.');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/deposit_request");
            } else {
                echo "failed";
            }
        }
    }
    public function deposit_approve_funds()
    {
        if ($this->input->get('id')) {
            $id = $this->input->get('id');
            $data = $wallet = array();
            $data["status"] = 1;
            $data["marked"] = 1;

            $resp = $this->Adm->update_status_deposit($id, $data);
            $fundRow = $this->Adm->get_row_by_id_deposit($id);
            if ($resp) {
                $userId = $fundRow["user_id"];
                $wallet = array();
                $wallet["user_id"] = $userId;
                // $walletInUSD = Coinpayments::get_btc_dollars($fundRow['wallet_type'], $fundRow['amount']);
                $walletInUSD = $fundRow['amount'];
                $wallet['wallet_amount'] = $walletInUSD;
                $wallet['updated_at'] = date("Y-m-d");
                $this->Adm->add_wallet_amount($userId, $wallet);

                $flash = Helpers::flash('success', 'Your request has been updated');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/deposit_request");
            } else {
                echo "failed";
            }
        }
    }
    public function compounding_report()
    {
        $data = $this->Adm->get_compounding_report();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/compounding_report", "data" => $data]);
    }
    public function compounding_commission_report()
    {
        $data = $this->Adm->get_all_commission_roi();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/compounding_commission_report", "data" => $data]);
    }

    public function fee_update()
    {
        if ($this->input->post()) {
            $data["withdraw_fee"] = $this->input->post("withdraw_fee");
            // $data["deposit_fee"] = $this->input->post("deposit_fee");
            // $data["transfer_fee"] = $this->input->post("transfer_fee");
            $resp = $this->Adm->update_settings($data);
            if ($resp) {
                $flash = Helpers::flash('success', 'Your Details are updated');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/fee_update");
            } else {
                $flash = Helpers::flash('danger', 'Something went wrong');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/fee_update");
            }
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/fee_update"]);
    }

    public function enable_user_to_user_notifications()
    {

        if ($this->input->post()) {
            $uname = $this->input->post('username');
            $status = $this->input->post('status');
            $user = Helpers::getuserbyusername($uname);
            if (!$user) {
                $flash = Helpers::flash('danger', ' User not found.');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/enable_user_to_user_notifications");
            }

            if ($status == "enable_e") {
                $data['user_to_user_notification'] = 1;
            } elseif ($status == "disable_d") {
                $data['user_to_user_notification'] = 0;
            }

            $update = $this->Adm->updateuser($user['id'], $data);
            if ($update) {
                if ($status == "enable_e") {

                    $flash = Helpers::flash('success', 'User enabled successfully');
                    $this->session->set_flashdata('response', $flash);
                    return redirect('admin/enable_user_to_user_notifications');
                } elseif ($status == "disable_d") {

                    $flash = Helpers::flash('danger', 'User disabled successfully');
                    $this->session->set_flashdata('response', $flash);
                    return redirect('admin/enable_user_to_user_notifications');
                }
            } else {

                $flash = Helpers::flash('danger', "Something went wrong");
                $this->session->set_flashdata('response', $flash);
                return redirect('admin/enable_user_to_user_notifications');
            }
        }
        $getccrequests = $this->Adm->get_enabled_users_for_user_to_user_noti();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/enable_user_to_user_notifications", "data" => $getccrequests]);
    }

    public function mpesa_settings()
    {
        if ($this->input->post()) {
            $data["consumer_key"] = $this->input->post("consumer_key");
            $data["consumer_secret"] = $this->input->post("consumer_secret");
            $data["short_code"] = $this->input->post("short_code");
            $data["lipa_na_mpesa_key"] = $this->input->post("pass_key");
            $resp = $this->Adm->update_settings($data);
            if ($resp) {
                $flash = Helpers::flash('success', 'Your Details are updated');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/mpesa_settings");
            } else {
                $flash = Helpers::flash('danger', 'Something went wrong');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/mpesa_settings");
            }
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/mpesa_settings"]);
    }
    public function online_writing_settings()
    {
        if ($this->input->post()) {
            $data["online_writing"] = nl2br($this->input->post("online_writing"));
            $resp = $this->Adm->update_settings($data);
            if ($resp) {
                $flash = Helpers::flash('success', 'Your Details are updated');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/online_writing_settings");
            } else {
                $flash = Helpers::flash('danger', 'Something went wrong');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/online_writing_settings");
            }
        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/online_writing_settings"]);
    }

    public function google_ads_history()
    {

        // $data = $this->Adm->get_history_agent();

        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getccrequests = $this->Adm->get_history_google_ads_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getccrequests = $this->Adm->get_history_google_ads_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getccrequests = $this->Adm->get_history_google_ads_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getccrequests = $this->Adm->get_history_google_ads_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getccrequests = $this->Adm->get_history_google_ads_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_history_google_ads_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_history_google_ads_by_date($endDate, $today);
        } else {
            $getccrequests = $this->Adm->get_history_google_ads_by_date();
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/google_ads_history", "data" => $getccrequests]);
    }

    public function online_writing_history()
    {

        // $data = $this->Adm->get_history_agent();

        $today = date('Y-m-d H:i:s');
        if ($this->input->get('days') == "0") {
            $endDate = date('Y-m-d 00:00:00');
            $getccrequests = $this->Adm->get_history_ow_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "1") {
            $endDate = date('Y-m-d 00:00:00', strtotime("-1 days"));
            $today = date('Y-m-d  00:00:00');
            $getccrequests = $this->Adm->get_history_ow_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "7") {
            $endDate = date('Y-m-d H:i:s', strtotime("-7 days"));
            $getccrequests = $this->Adm->get_history_ow_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "10") {
            $endDate = date('Y-m-d H:i:s', strtotime("-10 days"));
            $getccrequests = $this->Adm->get_history_ow_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "30") {
            $endDate = date('Y-m-d H:i:s', strtotime("-30 days"));
            $getccrequests = $this->Adm->get_history_ow_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "this_month") {

            $month = date("m");
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_history_ow_by_date($endDate, $today);
        } elseif ($this->input->get('days') == "last_month") {
            $month = date("m", strtotime('-1 month'));
            $year = date("Y");
            $startDate = "01-" . $month . "-" . $year;
            $lastDate = "30-" . $month . "-" . $year;
            $endDate = date("Y-m-d H:i:s", strtotime($startDate));
            $today = date("Y-m-d H:i:s", strtotime($lastDate));

            $getccrequests = $this->Adm->get_history_ow_by_date($endDate, $today);
        } else {
            $getccrequests = $this->Adm->get_history_ow_by_date();
        }

        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/online_writing_history", "data" => $getccrequests]);
    }

    public function whatsapp_settings()
    {
        if ($this->input->post()) {
            $username = $this->input->post("username");
            $user = Helpers::getuserbyusername($username);
            if (!$user) {
                $flash = Helpers::flash('danger', 'User not found...');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/whatsapp_settings");
            }
            $data["whatsapp_req"] = $this->input->post("status");
            // $data["deposit_fee"] = $this->input->post("deposit_fee");
            // $data["transfer_fee"] = $this->input->post("transfer_fee");
            $resp = $this->Adm->updateuser($user['id'], $data);
            if ($resp) {
                $flash = Helpers::flash('success', 'Your Details are updated');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/whatsapp_settings");
            } else {
                $flash = Helpers::flash('danger', 'Something went wrong');
                $this->session->set_flashdata('response', $flash);
                redirect("admin/whatsapp_settings");
            }
        }

        $data1 = $this->Adm->get_allowed_users();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/whatsapp_settings", "data" => $data1]);
    }

    public function sub_admin()
    {
        if ($this->input->post()) {
            $this->form_validation->set_rules('name', 'Name', 'required');
            $this->form_validation->set_rules('username', 'Username', 'required|is_unique[admin_details.username]|alpha_numeric');
            $this->form_validation->set_rules('password', 'Password', 'required|min_length[6]|max_length[15]');
            $this->form_validation->set_rules('email', 'Email', 'required|valid_email|is_unique[admin_details.email]');
            $this->form_validation->set_rules('cpassowrd', 'Password Confirmation', 'required|matches[password]');
            if ($this->form_validation->run() == FALSE) {
                
            } else {
                $data['username'] = $this->input->post("username");
                $data['name'] = $this->input->post("name");
                $data['email'] = $this->input->post("email");
                $data['password'] = $this->input->post("password");
                $data['dashboard'] = $this->input->post("dashboard") ? "1" : false;
                $data['users'] = $this->input->post("users") ? "1" : false;
                $data['support'] = $this->input->post("support") ? "1" : false;
                $data['requests'] = $this->input->post("requests") ? "1" : false;
                $data['history'] = $this->input->post("history") ? "1" : false;
                $data['withdraw'] = $this->input->post("withdraw") ? "1" : false;
                $data['notifications'] = $this->input->post("notifications") ? "1" : false;
                $data['top-earned'] = $this->input->post("top-earned") ? "1" : false;
                $data['whatsapp-clear'] = $this->input->post("whatsapp-clear") ? "1" : false;
                $data['ads'] = $this->input->post("ads") ? "1" : false;
                $data['blogs'] = $this->input->post("blogs") ? "1" : false;
                $data['admin-features'] = $this->input->post("admin-features") ? "1" : false;
                $data['topup-history'] = $this->input->post("topup-history") ? "1" : false;
                $data['ewallet-history'] = $this->input->post("ewallet-history") ? "1" : false;
                $user = $this->Adm->add_admin($data);
                if ($user) {
                    $flash = Helpers::flash('success', 'Admin created successfully ! ');
                    $this->session->set_flashdata('response', $flash);
                    redirect("admin/sub_admin");
                }
            }

        }
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/sub_admin"]);
    }

    function logout()
    {
        $this->session->sess_destroy();
        redirect('login');
    }
    public function users_balance()
    {
        $users = $this->Adm->get_all_users();
        $this->load->view("admin/layouts/adminview", ["template" => "admin/pages/users_balance", "data" => $users]);
    }
}
