<?php

namespace App\Http\Controllers\auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use App\Models\Users;

class AuthController extends Controller
{
    public function register(Request $request)
    {
        return  view('register');
    }
    public function register_create(Request $request)
    {
        $request->validate([
            'username' => ['required', 'string', 'unique:users'],
            'phone' => ['required'],
            'email' => ['required', 'string', 'email', 'unique:users'],
            'password' => ['required', 'string'],
            'conf_password' => ['required', 'string', 'same:password']
        ]);
        $user = User::create([
            'username' => $request->username,
            'phone' => $request->phone,
            'email' => $request->email,
            'password' => Hash::make($request->password),
            'created_date' => date("Y-m-d H:i:s"),
        ]);
        // Users::insert([
        //     'id' => $user->id,
        //     'created_at' => date("Y-m-d H:i:s"),
        // ]);

        return  redirect('/register')->with('flash_success', 'Register Successfully !');
    }
}
